/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common;

import java.util.stream.IntStream;
import net.algart.arrays.Arrays;

public class Multithreading {
    private Multithreading() {
    }

    public static IntStream loopStream(int n) {
        return Multithreading.loopStream(n, true);
    }

    public static IntStream loopStream(int n, boolean enableMultithreading) {
        return enableMultithreading && Arrays.SystemSettings.cpuCount() > 1 ? IntStream.range(0, n).parallel() : IntStream.range(0, n);
    }

    public static int recommendedNumberOfParallelRanges() {
        return Multithreading.recommendedNumberOfParallelRanges(Integer.MAX_VALUE);
    }

    public static int recommendedNumberOfParallelRanges(int n) {
        int cpuCount = Arrays.SystemSettings.cpuCount();
        return cpuCount == 1 ? 1 : (int)Math.min((long)n, 4L * (long)cpuCount);
    }

    public static int[] splitToRanges(int n, int numberOfRanges) {
        if (numberOfRanges < 0) {
            throw new IllegalArgumentException("Negative number of ranges: " + numberOfRanges);
        }
        int[] result = new int[numberOfRanges + 1];
        Arrays.splitToRanges((int[])result, (int)n);
        return result;
    }

    public static long[] splitToRanges(long n, int numberOfRanges) {
        if (numberOfRanges < 0) {
            throw new IllegalArgumentException("Negative number of ranges: " + numberOfRanges);
        }
        long[] result = new long[numberOfRanges + 1];
        Arrays.splitToRanges((long[])result, (long)n);
        return result;
    }
}

