/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SettingsTree;

public class SmartSearchSettings {
    private static final String TESTED_SUBSTRING = "\"settings\"";
    private static final System.Logger LOG = System.getLogger(SettingsTree.class.getName());
    private final ExecutorSpecificationFactory factory;
    private final Supplier<? extends Collection<String>> allSettingsIds;
    private System.Logger.Level logLevel = System.Logger.Level.DEBUG;
    private volatile boolean ready = false;
    private volatile Map<String, ExecutorSpecification> allSettings = null;
    private volatile boolean complete = false;

    private SmartSearchSettings(ExecutorSpecificationFactory factory, Supplier<? extends Collection<String>> allSettingsIds) {
        this.factory = Objects.requireNonNull(factory, "Null factory");
        this.allSettingsIds = Objects.requireNonNull(allSettingsIds, "Null allSettingsIds");
    }

    public static SmartSearchSettings newInstance(ExecutorSpecificationFactory factory, Supplier<? extends Collection<String>> allExecutorsIdsToCheck) {
        return new SmartSearchSettings(factory, allExecutorsIdsToCheck);
    }

    public static SmartSearchSettings newInstance(ExecutorLoaderSet executorLoaderSet, String sessionId) {
        Objects.requireNonNull(executorLoaderSet, "Null executor loader set");
        ExecutorFactory factory = executorLoaderSet.newFactory(sessionId);
        return SmartSearchSettings.newInstance(factory, () -> SmartSearchSettings.probableSettingsIds(executorLoaderSet, sessionId));
    }

    public static SmartSearchSettings newInstance(String sessionId) {
        return SmartSearchSettings.newInstance(ExecutionBlock.globalLoaders(), sessionId);
    }

    public static SmartSearchSettings newSharedInstance() {
        return SmartSearchSettings.newInstance("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f");
    }

    public ExecutorSpecificationFactory factory() {
        return this.factory;
    }

    public System.Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public SmartSearchSettings setLogLevel(System.Logger.Level logLevel) {
        this.logLevel = Objects.requireNonNull(logLevel, "Null logLevel");
        return this;
    }

    public Map<String, ExecutorSpecification> allSettings() {
        this.checkReady();
        return this.allSettings;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean search() {
        if (this.ready) {
            return this.complete;
        }
        this.allSettings = this.makeAllSettings();
        boolean complete = true;
        for (ExecutorSpecification specification : this.allSettings.values()) {
            Map<String, ControlSpecification> controls = specification.getControls();
            for (Map.Entry<String, ControlSpecification> entry : controls.entrySet()) {
                String settingsId;
                String name = entry.getKey();
                ControlSpecification control = entry.getValue();
                if (!control.isSubSettings() || (settingsId = control.getSettingsId()) != null) continue;
                settingsId = this.tryToFindSettings(control.getValueClassName(), name);
                if (settingsId != null) {
                    specification.updateControlSettingsId(name, settingsId);
                    continue;
                }
                complete = false;
                LOG.log(this.logLevel, () -> "Cannot find sub-settings for control \"" + name + "\" of the executor \"" + specification.canonicalName() + "\" (" + specification.getId() + ")");
            }
        }
        this.complete = complete;
        this.ready = true;
        return complete;
    }

    public static Set<String> probableSettingsIds(ExecutorLoaderSet executorLoaderSet, String sessionId) {
        return SmartSearchSettings.probableSerializedSettings(executorLoaderSet, sessionId).keySet();
    }

    public static Map<String, String> probableSerializedSettings(ExecutorLoaderSet executorLoaderSet, String sessionId) {
        Objects.requireNonNull(executorLoaderSet, "Null executor loader set");
        Map<String, String> serialized = executorLoaderSet.allSerializedSpecifications(sessionId, true);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> stringStringEntry : serialized.entrySet()) {
            if (!stringStringEntry.getValue().contains(TESTED_SUBSTRING)) continue;
            result.put(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        return result;
    }

    private Map<String, ExecutorSpecification> makeAllSettings() {
        LinkedHashMap<String, ExecutorSpecification> result = new LinkedHashMap<String, ExecutorSpecification>();
        for (String settingsId : this.allSettingsIds.get()) {
            ExecutorSpecification specification = this.factory.getSpecification(settingsId);
            if (specification == null || !specification.isRoleSettings()) continue;
            result.put(settingsId, specification);
        }
        return result;
    }

    private String tryToFindSettings(String valueClassName, String controlName) {
        String settingsId = null;
        if (valueClassName != null && (settingsId = this.tryToFindSettings(role -> role.equalsClass(valueClassName))) == null) {
            settingsId = this.tryToFindSettings(role -> role.matchesClass(valueClassName));
        }
        if (settingsId == null) {
            settingsId = this.tryToFindSettings(role -> role.matchesClass(controlName));
        }
        return settingsId;
    }

    private String tryToFindSettings(Predicate<ExecutorSpecification.Options.Role> matchesRole) {
        for (Map.Entry<String, ExecutorSpecification> entry : this.allSettings.entrySet()) {
            ExecutorSpecification specification = entry.getValue();
            ExecutorSpecification.Options.Role role = specification.getRole();
            if (role == null || !matchesRole.test(role)) continue;
            return specification.getId();
        }
        return null;
    }

    private void checkReady() {
        if (!this.ready) {
            throw new IllegalStateException("Smart search has not been performed yet");
        }
    }
}

