/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.SpecialSpecificationsBuilder;

public final class ExecutorSpecificationSet {
    private static final System.Logger LOG = System.getLogger(Executor.class.getName());
    private final Map<String, ExecutorSpecification> specifications = new LinkedHashMap<String, ExecutorSpecification>();
    private boolean immutable = false;

    private ExecutorSpecificationSet() {
    }

    public static ExecutorSpecificationSet newInstance() {
        return new ExecutorSpecificationSet();
    }

    public static ExecutorSpecificationSet allBuiltIn() {
        try {
            return ExecutorSpecificationSet.findAllBuiltIn();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static ExecutorSpecificationSet findAllBuiltIn() throws IOException {
        return InstalledSetHolder.builtInSet();
    }

    public void add(ExecutorSpecification specification) {
        Objects.requireNonNull(specification, "Null specification");
        this.add(specification.getId(), specification);
    }

    public void add(String executorId, ExecutorSpecification specification) {
        this.add(executorId, specification, null);
    }

    public int addFolder(Path folder, boolean onlyBuiltIn) throws IOException {
        return this.addFolder(folder, null, onlyBuiltIn);
    }

    public int addFolder(Path folder, ExtensionSpecification.Platform platform, boolean onlyBuiltIn) throws IOException {
        Objects.requireNonNull(folder, "Null folder");
        LOG.log(System.Logger.Level.TRACE, () -> "Adding executors folder " + String.valueOf(folder));
        this.checkImmutable();
        if (!Files.exists(folder, new LinkOption[0])) {
            throw new NoSuchFileException(folder.toString());
        }
        int n = 0;
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder);){
            for (Path file : files) {
                if (file.getFileName().toString().startsWith(".")) continue;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    n += this.addFolder(file, platform, onlyBuiltIn);
                    continue;
                }
                if (!Files.isRegularFile(file, new LinkOption[0]) || !ExecutorSpecification.isExecutorSpecificationFile(file)) continue;
                ExecutorSpecification specification = ExecutorSpecification.readIfValid(file);
                if (specification != null) {
                    if (onlyBuiltIn && !specification.isJavaExecutor()) continue;
                    specification.addSystemExecutorIdPort();
                    if (platform != null) {
                        specification.updateCategoryPrefix(platform.getCategory());
                        specification.addTags(platform.getTags());
                        specification.setPlatformId(platform.getId());
                        specification.addSystemPlatformIdPort();
                    }
                    this.add(specification.getId(), specification, file);
                    ++n;
                    LOG.log(System.Logger.Level.TRACE, () -> "Executor " + specification.getId() + " loaded from " + String.valueOf(file));
                    continue;
                }
                LOG.log(System.Logger.Level.TRACE, () -> "File " + String.valueOf(file) + " skipped: it is not an executor's JSON");
            }
        }
        return n;
    }

    public void addInstalledModelFolders(boolean onlyBuiltIn) throws IOException {
        for (ExtensionSpecification.Platform platform : InstalledExtensions.allInstalledPlatforms()) {
            if (onlyBuiltIn && !platform.isBuiltIn() || !platform.hasSpecifications()) continue;
            Path folder = platform.specificationsFolder();
            long t1 = System.nanoTime();
            int n = this.addFolder(folder, platform, onlyBuiltIn);
            long t2 = System.nanoTime();
            LOG.log(System.Logger.Level.INFO, () -> String.format(Locale.US, "Loading %d installed built-in executor specifications from %s: %.3f ms", n, folder, (double)(t2 - t1) * 1.0E-6));
        }
    }

    public Collection<ExecutorSpecification> all() {
        return Collections.unmodifiableCollection(this.specifications.values());
    }

    public boolean contains(String executorId) {
        Objects.requireNonNull(executorId, "Null executorId");
        return this.specifications.containsKey(executorId);
    }

    public ExecutorSpecification get(String executorId) {
        Objects.requireNonNull(executorId, "Null executorId");
        return this.specifications.get(executorId);
    }

    public ExecutorSpecification remove(String executorId) {
        Objects.requireNonNull(executorId, "Null executorId");
        this.checkImmutable();
        return this.specifications.remove(executorId);
    }

    private void add(String executorId, ExecutorSpecification executorSpecification, Path file) {
        Objects.requireNonNull(executorId, "Null executorId");
        Objects.requireNonNull(executorSpecification, "Null executorSpecification");
        if (this.immutable) {
            throw new UnsupportedOperationException("This executors json set is immutable");
        }
        if (this.specifications.putIfAbsent(executorId, executorSpecification) != null) {
            throw new IllegalArgumentException("Duplicate executor ID: " + executorId + (String)(file == null ? "" : " in " + String.valueOf(file)));
        }
    }

    private void checkImmutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("This executors' json set is immutable");
        }
    }

    private static class InstalledSetHolder {
        private static ExecutorSpecificationSet installedSet = null;

        private InstalledSetHolder() {
        }

        static synchronized ExecutorSpecificationSet builtInSet() throws IOException {
            if (installedSet == null) {
                ExecutorSpecificationSet newSet = ExecutorSpecificationSet.newInstance();
                newSet.addInstalledModelFolders(true);
                SpecialSpecificationsBuilder builder = new SpecialSpecificationsBuilder(newSet);
                builder.addSpecifications();
                newSet.immutable = true;
                installedSet = newSet;
            }
            return installedSet;
        }
    }
}

