/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Objects;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorExpectedException;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecificationFactory;

public interface ExecutorFactory
extends ExecutorSpecificationFactory {
    public String sessionId();

    public ExecutionBlock newExecutor(String var1, CreateMode var2) throws ClassNotFoundException, ExecutorExpectedException;

    default public <T extends ExecutionBlock> T newExecutor(Class<T> expectedClass, String executorId) {
        return this.newExecutor(expectedClass, executorId, CreateMode.REQUEST_DEFAULT);
    }

    default public <T extends ExecutionBlock> T newExecutor(Class<T> expectedClass, String executorId, CreateMode createMode) {
        ExecutionBlock result;
        Objects.requireNonNull(expectedClass, "Null expectedClass");
        Objects.requireNonNull(executorId, "Null executorId");
        Objects.requireNonNull(createMode, "Null createMode");
        try {
            result = this.newExecutor(executorId, createMode);
        }
        catch (ClassNotFoundException e) {
            throw new ExecutorExpectedException("Executor with ID \"" + executorId + "\" probably was not successfully registered - Java class not found: " + e.getMessage(), e);
        }
        if (!expectedClass.isInstance(result)) {
            throw new ExecutorExpectedException("Executor with ID \"" + executorId + "\" has unexpected " + (String)(result == null ? "null value" : "type " + result.getClass().getName()) + ": it is not an instance of " + String.valueOf(expectedClass));
        }
        return (T)((ExecutionBlock)expectedClass.cast(result));
    }

    public static ExecutorFactory newSharedFactory() {
        return ExecutorFactory.newSharedFactory(ExecutionBlock.globalLoaders());
    }

    public static ExecutorFactory newSharedFactory(ExecutorLoaderSet loaders) {
        return ExecutorFactory.newFactory(loaders, "$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f");
    }

    public static ExecutorFactory newFactory(String sessionId) {
        return ExecutorFactory.newFactory(ExecutionBlock.globalLoaders(), sessionId);
    }

    public static ExecutorFactory newFactory(ExecutorLoaderSet loaders, String sessionId) {
        Objects.requireNonNull(loaders, "Null loader set");
        Objects.requireNonNull(sessionId, "Null sessionId");
        return loaders.newFactory(sessionId);
    }
}

