/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python.core;

import java.util.Locale;
import net.algart.arrays.Arrays;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.jep.JepPlatforms;
import net.algart.executors.api.python.JepCaller;
import net.algart.executors.api.python.core.UsingPython;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepInterpretation;

public class InterpretPython
extends Executor
implements ReadOnlyExecutionInput {
    private static final boolean ENFORCE_SHUTDOWN_ON_CLOSE = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.python.enforceShutdownOnClose", (boolean)true);
    private volatile JepCaller jepCaller = null;

    public InterpretPython() {
        this.useVisibleResultParameter();
        this.disableOnChangeParametersAutomatic();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void process() {
        JepCaller jepCaller = this.jepCaller();
        if (jepCaller.isGlobalSynchronizationRequired()) {
            JepInterpretation.executeWithJVMGlobalLock(() -> this.initializePython(jepCaller), () -> this.processPython(jepCaller), () -> this.closePython(true));
        } else {
            jepCaller.executeWithLock(() -> this.initializePython(jepCaller), () -> this.processPython(jepCaller));
        }
    }

    @Override
    public void close() {
        this.closePython(ENFORCE_SHUTDOWN_ON_CLOSE);
        super.close();
    }

    public JepCaller jepCaller() {
        String sessionId = this.getSessionId();
        String executorId = this.getExecutorId();
        if (sessionId == null) {
            throw new IllegalStateException("Cannot find Python worker: session ID is not set");
        }
        if (executorId == null) {
            throw new IllegalStateException("Cannot find Python worker: executor ID is not set");
        }
        JepCaller jepCaller = this.jepCaller;
        if (jepCaller == null) {
            jepCaller = UsingPython.jepCallerLoader().registeredWorker(sessionId, executorId);
            this.jepCaller = jepCaller = jepCaller.clone();
        }
        return jepCaller;
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }

    private void initializePython(JepCaller jepCaller) {
        long t1 = InterpretPython.debugTime();
        jepCaller.initialize(this);
        long t2 = InterpretPython.debugTime();
        InterpretPython.logDebug(() -> String.format(Locale.US, "Python module \"%s\" (%s) initialized in %.3f ms", new Object[]{jepCaller.name(), jepCaller.type(), (double)(t2 - t1) * 1.0E-6}));
    }

    private void processPython(JepCaller jepCaller) {
        long t4;
        long t3;
        long t2;
        long t1 = InterpretPython.debugTime();
        try (AtomicPyObject parameters = jepCaller.loadParameters(this);
             AtomicPyObject inputs = jepCaller.readInputPorts(this);
             AtomicPyObject outputs = jepCaller.createOutputs();){
            t2 = InterpretPython.debugTime();
            Object result = jepCaller.callPython(parameters, inputs, outputs);
            t3 = InterpretPython.debugTime();
            jepCaller.writeOutputPorts(this, outputs);
            jepCaller.writeOptionalOutputPort(this, DEFAULT_OUTPUT_PORT, result, true);
            t4 = InterpretPython.debugTime();
        }
        this.setSystemOutputs();
        InterpretPython.logDebug(() -> String.format(Locale.US, "Python module \"%s\" (%s) executed in %.5f ms: %.6f ms loading inputs + %.6f ms calling + %.6f ms returning outputs", new Object[]{jepCaller.name(), jepCaller.type(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6}));
    }

    private void closePython(boolean doClose) {
        JepCaller jepCaller = this.jepCaller;
        if (jepCaller != null) {
            this.jepCaller = null;
            if (doClose) {
                jepCaller.close();
            }
        }
    }

    private void setSystemOutputs() {
        if (this.isOutputNecessary("_py_supplied_python_roots")) {
            this.getScalar("_py_supplied_python_roots").setTo(String.join((CharSequence)String.format("%n", new Object[0]), JepPlatforms.pythonRootFolders()));
        }
        if (this.isOutputNecessary("_py_supplied_python_specification")) {
            this.getScalar("_py_supplied_python_specification").setTo(String.join((CharSequence)String.format("%n", new Object[0]), JepPlatforms.pythonPlatforms().installedSpecificationFolders()));
        }
    }
}

