/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.scriptengine;

import java.util.Objects;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptException;
import net.algart.executors.api.graalvm.js.scriptengine.ScriptEngineTools;

public final class JavaScriptPerformer {
    private static final boolean OPTIMIZE_SEVERAL_COMPILATION_OF_SAME_FORMULA = true;
    static final System.Logger LOG = System.getLogger(JavaScriptPerformer.class.getName());
    private final String script;
    private final CompiledScript compiledScript;
    private final ScriptEngine context;

    private JavaScriptPerformer(String script, ScriptEngine context) {
        this.script = Objects.requireNonNull(script, "Null script");
        this.context = context == null ? ScriptEngineTools.newEngine() : context;
        try {
            ScriptEngine scriptEngine = this.context;
            if (scriptEngine instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)scriptEngine);
                this.compiledScript = compilable.compile(script);
            } else {
                this.compiledScript = null;
            }
        }
        catch (ScriptException e) {
            throw JavaScriptException.wrap(e, script);
        }
    }

    public static JavaScriptPerformer newInstance(String script) {
        return new JavaScriptPerformer(script, null);
    }

    public static JavaScriptPerformer newInstance(String script, ScriptEngine context) {
        return new JavaScriptPerformer(script, context);
    }

    public static JavaScriptPerformer newInstanceIfChanged(String script, JavaScriptPerformer previousInstance) {
        return JavaScriptPerformer.newInstanceIfChanged(script, previousInstance, null);
    }

    public static JavaScriptPerformer newInstanceIfChanged(String script, JavaScriptPerformer previousInstance, ScriptEngine context) {
        Objects.requireNonNull(script, "Null script");
        return previousInstance != null && previousInstance.script.equals(script) && (context == null || context == previousInstance.context) ? previousInstance : new JavaScriptPerformer(script, context);
    }

    public String script() {
        return this.script;
    }

    public ScriptEngine context() {
        return this.context;
    }

    public void putVariable(String variableName, Object value) {
        this.context.put(variableName, value);
    }

    public boolean compilable() {
        return this.compiledScript != null;
    }

    public Object perform() {
        try {
            return this.compiledScript == null ? this.context.eval(this.script) : this.compiledScript.eval();
        }
        catch (ScriptException e) {
            throw JavaScriptException.wrap(e, this.script);
        }
    }

    public boolean calculateBoolean() {
        Object result = this.perform();
        if (result == null || result.equals("")) {
            return false;
        }
        return Boolean.parseBoolean(result.toString());
    }

    public double calculateDouble() {
        Object result = this.perform();
        if (result == null) {
            return Double.NaN;
        }
        return Double.parseDouble(result.toString());
    }

    public String calculateStringOrNumber() {
        double v;
        Object result = this.perform();
        if (result == null) {
            return null;
        }
        if ((result instanceof Double || result instanceof Float) && (v = ((Number)result).doubleValue()) == (double)((int)v)) {
            result = (int)v;
        }
        return result.toString();
    }

    public boolean isInterfaceSupported() {
        return this.context instanceof Invocable;
    }

    public <T> T getInterface(Class<T> clazz, String javaScriptFunction) {
        try {
            this.context.eval(javaScriptFunction);
        }
        catch (ScriptException e) {
            throw JavaScriptException.wrap(e, javaScriptFunction);
        }
        T result = ((Invocable)((Object)this.context)).getInterface(clazz);
        if (result == null) {
            throw new IllegalArgumentException("JavaScript code \"" + javaScriptFunction + "\" does not implement interface " + clazz.getName());
        }
        return result;
    }
}

