/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core.arrays;

import net.algart.executors.api.data.SNumbers;

public final class JSNumbersBlockInformation {
    public static final int MIN_BLOCK_DATA_ARRAY_LENGTH = 32;
    public final boolean initialized;
    public final double[] x;
    public double v;
    public int i = -1;
    public final int len;
    public final float[] all;
    private final SNumbers numbers;
    private double originalX0;

    public JSNumbersBlockInformation(SNumbers numbers) {
        this(numbers, numbers != null && numbers.isInitialized() ? numbers.toFloatArray() : new float[]{});
    }

    public JSNumbersBlockInformation(SNumbers numbers, float[] all) {
        boolean bl = this.initialized = numbers != null && numbers.isInitialized();
        if (this.initialized) {
            this.numbers = numbers;
            this.all = all;
            this.len = numbers.getBlockLength();
            this.x = new double[Math.max(this.len, 32)];
        } else {
            this.numbers = null;
            this.all = all;
            this.len = 0;
            this.x = new double[32];
        }
    }

    public SNumbers getNumbers() {
        return this.numbers;
    }

    public void readBlock(int blockIndex) {
        this.i = blockIndex;
        if (this.initialized) {
            this.numbers.getBlockDoubleValues(blockIndex, this.x);
            this.v = this.originalX0 = this.x[0];
        }
    }

    public void writeBlock() {
        if (this.initialized && this.i >= 0 && this.i < this.numbers.n()) {
            if (this.x[0] == this.originalX0 && this.v != this.originalX0) {
                this.x[0] = this.v;
            }
            this.numbers.setBlockDoubleValues(this.i, this.x);
        }
    }
}

