/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core.arrays;

import java.util.List;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.executors.modules.core.logic.SimpleResultElementType;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;

public final class ElementwiseFormula
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    public static final String INPUT_C = "c";
    public static final String INPUT_D = "d";
    public static final String INPUT_E = "e";
    public static final String INPUT_F = "f";
    private String formula = "a * p + b";
    private SimpleResultElementType resultElementType = SimpleResultElementType.FLOAT;
    private double defaultA = 0.0;
    private double defaultB = 0.0;
    private double defaultC = 0.0;
    private double defaultD = 0.0;
    private double defaultE = 0.0;
    private double defaultF = 0.0;
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private volatile JavaScriptPerformer javaScript = null;

    public ElementwiseFormula() {
        super(INPUT_A, INPUT_B, INPUT_C, INPUT_D, INPUT_E, INPUT_F);
    }

    public String getFormula() {
        return this.formula;
    }

    public ElementwiseFormula setFormula(String formula) {
        this.formula = ElementwiseFormula.nonNull(formula);
        return this;
    }

    public SimpleResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public ElementwiseFormula setResultElementType(SimpleResultElementType resultElementType) {
        this.resultElementType = ElementwiseFormula.nonNull(resultElementType);
        return this;
    }

    public double getDefaultA() {
        return this.defaultA;
    }

    public ElementwiseFormula setDefaultA(double defaultA) {
        this.defaultA = defaultA;
        return this;
    }

    public double getDefaultB() {
        return this.defaultB;
    }

    public ElementwiseFormula setDefaultB(double defaultB) {
        this.defaultB = defaultB;
        return this;
    }

    public double getDefaultC() {
        return this.defaultC;
    }

    public ElementwiseFormula setDefaultC(double defaultC) {
        this.defaultC = defaultC;
        return this;
    }

    public double getDefaultD() {
        return this.defaultD;
    }

    public ElementwiseFormula setDefaultD(double defaultD) {
        this.defaultD = defaultD;
        return this;
    }

    public double getDefaultE() {
        return this.defaultE;
    }

    public ElementwiseFormula setDefaultE(double defaultE) {
        this.defaultE = defaultE;
        return this;
    }

    public double getDefaultF() {
        return this.defaultF;
    }

    public ElementwiseFormula setDefaultF(double defaultF) {
        this.defaultF = defaultF;
        return this;
    }

    public double getP() {
        return this.p;
    }

    public ElementwiseFormula setP(double p) {
        this.p = p;
        return this;
    }

    public double getQ() {
        return this.q;
    }

    public ElementwiseFormula setQ(double q) {
        this.q = q;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public ElementwiseFormula setR(double r) {
        this.r = r;
        return this;
    }

    public double getS() {
        return this.s;
    }

    public ElementwiseFormula setS(double s) {
        this.s = s;
        return this;
    }

    public double getT() {
        return this.t;
    }

    public ElementwiseFormula setT(double t) {
        this.t = t;
        return this;
    }

    public double getU() {
        return this.u;
    }

    public ElementwiseFormula setU(double u) {
        this.u = u;
        return this;
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        AbstractFunc f;
        double[] defaults = new double[]{this.defaultA, this.defaultB, this.defaultC, this.defaultD, this.defaultE, this.defaultF};
        long length = -1L;
        for (PNumberArray source : sources) {
            if (source == null) continue;
            length = source.length();
        }
        if (length == -1L) {
            throw new IllegalArgumentException("At least one array must be initialized");
        }
        while (sources.size() < defaults.length) {
            sources.add(null);
        }
        int n = sources.size();
        for (int k = 0; k < n; ++k) {
            if (sources.get(k) != null) continue;
            ConstantFunc constant = ConstantFunc.getInstance((double)(k < defaults.length ? defaults[k] : 0.0));
            sources.set(k, (PNumberArray)Arrays.asIndexFuncArray((Func)constant, DoubleArray.class, (long)length));
        }
        this.javaScript = JavaScriptPerformer.newInstanceIfChanged(this.formula, this.javaScript);
        this.javaScript.putVariable("p", this.p);
        this.javaScript.putVariable("q", this.q);
        this.javaScript.putVariable("r", this.r);
        this.javaScript.putVariable("s", this.s);
        this.javaScript.putVariable("t", this.t);
        this.javaScript.putVariable("u", this.u);
        if (this.javaScript.isInterfaceSupported()) {
            String javaScriptFunction = "function get(a, b, c, d, e, f) { return (" + this.formula + ");}";
            final JavaScriptInterface bridge = this.javaScript.getInterface(JavaScriptInterface.class, javaScriptFunction);
            ElementwiseFormula.logDebug(() -> "Elementwise JavaScript function: " + javaScriptFunction);
            f = new AbstractFunc(this){

                public double get(double ... x) {
                    return bridge.get(x[0], x[1], x[2], x[3], x[4], x[5]);
                }
            };
        } else {
            f = new AbstractFunc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public double get(double ... x) {
                    JavaScriptPerformer javaScriptPerformer = ElementwiseFormula.this.javaScript;
                    synchronized (javaScriptPerformer) {
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_A, x[0]);
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_B, x[1]);
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_C, x[2]);
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_D, x[3]);
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_E, x[4]);
                        ElementwiseFormula.this.javaScript.putVariable(ElementwiseFormula.INPUT_F, x[5]);
                        return ElementwiseFormula.this.javaScript.calculateDouble();
                    }
                }
            };
        }
        PArray array = Arrays.asFuncArray((Func)f, (Class)Arrays.type(PArray.class, this.resultElementType.elementType()), (PArray[])sources.toArray(new PArray[0]));
        UpdatablePArray result = (UpdatablePArray)Arrays.SMM.newUnresizableArray((Array)array);
        Arrays.copy(null, (UpdatableArray)result, (Array)array, (int)1);
        return result;
    }

    public static interface JavaScriptInterface {
        public double get(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

