/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core.arrays;

import java.util.List;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.graalvm.js.core.arrays.JSNumbersBlockInformation;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.executors.modules.core.logic.SimpleResultElementType;

public final class BlockFormulaForSeveralNumbers
extends SeveralNumbersOperation {
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    public static final String INPUT_C = "c";
    public static final String INPUT_D = "d";
    public static final String INPUT_E = "e";
    public static final String INPUT_F = "f";
    private String formula = "a[0] + p * aInfo.i";
    private SimpleResultElementType resultElementType = SimpleResultElementType.FLOAT;
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private volatile JavaScriptPerformer javaScript = null;

    public BlockFormulaForSeveralNumbers() {
        super(INPUT_A, INPUT_B, INPUT_C, INPUT_D, INPUT_E, INPUT_F);
    }

    public String getFormula() {
        return this.formula;
    }

    public BlockFormulaForSeveralNumbers setFormula(String formula) {
        this.formula = BlockFormulaForSeveralNumbers.nonNull(formula);
        return this;
    }

    public SimpleResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public BlockFormulaForSeveralNumbers setResultElementType(SimpleResultElementType resultElementType) {
        this.resultElementType = BlockFormulaForSeveralNumbers.nonNull(resultElementType);
        return this;
    }

    public double getP() {
        return this.p;
    }

    public BlockFormulaForSeveralNumbers setP(double p) {
        this.p = p;
        return this;
    }

    public double getQ() {
        return this.q;
    }

    public BlockFormulaForSeveralNumbers setQ(double q) {
        this.q = q;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public BlockFormulaForSeveralNumbers setR(double r) {
        this.r = r;
        return this;
    }

    public double getS() {
        return this.s;
    }

    public BlockFormulaForSeveralNumbers setS(double s) {
        this.s = s;
        return this;
    }

    public double getT() {
        return this.t;
    }

    public BlockFormulaForSeveralNumbers setT(double t) {
        this.t = t;
        return this;
    }

    public double getU() {
        return this.u;
    }

    public BlockFormulaForSeveralNumbers setU(double u) {
        this.u = u;
        return this;
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        int n = -1;
        for (SNumbers source : sources) {
            if (source == null || !source.isInitialized()) continue;
            n = source.n();
        }
        if (n == -1) {
            throw new IllegalArgumentException("At least one array must be initialized");
        }
        this.javaScript = JavaScriptPerformer.newInstanceIfChanged(this.formula, this.javaScript);
        SNumbers result = SNumbers.zeros(this.resultElementType.elementType(), n, 1);
        this.javaScript.putVariable("p", this.p);
        this.javaScript.putVariable("q", this.q);
        this.javaScript.putVariable("r", this.r);
        this.javaScript.putVariable("s", this.s);
        this.javaScript.putVariable("t", this.t);
        this.javaScript.putVariable("u", this.u);
        JSNumbersBlockInformation aInfo = new JSNumbersBlockInformation(sources.get(0));
        JSNumbersBlockInformation bInfo = new JSNumbersBlockInformation(sources.get(1));
        JSNumbersBlockInformation cInfo = new JSNumbersBlockInformation(sources.get(2));
        JSNumbersBlockInformation dInfo = new JSNumbersBlockInformation(sources.get(3));
        JSNumbersBlockInformation eInfo = new JSNumbersBlockInformation(sources.get(4));
        JSNumbersBlockInformation fInfo = new JSNumbersBlockInformation(sources.get(5));
        double[] a = aInfo.x;
        double[] b = bInfo.x;
        double[] c = cInfo.x;
        double[] d = dInfo.x;
        double[] e = eInfo.x;
        double[] f = fInfo.x;
        this.javaScript.putVariable("aInfo", aInfo);
        this.javaScript.putVariable("bInfo", bInfo);
        this.javaScript.putVariable("cInfo", cInfo);
        this.javaScript.putVariable("dInfo", dInfo);
        this.javaScript.putVariable("eInfo", eInfo);
        this.javaScript.putVariable("fInfo", fInfo);
        this.javaScript.putVariable(INPUT_A, a);
        this.javaScript.putVariable(INPUT_B, b);
        this.javaScript.putVariable(INPUT_C, c);
        this.javaScript.putVariable(INPUT_D, d);
        this.javaScript.putVariable(INPUT_E, e);
        this.javaScript.putVariable(INPUT_F, f);
        for (int k = 0; k < n; ++k) {
            aInfo.readBlock(k);
            bInfo.readBlock(k);
            cInfo.readBlock(k);
            dInfo.readBlock(k);
            eInfo.readBlock(k);
            fInfo.readBlock(k);
            result.setValue(k, this.javaScript.calculateDouble());
        }
        return result;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return false;
    }
}

