/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainInputPort;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainPortKey;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;

public abstract sealed class ChainPort<REVERSE extends ChainPort<?>>
permits ChainInputPort, ChainOutputPort {
    final Chain chain;
    final ChainBlock block;
    final String name;
    Data data;
    final String id;
    final ChainPortType portType;
    final DataType dataType;
    final ChainPortKey key;
    final Map<String, REVERSE> connected;

    ChainPort(ChainBlock block, String id, String name, ChainPortType portType, DataType dataType) {
        this.block = Objects.requireNonNull(block, "Null containing block");
        this.chain = block.chain;
        this.id = id;
        this.name = Objects.requireNonNull(name, "Null name");
        this.portType = Objects.requireNonNull(portType, "Null port type");
        this.dataType = Objects.requireNonNull(dataType, "Null data type");
        this.data = dataType.createEmpty();
        this.key = new ChainPortKey(portType, name);
        this.connected = new LinkedHashMap<String, REVERSE>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ChainPortType getPortType() {
        return this.portType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Data getData() {
        if (this.data == null) {
            throw new AssertionError((Object)("Null data in " + String.valueOf(this)));
        }
        return this.data;
    }

    public Map<String, REVERSE> getConnected() {
        return Collections.unmodifiableMap(this.connected);
    }

    public void addConnection(REVERSE connectedPort) {
        Objects.requireNonNull(connectedPort, "Null connectedPort");
        if (this.portType.actualPortType() == Port.Type.INPUT && !this.connected.isEmpty()) {
            throw new IllegalArgumentException("Cannot add more than 1 connection to the input port: " + String.valueOf(this));
        }
        if (this.connected.putIfAbsent(((ChainPort)connectedPort).id, connectedPort) != null) {
            throw new IllegalArgumentException("Duplicate connected port id: " + ((ChainPort)connectedPort).id);
        }
    }

    public boolean isConnected() {
        return !this.connected.isEmpty();
    }

    public void removeData() {
        this.data.setInitialized(false);
    }

    public abstract ChainPort<REVERSE> cleanCopy(ChainBlock var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', name='" + this.name + "', portType=" + String.valueOf((Object)this.portType) + ", dataType=" + String.valueOf((Object)this.dataType) + ", data=" + String.valueOf(this.data) + ", connected=" + String.valueOf(this.connected.keySet()) + " (belongs to block " + System.identityHashCode(this.block) + " and chain " + System.identityHashCode(this.chain) + "}'";
    }
}

