/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainParameter;
import net.algart.executors.api.chains.ChainPort;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.parameters.ValueType;
import net.algart.executors.api.system.PortSpecification;

public final class ChainInputPort
extends ChainPort<ChainOutputPort> {
    private static final boolean OPTIMIZE_COPYING_DATA = true;

    private ChainInputPort(ChainBlock block, String id, String name, ChainPortType portType, DataType dataType) {
        super(block, id, name, portType, dataType);
        if (portType.actualPortType() != Port.Type.INPUT) {
            throw new IllegalArgumentException("Non-input port type");
        }
    }

    public static ChainInputPort of(ChainBlock block, String id, String name, ChainPortType portType, DataType dataType) {
        return new ChainInputPort(block, id, name, portType, dataType);
    }

    public static ChainInputPort of(ChainBlock block, ChainSpecification.Block.Port port) {
        return ChainInputPort.of(block, port.getUuid(), port.getName(), port.getPortType(), port.getDataType());
    }

    public static ChainInputPort of(ChainBlock block, PortSpecification portSpecification) {
        return ChainInputPort.of(block, null, portSpecification.getName(), ChainPortType.INPUT_PORT, portSpecification.getValueType());
    }

    public Boolean necessary() {
        if (this.portType.isVirtual()) {
            return null;
        }
        ExecutionBlock executor = this.block.executor;
        if (executor == null) {
            return null;
        }
        Port executorPort = executor.getInputPort(this.name);
        return executorPort == null ? null : executor.checkInputNecessary(executorPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToExecutorPort() {
        ExecutionBlock executor = this.block.getExecutor();
        assert (executor != null) : "should be checked by getExecutor";
        switch (this.portType) {
            case INPUT_PORT: {
                Object object = this.chain.blocksInteractionLock;
                synchronized (object) {
                    executor.getRequiredInputPort(this.name).setData(this.data);
                    break;
                }
            }
            case INPUT_PARAMETER_AS_PORT: {
                String stringValue;
                Object object = this.chain.blocksInteractionLock;
                synchronized (object) {
                    Data data = this.data;
                    if (!(data instanceof SScalar)) {
                        throw new IllegalArgumentException("Invalid port: virtual data port contains non-scalar data " + String.valueOf(this.data) + " (" + String.valueOf(this) + ")");
                    }
                    SScalar scalar = (SScalar)data;
                    if (!this.data.isInitialized()) {
                        break;
                    }
                    stringValue = scalar.getValue();
                }
                String parameterName = ChainBlock.resolveParameterAlias(executor, this.name, name -> "Legacy parameter-as-input-port name \"" + name + "\" detected");
                ChainParameter chainParameter = this.block.parameters.get(parameterName);
                if (chainParameter == null) {
                    executor.parameters().put(parameterName, (Object)stringValue);
                } else {
                    ValueType valueType = chainParameter.probableType(this.block, ValueType.STRING);
                    Object value = valueType.toParameter(stringValue);
                    if (value == null) {
                        value = stringValue;
                    }
                    executor.parameters().put(parameterName, value);
                }
                executor.onChangeParameter(parameterName);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown input port type: " + String.valueOf((Object)this.portType)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromConnectedPort() {
        Object object = this.chain.blocksInteractionLock;
        synchronized (object) {
            ChainOutputPort connectedSource = this.connectedOutputPort();
            int countOfConnectedInputs = connectedSource.reduceCountOfConnectedInputs();
            boolean hasConnectedReadOnlyExecutors = connectedSource.hasConnectedReadOnlyExecutors();
            if (!hasConnectedReadOnlyExecutors && countOfConnectedInputs == 0 && !connectedSource.isStandardOutput()) {
                this.data.exchange(connectedSource.getData());
            } else {
                boolean shallowCopy = this.block.getExecutor().isReadOnlyInput() && hasConnectedReadOnlyExecutors;
                this.data.setTo(connectedSource.getData(), !shallowCopy);
            }
        }
    }

    public ChainBlock connectedSourceBlock() {
        return this.connectedOutputPort().block;
    }

    public ChainInputPort cleanCopy(ChainBlock newBlock) {
        return new ChainInputPort(newBlock, this.id, this.name, this.portType, this.dataType);
    }

    ChainOutputPort connectedOutputPort() {
        if (!this.isConnected()) {
            throw new IllegalStateException("No connected ports");
        }
        if (this.connected.size() != 1) {
            throw new AssertionError((Object)("Internal error! Input port has >1 connections: " + String.valueOf(this)));
        }
        return (ChainOutputPort)this.connected.values().iterator().next();
    }
}

