/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.math.functions.CoordinateTransformationOperator;
import net.algart.math.functions.LinearOperator;
import net.algart.matrices.stitching.AbstractStitchingFunc;
import net.algart.matrices.stitching.Frame;
import net.algart.matrices.stitching.ShiftFramePosition;
import net.algart.matrices.stitching.StitchingFunc;
import net.algart.matrices.stitching.StitchingMethod;
import net.algart.matrices.stitching.UniversalFramePosition;

public final class UniversalStitchingMethod<P extends UniversalFramePosition>
implements StitchingMethod<P> {
    private final double defaultValue;
    private final boolean weighted;

    private UniversalStitchingMethod(double defaultValue, boolean weighted) {
        this.defaultValue = defaultValue;
        this.weighted = weighted;
    }

    public static <P extends UniversalFramePosition> UniversalStitchingMethod<P> getNearestNeighbourInstance(double defaultValue) {
        return new UniversalStitchingMethod<P>(defaultValue, false);
    }

    public static <P extends UniversalFramePosition> UniversalStitchingMethod<P> getWeightedNeighboursInstance(double defaultValue) {
        return new UniversalStitchingMethod<P>(defaultValue, true);
    }

    @Override
    public boolean simpleBehaviorForEmptySpace() {
        return true;
    }

    @Override
    public boolean simpleBehaviorForSingleFrame() {
        return true;
    }

    @Override
    public StitchingFunc getStitchingFunc(List<? extends Frame<P>> frames) {
        Objects.requireNonNull(frames, "Null frames argument");
        boolean affine2D = true;
        for (Frame<P> frame : frames) {
            CoordinateTransformationOperator o = ((UniversalFramePosition)frame.position()).inverseTransform();
            if (o instanceof LinearOperator && ((LinearOperator)o).n() == 2) continue;
            affine2D = false;
            break;
        }
        if (affine2D) {
            if (this.weighted) {
                return new Affine2DWeighedStitchingFunc(frames);
            }
            return new Affine2DNearestStitchingFunc(frames);
        }
        if (this.weighted) {
            return new UniversalWeighedStitchingFunc(frames);
        }
        return new UniversalNearestStitchingFunc(frames);
    }

    public String toString() {
        return "universal stitching method";
    }

    private class Affine2DWeighedStitchingFunc
    extends UniversalWeighedStitchingFunc {
        private final double[][] a;
        private final double[][] b;
        private final double[] a0;
        private final double[] a1;
        private final double[] a2;
        private final double[] a3;
        private final double[] a4;
        private final double[] a5;
        private final double[] a6;
        private final double[] a7;
        private final double[] b0;
        private final double[] b1;
        private final double[] b2;
        private final double[] b3;
        private final double[] b4;
        private final double[] b5;
        private final double[] b6;
        private final double[] b7;

        private Affine2DWeighedStitchingFunc(List<? extends Frame<P>> frames) {
            super(frames);
            this.a = new double[this.inverseTransforms.length][];
            this.b = new double[this.inverseTransforms.length][];
            for (int k = 0; k < this.inverseTransforms.length; ++k) {
                LinearOperator lo = (LinearOperator)this.inverseTransforms[k];
                assert (lo.n() == 2);
                this.a[k] = lo.a();
                this.b[k] = lo.b();
            }
            this.a0 = this.inverseTransforms.length >= 1 ? this.a[0] : null;
            this.a1 = this.inverseTransforms.length >= 2 ? this.a[1] : null;
            this.a2 = this.inverseTransforms.length >= 3 ? this.a[2] : null;
            this.a3 = this.inverseTransforms.length >= 4 ? this.a[3] : null;
            this.a4 = this.inverseTransforms.length >= 5 ? this.a[4] : null;
            this.a5 = this.inverseTransforms.length >= 6 ? this.a[5] : null;
            this.a6 = this.inverseTransforms.length >= 7 ? this.a[6] : null;
            this.a7 = this.inverseTransforms.length >= 8 ? this.a[7] : null;
            this.b0 = this.inverseTransforms.length >= 1 ? this.b[0] : null;
            this.b1 = this.inverseTransforms.length >= 2 ? this.b[1] : null;
            this.b2 = this.inverseTransforms.length >= 3 ? this.b[2] : null;
            this.b3 = this.inverseTransforms.length >= 4 ? this.b[3] : null;
            this.b4 = this.inverseTransforms.length >= 5 ? this.b[4] : null;
            this.b5 = this.inverseTransforms.length >= 6 ? this.b[5] : null;
            this.b6 = this.inverseTransforms.length >= 7 ? this.b[6] : null;
            this.b7 = this.inverseTransforms.length >= 8 ? this.b[7] : null;
        }

        @Override
        public double get2D(double x0, double x1, double[] values) {
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                double y0 = this.a[k][0] * x0 + this.a[k][1] * x1 + this.b[k][0];
                double y1 = this.a[k][2] * x0 + this.a[k][3] * x1 + this.b[k][1];
                distances[k] = this.areasInMatrices[k].parallelDistance(y0, y1);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return UniversalStitchingMethod.this.defaultValue;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) < 0.0) {
                b -= d3;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) < 0.0) {
                b -= d4;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5) {
            double y1;
            double y0;
            Object srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) < 0.0) {
                b -= d5;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areasInMatrices[6].parallelDistance(y0 = this.a6[0] * x0 + this.a6[1] * x1 + this.b6[0], y1 = this.a6[2] * x0 + this.a6[3] * x1 + this.b6[1])) < 0.0) {
                b -= d6;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double y1;
            double y0;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areasInMatrices[0].parallelDistance(y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0], y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1])) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areasInMatrices[6].parallelDistance(y0 = this.a6[0] * x0 + this.a6[1] * x1 + this.b6[0], y1 = this.a6[2] * x0 + this.a6[3] * x1 + this.b6[1])) < 0.0) {
                b -= d6;
            }
            if (v7 == v7 && (d7 = this.areasInMatrices[7].parallelDistance(y0 = this.a7[0] * x0 + this.a7[1] * x1 + this.b7[0], y1 = this.a7[2] * x0 + this.a7[3] * x1 + this.b7[1])) < 0.0) {
                b -= d7;
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        @Override
        public String toString() {
            return "affine 2D \"weighted-frames-in-translated-coordinates\" stitching function";
        }
    }

    private class Affine2DNearestStitchingFunc
    extends UniversalNearestStitchingFunc {
        private final double[][] a;
        private final double[][] b;
        private final double[] a0;
        private final double[] a1;
        private final double[] a2;
        private final double[] a3;
        private final double[] a4;
        private final double[] a5;
        private final double[] a6;
        private final double[] a7;
        private final double[] b0;
        private final double[] b1;
        private final double[] b2;
        private final double[] b3;
        private final double[] b4;
        private final double[] b5;
        private final double[] b6;
        private final double[] b7;

        private Affine2DNearestStitchingFunc(List<? extends Frame<P>> frames) {
            super(frames);
            this.a = new double[this.inverseTransforms.length][];
            this.b = new double[this.inverseTransforms.length][];
            for (int k = 0; k < this.inverseTransforms.length; ++k) {
                LinearOperator lo = (LinearOperator)this.inverseTransforms[k];
                assert (lo.n() == 2);
                this.a[k] = lo.a();
                this.b[k] = lo.b();
            }
            this.a0 = this.inverseTransforms.length >= 1 ? this.a[0] : null;
            this.a1 = this.inverseTransforms.length >= 2 ? this.a[1] : null;
            this.a2 = this.inverseTransforms.length >= 3 ? this.a[2] : null;
            this.a3 = this.inverseTransforms.length >= 4 ? this.a[3] : null;
            this.a4 = this.inverseTransforms.length >= 5 ? this.a[4] : null;
            this.a5 = this.inverseTransforms.length >= 6 ? this.a[5] : null;
            this.a6 = this.inverseTransforms.length >= 7 ? this.a[6] : null;
            this.a7 = this.inverseTransforms.length >= 8 ? this.a[7] : null;
            this.b0 = this.inverseTransforms.length >= 1 ? this.b[0] : null;
            this.b1 = this.inverseTransforms.length >= 2 ? this.b[1] : null;
            this.b2 = this.inverseTransforms.length >= 3 ? this.b[2] : null;
            this.b3 = this.inverseTransforms.length >= 4 ? this.b[3] : null;
            this.b4 = this.inverseTransforms.length >= 5 ? this.b[4] : null;
            this.b5 = this.inverseTransforms.length >= 6 ? this.b[5] : null;
            this.b6 = this.inverseTransforms.length >= 7 ? this.b[6] : null;
            this.b7 = this.inverseTransforms.length >= 8 ? this.b[7] : null;
        }

        @Override
        public double get2D(double x0, double x1, double[] values) {
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int k = 0; k < values.length; ++k) {
                double y1;
                double y0;
                double distance;
                if (values[k] != values[k] || !((distance = this.areasInMatrices[k].parallelDistance(y0 = this.a[k][0] * x0 + this.a[k][1] * x1 + this.b[k][0], y1 = this.a[k][2] * x0 + this.a[k][3] * x1 + this.b[k][1])) <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return UniversalStitchingMethod.this.defaultValue;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                nearest = v1;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                nearest = v2;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            Object srcCoordinates = null;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) <= minDistance) {
                nearest = v3;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            Object srcCoordinates = null;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) <= minDistance) {
                nearest = v4;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            Object srcCoordinates = null;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) <= minDistance) {
                nearest = v5;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            Object srcCoordinates = null;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areasInMatrices[6].parallelDistance(y0 = this.a6[0] * x0 + this.a6[1] * x1 + this.b6[0], y1 = this.a6[2] * x0 + this.a6[3] * x1 + this.b6[1])) <= minDistance) {
                nearest = v6;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double y1;
            double y0;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            Object srcCoordinates = null;
            if (v0 == v0) {
                y0 = this.a0[0] * x0 + this.a0[1] * x1 + this.b0[0];
                y1 = this.a0[2] * x0 + this.a0[3] * x1 + this.b0[1];
                minDistance = this.areasInMatrices[0].parallelDistance(y0, y1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areasInMatrices[1].parallelDistance(y0 = this.a1[0] * x0 + this.a1[1] * x1 + this.b1[0], y1 = this.a1[2] * x0 + this.a1[3] * x1 + this.b1[1])) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areasInMatrices[2].parallelDistance(y0 = this.a2[0] * x0 + this.a2[1] * x1 + this.b2[0], y1 = this.a2[2] * x0 + this.a2[3] * x1 + this.b2[1])) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areasInMatrices[3].parallelDistance(y0 = this.a3[0] * x0 + this.a3[1] * x1 + this.b3[0], y1 = this.a3[2] * x0 + this.a3[3] * x1 + this.b3[1])) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areasInMatrices[4].parallelDistance(y0 = this.a4[0] * x0 + this.a4[1] * x1 + this.b4[0], y1 = this.a4[2] * x0 + this.a4[3] * x1 + this.b4[1])) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areasInMatrices[5].parallelDistance(y0 = this.a5[0] * x0 + this.a5[1] * x1 + this.b5[0], y1 = this.a5[2] * x0 + this.a5[3] * x1 + this.b5[1])) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areasInMatrices[6].parallelDistance(y0 = this.a6[0] * x0 + this.a6[1] * x1 + this.b6[0], y1 = this.a6[2] * x0 + this.a6[3] * x1 + this.b6[1])) <= minDistance) {
                minDistance = distance;
                nearest = v6;
            }
            if (v7 == v7 && (distance = this.areasInMatrices[6].parallelDistance(y0 = this.a7[0] * x0 + this.a7[1] * x1 + this.b7[0], y1 = this.a7[2] * x0 + this.a7[3] * x1 + this.b7[1])) <= minDistance) {
                nearest = v7;
            }
            return nearest;
        }

        @Override
        public String toString() {
            return "affine 2D \"nearest-frame-in-translated-coordinates\" stitching function";
        }
    }

    private class UniversalWeighedStitchingFunc
    extends AbstractStitchingFunc
    implements StitchingFunc {
        final RectangularArea[] areasInMatrices;
        final CoordinateTransformationOperator[] inverseTransforms;

        private UniversalWeighedStitchingFunc(List<? extends Frame<P>> frames) {
            this.areasInMatrices = new RectangularArea[frames.size()];
            this.inverseTransforms = new CoordinateTransformationOperator[frames.size()];
            int n = 0;
            Point shiftMinus05 = null;
            for (Frame frame : frames) {
                UniversalFramePosition p = (UniversalFramePosition)frame.position();
                RectangularArea area = ShiftFramePosition.area(Point.origin(frame.dimCount()), frame.matrix().dimensions());
                if (shiftMinus05 == null) {
                    double[] shift = new double[area.coordCount()];
                    JArrays.fill(shift, -0.5);
                    shiftMinus05 = Point.of(shift);
                }
                this.areasInMatrices[n] = area.shift(shiftMinus05);
                this.inverseTransforms[n] = p.inverseTransform();
                ++n;
            }
        }

        @Override
        public double get(double[] coordinates, double[] values) {
            double[] srcCoordinates = null;
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[k].map(srcCoordinates, coordinates);
                distances[k] = this.areasInMatrices[k].parallelDistance(srcCoordinates);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return UniversalStitchingMethod.this.defaultValue;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                d3 = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                d3 = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                d4 = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                d3 = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                d4 = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                d5 = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                d3 = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                d4 = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                d5 = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (v6 == v6) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[6].map(srcCoordinates, coordinates);
                d6 = this.areasInMatrices[6].parallelDistance(srcCoordinates);
                if (d6 < 0.0) {
                    b -= d6;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double[] srcCoordinates = null;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                d0 = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                d1 = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                d2 = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                d3 = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                d4 = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                d5 = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (v6 == v6) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[6].map(srcCoordinates, coordinates);
                d6 = this.areasInMatrices[6].parallelDistance(srcCoordinates);
                if (d6 < 0.0) {
                    b -= d6;
                }
            }
            if (v7 == v7) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[7].map(srcCoordinates, coordinates);
                d7 = this.areasInMatrices[7].parallelDistance(srcCoordinates);
                if (d7 < 0.0) {
                    b -= d7;
                }
            }
            if (b == 0.0) {
                return UniversalStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        public String toString() {
            return "\"weighted-frames-in-translated-coordinates\" stitching function";
        }
    }

    private class UniversalNearestStitchingFunc
    extends AbstractStitchingFunc
    implements StitchingFunc {
        final RectangularArea[] areasInMatrices;
        final CoordinateTransformationOperator[] inverseTransforms;

        private UniversalNearestStitchingFunc(List<? extends Frame<P>> frames) {
            this.areasInMatrices = new RectangularArea[frames.size()];
            this.inverseTransforms = new CoordinateTransformationOperator[frames.size()];
            int n = 0;
            for (Frame frame : frames) {
                UniversalFramePosition p = (UniversalFramePosition)frame.position();
                this.areasInMatrices[n] = ShiftFramePosition.area(Point.origin(frame.dimCount()), frame.matrix().dimensions());
                this.inverseTransforms[n] = p.inverseTransform();
                ++n;
            }
        }

        @Override
        public double get(double[] coordinates, double[] values) {
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[k].map(srcCoordinates, coordinates);
                double distance = this.areasInMatrices[k].parallelDistance(srcCoordinates);
                if (!(distance <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return UniversalStitchingMethod.this.defaultValue;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1) {
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                double distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v1;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v2;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v3;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v4;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v5;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v5;
                }
            }
            if (v6 == v6) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[6].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[6].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v6;
                }
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double nearest = UniversalStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            double[] srcCoordinates = null;
            if (v0 == v0) {
                srcCoordinates = new double[coordinates.length];
                this.inverseTransforms[0].map(srcCoordinates, coordinates);
                minDistance = this.areasInMatrices[0].parallelDistance(srcCoordinates);
                nearest = v0;
            }
            if (v1 == v1) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[1].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[1].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[2].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[2].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[3].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[3].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[4].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[4].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[5].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[5].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v5;
                }
            }
            if (v6 == v6) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[6].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[6].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v6;
                }
            }
            if (v7 == v7) {
                if (srcCoordinates == null) {
                    srcCoordinates = new double[coordinates.length];
                }
                this.inverseTransforms[7].map(srcCoordinates, coordinates);
                distance = this.areasInMatrices[7].parallelDistance(srcCoordinates);
                if (distance <= minDistance) {
                    nearest = v7;
                }
            }
            return nearest;
        }

        public String toString() {
            return "\"nearest-frame-in-translated-coordinates\" stitching function";
        }
    }
}

