/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import net.algart.math.functions.Func;

public class FirstExceptingNaN
implements Func {
    private final double defaultValue;

    private FirstExceptingNaN(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static FirstExceptingNaN getInstance(double defaultValue) {
        return new FirstExceptingNaN(defaultValue);
    }

    @Override
    public double get(double ... x) {
        for (double v : x) {
            if (v != v) continue;
            return v;
        }
        return this.defaultValue;
    }

    @Override
    public double get() {
        return this.defaultValue;
    }

    @Override
    public double get(double x0) {
        return x0 == x0 ? x0 : this.defaultValue;
    }

    @Override
    public double get(double x0, double x1) {
        if (x0 == x0) {
            return x0;
        }
        if (x1 == x1) {
            return x1;
        }
        return this.defaultValue;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        if (x0 == x0) {
            return x0;
        }
        if (x1 == x1) {
            return x1;
        }
        if (x2 == x2) {
            return x2;
        }
        return this.defaultValue;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        if (x0 == x0) {
            return x0;
        }
        if (x1 == x1) {
            return x1;
        }
        if (x2 == x2) {
            return x2;
        }
        if (x3 == x3) {
            return x3;
        }
        return this.defaultValue;
    }

    public String toString() {
        return "first not-NaN argument";
    }
}

