/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.List;
import java.util.Objects;
import net.algart.math.functions.Func;
import net.algart.matrices.stitching.Frame;
import net.algart.matrices.stitching.FramePosition;
import net.algart.matrices.stitching.StitchingFunc;
import net.algart.matrices.stitching.StitchingMethod;

public final class CoordinateFreeStitchingMethod<P extends FramePosition>
implements StitchingMethod<P> {
    private final Func combiningFunc;
    private final boolean standardBehaviorForSingleFrame;

    private CoordinateFreeStitchingMethod(Func combiningFunc, boolean standardBehaviorForSingleFrame) {
        Objects.requireNonNull(combiningFunc, "Null combiningFunc");
        this.combiningFunc = combiningFunc;
        this.standardBehaviorForSingleFrame = standardBehaviorForSingleFrame;
    }

    public static <P extends FramePosition> CoordinateFreeStitchingMethod<P> getInstance(Func combiningFunc) {
        return new CoordinateFreeStitchingMethod<P>(combiningFunc, true);
    }

    public static <P extends FramePosition> CoordinateFreeStitchingMethod<P> getInstance(Func combiningFunc, boolean standardBehaviorForSingleFrame) {
        return new CoordinateFreeStitchingMethod<P>(combiningFunc, standardBehaviorForSingleFrame);
    }

    public Func combiningFunc() {
        return this.combiningFunc;
    }

    @Override
    public boolean simpleBehaviorForEmptySpace() {
        return true;
    }

    @Override
    public boolean simpleBehaviorForSingleFrame() {
        return this.standardBehaviorForSingleFrame;
    }

    @Override
    public StitchingFunc getStitchingFunc(List<? extends Frame<P>> frames) {
        Objects.requireNonNull(frames, "Null frames argument");
        return new StitchingFunc(){

            @Override
            public double get(double[] coordinates, double[] values) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && values.length == 1 && values[0] == values[0]) {
                    return values[0];
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(values);
            }

            @Override
            public double get1D(double x0, double[] values) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && values.length == 1 && values[0] == values[0]) {
                    return values[0];
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(values);
            }

            @Override
            public double get2D(double x0, double x1, double[] values) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && values.length == 1 && values[0] == values[0]) {
                    return values[0];
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(values);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double[] values) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && values.length == 1 && values[0] == values[0]) {
                    return values[0];
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(values);
            }

            @Override
            public double get(double[] coordinates, double v0) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && v0 == v0) {
                    return v0;
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0);
            }

            @Override
            public double get1D(double x0, double v0) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && v0 == v0) {
                    return v0;
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0);
            }

            @Override
            public double get2D(double x0, double x1, double v0) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && v0 == v0) {
                    return v0;
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0) {
                if (CoordinateFreeStitchingMethod.this.standardBehaviorForSingleFrame && v0 == v0) {
                    return v0;
                }
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1);
            }

            @Override
            public double get1D(double x0, double v0, double v1) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2, double v3) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2, double v3) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2, double v3) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2, double v3, double v4) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6);
            }

            @Override
            public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6, v7);
            }

            @Override
            public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6, v7);
            }

            @Override
            public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6, v7);
            }

            @Override
            public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
                return CoordinateFreeStitchingMethod.this.combiningFunc.get(v0, v1, v2, v3, v4, v5, v6, v7);
            }

            public String toString() {
                return "stitching function ignoring coordinates based on " + String.valueOf(CoordinateFreeStitchingMethod.this.combiningFunc);
            }
        };
    }

    public String toString() {
        return "simple stitching method (ignoring coordinates) based on " + String.valueOf(this.combiningFunc);
    }
}

