/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.skeletons.AbstractThinningSkeleton2D;
import net.algart.matrices.skeletons.OctupleThinningSkeleton2D;
import net.algart.matrices.skeletons.ThinningSkeleton;
import net.algart.matrices.skeletons.ThinningTools;

public class WeakOctupleThinningSkeleton2D
extends AbstractThinningSkeleton2D
implements ThinningSkeleton {
    private static final int[][] SKELETON_XP = new int[][]{{1, -1, 1, 0, 1, 1}, {-1, 0}, {0, 1, 0, -1, -1, 1, -1, -1}};
    private static final int[][] SKELETON_YP = ThinningTools.rotate90(SKELETON_XP);
    private static final int[][] SKELETON_XM = ThinningTools.rotate180(SKELETON_XP);
    private static final int[][] SKELETON_YM = ThinningTools.rotate270(SKELETON_XP);
    private static final int[][][] STRAIGHT_SKELETON = new int[][][]{SKELETON_XP, SKELETON_YP, SKELETON_XM, SKELETON_YM};
    private final boolean topological;

    private WeakOctupleThinningSkeleton2D(ArrayContext arrayContext, Matrix<? extends UpdatableBitArray> matrix, boolean straightThinning, boolean diagonalThinning, boolean topological) {
        super(arrayContext, matrix, straightThinning, diagonalThinning);
        this.topological = topological;
    }

    public static WeakOctupleThinningSkeleton2D getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix, boolean straightThinning, boolean diagonalThinning, boolean topological) {
        return new WeakOctupleThinningSkeleton2D(context, matrix, straightThinning, diagonalThinning, topological);
    }

    public static WeakOctupleThinningSkeleton2D getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix) {
        return new WeakOctupleThinningSkeleton2D(context, matrix, true, true, false);
    }

    @Override
    public long estimatedNumberOfIterations() {
        return ThinningTools.estimatedNumberOfIterations(this.result, this.topological);
    }

    @Override
    public Matrix<BitArray> asThinning(int directionIndex) {
        if (directionIndex < 0 || directionIndex > 7) {
            throw new IllegalArgumentException("Illegal directionIndex = " + directionIndex + " (must be 0..7)");
        }
        if (directionIndex % 2 == 0) {
            return this.asStraightThinning(this.result, directionIndex / 2, this.topological);
        }
        return OctupleThinningSkeleton2D.asDiagonalThinning(this.result, directionIndex / 2, this.topological);
    }

    public String toString() {
        return "weak octuple thinning 2D skeletonizer, " + (this.diagonalThinning ? "8 steps" : "4 steps") + (this.topological ? ", topological mode" : "");
    }

    private Matrix<BitArray> asStraightThinning(Matrix<? extends BitArray> result, int directionIndex, boolean topological) {
        int[][] points = STRAIGHT_SKELETON[directionIndex];
        Matrix<BitArray> dilationY3Points = ThinningTools.or(ThinningTools.shifts(result, points[0]));
        Matrix<BitArray> openingX = ThinningTools.shift(result, points[1]);
        if (!topological) {
            Matrix<BitArray> dilation4Points = ThinningTools.or(ThinningTools.shifts(result, points[2]));
            openingX = ThinningTools.and(openingX, dilation4Points);
        }
        Matrix<BitArray> weakErosion = ThinningTools.or(dilationY3Points, ThinningTools.not(openingX));
        return ThinningTools.and(result, weakErosion);
    }
}

