/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import java.util.Objects;
import net.algart.arrays.AbstractIterativeArrayProcessor;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableBitArray;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.IterativeErosion;

public class ErodingSkeleton
extends AbstractIterativeArrayProcessor<Matrix<? extends UpdatableBitArray>>
implements IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> {
    private final Pattern erosionPattern;
    private final Pattern openingPattern;
    private final Matrix<? extends UpdatableBitArray> result;
    private final Matrix<? extends UpdatableBitArray> temp1;
    private final Matrix<? extends UpdatableBitArray> temp2;
    private boolean done = false;

    private ErodingSkeleton(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix, Pattern erosionPattern, Pattern openingPattern) {
        super(context);
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(erosionPattern, "Null erosionPattern argument");
        Objects.requireNonNull(openingPattern, "Null openingPattern argument");
        this.erosionPattern = erosionPattern;
        this.openingPattern = openingPattern;
        boolean differentPatterns = !erosionPattern.equals(openingPattern);
        MemoryModel mm = ErodingSkeleton.mm(this.memoryModel, matrix, differentPatterns ? 2 : 1);
        this.result = matrix;
        this.temp1 = mm.newMatrix(UpdatableBitArray.class, Boolean.TYPE, matrix.dimensions());
        this.temp2 = differentPatterns ? mm.newMatrix(UpdatableBitArray.class, Boolean.TYPE, matrix.dimensions()) : null;
    }

    public static ErodingSkeleton getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix, Pattern erosionPattern, Pattern openingPattern) {
        return new ErodingSkeleton(context, matrix, erosionPattern, openingPattern);
    }

    @Override
    public void performIteration(ArrayContext context) {
        BasicMorphology morphology = BasicMorphology.getInstance(context);
        Class<PArray> type = this.result.type(PArray.class);
        if (this.temp2 == null) {
            morphology.context(ErodingSkeleton.part(context, 0.0, 0.5)).erosion(this.temp1, this.result, this.erosionPattern);
            Matrix<? extends PArray> lazyOpening = morphology.asDilation(this.temp1, this.erosionPattern);
            Matrix<PArray> lazyRears = Matrices.asFuncMatrix(Func.ABS_DIFF, type, this.result, lazyOpening);
            Matrix<PArray> lazyResult = Matrices.asFuncMatrix(Func.MAX, type, this.temp1, lazyRears);
            this.done = !Matrices.compareAndCopy(ErodingSkeleton.part(context, 0.5, 1.0), this.result, lazyResult).changed();
        } else {
            morphology.context(ErodingSkeleton.part(context, 0.0, 0.3)).erosion(this.temp1, this.result, this.openingPattern);
            morphology.context(ErodingSkeleton.part(context, 0.3, 0.6)).dilation(this.temp2, this.temp1, this.openingPattern);
            morphology.context(ErodingSkeleton.part(context, 0.6, 0.9)).erosion(this.temp1, this.result, this.erosionPattern);
            Matrix<PArray> lazyRears = Matrices.asFuncMatrix(Func.ABS_DIFF, type, this.result, this.temp2);
            Matrix<PArray> lazyResult = Matrices.asFuncMatrix(Func.MAX, type, this.temp1, lazyRears);
            this.done = !Matrices.compareAndCopy(ErodingSkeleton.part(context, 0.9, 1.0), this.result, lazyResult).changed();
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public long estimatedNumberOfIterations() {
        return IterativeErosion.estimatedNumberOfIterations(this.result, this.erosionPattern);
    }

    @Override
    public Matrix<? extends UpdatableBitArray> result() {
        return this.result;
    }

    @Override
    public void freeResources(ArrayContext context) {
        this.temp1.freeResources(context == null ? null : context.part(0.0, this.temp2 != null ? 0.3333333333333333 : 0.5));
        if (this.temp2 != null) {
            this.temp2.freeResources(context == null ? null : context.part(0.3333333333333333, 0.6666666666666666));
        }
        this.result.freeResources(context == null ? null : context.part(this.temp2 != null ? 0.6666666666666666 : 0.5, 1.0));
    }

    public String toString() {
        return "simple skeletonizer, " + (String)(this.temp2 == null ? this.erosionPattern.toString() : "patterns: " + String.valueOf(this.erosionPattern) + " (erosion) and " + String.valueOf(this.openingPattern) + " (opening)");
    }

    static MemoryModel mm(MemoryModel memoryModel, Matrix<? extends PArray> matrix, int numberOfMatrices) {
        if (Matrices.sizeOf(matrix) > Arrays.SystemSettings.maxTempJavaMemory() / (long)numberOfMatrices) {
            return memoryModel;
        }
        return SimpleMemoryModel.getInstance();
    }
}

