/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Histogram;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.StreamingApertureProcessor;
import net.algart.matrices.morphology.BasicMorphology;

abstract class RankOperationProcessor
extends StreamingApertureProcessor {
    static final int BUFFER_BLOCK_SIZE = 65536;
    static final boolean OPTIMIZE_GET_DATA = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.morphology.RankMorphology.optimizeGetData", true);
    static final boolean OPTIMIZE_DIRECT_ARRAYS = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.morphology.RankMorphology.optimizeDirectArrays", true);
    static final boolean INLINE_ONE_LEVEL = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.morphology.RankMorphology.inlineOneLevel", true);
    static final boolean OPTIMIZE_SEGMENTS_ALONG_AXES = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.morphology.RankMorphology.optimizeSegmentsAlongAxes", true);
    static final boolean SPECIAL_OPTIMIZE_THIN_PATTERNS_POWERS_OF_TWO = Arrays.SystemSettings.getBooleanProperty("net.algart.matrices.morphology.RankMorphology.specialOptimizeThinPatternsPowersOfTwo", true);
    final int[] bitLevels;
    final int numberOfAnalyzedBits;

    RankOperationProcessor(ArrayContext context, int[] bitLevels) {
        super(context);
        Objects.requireNonNull(bitLevels, "Null bitLevels argument");
        if (bitLevels.length == 0) {
            throw new IllegalArgumentException("Empty bitLevels argument");
        }
        bitLevels = (int[])bitLevels.clone();
        Histogram.newIntHistogram(0, bitLevels);
        this.numberOfAnalyzedBits = bitLevels[bitLevels.length - 1];
        if (this.numberOfAnalyzedBits > 30) {
            throw new IllegalArgumentException("Last bitLevel is greater than 30");
        }
        this.bitLevels = JArrays.copyOfRange(bitLevels, 0, bitLevels.length - 1);
    }

    public final int[] bitLevels() {
        int[] result = new int[this.bitLevels.length + 1];
        System.arraycopy(this.bitLevels, 0, result, 0, this.bitLevels.length);
        result[this.bitLevels.length] = this.numberOfAnalyzedBits;
        return result;
    }

    @Override
    public final <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        long[] rightShifts;
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        additionalMatrices = new ArrayList<Matrix<? extends PArray>>(additionalMatrices);
        RankOperationProcessor.checkArguments(src, src, additionalMatrices, pattern);
        PArray srcArray = src.array();
        long[] dimensions = src.dimensions();
        PArray[] additionalArrays = new PArray[additionalMatrices.size()];
        for (int k = 0; k < additionalArrays.length; ++k) {
            additionalArrays[k] = additionalMatrices.get(k).array();
        }
        long size = srcArray.length();
        long[] shifts = BasicMorphology.toShifts(null, size, dimensions, pattern, false);
        if (shifts.length == 0) {
            throw new AssertionError((Object)"Empty pattern: it is impossible");
        }
        UniformGridPattern roundedPattern = pattern.round();
        long[] leftShifts = BasicMorphology.toShifts(null, size, dimensions, roundedPattern.lowerSurface(0), false);
        if (leftShifts.length != (rightShifts = BasicMorphology.toShifts(null, size, dimensions, roundedPattern.upperSurface(0), false)).length) {
            throw new AssertionError((Object)"Unbalanced pattern.lowerSurface / pattern.upperSurface: different lengths");
        }
        PArray processed = this.asProcessed(requiredType, srcArray, additionalArrays, dimensions, shifts, leftShifts, rightShifts);
        PArray result = processed.type() != requiredType ? Arrays.asFuncArray(true, Func.IDENTITY, requiredType, processed) : (PArray)requiredType.cast(processed);
        return Matrices.matrix(result, dimensions);
    }

    abstract PArray asProcessed(Class<? extends PArray> var1, PArray var2, PArray[] var3, long[] var4, long[] var5, long[] var6, long[] var7);
}

