/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRectangularArea;
import net.algart.matrices.Abstract2DProcessor;

public abstract class Quick2DAverager
extends Abstract2DProcessor {
    final boolean twoStage;
    final int dimX;
    final long dimY;
    boolean strictDivision = false;
    boolean rounding = true;

    private Quick2DAverager(Class<?> elementType, long[] dimensions, boolean twoStage) {
        super(elementType, dimensions);
        this.twoStage = twoStage;
        this.dimX = this.dimX();
        this.dimY = this.dimY();
    }

    public static Quick2DAverager newInstance(Class<?> elementType, long dimX, long dimY) {
        return Quick2DAverager.newInstance(elementType, new long[]{dimX, dimY}, false);
    }

    public static Quick2DAverager newTwoStageInstance(Class<?> elementType, long dimX, long dimY) {
        return Quick2DAverager.newInstance(elementType, new long[]{dimX, dimY}, true);
    }

    public static Quick2DAverager newInstance(Class<?> elementType, long[] dimensions, boolean twoStage) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (elementType == Character.TYPE) {
            return new ForChar(elementType, dimensions, twoStage);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(elementType, dimensions, twoStage);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(elementType, dimensions, twoStage);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(elementType, dimensions, twoStage);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(elementType, dimensions, twoStage);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(elementType, dimensions, twoStage);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(elementType, dimensions, twoStage);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(elementType, dimensions, twoStage);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    public static boolean isSupportedRectangle(IRectangularArea rectangle) {
        return Quick2DAverager.unsupportedRectangleCode(rectangle) == 0;
    }

    public abstract boolean isInteger();

    public boolean isStrictDivision() {
        return this.strictDivision;
    }

    public Quick2DAverager setStrictDivision(boolean strictDivision) {
        this.strictDivision = strictDivision;
        return this;
    }

    public boolean isRounding() {
        return this.rounding;
    }

    public Quick2DAverager setRounding(boolean rounding) {
        this.rounding = rounding;
        return this;
    }

    public boolean isTwoStage() {
        return this.twoStage;
    }

    public Matrix<? extends UpdatablePArray> filter(Matrix<? extends PArray> source, IRectangularArea rectangle) {
        Matrix<UpdatablePArray> result = net.algart.arrays.Arrays.SMM.newMatrix(UpdatablePArray.class, source);
        this.filter(result, source, rectangle);
        return result;
    }

    public void filter(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> source, long minX, long minY, long sizeX, long sizeY) {
        if (sizeX < 0L || sizeY < 0L) {
            throw new IllegalArgumentException("Negative sizeX=" + sizeX + " or sizeY=" + sizeY);
        }
        this.filter(result, source, IRectangularArea.of(minX, minY, minX + sizeX - 1L, minY + sizeY - 1L));
    }

    public void filter(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> source, IRectangularArea rectangle) {
        DirectAccessible da;
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(rectangle, "Null rectangle");
        this.checkCompatibility(result);
        this.checkCompatibility(source);
        if (rectangle.coordCount() != 2) {
            throw new IllegalArgumentException("Rectangular area " + String.valueOf(rectangle) + " is not 2-dimensional");
        }
        switch (Quick2DAverager.unsupportedRectangleCode(rectangle)) {
            case 1: {
                throw new IllegalArgumentException("Rectangular area " + String.valueOf(rectangle) + " is not 2-dimensional");
            }
            case 2: {
                throw new IllegalArgumentException("Too large rectangle " + String.valueOf(rectangle) + " for averaging: its area " + (double)rectangle.sizeX() * (double)rectangle.sizeY() + " > 2^31-1");
            }
            case 3: {
                throw new IllegalArgumentException("Too large rectangle boundaries " + String.valueOf(rectangle) + " : they are outside 32-bit range -2^31..2^31-1");
            }
        }
        if (source.isEmpty()) {
            return;
        }
        int x1 = (int)rectangle.minX();
        int y1 = (int)rectangle.minY();
        int x2 = (int)rectangle.maxX();
        int y2 = (int)rectangle.maxY();
        Object sourceArray = null;
        int sourceOffset = -1;
        if (source.array() instanceof DirectAccessible && (da = (DirectAccessible)((Object)source.array())).hasJavaArray()) {
            sourceArray = da.javaArray();
            sourceOffset = da.javaArrayOffset();
        }
        if (y1 == y2) {
            this.doAverageByHorizontalLine(result.array(), source.array(), x1, y1, x2);
        } else if (sourceArray == null) {
            this.doAverageByRectangle(result.array(), source.array(), x1, y1, x2, y2);
        } else {
            this.doAverageByRectangleForDirectAccessible(result.array(), sourceArray, sourceOffset, x1, y1, x2, y2);
        }
    }

    public String toString() {
        return "quick averager (" + (this.strictDivision ? "strict division, " : "") + (this.rounding ? "rounding" : "truncating") + (this.twoStage ? ", two-stage mode)" : ")");
    }

    void writeShiftedLineFromArray(UpdatablePArray result, int x2, long lineOffset, Object lineArray) {
        x2 = Quick2DAverager.rem(x2, this.dimX);
        result.setData(lineOffset + (long)x2, lineArray, 0, this.dimX - x2);
        result.setData(lineOffset, lineArray, this.dimX - x2, x2);
    }

    void averageResultLine(long averagedSize) {
        assert (averagedSize > 0L);
        if (averagedSize == 1L) {
            this.copyFromSummedLine();
            return;
        }
        if (this.strictDivision) {
            this.divideSummedLine(averagedSize);
        } else {
            this.multiplySummedLine(1.0 / (double)averagedSize);
        }
    }

    void averageAccumulatorForStage2(long averagedSize) {
        assert (averagedSize > 0L);
        if (this.strictDivision) {
            this.divideAccumulator(averagedSize);
        } else {
            this.multiplyAccumulator(1.0 / (double)averagedSize);
        }
    }

    abstract void clearAccumulator();

    abstract void readLine(PArray var1, long var2);

    abstract void writeShiftedLine(UpdatablePArray var1, int var2, long var3);

    abstract void sumLineFromAccumulator(int var1);

    abstract void sumLineFromAccumulatorForStage2(int var1);

    abstract void copyToAccumulator();

    abstract void copyFromSummedLine();

    abstract void addLine();

    abstract void subtractLine();

    abstract void addLineForArray(Object var1, int var2);

    abstract void addAndSubtractLineForArray(Object var1, int var2, int var3);

    abstract void divideSummedLine(long var1);

    abstract void multiplySummedLine(double var1);

    abstract void divideAccumulator(long var1);

    abstract void multiplyAccumulator(double var1);

    private void doAverageByRectangle(UpdatablePArray result, PArray source, int x1, int y1, int x2, int y2) {
        long lineOffsetL;
        int sizeX = x2 - x1 + 1;
        int sizeY = y2 - y1 + 1;
        assert (sizeX > 0);
        assert (sizeY > 0);
        this.clearAccumulator();
        long lineOffsetR = lineOffsetL = Quick2DAverager.rem((long)(-y2), this.dimY) * (long)this.dimX;
        for (long dy = (long)y2; dy >= (long)y1; --dy) {
            this.readLine(source, lineOffsetR);
            this.addLine();
            lineOffsetR = this.nextLineOffset(lineOffsetR);
        }
        this.completeLine(result, 0L, x2, sizeX, sizeY);
        long y = 1L;
        long lineOffset = this.dimX;
        while (y < this.dimY) {
            this.readLine(source, lineOffsetL);
            this.subtractLine();
            lineOffsetL = this.nextLineOffset(lineOffsetL);
            this.readLine(source, lineOffsetR);
            this.addLine();
            lineOffsetR = this.nextLineOffset(lineOffsetR);
            this.completeLine(result, lineOffset, x2, sizeX, sizeY);
            ++y;
            lineOffset += (long)this.dimX;
        }
    }

    private void doAverageByHorizontalLine(UpdatablePArray result, PArray source, int x1, int y1, int x2) {
        int sizeX = x2 - x1 + 1;
        assert (sizeX > 0);
        long lineOffsetShift = Quick2DAverager.rem((long)(-y1), this.dimY) * (long)this.dimX;
        long y = 0L;
        long lineOffset = 0L;
        while (y < this.dimY) {
            this.readLine(source, lineOffsetShift);
            this.copyToAccumulator();
            lineOffsetShift = this.nextLineOffset(lineOffsetShift);
            this.sumLineFromAccumulator(sizeX);
            this.averageResultLine(sizeX);
            this.writeShiftedLine(result, x2, lineOffset);
            ++y;
            lineOffset += (long)this.dimX;
        }
    }

    private void doAverageByRectangleForDirectAccessible(UpdatablePArray result, Object sourceArray, int sourceOffset, int x1, int y1, int x2, int y2) {
        long lineOffsetL;
        int sizeX = x2 - x1 + 1;
        int sizeY = y2 - y1 + 1;
        assert (sizeX > 0);
        assert (sizeY > 0);
        this.clearAccumulator();
        long lineOffsetR = lineOffsetL = Quick2DAverager.rem((long)(-y2), this.dimY) * (long)this.dimX;
        for (long dy = (long)y2; dy >= (long)y1; --dy) {
            this.addLineForArray(sourceArray, (int)((long)sourceOffset + lineOffsetR));
            lineOffsetR = this.nextLineOffset(lineOffsetR);
        }
        this.completeLine(result, 0L, x2, sizeX, sizeY);
        long y = 1L;
        long lineOffset = this.dimX;
        while (y < this.dimY) {
            this.addAndSubtractLineForArray(sourceArray, (int)((long)sourceOffset + lineOffsetL), (int)((long)sourceOffset + lineOffsetR));
            lineOffsetL = this.nextLineOffset(lineOffsetL);
            lineOffsetR = this.nextLineOffset(lineOffsetR);
            this.completeLine(result, lineOffset, x2, sizeX, sizeY);
            ++y;
            lineOffset += (long)this.dimX;
        }
    }

    private void completeLine(UpdatablePArray result, long lineOffset, int x2, int sizeX, int sizeY) {
        long finalAveragedSize;
        long l = finalAveragedSize = this.twoStage ? (long)sizeX : (long)sizeX * (long)sizeY;
        if (this.twoStage) {
            this.averageAccumulatorForStage2(sizeY);
            this.sumLineFromAccumulatorForStage2(sizeX);
        } else {
            this.sumLineFromAccumulator(sizeX);
        }
        this.averageResultLine(finalAveragedSize);
        this.writeShiftedLine(result, x2, lineOffset);
    }

    private static int unsupportedRectangleCode(IRectangularArea rectangle) {
        Objects.requireNonNull(rectangle, "Null rectangle");
        if (rectangle.coordCount() != 2) {
            return 1;
        }
        if (rectangle.sizeX() > Integer.MAX_VALUE || rectangle.sizeY() > Integer.MAX_VALUE || rectangle.sizeX() * rectangle.sizeY() > Integer.MAX_VALUE) {
            return 2;
        }
        if (rectangle.minX() < -2147483647L || rectangle.maxX() > Integer.MAX_VALUE || rectangle.minY() < -2147483647L || rectangle.maxY() > Integer.MAX_VALUE) {
            return 3;
        }
        return 0;
    }

    private static class ForChar
    extends ForInteger32 {
        final char[] line;

        private ForChar(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new char[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i];
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (char)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)this.line[i];
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (long)this.line[i];
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            char[] array = (char[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)array[lineOffset + i];
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            char[] array = (char[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(array[lineOffsetToAdd + i] - array[lineOffsetToSubtract + i]);
            }
        }

        @Override
        void divideSummedLineWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (char)((this.summedLine[i] + half) / divider);
            }
        }

        @Override
        void multiplySummedLineWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (char)((double)this.summedLine[i] * multiplier + 0.5);
            }
        }

        @Override
        void divideSummedLineWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (char)(this.summedLine[i] / divider);
            }
        }

        @Override
        void multiplySummedLineWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (char)((double)this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForBit
    extends ForInteger32 {
        final boolean[] line;

        private ForBit(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new boolean[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i] ? 1 : 0;
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)this.summedLine[i] != 0;
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(this.line[i] ? 1 : 0);
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (long)(this.line[i] ? 1 : 0);
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            boolean[] array = (boolean[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(array[lineOffset + i] ? 1 : 0);
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            boolean[] array = (boolean[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)((array[lineOffsetToAdd + i] ? 1 : 0) - (array[lineOffsetToSubtract + i] ? 1 : 0));
            }
        }

        @Override
        void divideSummedLineWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((this.summedLine[i] + half) / divider) != 0;
            }
        }

        @Override
        void multiplySummedLineWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((double)this.summedLine[i] * multiplier + 0.5) != 0;
            }
        }

        @Override
        void divideSummedLineWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)(this.summedLine[i] / divider) != 0;
            }
        }

        @Override
        void multiplySummedLineWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((double)this.summedLine[i] * multiplier) != 0;
            }
        }
    }

    private static class ForByte
    extends ForInteger32 {
        final byte[] line;

        private ForByte(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new byte[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i] & 0xFF;
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (byte)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(this.line[i] & 0xFF);
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (long)(this.line[i] & 0xFF);
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            byte[] array = (byte[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(array[lineOffset + i] & 0xFF);
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            byte[] array = (byte[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)((array[lineOffsetToAdd + i] & 0xFF) - (array[lineOffsetToSubtract + i] & 0xFF));
            }
        }

        @Override
        void divideSummedLineWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (byte)((this.summedLine[i] + half) / divider);
            }
        }

        @Override
        void multiplySummedLineWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (byte)((double)this.summedLine[i] * multiplier + 0.5);
            }
        }

        @Override
        void divideSummedLineWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (byte)(this.summedLine[i] / divider);
            }
        }

        @Override
        void multiplySummedLineWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (byte)((double)this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForShort
    extends ForInteger32 {
        final short[] line;

        private ForShort(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new short[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i] & 0xFFFF;
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (short)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(this.line[i] & 0xFFFF);
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (long)(this.line[i] & 0xFFFF);
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            short[] array = (short[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(array[lineOffset + i] & 0xFFFF);
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            short[] array = (short[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)((array[lineOffsetToAdd + i] & 0xFFFF) - (array[lineOffsetToSubtract + i] & 0xFFFF));
            }
        }

        @Override
        void divideSummedLineWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (short)((this.summedLine[i] + half) / divider);
            }
        }

        @Override
        void multiplySummedLineWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (short)((double)this.summedLine[i] * multiplier + 0.5);
            }
        }

        @Override
        void divideSummedLineWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (short)(this.summedLine[i] / divider);
            }
        }

        @Override
        void multiplySummedLineWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (short)((double)this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForInt
    extends ForInteger32 {
        final int[] line;

        private ForInt(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new int[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i];
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)this.line[i];
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (long)this.line[i];
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            int[] array = (int[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)array[lineOffset + i];
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            int[] array = (int[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (long)(array[lineOffsetToAdd + i] - array[lineOffsetToSubtract + i]);
            }
        }

        @Override
        void divideSummedLineWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((this.summedLine[i] + half) / divider);
            }
        }

        @Override
        void multiplySummedLineWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((double)this.summedLine[i] * multiplier + 0.5);
            }
        }

        @Override
        void divideSummedLineWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)(this.summedLine[i] / divider);
            }
        }

        @Override
        void multiplySummedLineWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (int)((double)this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForLong
    extends ForLongAndFloatingPoint {
        final long[] line;

        private ForLong(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new long[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i];
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (long)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)this.line[i];
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (double)this.line[i];
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            long[] array = (long[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)array[lineOffset + i];
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            long[] array = (long[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)(array[lineOffsetToAdd + i] - array[lineOffsetToSubtract + i]);
            }
        }

        @Override
        void divideSummedLine(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (long)(this.summedLine[i] / (double)divider);
            }
        }

        @Override
        void multiplySummedLine(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (long)(this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForFloat
    extends ForLongAndFloatingPoint {
        final float[] line;

        private ForFloat(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new float[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return false;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i];
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (float)this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)this.line[i];
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - (double)this.line[i];
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            float[] array = (float[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)array[lineOffset + i];
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            float[] array = (float[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (double)(array[lineOffsetToAdd + i] - array[lineOffsetToSubtract + i]);
            }
        }

        @Override
        void divideSummedLine(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (float)(this.summedLine[i] / (double)divider);
            }
        }

        @Override
        void multiplySummedLine(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = (float)(this.summedLine[i] * multiplier);
            }
        }
    }

    private static class ForDouble
    extends ForLongAndFloatingPoint {
        final double[] line;

        private ForDouble(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.line = new double[this.dimX];
        }

        @Override
        public boolean isInteger() {
            return false;
        }

        @Override
        void readLine(PArray source, long lineOffset) {
            source.getData(lineOffset, this.line, 0, this.dimX);
        }

        @Override
        void writeShiftedLine(UpdatablePArray result, int x2, long lineOffset) {
            this.writeShiftedLineFromArray(result, x2, lineOffset, this.line);
        }

        @Override
        void copyToAccumulator() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulator[i] = this.line[i];
            }
        }

        @Override
        void copyFromSummedLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = this.summedLine[i];
            }
        }

        @Override
        void addLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + this.line[i];
            }
        }

        @Override
        void subtractLine() {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] - this.line[i];
            }
        }

        @Override
        void addLineForArray(Object javaArray, int lineOffset) {
            double[] array = (double[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + array[lineOffset + i];
            }
        }

        @Override
        void addAndSubtractLineForArray(Object javaArray, int lineOffsetToSubtract, int lineOffsetToAdd) {
            double[] array = (double[])javaArray;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.accumulator[n2] = this.accumulator[n2] + (array[lineOffsetToAdd + i] - array[lineOffsetToSubtract + i]);
            }
        }

        @Override
        void divideSummedLine(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = this.summedLine[i] / (double)divider;
            }
        }

        @Override
        void multiplySummedLine(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.line[i] = this.summedLine[i] * multiplier;
            }
        }
    }

    private static abstract class ForLongAndFloatingPoint
    extends Quick2DAverager {
        final double[] accumulator;
        final double[] accumulatorForStage2;
        final double[] summedLine;

        private ForLongAndFloatingPoint(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.accumulator = new double[this.dimX];
            this.accumulatorForStage2 = twoStage ? new double[this.dimX] : null;
            this.summedLine = new double[this.dimX];
        }

        @Override
        void clearAccumulator() {
            Arrays.fill(this.accumulator, 0.0);
        }

        @Override
        void sumLineFromAccumulator(int sizeX) {
            this.sumLineFromArray(sizeX, this.accumulator);
        }

        @Override
        void sumLineFromAccumulatorForStage2(int sizeX) {
            this.sumLineFromArray(sizeX, this.accumulatorForStage2);
        }

        @Override
        abstract void divideSummedLine(long var1);

        @Override
        abstract void multiplySummedLine(double var1);

        @Override
        void divideAccumulator(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = this.accumulator[i] / (double)divider;
            }
        }

        @Override
        void multiplyAccumulator(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = this.accumulator[i] * multiplier;
            }
        }

        void sumLineFromArray(int sizeX, double[] array) {
            int xR;
            double sum;
            assert (sizeX > 0);
            if (sizeX == 1) {
                System.arraycopy(array, 0, this.summedLine, 0, this.dimX);
                return;
            }
            this.summedLine[0] = sum = ForLongAndFloatingPoint.sumZeroPosition(sizeX, array);
            int xL = 0;
            int to = this.dimX;
            for (xR = ForLongAndFloatingPoint.rem(sizeX, this.dimX); xR < to; ++xR) {
                this.summedLine[++xL] = sum += array[xR] - array[xL];
            }
            assert (xL < this.dimX);
            xR = 0;
            to = this.dimX - 1;
            while (xL < to) {
                this.summedLine[++xL] = sum += array[xR] - array[xL];
                ++xR;
            }
        }

        private static double sumZeroPosition(int sizeX, double[] array) {
            int length;
            double sum = 0.0;
            for (int i = 0; i < sizeX; i += length) {
                length = Math.min(sizeX - i, array.length);
                for (int x = 0; x < length; ++x) {
                    sum += array[x];
                }
            }
            return sum;
        }
    }

    private static abstract class ForInteger32
    extends Quick2DAverager {
        final long[] accumulator;
        final long[] accumulatorForStage2;
        final long[] summedLine;

        private ForInteger32(Class<?> elementType, long[] dimensions, boolean twoStage) {
            super(elementType, dimensions, twoStage);
            this.accumulator = new long[this.dimX];
            this.accumulatorForStage2 = twoStage ? new long[this.dimX] : null;
            this.summedLine = new long[this.dimX];
        }

        @Override
        void clearAccumulator() {
            Arrays.fill(this.accumulator, 0L);
        }

        @Override
        void sumLineFromAccumulator(int sizeX) {
            this.sumLineFromArray(sizeX, this.accumulator);
        }

        @Override
        void sumLineFromAccumulatorForStage2(int sizeX) {
            this.sumLineFromArray(sizeX, this.accumulatorForStage2);
        }

        @Override
        void divideSummedLine(long divider) {
            if (this.rounding) {
                this.divideSummedLineWithRounding(divider);
            } else {
                this.divideSummedLineWithoutRounding(divider);
            }
        }

        @Override
        void multiplySummedLine(double multiplier) {
            if (this.rounding) {
                this.multiplySummedLineWithRounding(multiplier);
            } else {
                this.multiplySummedLineWithoutRounding(multiplier);
            }
        }

        @Override
        void divideAccumulator(long divider) {
            if (this.rounding) {
                this.divideAccumulatorWithRounding(divider);
            } else {
                this.divideAccumulatorWithoutRounding(divider);
            }
        }

        @Override
        void multiplyAccumulator(double multiplier) {
            if (this.rounding) {
                this.multiplyAccumulatorWithRounding(multiplier);
            } else {
                this.multiplyAccumulatorWithoutRounding(multiplier);
            }
        }

        abstract void divideSummedLineWithoutRounding(long var1);

        abstract void multiplySummedLineWithoutRounding(double var1);

        abstract void divideSummedLineWithRounding(long var1);

        abstract void multiplySummedLineWithRounding(double var1);

        private void divideAccumulatorWithRounding(long divider) {
            long half = divider >> 1;
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = (this.accumulator[i] + half) / divider;
            }
        }

        private void multiplyAccumulatorWithRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = (long)((double)this.accumulator[i] * multiplier + 0.5);
            }
        }

        private void divideAccumulatorWithoutRounding(long divider) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = this.accumulator[i] / divider;
            }
        }

        private void multiplyAccumulatorWithoutRounding(double multiplier) {
            int n = this.dimX;
            for (int i = 0; i < n; ++i) {
                this.accumulatorForStage2[i] = (long)((double)this.accumulator[i] * multiplier);
            }
        }

        private void sumLineFromArray(int sizeX, long[] array) {
            int xR;
            long sum;
            assert (sizeX > 0);
            if (sizeX == 1) {
                System.arraycopy(array, 0, this.summedLine, 0, this.dimX);
                return;
            }
            this.summedLine[0] = sum = ForInteger32.sumZeroPosition(sizeX, array);
            int xL = 0;
            int to = this.dimX;
            for (xR = ForInteger32.rem(sizeX, this.dimX); xR < to; ++xR) {
                this.summedLine[++xL] = sum += array[xR] - array[xL];
            }
            assert (xL < this.dimX);
            xR = 0;
            to = this.dimX - 1;
            while (xL < to) {
                this.summedLine[++xL] = sum += array[xR] - array[xL];
                ++xR;
            }
        }

        private static long sumZeroPosition(int sizeX, long[] array) {
            int length;
            long sum = 0L;
            for (int i = 0; i < sizeX; i += length) {
                length = Math.min(sizeX - i, array.length);
                for (int x = 0; x < length; ++x) {
                    sum += array[x];
                }
            }
            return sum;
        }
    }
}

