/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Histogram;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.matrices.morphology.HistogramCache;
import net.algart.matrices.morphology.RankOperationProcessor;

class PercentilePairProcessor
extends RankOperationProcessor {
    private static final boolean SIMPLE_PERCENTILE_PAIR = false;
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean inlineOneLevel = INLINE_ONE_LEVEL;
    private final Func processingFunc;
    private final boolean interpolated;

    PercentilePairProcessor(ArrayContext context, Func processingFunc, boolean interpolated, int[] bitLevels) {
        super(context, bitLevels);
        Objects.requireNonNull(processingFunc, "Null contrastingFunc");
        this.processingFunc = processingFunc;
        this.interpolated = interpolated;
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, final long[] shifts, final long[] left, final long[] right) {
        ArrayPool ap2;
        if (additional.length < 3) {
            throw new IllegalArgumentException("Three additional matrices are required (processed matrix + percentile indexes)");
        }
        assert (shifts.length > 0);
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        final PArray processedArray = additional[0];
        final ArrayPool ap0 = this.optimizeDirectArrays && (Arrays.isNCopies(processedArray) || SimpleMemoryModel.isSimpleArray(processedArray)) ? null : ArrayPool.getInstance(Arrays.SMM, processedArray.elementType(), 65536L);
        final PArray fPerc1 = additional[1];
        final ArrayPool ap1 = this.optimizeDirectArrays && (Arrays.isNCopies(fPerc1) || SimpleMemoryModel.isSimpleArray(fPerc1)) ? null : ArrayPool.getInstance(Arrays.SMM, fPerc1.elementType(), 65536L);
        final PArray fPerc2 = additional[2];
        ArrayPool arrayPool = ap2 = this.optimizeDirectArrays && (Arrays.isNCopies(fPerc2) || SimpleMemoryModel.isSimpleArray(fPerc2)) ? null : ArrayPool.getInstance(Arrays.SMM, fPerc2.elementType(), 65536L);
        if (src instanceof BitArray) {
            final BitArray a = (BitArray)src;
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double value1;
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    if (pIndex1 < 0.0) {
                        pIndex1 = 0.0;
                    } else if (pIndex1 > (double)shifts.length) {
                        pIndex1 = shifts.length;
                    }
                    if (pIndex2 < 0.0) {
                        pIndex2 = 0.0;
                    } else if (pIndex2 > (double)shifts.length) {
                        pIndex2 = shifts.length;
                    }
                    int b = 0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if (a.getBit(i)) continue;
                        ++b;
                    }
                    double d = pIndex1 < (double)b ? (b == 0 ? 1.0 : pIndex1 / (double)b) : (value1 = b == shifts.length ? 1.0 : 1.0 + (pIndex1 - (double)b) / (double)(shifts.length - b));
                    double value2 = pIndex2 < (double)b ? (b == 0 ? 1.0 : pIndex2 / (double)b) : (b == shifts.length ? 1.0 : 1.0 + (pIndex2 - (double)b) / (double)(shifts.length - b));
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1, value2);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    int[] hist = (int[])histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = new int[1];
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (a.getBit(i)) continue;
                            hist[0] = hist[0] + 1;
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double value1;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(arrayPos);
                            if (pIndex1 < 0.0) {
                                pIndex1 = 0.0;
                            } else if (pIndex1 > (double)shifts.length) {
                                pIndex1 = shifts.length;
                            }
                            if (pIndex2 < 0.0) {
                                pIndex2 = 0.0;
                            } else if (pIndex2 > (double)shifts.length) {
                                pIndex2 = shifts.length;
                            }
                            int b = hist[0];
                            double d = pIndex1 < (double)b ? (b == 0 ? 1.0 : pIndex1 / (double)b) : (value1 = b == shifts.length ? 1.0 : 1.0 + (pIndex1 - (double)b) / (double)(shifts.length - b));
                            double value2 = pIndex2 < (double)b ? (b == 0 ? 1.0 : pIndex2 / (double)b) : (b == shifts.length ? 1.0 : 1.0 + (pIndex2 - (double)b) / (double)(shifts.length - b));
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1, value2);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] - 1;
                                assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] + 1;
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof CharArray) {
            final CharArray a = (CharArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int b = hist[currentIValue1];
                                        assert (b > 0);
                                        value1 += (pIndex1 - (double)currentIRank1) / (double)b;
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int b = hist[currentIValue2];
                                        assert (b > 0);
                                        value2 += (pIndex2 - (double)currentIRank2) / (double)b;
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (implementHere) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.preciseValue(hist, pIndex1);
                            double value2 = Histogram.preciseValue(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int indexInBar = r1 - currentIRank1;
                                        int leftBar = hist[currentIValue1];
                                        assert (leftBar > 0);
                                        if (r1 >= shifts.length - 1 || pIndex1 == (double)r1 || indexInBar < leftBar - 1) {
                                            value1 += (pIndex1 - (double)currentIRank1) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value1 : value1 + (double)indexInBar / (double)leftBar;
                                            assert (r1 + 1 == (currentIRank1 += leftBar));
                                            int rightBar = hist[++currentIValue1];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                            value1 = leftPreciseValue + (pIndex1 - (double)r1) * ((double)currentIValue1 - leftPreciseValue);
                                        }
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int indexInBar = r2 - currentIRank2;
                                        int leftBar = hist[currentIValue2];
                                        assert (leftBar > 0);
                                        if (r2 >= shifts.length - 1 || pIndex2 == (double)r2 || indexInBar < leftBar - 1) {
                                            value2 += (pIndex2 - (double)currentIRank2) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value2 : value2 + (double)indexInBar / (double)leftBar;
                                            assert (r2 + 1 == (currentIRank2 += leftBar));
                                            int rightBar = hist[++currentIValue2];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                            value2 = leftPreciseValue + (pIndex2 - (double)r2) * ((double)currentIValue2 - leftPreciseValue);
                                        }
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            final ByteArray a = (ByteArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 8);
            final int bs = 8 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int b = hist[currentIValue1];
                                        assert (b > 0);
                                        value1 += (pIndex1 - (double)currentIRank1) / (double)b;
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int b = hist[currentIValue2];
                                        assert (b > 0);
                                        value2 += (pIndex2 - (double)currentIRank2) / (double)b;
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (implementHere) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.preciseValue(hist, pIndex1);
                            double value2 = Histogram.preciseValue(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int indexInBar = r1 - currentIRank1;
                                        int leftBar = hist[currentIValue1];
                                        assert (leftBar > 0);
                                        if (r1 >= shifts.length - 1 || pIndex1 == (double)r1 || indexInBar < leftBar - 1) {
                                            value1 += (pIndex1 - (double)currentIRank1) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value1 : value1 + (double)indexInBar / (double)leftBar;
                                            assert (r1 + 1 == (currentIRank1 += leftBar));
                                            int rightBar = hist[++currentIValue1];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                            value1 = leftPreciseValue + (pIndex1 - (double)r1) * ((double)currentIValue1 - leftPreciseValue);
                                        }
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int indexInBar = r2 - currentIRank2;
                                        int leftBar = hist[currentIValue2];
                                        assert (leftBar > 0);
                                        if (r2 >= shifts.length - 1 || pIndex2 == (double)r2 || indexInBar < leftBar - 1) {
                                            value2 += (pIndex2 - (double)currentIRank2) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value2 : value2 + (double)indexInBar / (double)leftBar;
                                            assert (r2 + 1 == (currentIRank2 += leftBar));
                                            int rightBar = hist[++currentIValue2];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                            value2 = leftPreciseValue + (pIndex2 - (double)r2) * ((double)currentIValue2 - leftPreciseValue);
                                        }
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            final ShortArray a = (ShortArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int b = hist[currentIValue1];
                                        assert (b > 0);
                                        value1 += (pIndex1 - (double)currentIRank1) / (double)b;
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int b = hist[currentIValue2];
                                        assert (b > 0);
                                        value2 += (pIndex2 - (double)currentIRank2) / (double)b;
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (implementHere) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.preciseValue(hist, pIndex1);
                            double value2 = Histogram.preciseValue(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    int r2;
                                    int r1;
                                    double pv;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    PercentilePairProcessor.checkNaN(pIndex2);
                                    double d = pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    if (pIndex1 < 0.0) {
                                        r1 = 0;
                                        pIndex1 = 0;
                                    } else if (pIndex1 > (double)shifts.length) {
                                        r1 = shifts.length;
                                        pIndex1 = r1;
                                    } else {
                                        r1 = (int)pIndex1;
                                    }
                                    if (r1 < currentIRank1) {
                                        while (r1 < (currentIRank1 -= (b = hist[--currentIValue1]))) {
                                        }
                                        assert (currentIRank1 >= 0);
                                    } else if (r1 < shifts.length) {
                                        b = hist[currentIValue1];
                                        while (r1 >= currentIRank1 + b) {
                                            currentIRank1 += b;
                                            b = hist[++currentIValue1];
                                        }
                                        assert (currentIRank1 < shifts.length);
                                    } else if (currentIRank1 == shifts.length) {
                                        assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                        assert (currentIValue1 > 0);
                                        while (hist[currentIValue1 - 1] == 0) {
                                            assert (--currentIValue1 > 0);
                                        }
                                    } else {
                                        assert (currentIRank1 < shifts.length);
                                        do {
                                            b = hist[currentIValue1];
                                            ++currentIValue1;
                                        } while ((currentIRank1 += b) < shifts.length);
                                        assert (currentIRank1 == shifts.length);
                                    }
                                    if (pIndex2 < 0.0) {
                                        r2 = 0;
                                        pIndex2 = 0;
                                    } else if (pIndex2 > (double)shifts.length) {
                                        r2 = shifts.length;
                                        pIndex2 = r2;
                                    } else {
                                        r2 = (int)pIndex2;
                                    }
                                    if (r2 < currentIRank2) {
                                        int b;
                                        while (r2 < (currentIRank2 -= (b = hist[--currentIValue2]))) {
                                        }
                                        assert (currentIRank2 >= 0);
                                    } else if (r2 < shifts.length) {
                                        int b = hist[currentIValue2];
                                        while (r2 >= currentIRank2 + b) {
                                            currentIRank2 += b;
                                            b = hist[++currentIValue2];
                                        }
                                        assert (currentIRank2 < shifts.length);
                                    } else if (currentIRank2 == shifts.length) {
                                        assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                        assert (currentIValue2 > 0);
                                        while (hist[currentIValue2 - 1] == 0) {
                                            assert (--currentIValue2 > 0);
                                        }
                                    } else {
                                        int b;
                                        assert (currentIRank2 < shifts.length);
                                        do {
                                            b = hist[currentIValue2];
                                            ++currentIValue2;
                                        } while ((currentIRank2 += b) < shifts.length);
                                        assert (currentIRank2 == shifts.length);
                                    }
                                    double value1 = currentIValue1;
                                    if (pIndex1 != (double)currentIRank1) {
                                        assert ((double)currentIRank1 < pIndex1);
                                        int indexInBar = r1 - currentIRank1;
                                        int leftBar = hist[currentIValue1];
                                        assert (leftBar > 0);
                                        if (r1 >= shifts.length - 1 || pIndex1 == (double)r1 || indexInBar < leftBar - 1) {
                                            value1 += (pIndex1 - (double)currentIRank1) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value1 : value1 + (double)indexInBar / (double)leftBar;
                                            assert (r1 + 1 == (currentIRank1 += leftBar));
                                            int rightBar = hist[++currentIValue1];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                            value1 = leftPreciseValue + (pIndex1 - (double)r1) * ((double)currentIValue1 - leftPreciseValue);
                                        }
                                    }
                                    double value2 = currentIValue2;
                                    if (pIndex2 != (double)currentIRank2) {
                                        assert ((double)currentIRank2 < pIndex2);
                                        int indexInBar = r2 - currentIRank2;
                                        int leftBar = hist[currentIValue2];
                                        assert (leftBar > 0);
                                        if (r2 >= shifts.length - 1 || pIndex2 == (double)r2 || indexInBar < leftBar - 1) {
                                            value2 += (pIndex2 - (double)currentIRank2) / (double)leftBar;
                                        } else {
                                            assert (indexInBar == leftBar - 1);
                                            double leftPreciseValue = leftBar == 1 ? value2 : value2 + (double)indexInBar / (double)leftBar;
                                            assert (r2 + 1 == (currentIRank2 += leftBar));
                                            int rightBar = hist[++currentIValue2];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                            value2 = leftPreciseValue + (pIndex2 - (double)r2) * ((double)currentIValue2 - leftPreciseValue);
                                        }
                                    }
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            final IntArray a = (IntArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 31 - nab;
            final double multiplierInv = 1L << bs;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                int v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                int n = v >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    int v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.exclude(v >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        int v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getInt(i)) < 0) {
                            v = 0;
                        }
                        int n = v >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            int v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            hist1.include(v >> bs);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.exclude(v >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            final LongArray a = (LongArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 63 - nab;
            final double multiplierInv = 1L << bs;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                int n = (int)(v >> bs);
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.exclude((int)(v >> bs));
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getLong(i)) < 0L) {
                            v = 0L;
                        }
                        int n = (int)(v >> bs);
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(1 << nab, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            hist1.include((int)(v >> bs));
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.exclude((int)(v >> bs));
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            final FloatArray a = (FloatArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            final DoubleArray a = (DoubleArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            PercentilePairProcessor.checkNaN(pIndex2);
                            double pv = processedArray.getDouble(index);
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            double value1 = Histogram.value(hist, pIndex1);
                            double value2 = Histogram.value(hist, pIndex2);
                            return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!PercentilePairProcessor.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                            Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            Histogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap0 != null) {
                                    buf0.copy(processedArray.subArr(arrayPos, len));
                                }
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double value1 = hist1.currentValue();
                                    double value2 = hist2.currentValue();
                                    dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                            if (ap0 != null) {
                                ap0.releaseArray(buf0);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.preciseValue(hist, pIndex1);
                        double value2 = Histogram.preciseValue(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        PercentilePairProcessor.checkNaN(pIndex2);
                        double pv = processedArray.getDouble(index);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double value1 = Histogram.value(hist, pIndex1);
                        double value2 = Histogram.value(hist, pIndex2);
                        return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!PercentilePairProcessor.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                        Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        Histogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap0 != null) {
                                buf0.copy(processedArray.subArr(arrayPos, len));
                            }
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                                hist1.moveToRank(pIndex1);
                                hist2.moveToRank(pIndex2);
                                double value1 = hist1.currentValue();
                                double value2 = hist2.currentValue();
                                dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                        if (ap0 != null) {
                            ap0.releaseArray(buf0);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    PercentilePairProcessor.checkNaN(pIndex2);
                    double pv = processedArray.getDouble(index);
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    double value1 = Histogram.preciseValue(hist, pIndex1);
                    double value2 = Histogram.preciseValue(hist, pIndex2);
                    return PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!PercentilePairProcessor.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    PercentilePairProcessor.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf0 = ap0 == null ? null : (UpdatablePArray)ap0.requestArray();
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap0 == null && ap1 == null && ap2 == null ? count : 65536;
                    Histogram hist1 = (Histogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = Histogram.newIntHistogram(histLength, PercentilePairProcessor.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    Histogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap0 != null) {
                            buf0.copy(processedArray.subArr(arrayPos, len));
                        }
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double pv = ap0 != null ? buf0.getDouble(k) : processedArray.getDouble(arrayPos);
                            hist1.moveToPreciseRank(pIndex1);
                            hist2.moveToPreciseRank(pIndex2);
                            double value1 = hist1.currentValue();
                            double value2 = hist2.currentValue();
                            dest[destArrayOffset] = PercentilePairProcessor.this.processingFunc.get(pv, value1 * multiplierInv, value2 * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                    if (ap0 != null) {
                        ap0.releaseArray(buf0);
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }

    private static void checkNaN(double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank (NaN) in some elements of percentileIndexes1 or percentileIndexes2");
        }
    }
}

