/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Continuer;
import net.algart.matrices.morphology.RankMorphology;

public class ContinuedRankMorphology
extends ContinuedMorphology
implements RankMorphology {
    private final RankMorphology parent;

    ContinuedRankMorphology(RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        super(parent, continuationMode);
        this.parent = parent;
    }

    public static ContinuedRankMorphology getInstance(RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        return new ContinuedRankMorphology(parent, continuationMode);
    }

    @Override
    public RankMorphology parent() {
        return this.parent;
    }

    @Override
    public RankMorphology context(ArrayContext newContext) {
        return new ContinuedRankMorphology(this.parent.context(newContext), this.continuationMode);
    }

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        Continuer c = new Continuer(null, src, percentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asPercentile(c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asPercentile(c.get(0), percentileIndex, pattern));
    }

    @Override
    public <T extends PArray> Matrix<T> asRank(Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        Continuer c = new Continuer(null, baseMatrix, rankedMatrix, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asRank(requiredType, c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, fromPercentileIndexes, toPercentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenPercentiles(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenPercentiles(c.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, minValues, maxValues, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenValues(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMean(Matrix<? extends PArray> src, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMean(c.get(0), pattern));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfSum(Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfSum(c.get(0), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, percentileIndexes1, percentileIndexes2, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfPercentilePair(c.get(0), c.get(1), c.get(2), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfPercentilePair(c.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc));
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        Continuer c = new Continuer(null, src, percentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.percentile(c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.percentile(c.get(0), percentileIndex, pattern));
    }

    @Override
    public <T extends PArray> Matrix<? extends T> rank(Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        Continuer c = new Continuer(null, baseMatrix, rankedMatrix, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.rank(requiredType, c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, fromPercentileIndexes, toPercentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.meanBetweenPercentiles(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.meanBetweenPercentiles(c.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler));
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, minValues, maxValues, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.meanBetweenValues(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends UpdatablePArray> mean(Matrix<? extends PArray> src, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.mean(c.get(0), pattern));
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfSum(Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.functionOfSum(c.get(0), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, percentileIndexes1, percentileIndexes2, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.functionOfPercentilePair(c.get(0), c.get(1), c.get(2), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.functionOfPercentilePair(c.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc));
    }

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        Continuer c = new Continuer(dest, src, percentileIndexes, pattern, this.parent, this.continuationMode);
        this.parent.percentile(c.continuedDest(), c.get(0), c.get(1), pattern);
    }

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Continuer c = new Continuer(dest, src, pattern, this.parent, this.continuationMode);
        this.parent.percentile(c.continuedDest(), c.get(0), percentileIndex, pattern);
    }

    @Override
    public void rank(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        Continuer c = new Continuer(dest, baseMatrix, rankedMatrix, pattern, this.parent, this.continuationMode);
        this.parent.rank(c.continuedDest(), c.get(0), c.get(1), pattern);
    }

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, Pattern pattern, double filler) {
        Continuer c = new Continuer(dest, src, fromPercentileIndexes, toPercentileIndexes, pattern, this.parent, this.continuationMode);
        this.parent.meanBetweenPercentiles(c.continuedDest(), c.get(0), c.get(1), c.get(2), pattern, filler);
    }

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Continuer c = new Continuer(dest, src, pattern, this.parent, this.continuationMode);
        this.parent.meanBetweenPercentiles(c.continuedDest(), c.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler);
    }

    @Override
    public void meanBetweenValues(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        Continuer c = new Continuer(dest, src, minValues, maxValues, pattern, this.parent, this.continuationMode);
        this.parent.meanBetweenValues(c.continuedDest(), c.get(0), c.get(1), c.get(2), pattern, filler);
    }

    @Override
    public void mean(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        Continuer c = new Continuer(dest, src, pattern, this.parent, this.continuationMode);
        this.parent.mean(c.continuedDest(), c.get(0), pattern);
    }

    @Override
    public void functionOfSum(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(dest, src, pattern, this.parent, this.continuationMode);
        this.parent.functionOfSum(c.continuedDest(), c.get(0), pattern, processingFunc);
    }

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(dest, src, percentileIndexes1, percentileIndexes2, pattern, this.parent, this.continuationMode);
        this.parent.functionOfPercentilePair(c.continuedDest(), c.get(0), c.get(1), c.get(2), pattern, processingFunc);
    }

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(dest, src, pattern, this.parent, this.continuationMode);
        this.parent.functionOfPercentilePair(c.continuedDest(), c.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc);
    }
}

