/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SummingHistogram;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.morphology.HistogramCache;
import net.algart.matrices.morphology.RankOperationProcessor;

class AveragerBetweenPercentiles
extends RankOperationProcessor {
    private static final boolean DEBUG_MODE = false;
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean inlineOneLevel = INLINE_ONE_LEVEL;
    private final double filler;
    private final boolean interpolated;

    AveragerBetweenPercentiles(ArrayContext context, double filler, boolean interpolated, int[] bitLevels) {
        super(context, bitLevels);
        this.filler = filler;
        this.interpolated = interpolated;
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, final long[] shifts, final long[] left, final long[] right) {
        ArrayPool ap2;
        if (additional.length < 2) {
            throw new IllegalArgumentException("Two additional matrices are required (percentile indexes)");
        }
        assert (shifts.length > 0);
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        final PArray fPerc1 = additional[0];
        final ArrayPool ap1 = this.optimizeDirectArrays && (Arrays.isNCopies(fPerc1) || SimpleMemoryModel.isSimpleArray(fPerc1)) ? null : ArrayPool.getInstance(Arrays.SMM, fPerc1.elementType(), 65536L);
        final PArray fPerc2 = additional[1];
        ArrayPool arrayPool = ap2 = this.optimizeDirectArrays && (Arrays.isNCopies(fPerc2) || SimpleMemoryModel.isSimpleArray(fPerc2)) ? null : ArrayPool.getInstance(Arrays.SMM, fPerc2.elementType(), 65536L);
        if (src instanceof BitArray) {
            final BitArray a = (BitArray)src;
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double i;
                    int r2;
                    int r1;
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    if (pIndex1 < 0.0) {
                        r1 = 0;
                        pIndex1 = 0;
                    } else if (pIndex1 > (double)shifts.length) {
                        r1 = shifts.length;
                        pIndex1 = r1;
                    } else {
                        r1 = (int)pIndex1;
                    }
                    if (pIndex2 < 0.0) {
                        r2 = 0;
                        pIndex2 = 0;
                    } else if (pIndex2 > (double)shifts.length) {
                        r2 = shifts.length;
                        pIndex2 = r2;
                    } else {
                        r2 = (int)pIndex2;
                    }
                    assert (0 <= r1 && r1 <= r2 && r2 <= shifts.length);
                    if (r1 == shifts.length || pIndex2 == 0.0) {
                        assert (pIndex1 == pIndex2);
                        return 0.0;
                    }
                    int b = 0;
                    for (long shift : shifts) {
                        long i2 = index - shift;
                        if (i2 < 0L) {
                            i2 += this.length;
                        }
                        if (a.getBit(i2)) continue;
                        ++b;
                    }
                    if (pIndex2 <= (double)b) {
                        assert (b > 0);
                        i = (pIndex2 - pIndex1) * 0.5 * (pIndex1 + pIndex2) / (double)b;
                    } else if (r1 >= b) {
                        assert (b < shifts.length);
                        i = (pIndex2 - pIndex1) * (1.0 + (0.5 * (pIndex1 + pIndex2) - (double)b) / (double)(shifts.length - b));
                    } else {
                        assert (b > 0);
                        assert (b < shifts.length);
                        i = ((double)b - pIndex1) * 0.5 * (pIndex1 + (double)b) / (double)b + (pIndex2 - (double)b) * (1.0 + 0.5 * (pIndex2 - (double)b) / (double)(shifts.length - b));
                    }
                    return i / n;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    int[] hist = (int[])histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = new int[1];
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (a.getBit(i)) continue;
                            hist[0] = hist[0] + 1;
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                double i2;
                                int r2;
                                int r1;
                                if (pIndex1 < 0.0) {
                                    r1 = 0;
                                    pIndex1 = 0;
                                } else if (pIndex1 > (double)shifts.length) {
                                    r1 = shifts.length;
                                    pIndex1 = r1;
                                } else {
                                    r1 = (int)pIndex1;
                                }
                                if (pIndex2 < 0.0) {
                                    r2 = 0;
                                    pIndex2 = 0;
                                } else if (pIndex2 > (double)shifts.length) {
                                    r2 = shifts.length;
                                    pIndex2 = r2;
                                } else {
                                    r2 = (int)pIndex2;
                                }
                                assert (0 <= r1 && r1 <= r2 && r2 <= shifts.length);
                                int b = hist[0];
                                if (r1 == shifts.length || pIndex2 == 0.0) {
                                    assert (pIndex1 == pIndex2);
                                    i2 = 0.0;
                                } else if (pIndex2 <= (double)b) {
                                    assert (b > 0);
                                    i2 = (pIndex2 - pIndex1) * 0.5 * (pIndex1 + pIndex2) / (double)b;
                                } else if (r1 >= b) {
                                    assert (b < shifts.length);
                                    i2 = (pIndex2 - pIndex1) * (1.0 + (0.5 * (pIndex1 + pIndex2) - (double)b) / (double)(shifts.length - b));
                                } else {
                                    assert (b > 0);
                                    assert (b < shifts.length);
                                    i2 = ((double)b - pIndex1) * 0.5 * (pIndex1 + (double)b) / (double)b + (pIndex2 - (double)b) * (1.0 + 0.5 * (pIndex2 - (double)b) / (double)(shifts.length - b));
                                }
                                w = i2 / n;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] - 1;
                                assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] + 1;
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof CharArray) {
            final CharArray a = (CharArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        double i;
                                        int r2;
                                        int r1;
                                        if (pIndex1 < 0.0) {
                                            r1 = 0;
                                            pIndex1 = 0;
                                        } else if (pIndex1 > (double)shifts.length) {
                                            r1 = shifts.length;
                                            pIndex1 = r1;
                                        } else {
                                            r1 = (int)pIndex1;
                                        }
                                        if (r1 < currentIRank1) {
                                            do {
                                                b = hist[--currentIValue1];
                                                currentSum1 -= (long)b * (long)currentIValue1;
                                            } while (r1 < (currentIRank1 -= b));
                                            assert (currentIRank1 >= 0);
                                        } else if (r1 < shifts.length) {
                                            b = hist[currentIValue1];
                                            while (r1 >= currentIRank1 + b) {
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                b = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                        } else if (currentIRank1 == shifts.length) {
                                            assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                            assert (currentIValue1 > 0);
                                            while (hist[currentIValue1 - 1] == 0) {
                                                assert (--currentIValue1 > 0);
                                            }
                                        } else {
                                            assert (currentIRank1 < shifts.length);
                                            do {
                                                b = hist[currentIValue1];
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                ++currentIValue1;
                                            } while ((currentIRank1 += b) < shifts.length);
                                            assert (currentIRank1 == shifts.length);
                                        }
                                        if (pIndex2 < 0.0) {
                                            r2 = 0;
                                            pIndex2 = 0;
                                        } else if (pIndex2 > (double)shifts.length) {
                                            r2 = shifts.length;
                                            pIndex2 = r2;
                                        } else {
                                            r2 = (int)pIndex2;
                                        }
                                        if (r2 < currentIRank2) {
                                            do {
                                                b = hist[--currentIValue2];
                                                currentSum2 -= (long)b * (long)currentIValue2;
                                            } while (r2 < (currentIRank2 -= b));
                                            assert (currentIRank2 >= 0);
                                        } else if (r2 < shifts.length) {
                                            b = hist[currentIValue2];
                                            while (r2 >= currentIRank2 + b) {
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                b = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                        } else if (currentIRank2 == shifts.length) {
                                            assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                            assert (currentIValue2 > 0);
                                            while (hist[currentIValue2 - 1] == 0) {
                                                assert (--currentIValue2 > 0);
                                            }
                                        } else {
                                            assert (currentIRank2 < shifts.length);
                                            do {
                                                b = hist[currentIValue2];
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                ++currentIValue2;
                                            } while ((currentIRank2 += b) < shifts.length);
                                            assert (currentIRank2 == shifts.length);
                                        }
                                        double i1 = (double)currentSum1 + 0.5 * (double)currentIRank1;
                                        if (pIndex1 != (double)currentIRank1) {
                                            assert ((double)currentIRank1 < pIndex1);
                                            int b = hist[currentIValue1];
                                            assert (b > 0);
                                            double delta = (pIndex1 - (double)currentIRank1) / (double)b;
                                            i1 += (pIndex1 - (double)currentIRank1) * ((double)currentIValue1 + 0.5 * delta);
                                        }
                                        double i2 = (double)currentSum2 + 0.5 * (double)currentIRank2;
                                        if (pIndex2 != (double)currentIRank2) {
                                            assert ((double)currentIRank2 < pIndex2);
                                            int b = hist[currentIValue2];
                                            assert (b > 0);
                                            double delta = (pIndex2 - (double)currentIRank2) / (double)b;
                                            i2 += (pIndex2 - (double)currentIRank2) * ((double)currentIValue2 + 0.5 * delta);
                                        }
                                        if ((i = i2 - i1) < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i));
                                        }
                                        w = i / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = a.getInt(i) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n2 = a.getInt(i) >> bs;
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            final ByteArray a = (ByteArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 8);
            final int bs = 8 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        double i;
                                        int r2;
                                        int r1;
                                        if (pIndex1 < 0.0) {
                                            r1 = 0;
                                            pIndex1 = 0;
                                        } else if (pIndex1 > (double)shifts.length) {
                                            r1 = shifts.length;
                                            pIndex1 = r1;
                                        } else {
                                            r1 = (int)pIndex1;
                                        }
                                        if (r1 < currentIRank1) {
                                            do {
                                                b = hist[--currentIValue1];
                                                currentSum1 -= (long)b * (long)currentIValue1;
                                            } while (r1 < (currentIRank1 -= b));
                                            assert (currentIRank1 >= 0);
                                        } else if (r1 < shifts.length) {
                                            b = hist[currentIValue1];
                                            while (r1 >= currentIRank1 + b) {
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                b = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                        } else if (currentIRank1 == shifts.length) {
                                            assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                            assert (currentIValue1 > 0);
                                            while (hist[currentIValue1 - 1] == 0) {
                                                assert (--currentIValue1 > 0);
                                            }
                                        } else {
                                            assert (currentIRank1 < shifts.length);
                                            do {
                                                b = hist[currentIValue1];
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                ++currentIValue1;
                                            } while ((currentIRank1 += b) < shifts.length);
                                            assert (currentIRank1 == shifts.length);
                                        }
                                        if (pIndex2 < 0.0) {
                                            r2 = 0;
                                            pIndex2 = 0;
                                        } else if (pIndex2 > (double)shifts.length) {
                                            r2 = shifts.length;
                                            pIndex2 = r2;
                                        } else {
                                            r2 = (int)pIndex2;
                                        }
                                        if (r2 < currentIRank2) {
                                            do {
                                                b = hist[--currentIValue2];
                                                currentSum2 -= (long)b * (long)currentIValue2;
                                            } while (r2 < (currentIRank2 -= b));
                                            assert (currentIRank2 >= 0);
                                        } else if (r2 < shifts.length) {
                                            b = hist[currentIValue2];
                                            while (r2 >= currentIRank2 + b) {
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                b = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                        } else if (currentIRank2 == shifts.length) {
                                            assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                            assert (currentIValue2 > 0);
                                            while (hist[currentIValue2 - 1] == 0) {
                                                assert (--currentIValue2 > 0);
                                            }
                                        } else {
                                            assert (currentIRank2 < shifts.length);
                                            do {
                                                b = hist[currentIValue2];
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                ++currentIValue2;
                                            } while ((currentIRank2 += b) < shifts.length);
                                            assert (currentIRank2 == shifts.length);
                                        }
                                        double i1 = (double)currentSum1 + 0.5 * (double)currentIRank1;
                                        if (pIndex1 != (double)currentIRank1) {
                                            assert ((double)currentIRank1 < pIndex1);
                                            int b = hist[currentIValue1];
                                            assert (b > 0);
                                            double delta = (pIndex1 - (double)currentIRank1) / (double)b;
                                            i1 += (pIndex1 - (double)currentIRank1) * ((double)currentIValue1 + 0.5 * delta);
                                        }
                                        double i2 = (double)currentSum2 + 0.5 * (double)currentIRank2;
                                        if (pIndex2 != (double)currentIRank2) {
                                            assert ((double)currentIRank2 < pIndex2);
                                            int b = hist[currentIValue2];
                                            assert (b > 0);
                                            double delta = (pIndex2 - (double)currentIRank2) / (double)b;
                                            i2 += (pIndex2 - (double)currentIRank2) * ((double)currentIValue2 + 0.5 * delta);
                                        }
                                        if ((i = i2 - i1) < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i));
                                        }
                                        w = i / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = a.getInt(i) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n2 = a.getInt(i) >> bs;
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            final ShortArray a = (ShortArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            if (direct) {
                boolean implementHere;
                final short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        double i;
                                        int r2;
                                        int r1;
                                        if (pIndex1 < 0.0) {
                                            r1 = 0;
                                            pIndex1 = 0;
                                        } else if (pIndex1 > (double)shifts.length) {
                                            r1 = shifts.length;
                                            pIndex1 = r1;
                                        } else {
                                            r1 = (int)pIndex1;
                                        }
                                        if (r1 < currentIRank1) {
                                            do {
                                                b = hist[--currentIValue1];
                                                currentSum1 -= (long)b * (long)currentIValue1;
                                            } while (r1 < (currentIRank1 -= b));
                                            assert (currentIRank1 >= 0);
                                        } else if (r1 < shifts.length) {
                                            b = hist[currentIValue1];
                                            while (r1 >= currentIRank1 + b) {
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                b = hist[++currentIValue1];
                                            }
                                            assert (currentIRank1 < shifts.length);
                                        } else if (currentIRank1 == shifts.length) {
                                            assert (currentIValue1 == hist.length || hist[currentIValue1] == 0);
                                            assert (currentIValue1 > 0);
                                            while (hist[currentIValue1 - 1] == 0) {
                                                assert (--currentIValue1 > 0);
                                            }
                                        } else {
                                            assert (currentIRank1 < shifts.length);
                                            do {
                                                b = hist[currentIValue1];
                                                currentSum1 += (long)b * (long)currentIValue1;
                                                ++currentIValue1;
                                            } while ((currentIRank1 += b) < shifts.length);
                                            assert (currentIRank1 == shifts.length);
                                        }
                                        if (pIndex2 < 0.0) {
                                            r2 = 0;
                                            pIndex2 = 0;
                                        } else if (pIndex2 > (double)shifts.length) {
                                            r2 = shifts.length;
                                            pIndex2 = r2;
                                        } else {
                                            r2 = (int)pIndex2;
                                        }
                                        if (r2 < currentIRank2) {
                                            do {
                                                b = hist[--currentIValue2];
                                                currentSum2 -= (long)b * (long)currentIValue2;
                                            } while (r2 < (currentIRank2 -= b));
                                            assert (currentIRank2 >= 0);
                                        } else if (r2 < shifts.length) {
                                            b = hist[currentIValue2];
                                            while (r2 >= currentIRank2 + b) {
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                b = hist[++currentIValue2];
                                            }
                                            assert (currentIRank2 < shifts.length);
                                        } else if (currentIRank2 == shifts.length) {
                                            assert (currentIValue2 == hist.length || hist[currentIValue2] == 0);
                                            assert (currentIValue2 > 0);
                                            while (hist[currentIValue2 - 1] == 0) {
                                                assert (--currentIValue2 > 0);
                                            }
                                        } else {
                                            assert (currentIRank2 < shifts.length);
                                            do {
                                                b = hist[currentIValue2];
                                                currentSum2 += (long)b * (long)currentIValue2;
                                                ++currentIValue2;
                                            } while ((currentIRank2 += b) < shifts.length);
                                            assert (currentIRank2 == shifts.length);
                                        }
                                        double i1 = (double)currentSum1 + 0.5 * (double)currentIRank1;
                                        if (pIndex1 != (double)currentIRank1) {
                                            assert ((double)currentIRank1 < pIndex1);
                                            int b = hist[currentIValue1];
                                            assert (b > 0);
                                            double delta = (pIndex1 - (double)currentIRank1) / (double)b;
                                            i1 += (pIndex1 - (double)currentIRank1) * ((double)currentIValue1 + 0.5 * delta);
                                        }
                                        double i2 = (double)currentSum2 + 0.5 * (double)currentIRank2;
                                        if (pIndex2 != (double)currentIRank2) {
                                            assert ((double)currentIRank2 < pIndex2);
                                            int b = hist[currentIValue2];
                                            assert (b > 0);
                                            double delta = (pIndex2 - (double)currentIRank2) / (double)b;
                                            i2 += (pIndex2 - (double)currentIRank2) * ((double)currentIValue2 + 0.5 * delta);
                                        }
                                        if ((i = i2 - i1) < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i));
                                        }
                                        w = i / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n2 = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n2] = hist[n2] - 1;
                                        if (hist[n2] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        long i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n3 = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n3] = hist[n3] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = a.getInt(i) >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n2 = a.getInt(i) >> bs;
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            final IntArray a = (IntArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 31 - nab;
            final double multiplierInv = 1L << bs;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                int v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                int n2 = v >> bs;
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    int v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0) {
                                v = 0;
                            }
                            int n2 = v >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            int n2 = v >> bs;
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.exclude(v >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        int v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getInt(i)) < 0) {
                            v = 0;
                        }
                        int n2 = v >> bs;
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            int v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            hist1.include(v >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.exclude(v >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            final LongArray a = (LongArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 63 - nab;
            final double multiplierInv = 1L << bs;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                int n2 = (int)(v >> bs);
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0L) {
                                v = 0L;
                            }
                            int n2 = (int)(v >> bs);
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            int n2 = (int)(v >> bs);
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.exclude((int)(v >> bs));
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getLong(i)) < 0L) {
                            v = 0L;
                        }
                        int n2 = (int)(v >> bs);
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            hist1.include((int)(v >> bs));
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.exclude((int)(v >> bs));
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            final FloatArray a = (FloatArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n2 = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            final DoubleArray a = (DoubleArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double pIndex1 = fPerc1.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex1);
                            double pIndex2 = fPerc2.getDouble(index);
                            AveragerBetweenPercentiles.checkNaN(pIndex2);
                            double n = pIndex2 - pIndex1;
                            if (n <= 0.0) {
                                return AveragerBetweenPercentiles.this.filler;
                            }
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n2 = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n2] = hist[n2] + 1;
                            }
                            double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenPercentiles.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(fPerc1.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(fPerc2.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                    double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                    double w = AveragerBetweenPercentiles.this.filler;
                                    double n = pIndex2 - pIndex1;
                                    if (n > 0.0) {
                                        hist1.moveToRank(pIndex1);
                                        hist2.moveToRank(pIndex2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < 0.0) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        w = i2 / n * multiplierInv;
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToPreciseRank(pIndex1);
                                    hist2.moveToPreciseRank(pIndex2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double pIndex1 = fPerc1.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex1);
                        double pIndex2 = fPerc2.getDouble(index);
                        AveragerBetweenPercentiles.checkNaN(pIndex2);
                        double n = pIndex2 - pIndex1;
                        if (n <= 0.0) {
                            return AveragerBetweenPercentiles.this.filler;
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n2 = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n2] = hist[n2] + 1;
                        }
                        double i = SummingHistogram.integralBetweenRanks(hist, pIndex1, pIndex2);
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenPercentiles.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(fPerc1.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(fPerc2.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                                double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                                double w = AveragerBetweenPercentiles.this.filler;
                                double n = pIndex2 - pIndex1;
                                if (n > 0.0) {
                                    hist1.moveToRank(pIndex1);
                                    hist2.moveToRank(pIndex2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < 0.0) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    w = i2 / n * multiplierInv;
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double pIndex1 = fPerc1.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex1);
                    double pIndex2 = fPerc2.getDouble(index);
                    AveragerBetweenPercentiles.checkNaN(pIndex2);
                    double n = pIndex2 - pIndex1;
                    if (n <= 0.0) {
                        return AveragerBetweenPercentiles.this.filler;
                    }
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n2 = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n2] = hist[n2] + 1;
                    }
                    double i = SummingHistogram.preciseIntegralBetweenRanks(hist, pIndex1, pIndex2);
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenPercentiles.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenPercentiles.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenPercentiles.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(fPerc1.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(fPerc2.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double pIndex1 = ap1 != null ? buf1.getDouble(k) : fPerc1.getDouble(arrayPos);
                            double pIndex2 = ap2 != null ? buf2.getDouble(k) : fPerc2.getDouble(arrayPos);
                            double w = AveragerBetweenPercentiles.this.filler;
                            double n = pIndex2 - pIndex1;
                            if (n > 0.0) {
                                hist1.moveToPreciseRank(pIndex1);
                                hist2.moveToPreciseRank(pIndex2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < 0.0) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + ", simple integral = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                }
                                w = i2 / n * multiplierInv;
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }

    private static void checkNaN(double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank (NaN) in some elements of fromPercentileIndexes or toPercentileIndexes");
        }
    }
}

