/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.WeightedPattern;
import net.algart.matrices.ApertureProcessor;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.TiledApertureProcessorFactory;
import net.algart.matrices.linearfiltering.Convolution;

public class TiledConvolution
implements Convolution {
    private final Convolution parent;
    private final ArrayContext context;
    private final TiledApertureProcessorFactory tiler;
    private final int dimCount;

    TiledConvolution(Convolution parent, TiledApertureProcessorFactory tiler) {
        Objects.requireNonNull(parent, "Null parent convolution");
        Objects.requireNonNull(tiler, "Null tiler");
        this.parent = parent;
        this.context = parent.context() == null ? ArrayContext.DEFAULT : parent.context();
        this.tiler = tiler.context(this.context);
        this.dimCount = tiler.dimCount();
    }

    public static TiledConvolution getInstance(Convolution parent, TiledApertureProcessorFactory tiler) {
        return new TiledConvolution(parent, tiler);
    }

    public Convolution parent() {
        return this.parent;
    }

    public TiledApertureProcessorFactory tiler() {
        return this.tiler;
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    @Override
    public Convolution context(ArrayContext newContext) {
        return new TiledConvolution(this.parent.context(newContext), this.tiler);
    }

    @Override
    public boolean isPseudoCyclic() {
        return this.tiler.continuationMode() == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public double increment(Class<?> elementType) {
        return this.parent.increment(elementType);
    }

    @Override
    public Matrix<? extends PArray> asConvolution(Matrix<? extends PArray> src, WeightedPattern pattern) {
        IRectangularArea a = (this.parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, false);
        src = DependenceApertureBuilder.extend(src, a, this.tiler.continuationMode());
        return DependenceApertureBuilder.reduce(this.parent.asConvolution(src, pattern), a);
    }

    @Override
    public <T extends PArray> Matrix<T> asConvolution(Class<? extends T> requiredType, Matrix<? extends PArray> src, WeightedPattern pattern) {
        IRectangularArea a = (this.parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, false);
        src = DependenceApertureBuilder.extend(src, a, this.tiler.continuationMode());
        return DependenceApertureBuilder.reduce(this.parent.asConvolution(requiredType, src, pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> convolution(Matrix<? extends PArray> src, final WeightedPattern pattern) {
        return this.tilingProcess(new ConvolutionProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().convolution(src, pattern);
            }
        }, null, src);
    }

    @Override
    public <T extends PArray> Matrix<? extends T> convolution(final Class<? extends T> requiredType, Matrix<? extends PArray> src, final WeightedPattern pattern) {
        return this.tilingProcess(new ConvolutionProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

            @Override
            public Matrix<? extends PArray> process(Matrix<? extends PArray> src) {
                return this.parent().convolution(requiredType, src, pattern);
            }
        }, null, src).cast(requiredType);
    }

    @Override
    public void convolution(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final WeightedPattern pattern) {
        this.tilingProcess(new ConvolutionInPlaceProcessor(this, DependenceApertureBuilder.SUM.getAperture(this.dimCount, pattern, false)){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
                this.parent().convolution(dest, src, pattern);
            }
        }, dest, src);
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
        LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>> destMatrices = new LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>>();
        LinkedHashMap<Integer, Matrix<? extends PArray>> srcMatrices = new LinkedHashMap<Integer, Matrix<? extends PArray>>();
        destMatrices.put(0, dest);
        srcMatrices.put(0, src);
        this.tiler.tile(processor).process(destMatrices, srcMatrices);
        return ((Matrix)destMatrices.get(0)).cast(UpdatablePArray.class);
    }

    private abstract class ConvolutionInPlaceProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;

        private ConvolutionInPlaceProcessor(IRectangularArea dependenceAperture) {
            super(null);
            this.dependenceAperture = dependenceAperture;
        }

        public Convolution parent() {
            return TiledConvolution.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() == 1);
            assert (dest.size() == 1);
            this.process(dest.get(0).cast(UpdatablePArray.class), src.get(0).cast(PArray.class));
        }

        public abstract void process(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            assert (srcMatrixKey == 0);
            return this.dependenceAperture;
        }
    }

    private abstract class ConvolutionProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;

        private ConvolutionProcessor(IRectangularArea dependenceAperture) {
            super(null);
            this.dependenceAperture = dependenceAperture;
        }

        public Convolution parent() {
            return TiledConvolution.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() == 1);
            assert (dest.size() == 1);
            dest.put(0, this.process(src.get(0).cast(PArray.class)));
        }

        public abstract Matrix<? extends PArray> process(Matrix<? extends PArray> var1);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            assert (srcMatrixKey == 0);
            return this.dependenceAperture;
        }
    }
}

