/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import java.util.Arrays;
import java.util.Random;
import net.algart.matrices.filters3x3.AbstractQuickFilter3x3;
import net.algart.matrices.filters3x3.DilationBySquare3x3;
import net.algart.matrices.filters3x3.ErosionBySquare3x3;
import net.algart.matrices.filters3x3.MedianBySquare3x3;

public abstract class PercentileBySquare3x3
extends AbstractQuickFilter3x3 {
    final int percentileIndex;
    final int percentileIndexP1;
    final int percentileIndexM1;

    PercentileBySquare3x3(Class<?> elementType, long[] dimensions, int percentileIndex) {
        super(elementType, dimensions);
        if (percentileIndex < 0 || percentileIndex > 8) {
            throw new IllegalArgumentException("Percentile index is out of allowed range 0..8");
        }
        this.percentileIndex = percentileIndex;
        this.percentileIndexP1 = percentileIndex + 1;
        this.percentileIndexM1 = percentileIndex - 1;
    }

    public static PercentileBySquare3x3 newInstance(Class<?> elementType, long dimX, long dimY, int percentileIndex) {
        return PercentileBySquare3x3.newInstance(elementType, new long[]{dimX, dimY}, percentileIndex);
    }

    public static PercentileBySquare3x3 newInstance(Class<?> elementType, long[] dimensions, int percentileIndex) {
        return PercentileBySquare3x3.newInstance(elementType, dimensions, percentileIndex, true);
    }

    public static PercentileBySquare3x3 newInstance(Class<?> elementType, long[] dimensions, int percentileIndex, boolean specialAlgorithmWhenPossible) {
        if (specialAlgorithmWhenPossible) {
            switch (percentileIndex) {
                case 4: {
                    return MedianBySquare3x3.newInstance(elementType, dimensions);
                }
                case 0: {
                    return ErosionBySquare3x3.newInstance(elementType, dimensions);
                }
                case 8: {
                    return DilationBySquare3x3.newInstance(elementType, dimensions);
                }
            }
        }
        if (elementType == Character.TYPE) {
            return new ForChar(dimensions, percentileIndex);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(dimensions, percentileIndex);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(dimensions, percentileIndex);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(dimensions, percentileIndex);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(dimensions, percentileIndex);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(dimensions, percentileIndex);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions, percentileIndex);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions, percentileIndex);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    public int percentileIndex() {
        return this.percentileIndex;
    }

    public static void main(String[] args) {
        int max = 100;
        Random rnd = new Random(22L);
        int[] v = new int[9];
        int testCount = 0x100000;
        for (int test = 1; test <= testCount; ++test) {
            Arrays.setAll(v, k -> rnd.nextInt(100));
            int count = 1 + rnd.nextInt(8);
            int index = rnd.nextInt(count);
            int percentileL = ForInt.percentileStartingFromMinimum((int[])v.clone(), count, index);
            int percentileR = ForInt.percentileStartingFromMaximum((int[])v.clone(), count, index);
            Arrays.sort(v, 0, count);
            if (percentileL != v[index]) {
                throw new AssertionError((Object)(test + ": Invalid percentileL #" + index + ": " + percentileL + " instead of " + v[index] + " for " + Arrays.toString(v)));
            }
            if (percentileR != v[count - 1 - index]) {
                throw new AssertionError((Object)(test + ": Invalid percentileR #" + index + ": " + percentileR + " instead of " + v[count - 1 - index] + " for " + Arrays.toString(v)));
            }
        }
        int[] left = new int[7];
        int[] right = new int[7];
        int testCount2 = 0x1000000;
        for (int test = 1; test <= testCount2; ++test) {
            if ((test & 0xFF) == 0) {
                System.out.print("\r" + test);
            }
            int index = rnd.nextInt(9);
            ForInt percentile = new ForInt(new long[]{10L, 10L}, index);
            Arrays.setAll(v, k -> rnd.nextInt(100));
            int percentileSimple = percentile.slowPercentile(v);
            int percentileA = percentile.percentileVersionA(left, right, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
            if (percentileA != percentileSimple) {
                throw new AssertionError((Object)(test + ": Invalid percentile-A #" + index + ": " + percentileA + " instead of " + percentileSimple + " for " + Arrays.toString(v)));
            }
            int percentileB = percentile.percentileVersionB(left, right, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
            if (percentileB != percentileSimple) {
                throw new AssertionError((Object)(test + ": Invalid percentile-B #" + index + ": " + percentileB + " instead of " + percentileSimple + " for " + Arrays.toString(v)));
            }
            int percentileC = percentile.percentileVersionC(left, right, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
            if (percentileC != percentileSimple) {
                throw new AssertionError((Object)(test + ": Invalid percentile-C #" + index + ": " + percentileC + " instead of " + percentileSimple + " for " + Arrays.toString(v)));
            }
        }
    }

    private static class ForChar
    extends PercentileBySquare3x3 {
        private final int[][] threadLeft = new int[this.numberOfRanges()][7];
        private final int[][] threadRight = new int[this.numberOfRanges()][7];

        private ForChar(long[] dimensions, int percentileIndex) {
            super(Character.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            int[] left = this.threadLeft[multithreadingRangeIndex];
            int[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            int v0 = source[firstLineOffset + this.dimXm1];
            int v1 = source[firstLineOffset];
            int v2 = source[firstLineOffset + this.rem1ForDimX];
            int v3 = source[middleLineOffset + this.dimXm1];
            int v4 = source[middleLineOffset];
            int v5 = source[middleLineOffset + this.rem1ForDimX];
            int v6 = source[lastLineOffset + this.dimXm1];
            int v7 = source[lastLineOffset];
            int v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (char)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                int vR;
                int vM;
                int vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                int r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForChar.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForChar.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = (char)r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (char)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private int slowPercentile(int ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private int percentileVersionA(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            int r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(int[] left, int[] right, int v0, int vL, int vR, int vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(int[] right, int count, int v) {
            int w;
            while (count > 0 && v <= (w = right[count - 1])) {
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(int[] left, int count, int v) {
            int w;
            while (count > 0 && v <= (w = left[count - 1])) {
                left[count--] = w;
            }
            left[count] = v;
        }

        private int percentileVersionB(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int r;
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForChar.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForChar.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(int[] a, int count) {
            int k = 0;
            while (++k < count) {
                int w;
                int i = k;
                int ai = a[i];
                if (ai >= a[i - 1]) continue;
                while (--i >= 0 && ai < (w = a[i])) {
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private int percentileVersionC(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForChar.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForChar.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static int percentileStartingFromMinimum(int[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                int w;
                int min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai >= min) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static int percentileStartingFromMaximum(int[] a, int count, int percentileReverseIndex) {
            int k = 0;
            while (true) {
                int w;
                int max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai <= max) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if (k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    static class ForBit
    extends PercentileBySquare3x3 {
        private ForBit(long[] dimensions, int percentileIndex) {
            super(Boolean.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            boolean v0 = source[firstLineOffset + this.dimXm1];
            boolean v1 = source[firstLineOffset];
            boolean v2 = source[firstLineOffset + this.rem1ForDimX];
            boolean v3 = source[middleLineOffset + this.dimXm1];
            boolean v4 = source[middleLineOffset];
            boolean v5 = source[middleLineOffset + this.rem1ForDimX];
            boolean v6 = source[lastLineOffset + this.dimXm1];
            boolean v7 = source[lastLineOffset];
            boolean v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForBit.percentile(this.percentileIndex, v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = ForBit.percentile(this.percentileIndex, v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForBit.percentile(this.percentileIndex, v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        static boolean percentile(int percentileIndex, boolean v0, boolean v1, boolean v2, boolean v3, boolean v4, boolean v5, boolean v6, boolean v7, boolean v8) {
            int count;
            int n = count = v0 ? 1 : 0;
            if (v1) {
                ++count;
            }
            if (v2) {
                ++count;
            }
            if (v3) {
                ++count;
            }
            if (v4) {
                ++count;
            }
            if (v5) {
                ++count;
            }
            if (v6) {
                ++count;
            }
            if (v7) {
                ++count;
            }
            if (v8) {
                ++count;
            }
            return percentileIndex >= 9 - count;
        }
    }

    private static class ForByte
    extends PercentileBySquare3x3 {
        private final int[][] threadLeft = new int[this.numberOfRanges()][7];
        private final int[][] threadRight = new int[this.numberOfRanges()][7];

        private ForByte(long[] dimensions, int percentileIndex) {
            super(Byte.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int[] left = this.threadLeft[multithreadingRangeIndex];
            int[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFF;
            int v1 = source[firstLineOffset] & 0xFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFF;
            int v4 = source[middleLineOffset] & 0xFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFF;
            int v7 = source[lastLineOffset] & 0xFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFF;
            result[resultLineOffset] = (byte)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                int vR;
                int vM;
                int vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFF;
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                int r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForByte.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForByte.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = (byte)r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFF;
                result[++resultLineOffset] = (byte)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private int slowPercentile(int ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private int percentileVersionA(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            int r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(int[] left, int[] right, int v0, int vL, int vR, int vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(int[] right, int count, int v) {
            int w;
            while (count > 0 && v <= (w = right[count - 1])) {
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(int[] left, int count, int v) {
            int w;
            while (count > 0 && v <= (w = left[count - 1])) {
                left[count--] = w;
            }
            left[count] = v;
        }

        private int percentileVersionB(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int r;
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForByte.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForByte.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(int[] a, int count) {
            int k = 0;
            while (++k < count) {
                int w;
                int i = k;
                int ai = a[i];
                if (ai >= a[i - 1]) continue;
                while (--i >= 0 && ai < (w = a[i])) {
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private int percentileVersionC(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForByte.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForByte.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static int percentileStartingFromMinimum(int[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                int w;
                int min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai >= min) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static int percentileStartingFromMaximum(int[] a, int count, int percentileReverseIndex) {
            int k = 0;
            while (true) {
                int w;
                int max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai <= max) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if (k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    private static class ForShort
    extends PercentileBySquare3x3 {
        private final int[][] threadLeft = new int[this.numberOfRanges()][7];
        private final int[][] threadRight = new int[this.numberOfRanges()][7];

        private ForShort(long[] dimensions, int percentileIndex) {
            super(Short.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int[] left = this.threadLeft[multithreadingRangeIndex];
            int[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFFFF;
            int v1 = source[firstLineOffset] & 0xFFFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int v4 = source[middleLineOffset] & 0xFFFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFFFF;
            int v7 = source[lastLineOffset] & 0xFFFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFFFF;
            result[resultLineOffset] = (short)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                int vR;
                int vM;
                int vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFFFF;
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                int r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForShort.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForShort.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = (short)r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFFFF;
                result[++resultLineOffset] = (short)this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private int slowPercentile(int ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private int percentileVersionA(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            int r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(int[] left, int[] right, int v0, int vL, int vR, int vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(int[] right, int count, int v) {
            int w;
            while (count > 0 && v <= (w = right[count - 1])) {
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(int[] left, int count, int v) {
            int w;
            while (count > 0 && v <= (w = left[count - 1])) {
                left[count--] = w;
            }
            left[count] = v;
        }

        private int percentileVersionB(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int r;
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForShort.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForShort.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(int[] a, int count) {
            int k = 0;
            while (++k < count) {
                int w;
                int i = k;
                int ai = a[i];
                if (ai >= a[i - 1]) continue;
                while (--i >= 0 && ai < (w = a[i])) {
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private int percentileVersionC(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForShort.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForShort.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static int percentileStartingFromMinimum(int[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                int w;
                int min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai >= min) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static int percentileStartingFromMaximum(int[] a, int count, int percentileReverseIndex) {
            int k = 0;
            while (true) {
                int w;
                int max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai <= max) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if (k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    private static class ForInt
    extends PercentileBySquare3x3 {
        private final int[][] threadLeft = new int[this.numberOfRanges()][7];
        private final int[][] threadRight = new int[this.numberOfRanges()][7];

        private ForInt(long[] dimensions, int percentileIndex) {
            super(Integer.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            int[] left = this.threadLeft[multithreadingRangeIndex];
            int[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            int v0 = source[firstLineOffset + this.dimXm1];
            int v1 = source[firstLineOffset];
            int v2 = source[firstLineOffset + this.rem1ForDimX];
            int v3 = source[middleLineOffset + this.dimXm1];
            int v4 = source[middleLineOffset];
            int v5 = source[middleLineOffset + this.rem1ForDimX];
            int v6 = source[lastLineOffset + this.dimXm1];
            int v7 = source[lastLineOffset];
            int v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                int vR;
                int vM;
                int vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                int r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForInt.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForInt.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private int slowPercentile(int ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private int percentileVersionA(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            int r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(int[] left, int[] right, int v0, int vL, int vR, int vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(int[] right, int count, int v) {
            int w;
            while (count > 0 && v <= (w = right[count - 1])) {
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(int[] left, int count, int v) {
            int w;
            while (count > 0 && v <= (w = left[count - 1])) {
                left[count--] = w;
            }
            left[count] = v;
        }

        private int percentileVersionB(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int r;
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForInt.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForInt.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(int[] a, int count) {
            int k = 0;
            while (++k < count) {
                int w;
                int i = k;
                int ai = a[i];
                if (ai >= a[i - 1]) continue;
                while (--i >= 0 && ai < (w = a[i])) {
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private int percentileVersionC(int[] left, int[] right, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            int rightCount;
            int leftCount;
            int vR;
            int vM;
            int vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForInt.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForInt.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static int percentileStartingFromMinimum(int[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                int w;
                int min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai >= min) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static int percentileStartingFromMaximum(int[] a, int count, int percentileReverseIndex) {
            int k = 0;
            while (true) {
                int w;
                int max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    int ai = a[i];
                    if (ai <= max) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if (k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    private static class ForLong
    extends PercentileBySquare3x3 {
        private final long[][] threadLeft = new long[this.numberOfRanges()][7];
        private final long[][] threadRight = new long[this.numberOfRanges()][7];

        private ForLong(long[] dimensions, int percentileIndex) {
            super(Long.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            long[] left = this.threadLeft[multithreadingRangeIndex];
            long[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            long v0 = source[firstLineOffset + this.dimXm1];
            long v1 = source[firstLineOffset];
            long v2 = source[firstLineOffset + this.rem1ForDimX];
            long v3 = source[middleLineOffset + this.dimXm1];
            long v4 = source[middleLineOffset];
            long v5 = source[middleLineOffset + this.rem1ForDimX];
            long v6 = source[lastLineOffset + this.dimXm1];
            long v7 = source[lastLineOffset];
            long v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                long vR;
                long vM;
                long vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                long r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForLong.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForLong.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private long slowPercentile(long ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private long percentileVersionA(long[] left, long[] right, long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7, long v8) {
            int rightCount;
            int leftCount;
            long vR;
            long vM;
            long vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            long r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(long[] left, long[] right, long v0, long vL, long vR, long vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(long[] right, int count, long v) {
            long w;
            while (count > 0 && v <= (w = right[count - 1])) {
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(long[] left, int count, long v) {
            long w;
            while (count > 0 && v <= (w = left[count - 1])) {
                left[count--] = w;
            }
            left[count] = v;
        }

        private long percentileVersionB(long[] left, long[] right, long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7, long v8) {
            long r;
            int rightCount;
            int leftCount;
            long vR;
            long vM;
            long vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForLong.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForLong.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(long[] a, int count) {
            int k = 0;
            while (++k < count) {
                long w;
                int i = k;
                long ai = a[i];
                if (ai >= a[i - 1]) continue;
                while (--i >= 0 && ai < (w = a[i])) {
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private long percentileVersionC(long[] left, long[] right, long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7, long v8) {
            int rightCount;
            int leftCount;
            long vR;
            long vM;
            long vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForLong.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForLong.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static long percentileStartingFromMinimum(long[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                long w;
                long min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    long ai = a[i];
                    if (ai >= min) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static long percentileStartingFromMaximum(long[] a, int count, long percentileReverseIndex) {
            int k = 0;
            while (true) {
                long w;
                long max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    long ai = a[i];
                    if (ai <= max) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if ((long)k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    private static class ForFloat
    extends PercentileBySquare3x3 {
        private final float[][] threadLeft = new float[this.numberOfRanges()][7];
        private final float[][] threadRight = new float[this.numberOfRanges()][7];

        private ForFloat(long[] dimensions, int percentileIndex) {
            super(Float.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            float[] left = this.threadLeft[multithreadingRangeIndex];
            float[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            float v0 = source[firstLineOffset + this.dimXm1];
            float v1 = source[firstLineOffset];
            float v2 = source[firstLineOffset + this.rem1ForDimX];
            float v3 = source[middleLineOffset + this.dimXm1];
            float v4 = source[middleLineOffset];
            float v5 = source[middleLineOffset + this.rem1ForDimX];
            float v6 = source[lastLineOffset + this.dimXm1];
            float v7 = source[lastLineOffset];
            float v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                float vR;
                float vM;
                float vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                float r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForFloat.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForFloat.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private float slowPercentile(float ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private float percentileVersionA(float[] left, float[] right, float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7, float v8) {
            int rightCount;
            int leftCount;
            float vR;
            float vM;
            float vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            float r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(float[] left, float[] right, float v0, float vL, float vR, float vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(float[] right, int count, float v) {
            while (count > 0) {
                float f;
                float w = right[count - 1];
                if (!(v <= f)) break;
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(float[] left, int count, float v) {
            while (count > 0) {
                float f;
                float w = left[count - 1];
                if (!(v <= f)) break;
                left[count--] = w;
            }
            left[count] = v;
        }

        private float percentileVersionB(float[] left, float[] right, float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7, float v8) {
            float r;
            int rightCount;
            int leftCount;
            float vR;
            float vM;
            float vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForFloat.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForFloat.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(float[] a, int count) {
            int k = 0;
            while (++k < count) {
                int i = k;
                float ai = a[i];
                if (!(ai < a[i - 1])) continue;
                while (--i >= 0) {
                    float f;
                    float w = a[i];
                    if (!(ai < f)) break;
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private float percentileVersionC(float[] left, float[] right, float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7, float v8) {
            int rightCount;
            int leftCount;
            float vR;
            float vM;
            float vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForFloat.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForFloat.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static float percentileStartingFromMinimum(float[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                float w;
                float min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    float ai = a[i];
                    if (!(ai < min)) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static float percentileStartingFromMaximum(float[] a, int count, float percentileReverseIndex) {
            int k = 0;
            while (true) {
                float w;
                float max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    float ai = a[i];
                    if (!(ai > max)) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if ((float)k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }

    private static class ForDouble
    extends PercentileBySquare3x3 {
        private final double[][] threadLeft = new double[this.numberOfRanges()][7];
        private final double[][] threadRight = new double[this.numberOfRanges()][7];

        private ForDouble(long[] dimensions, int percentileIndex) {
            super(Double.TYPE, dimensions, percentileIndex);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double[] left = this.threadLeft[multithreadingRangeIndex];
            double[] right = this.threadRight[multithreadingRangeIndex];
            int percentileIndex = this.percentileIndex;
            int percentileIndexP1 = this.percentileIndexP1;
            int percentileIndexM1 = this.percentileIndexM1;
            double v0 = source[firstLineOffset + this.dimXm1];
            double v1 = source[firstLineOffset];
            double v2 = source[firstLineOffset + this.rem1ForDimX];
            double v3 = source[middleLineOffset + this.dimXm1];
            double v4 = source[middleLineOffset];
            double v5 = source[middleLineOffset + this.rem1ForDimX];
            double v6 = source[lastLineOffset + this.dimXm1];
            double v7 = source[lastLineOffset];
            double v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int rightCount;
                int leftCount;
                double vR;
                double vM;
                double vL;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                if (v3 < v4) {
                    vL = v3;
                    vM = v4;
                } else {
                    vL = v4;
                    vM = v3;
                }
                if (v5 >= vM) {
                    vR = v5;
                } else if (v5 >= vL) {
                    vR = vM;
                    vM = v5;
                } else {
                    vR = vM;
                    vM = vL;
                    vL = v5;
                }
                left[0] = vL;
                right[0] = vR;
                if (v0 < vM) {
                    left[1] = v0;
                    leftCount = 2;
                    rightCount = 1;
                } else {
                    right[1] = v0;
                    leftCount = 1;
                    rightCount = 2;
                }
                if (v1 < vM) {
                    left[leftCount++] = v1;
                } else {
                    right[rightCount++] = v1;
                }
                if (v2 < vM) {
                    left[leftCount++] = v2;
                } else {
                    right[rightCount++] = v2;
                }
                if (v6 < vM) {
                    left[leftCount++] = v6;
                } else {
                    right[rightCount++] = v6;
                }
                if (v7 < vM) {
                    left[leftCount++] = v7;
                } else {
                    right[rightCount++] = v7;
                }
                if (v8 < vM) {
                    left[leftCount++] = v8;
                } else {
                    right[rightCount++] = v8;
                }
                double r = percentileIndex == leftCount ? vM : (percentileIndex < leftCount ? ForDouble.percentileStartingFromMaximum(left, leftCount, leftCount - percentileIndexP1) : ForDouble.percentileStartingFromMinimum(right, rightCount, percentileIndexM1 - leftCount));
                result[++resultLineOffset] = r;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.slowPercentile(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private double slowPercentile(double ... values) {
            Arrays.sort(values);
            return values[this.percentileIndex];
        }

        private double percentileVersionA(double[] left, double[] right, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7, double v8) {
            int rightCount;
            int leftCount;
            double vR;
            double vM;
            double vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            if (this.insertV0(left, right, v0, vL, vR, vM)) {
                leftCount = 2;
                rightCount = 1;
            } else {
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                this.insertLeft(left, leftCount++, v1);
            } else {
                this.insertRight(right, rightCount++, v1);
            }
            if (v2 < vM) {
                this.insertLeft(left, leftCount++, v2);
            } else {
                this.insertRight(right, rightCount++, v2);
            }
            if (v6 < vM) {
                this.insertLeft(left, leftCount++, v6);
            } else {
                this.insertRight(right, rightCount++, v6);
            }
            if (v7 < vM) {
                this.insertLeft(left, leftCount++, v7);
            } else {
                this.insertRight(right, rightCount++, v7);
            }
            if (v8 < vM) {
                this.insertLeft(left, leftCount++, v8);
            } else {
                this.insertRight(right, rightCount++, v8);
            }
            double r = this.percentileIndex < leftCount ? left[this.percentileIndex] : (this.percentileIndex == leftCount ? vM : right[this.percentileIndex - leftCount - 1]);
            return r;
        }

        private boolean insertV0(double[] left, double[] right, double v0, double vL, double vR, double vM) {
            if (v0 < vM) {
                if (v0 < vL) {
                    left[0] = v0;
                    left[1] = vL;
                } else {
                    left[0] = vL;
                    left[1] = v0;
                }
                right[0] = vR;
                return true;
            }
            if (v0 < vR) {
                right[0] = v0;
                right[1] = vR;
            } else {
                right[0] = vR;
                right[1] = v0;
            }
            left[0] = vL;
            return false;
        }

        private void insertRight(double[] right, int count, double v) {
            while (count > 0) {
                double d;
                double w = right[count - 1];
                if (!(v <= d)) break;
                right[count--] = w;
            }
            right[count] = v;
        }

        private void insertLeft(double[] left, int count, double v) {
            while (count > 0) {
                double d;
                double w = left[count - 1];
                if (!(v <= d)) break;
                left[count--] = w;
            }
            left[count] = v;
        }

        private double percentileVersionB(double[] left, double[] right, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7, double v8) {
            double r;
            int rightCount;
            int leftCount;
            double vR;
            double vM;
            double vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex < leftCount) {
                ForDouble.insertionSort(left, leftCount);
                r = left[this.percentileIndex];
            } else if (this.percentileIndex == leftCount) {
                r = vM;
            } else {
                ForDouble.insertionSort(right, rightCount);
                r = right[this.percentileIndex - leftCount - 1];
            }
            return r;
        }

        private static void insertionSort(double[] a, int count) {
            int k = 0;
            while (++k < count) {
                int i = k;
                double ai = a[i];
                if (!(ai < a[i - 1])) continue;
                while (--i >= 0) {
                    double d;
                    double w = a[i];
                    if (!(ai < d)) break;
                    a[i + 1] = w;
                }
                a[i + 1] = ai;
            }
        }

        private double percentileVersionC(double[] left, double[] right, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7, double v8) {
            int rightCount;
            int leftCount;
            double vR;
            double vM;
            double vL;
            if (v3 < v4) {
                vL = v3;
                vM = v4;
            } else {
                vL = v4;
                vM = v3;
            }
            if (v5 >= vM) {
                vR = v5;
            } else if (v5 >= vL) {
                vR = vM;
                vM = v5;
            } else {
                vR = vM;
                vM = vL;
                vL = v5;
            }
            left[0] = vL;
            right[0] = vR;
            if (v0 < vM) {
                left[1] = v0;
                leftCount = 2;
                rightCount = 1;
            } else {
                right[1] = v0;
                leftCount = 1;
                rightCount = 2;
            }
            if (v1 < vM) {
                left[leftCount++] = v1;
            } else {
                right[rightCount++] = v1;
            }
            if (v2 < vM) {
                left[leftCount++] = v2;
            } else {
                right[rightCount++] = v2;
            }
            if (v6 < vM) {
                left[leftCount++] = v6;
            } else {
                right[rightCount++] = v6;
            }
            if (v7 < vM) {
                left[leftCount++] = v7;
            } else {
                right[rightCount++] = v7;
            }
            if (v8 < vM) {
                left[leftCount++] = v8;
            } else {
                right[rightCount++] = v8;
            }
            if (this.percentileIndex == leftCount) {
                return vM;
            }
            if (this.percentileIndex < leftCount) {
                return ForDouble.percentileStartingFromMaximum(left, leftCount, leftCount - this.percentileIndexP1);
            }
            return ForDouble.percentileStartingFromMinimum(right, rightCount, this.percentileIndexM1 - leftCount);
        }

        private static double percentileStartingFromMinimum(double[] a, int count, int percentileIndex) {
            int k = 0;
            while (true) {
                double w;
                double min = w = a[k];
                int indexOfMin = k;
                for (int i = k + 1; i < count; ++i) {
                    double ai = a[i];
                    if (!(ai < min)) continue;
                    min = ai;
                    indexOfMin = i;
                }
                if (k == percentileIndex) {
                    return min;
                }
                a[indexOfMin] = w;
                ++k;
            }
        }

        private static double percentileStartingFromMaximum(double[] a, int count, double percentileReverseIndex) {
            int k = 0;
            while (true) {
                double w;
                double max = w = a[k];
                int indexOfMax = k;
                for (int i = k + 1; i < count; ++i) {
                    double ai = a[i];
                    if (!(ai > max)) continue;
                    max = ai;
                    indexOfMax = i;
                }
                if ((double)k == percentileReverseIndex) {
                    return max;
                }
                a[indexOfMax] = w;
                ++k;
            }
        }
    }
}

