/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;

public abstract class Abstract2DProcessor {
    private final Class<?> elementType;
    private final int dimX;
    private final long dimY;
    private final long matrixSize;

    protected Abstract2DProcessor(Class<?> elementType, long[] dimensions) {
        this(elementType, dimensions, 0x7FFFFFEF);
    }

    protected Abstract2DProcessor(Class<?> elementType, long[] dimensions, int maxDimX) {
        this.elementType = Objects.requireNonNull(elementType, "Null elementType");
        Objects.requireNonNull(dimensions, "Null dimensions");
        if (maxDimX <= 0) {
            throw new IllegalArgumentException("Zero or negative maxDimX = " + maxDimX);
        }
        if (dimensions.length != 2) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " can be used for 2-dimensional matrices only");
        }
        long dimX = dimensions[0];
        long dimY = dimensions[1];
        if (dimX <= 0L || dimY <= 0L) {
            throw new IllegalArgumentException("Zero or negative matrix dimensions: " + dimX + "x" + dimY);
        }
        if (dimX > (long)maxDimX) {
            throw new TooLargeArrayException("Matrix width must be < " + maxDimX + ", but we have " + dimX + "x" + dimY);
        }
        this.dimX = (int)dimX;
        this.dimY = dimY;
        this.matrixSize = Arrays.longMul(dimX, dimY);
        if (this.matrixSize == Long.MIN_VALUE) {
            throw new TooLargeArrayException("Matrix size " + dimX + "x" + dimY + " is too large: >2^63-1");
        }
    }

    public final Class<?> elementType() {
        return this.elementType;
    }

    public final int dimX() {
        return this.dimX;
    }

    public final long dimY() {
        return this.dimY;
    }

    public final long matrixSize() {
        return this.matrixSize;
    }

    public void checkCompatibility(Matrix<? extends PArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix");
        if (matrix.elementType() != this.elementType) {
            throw new IllegalArgumentException("Element type of " + String.valueOf(matrix) + " does not match the element type of this finder: " + String.valueOf(this.elementType));
        }
        if (matrix.dimCount() != 2) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " can be used for 2-dimensional matrices only, but we have " + String.valueOf(matrix));
        }
        if (matrix.dimX() != (long)this.dimX || matrix.dimY() != this.dimY) {
            throw new IllegalArgumentException("New matrix has other dimensions than the stored dimensions: stored are " + this.dimY + "x" + this.dimY + ", new is " + String.valueOf(matrix));
        }
    }

    public long previousLineOffset(long offset) {
        return (offset -= (long)this.dimX) < 0L ? this.matrixSize - (long)this.dimX : offset;
    }

    public long nextLineOffset(long offset) {
        return (offset += (long)this.dimX) >= this.matrixSize ? 0L : offset;
    }

    public static long rem(long index, long dim) {
        return (index %= dim) >= 0L ? index : index + dim;
    }

    public static int rem(int index, int dim) {
        return (index %= dim) >= 0 ? index : index + dim;
    }
}

