/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.MinkowskiSum;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.UniformGridPattern;

final class Union
extends AbstractPattern
implements Pattern {
    private final Pattern[] subsets;
    private final Pattern[] projections;
    private volatile Reference<Set<Point>> points = null;

    Union(Pattern[] patterns) {
        super(MinkowskiSum.getDimCountAndCheck(patterns));
        ArrayList<Pattern> allSubsets = new ArrayList<Pattern>();
        for (Pattern ptn : patterns) {
            if (ptn instanceof Union) {
                allSubsets.addAll(Arrays.asList(((Union)ptn).subsets));
                continue;
            }
            allSubsets.add(ptn);
        }
        double[] minCoord = new double[this.dimCount];
        double[] maxCoord = new double[this.dimCount];
        Arrays.fill(minCoord, Double.POSITIVE_INFINITY);
        Arrays.fill(maxCoord, Double.NEGATIVE_INFINITY);
        for (Pattern ptn : allSubsets) {
            for (int k = 0; k < this.dimCount; ++k) {
                Range range = ptn.coordRange(k);
                if (range.min() < minCoord[k]) {
                    minCoord[k] = range.min();
                }
                if (!(range.max() > maxCoord[k])) continue;
                maxCoord[k] = range.max();
            }
        }
        for (int k = 0; k < this.dimCount; ++k) {
            this.coordRanges[k] = Range.of(minCoord[k], maxCoord[k]);
            Union.checkCoordRange(this.coordRanges[k]);
        }
        this.subsets = allSubsets.toArray(new Pattern[0]);
        this.projections = new UniformGridPattern[this.dimCount];
    }

    @Override
    public long pointCount() {
        return this.points().size();
    }

    @Override
    public Set<Point> points() {
        Set<Point> resultPoints;
        Set<Point> set = resultPoints = this.points == null ? null : this.points.get();
        if (resultPoints == null) {
            resultPoints = new HashSet<Point>();
            for (Pattern ptn : this.subsets) {
                resultPoints.addAll(ptn.points());
            }
            resultPoints = Collections.unmodifiableSet(resultPoints);
            this.points = new SoftReference<Set<Point>>(resultPoints);
        }
        return resultPoints;
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.coordRanges[coordIndex];
    }

    @Override
    public RectangularArea coordArea() {
        return RectangularArea.of(this.coordRanges);
    }

    @Override
    public boolean isSurelySinglePoint() {
        for (Pattern p : this.subsets) {
            if (p.isSurelySinglePoint()) continue;
            return false;
        }
        return this.pointCount() == 1L;
    }

    @Override
    public boolean isSurelyInteger() {
        if (this.surelyInteger == null) {
            boolean allInteger = true;
            for (Pattern p : this.subsets) {
                if (p.isSurelyInteger()) continue;
                allInteger = false;
                break;
            }
            this.surelyInteger = allInteger;
        }
        return this.surelyInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        Pattern[] patternArray = this.projections;
        synchronized (this.projections) {
            if (this.projections[coordIndex] == null) {
                Pattern[] newSubsets = new Pattern[this.subsets.length];
                for (int k = 0; k < newSubsets.length; ++k) {
                    newSubsets[k] = this.subsets[k].projectionAlongAxis(coordIndex);
                }
                this.projections[coordIndex] = new Union(newSubsets);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.projections[coordIndex];
        }
    }

    @Override
    public Pattern shift(Point shift) {
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        Pattern[] newSubsets = new Pattern[this.subsets.length];
        for (int k = 0; k < newSubsets.length; ++k) {
            newSubsets[k] = this.subsets[k].shift(shift);
        }
        return new Union(newSubsets);
    }

    @Override
    public Pattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        Pattern[] newSubsets = new Pattern[this.subsets.length];
        for (int k = 0; k < newSubsets.length; ++k) {
            newSubsets[k] = this.subsets[k].scale(multipliers);
        }
        return new Union(newSubsets);
    }

    @Override
    public List<List<Pattern>> allUnionDecompositions(int minimalPointCount) {
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        List<Pattern> result = new ArrayList(this.subsets.length);
        for (Pattern subset : this.subsets) {
            result.addAll(subset.unionDecomposition(minimalPointCount));
        }
        result = Collections.unmodifiableList(result);
        return Collections.singletonList(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.dimCount + "D integer union of " + this.subsets.length + " patterns: ");
        for (int k = 0; k < this.subsets.length; ++k) {
            if (k > 0) {
                sb.append(" U ");
            }
            sb.append(this.subsets[k]);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.subsets) ^ this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Union && (obj == this || Arrays.equals(this.subsets, ((Union)obj).subsets));
    }
}

