/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.BasicRectangularPattern;
import net.algart.math.patterns.OnePointPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.SimplePattern;
import net.algart.math.patterns.UniformGridPattern;

final class MinkowskiSum
extends AbstractPattern
implements Pattern {
    private final Pattern[] summands;
    private final List<Pattern> optimizedSummands;
    private final Pattern[] projections;
    private volatile Reference<Set<Point>> points = null;

    MinkowskiSum(Pattern[] patterns) {
        this(patterns, null);
    }

    private MinkowskiSum(Pattern[] patterns, List<Pattern> optimizedSummands) {
        super(MinkowskiSum.getDimCountAndCheck(patterns));
        ArrayList<Pattern> allSummands = new ArrayList<Pattern>();
        for (Pattern ptn : patterns) {
            if (ptn instanceof MinkowskiSum) {
                allSummands.addAll(Arrays.asList(((MinkowskiSum)ptn).summands));
                continue;
            }
            allSummands.add(ptn);
        }
        double[] minCoord = new double[this.dimCount];
        double[] maxCoord = new double[this.dimCount];
        for (Pattern ptn : allSummands) {
            int k = 0;
            while (k < this.dimCount) {
                Range range = ptn.coordRange(k);
                int n = k;
                minCoord[n] = minCoord[n] + range.min();
                int n2 = k++;
                maxCoord[n2] = maxCoord[n2] + range.max();
            }
        }
        for (int k = 0; k < this.dimCount; ++k) {
            this.coordRanges[k] = Range.of(minCoord[k], maxCoord[k]);
            MinkowskiSum.checkCoordRange(this.coordRanges[k]);
        }
        this.summands = allSummands.toArray(new Pattern[0]);
        this.optimizedSummands = optimizedSummands == null ? MinkowskiSum.optimizeMinkowskiSum(allSummands) : optimizedSummands;
        this.projections = new Pattern[this.dimCount];
    }

    @Override
    public long pointCount() {
        return this.points().size();
    }

    @Override
    public Set<Point> points() {
        Set<Point> resultPoints;
        Set<Point> set = resultPoints = this.points == null ? null : this.points.get();
        if (resultPoints == null) {
            Pattern ptn = new SimplePattern(this.optimizedSummands.get(0).points());
            int n = this.optimizedSummands.size();
            for (int k = 1; k < n; ++k) {
                ptn = ptn.minkowskiAdd(this.optimizedSummands.get(k));
            }
            resultPoints = ptn.points();
            this.points = new SoftReference<Set<Point>>(resultPoints);
        }
        return resultPoints;
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.coordRanges[coordIndex];
    }

    @Override
    public RectangularArea coordArea() {
        return RectangularArea.of(this.coordRanges);
    }

    @Override
    public boolean isSurelySinglePoint() {
        for (Pattern p : this.optimizedSummands) {
            if (p.isSurelySinglePoint()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSurelyInteger() {
        if (this.surelyInteger == null) {
            boolean allInteger = true;
            for (Pattern p : this.optimizedSummands) {
                if (p.isSurelyInteger()) continue;
                allInteger = false;
                break;
            }
            this.surelyInteger = allInteger;
        }
        return this.surelyInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        Pattern[] patternArray = this.projections;
        synchronized (this.projections) {
            if (this.projections[coordIndex] == null) {
                Pattern[] newSummands = new Pattern[this.summands.length];
                for (int k = 0; k < newSummands.length; ++k) {
                    newSummands[k] = this.summands[k].projectionAlongAxis(coordIndex);
                }
                this.projections[coordIndex] = new MinkowskiSum(newSummands);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.projections[coordIndex];
        }
    }

    @Override
    public Pattern shift(Point shift) {
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        Pattern[] newSummands = (Pattern[])this.summands.clone();
        newSummands[0] = newSummands[0].shift(shift);
        ArrayList<Pattern> newOptimizedSummands = new ArrayList<Pattern>(this.optimizedSummands);
        newOptimizedSummands.set(0, ((Pattern)newOptimizedSummands.get(0)).shift(shift));
        return new MinkowskiSum(newSummands, newOptimizedSummands);
    }

    @Override
    public Pattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        Pattern[] newSummands = new Pattern[this.summands.length];
        for (int k = 0; k < newSummands.length; ++k) {
            newSummands[k] = this.summands[k].scale(multipliers);
        }
        return new MinkowskiSum(newSummands);
    }

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        Objects.requireNonNull(added, "Null added argument");
        Pattern[] newSummands = new Pattern[this.summands.length + 1];
        System.arraycopy(this.summands, 0, newSummands, 0, this.summands.length);
        newSummands[this.summands.length] = added;
        return new MinkowskiSum(newSummands);
    }

    @Override
    public List<Pattern> minkowskiDecomposition(int minimalPointCount) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (Pattern summand : this.optimizedSummands) {
            result.addAll(summand.minkowskiDecomposition(minimalPointCount));
        }
        int numberOfPatternsWithAtLeast2Points = 0;
        for (Pattern ptn : result) {
            long pointCount = ptn.pointCount();
            if (pointCount >= 3L) {
                return Collections.unmodifiableList(result);
            }
            if (pointCount < 2L) continue;
            ++numberOfPatternsWithAtLeast2Points;
        }
        if (numberOfPatternsWithAtLeast2Points <= 1) {
            return Collections.singletonList(this);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        int n = this.optimizedSummands.size();
        StringBuilder sb = new StringBuilder(this.dimCount + "D Minkowski sum of " + n + " patterns: ");
        for (int k = 0; k < n; ++k) {
            if (k > 0) {
                sb.append(" (+) ");
            }
            sb.append(this.optimizedSummands.get(k));
        }
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.summands) ^ this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MinkowskiSum && (obj == this || Arrays.equals(this.summands, ((MinkowskiSum)obj).summands));
    }

    static int getDimCountAndCheck(Pattern[] patterns) {
        Objects.requireNonNull(patterns, "Null patterns argument");
        if (patterns.length == 0) {
            throw new IllegalArgumentException("Empty patterns array");
        }
        Objects.requireNonNull(patterns[0], "Null pattern is the array");
        int result = patterns[0].dimCount();
        for (int k = 1; k < patterns.length; ++k) {
            Objects.requireNonNull(patterns[k], "Null pattern #" + k + " is the array");
            if (patterns[k].dimCount() == result) continue;
            throw new IllegalArgumentException("Patterns dimensions mismatch: the first pattern has " + result + " dimensions, but pattern #" + k + " has " + patterns[k].dimCount());
        }
        return result;
    }

    private static List<Pattern> optimizeMinkowskiSum(List<Pattern> patterns) {
        HashMap<Pattern, Integer> numbersOfEquals = new HashMap<Pattern, Integer>();
        HashMap<Point, BasicRectangularPattern> rectangularSummands = new HashMap<Point, BasicRectangularPattern>();
        Pattern onePointSummand = null;
        for (Pattern pattern : patterns) {
            Integer previousNumber;
            if (pattern instanceof OnePointPattern) {
                if (!((onePointSummand = onePointSummand == null ? pattern : onePointSummand.minkowskiAdd(pattern)) instanceof OnePointPattern)) {
                    throw new AssertionError((Object)"Invalid OnePointPattern.minkowskiAdd implementation");
                }
                continue;
            }
            if (pattern instanceof UniformGridPattern) {
                UniformGridPattern ugPattern = (UniformGridPattern)pattern;
                if (((UniformGridPattern)pattern).isActuallyRectangular()) {
                    Point steps = Point.of((ugPattern = new BasicRectangularPattern(ugPattern.originOfGrid(), ugPattern.stepsOfGrid(), ugPattern.gridIndexArea().ranges())).stepsOfGrid());
                    UniformGridPattern uniformGridPattern = (UniformGridPattern)rectangularSummands.get(steps);
                    Pattern pattern2 = pattern = uniformGridPattern == null ? ugPattern : uniformGridPattern.minkowskiAdd(ugPattern);
                    if (!(pattern instanceof BasicRectangularPattern)) {
                        throw new AssertionError((Object)"Invalid RectangularUniformGridPattern.minkowskiAdd implementation");
                    }
                    rectangularSummands.put(steps, (BasicRectangularPattern)pattern);
                    continue;
                }
            }
            if ((previousNumber = (Integer)numbersOfEquals.get(pattern)) == null) {
                numbersOfEquals.put(pattern, 1);
                continue;
            }
            numbersOfEquals.put(pattern, previousNumber + 1);
        }
        ArrayList multiPatterns = new ArrayList(numbersOfEquals.entrySet());
        multiPatterns.sort((o1, o2) -> {
            long pointCount1 = ((Pattern)o1.getKey()).pointCount();
            long pointCount2 = ((Pattern)o2.getKey()).pointCount();
            return Long.compare(pointCount2, pointCount1);
        });
        ArrayList<Pattern> result = new ArrayList<Pattern>(rectangularSummands.values());
        if (onePointSummand != null) {
            if (result.isEmpty()) {
                result.add(onePointSummand);
            } else {
                result.set(0, onePointSummand.minkowskiAdd((Pattern)result.get(0)));
            }
        }
        Pattern last = null;
        for (Map.Entry entry : multiPatterns) {
            Pattern p = (Pattern)entry.getKey();
            int n = (Integer)entry.getValue();
            Pattern c = null;
            if (n > 1 || last != null) {
                c = p.carcass();
            }
            if (last != null && last.minkowskiAdd(p).equals(last.minkowskiAdd(c))) {
                result.add(c);
            } else {
                result.add(p);
            }
            if (--n > 0) {
                int maxMultiplier = p.maxCarcassMultiplier();
                int m = 1;
                while (true) {
                    if (m > n) {
                        m = n;
                    }
                    assert (c != null);
                    result.add(c.multiply(m));
                    if ((n -= m) == 0) break;
                    assert (n >= 0) : "Counter overflow while optimizing Minkowski sum";
                    if (2 * m < 0 || 2 * m > maxMultiplier) continue;
                    m *= 2;
                }
            }
            last = p;
        }
        return result;
    }
}

