/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.geometry;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.random.RandomGenerator;
import net.algart.math.geometry.CollinearityException;

public final class Orthonormal3DBasis {
    public static final double COLLINEARITY_EPSILON = 1.0E-7;
    public static final double COLLINEARITY_EPSILON_SQR = 9.999999999999998E-15;
    private static final int REVIVING_COUNT = 32;
    public static final double MIN_ALLOWED_LENGTH = 1.0E-100;
    private static final AtomicInteger globalCallCount = new AtomicInteger();
    public static final Orthonormal3DBasis DEFAULT = new Orthonormal3DBasis(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0);
    private final double ix;
    private final double iy;
    private final double iz;
    private final double jx;
    private final double jy;
    private final double jz;
    private final double kx;
    private final double ky;
    private final double kz;
    private final int counter;

    private Orthonormal3DBasis(double ix, double iy, double iz, double jx, double jy, double jz, double kx, double ky, double kz, int counter) {
        if ((globalCallCount.incrementAndGet() & 0x3FF) == 0) {
            double iSqr = ix * ix + iy * iy + iz * iz;
            double jSqr = jx * jx + jy * jy + jz * jz;
            double kSqr = kx * kx + ky * ky + kz * kz;
            double ij = ix * jx + iy * jy + iz * jz;
            double ik = ix * kx + iy * ky + iz * kz;
            double jk = jx * kx + jy * ky + jz * kz;
            if (iSqr < 0.98 || iSqr > 1.02) {
                throw new AssertionError((Object)("Internal error! |I| == " + Math.sqrt(iSqr) + " != 1.0"));
            }
            if (jSqr < 0.98 || jSqr > 1.02) {
                throw new AssertionError((Object)("Internal error! |J| == " + Math.sqrt(jSqr) + " != 1.0"));
            }
            if (ij < -0.02 || ij > 0.02) {
                throw new AssertionError((Object)("Internal error! IJ == " + ij + " != 0.0"));
            }
            if (kSqr < 0.9 || kSqr > 1.1) {
                throw new AssertionError((Object)("Internal error! |K| == " + Math.sqrt(kSqr) + " != 1.0"));
            }
            if (ik < -0.1 || ik > 0.1) {
                throw new AssertionError((Object)("Internal error! IK == " + ik + " != 0.0"));
            }
            if (jk < -0.1 || jk > 0.1) {
                throw new AssertionError((Object)("Internal error! JK == " + jk + " != 0.0"));
            }
        }
        this.ix = ix;
        this.iy = iy;
        this.iz = iz;
        this.jx = jx;
        this.jy = jy;
        this.jz = jz;
        this.kx = kx;
        this.ky = ky;
        this.kz = kz;
        this.counter = counter;
    }

    private Orthonormal3DBasis(double ix, double iy, double iz, double jx, double jy, double jz, int counter) {
        this(ix, iy, iz, jx, jy, jz, iy * jz - iz * jy, iz * jx - ix * jz, ix * jy - iy * jx, counter);
    }

    public static Orthonormal3DBasis newSomeBasis(double ix, double iy, double iz) {
        double zAbs;
        double xAbs = ix >= 0.0 ? ix : -ix;
        double yAbs = iy >= 0.0 ? iy : -iy;
        double d = zAbs = iz >= 0.0 ? iz : -iz;
        if (yAbs < zAbs) {
            if (xAbs < yAbs) {
                return Orthonormal3DBasis.newBasis(ix, iy, iz, 1.0, 0.0, 0.0, true);
            }
            return Orthonormal3DBasis.newBasis(ix, iy, iz, 0.0, 1.0, 0.0, true);
        }
        if (xAbs < zAbs) {
            return Orthonormal3DBasis.newBasis(ix, iy, iz, 1.0, 0.0, 0.0, true);
        }
        return Orthonormal3DBasis.newBasis(ix, iy, iz, 0.0, 0.0, 1.0, true);
    }

    public static Orthonormal3DBasis newBasis(double ix, double iy, double iz, double jx, double jy, double jz, boolean exceptionOnCollinearity) throws CollinearityException {
        double lengthI = Orthonormal3DBasis.length(ix, iy, iz);
        if (lengthI < 1.0E-100) {
            throw new IllegalArgumentException("Zero or too short I vector (" + ix + ", " + iy + ", " + iz + ") (vectors with length <1.0E-100 are not allowed)");
        }
        double lengthJ = Orthonormal3DBasis.length(jx, jy, jz);
        if (lengthJ < 1.0E-100) {
            throw new IllegalArgumentException("Zero or too short J vector (" + jx + ", " + jy + ", " + jz + ") (vectors with length <1.0E-100 are not allowed)");
        }
        double mult = 1.0 / lengthI;
        double newIx = ix * mult;
        double newJx = jx * (mult = 1.0 / lengthJ);
        double newIy = iy * mult;
        double newJy = jy * mult;
        double newIz = iz * mult;
        double newJz = jz * mult;
        double ij = newIx * newJx + newIy * newJy + newIz * newJz;
        if (ij != 0.0) {
            double correctedLengthJ = Orthonormal3DBasis.length(newJx -= newIx * ij, newJy -= newIy * ij, newJz -= newIz * ij);
            if (correctedLengthJ < 1.0E-7) {
                if (exceptionOnCollinearity) {
                    throw new CollinearityException("Passed I vector (" + ix + ", " + iy + ", " + iz + ") and J vector (" + jx + ", " + jy + ", " + jz + ") are collinear or almost collinear");
                }
                return Orthonormal3DBasis.newSomeBasis(ix, iy, iz);
            }
            mult = 1.0 / correctedLengthJ;
            newJx *= mult;
            newJy *= mult;
            newJz *= mult;
        }
        return new Orthonormal3DBasis(newIx, newIy, newIz, newJx, newJy, newJz, 0);
    }

    public static Optional<Orthonormal3DBasis> optBasis(double ix, double iy, double iz, double jx, double jy, double jz) {
        double lengthI = Orthonormal3DBasis.length(ix, iy, iz);
        if (lengthI < 1.0E-100) {
            return Optional.empty();
        }
        double lengthJ = Orthonormal3DBasis.length(jx, jy, jz);
        if (lengthJ < 1.0E-100) {
            return Optional.empty();
        }
        double mult = 1.0 / lengthI;
        double newIx = ix * mult;
        double newJx = jx * (mult = 1.0 / lengthJ);
        double newIy = iy * mult;
        double newJy = jy * mult;
        double newIz = iz * mult;
        double newJz = jz * mult;
        double ij = newIx * newJx + newIy * newJy + newIz * newJz;
        if (ij != 0.0) {
            double correctedLengthJ = Orthonormal3DBasis.length(newJx -= newIx * ij, newJy -= newIy * ij, newJz -= newIz * ij);
            if (correctedLengthJ < 1.0E-7) {
                return Optional.empty();
            }
            mult = 1.0 / correctedLengthJ;
            newJx *= mult;
            newJy *= mult;
            newJz *= mult;
        }
        return Optional.of(new Orthonormal3DBasis(newIx, newIy, newIz, newJx, newJy, newJz, 0));
    }

    public static Orthonormal3DBasis newRandomBasis(RandomGenerator random) {
        double iz;
        double iy;
        double ix;
        double distanceSqr;
        while (!((distanceSqr = (ix = 2.0 * random.nextDouble() - 1.0) * ix + (iy = 2.0 * random.nextDouble() - 1.0) * iy + (iz = 2.0 * random.nextDouble() - 1.0) * iz) >= 0.01) || !(distanceSqr < 1.0)) {
        }
        return Orthonormal3DBasis.newRandomBasis(random, ix, iy, iz);
    }

    public static Orthonormal3DBasis newRandomBasis(RandomGenerator random, double ix, double iy, double iz) {
        return Orthonormal3DBasis.newSomeBasis(ix, iy, iz).rotateJK(Math.PI * 2 * random.nextDouble());
    }

    public double ix() {
        return this.ix;
    }

    public double iy() {
        return this.iy;
    }

    public double iz() {
        return this.iz;
    }

    public double jx() {
        return this.jx;
    }

    public double jy() {
        return this.jy;
    }

    public double jz() {
        return this.jz;
    }

    public double kx() {
        return this.kx;
    }

    public double ky() {
        return this.ky;
    }

    public double kz() {
        return this.kz;
    }

    public double x(double i, double j, double k) {
        return i * this.ix + j * this.jx + k * this.kx;
    }

    public double y(double i, double j, double k) {
        return i * this.iy + j * this.jy + k * this.ky;
    }

    public double z(double i, double j, double k) {
        return i * this.iz + j * this.jz + k * this.kz;
    }

    public Orthonormal3DBasis jki() {
        return new Orthonormal3DBasis(this.jx, this.jy, this.jz, this.kx, this.ky, this.kz, this.ix, this.iy, this.iz, this.counter);
    }

    public Orthonormal3DBasis kij() {
        return new Orthonormal3DBasis(this.kx, this.ky, this.kz, this.ix, this.iy, this.iz, this.jx, this.jy, this.jz, this.counter);
    }

    public Orthonormal3DBasis rotateJK(double angleInRadians) {
        if (angleInRadians == 0.0) {
            return this;
        }
        double cos = Math.cos(angleInRadians);
        double sin = Math.sin(angleInRadians);
        double newJx = cos * this.jx + sin * this.kx;
        double newJy = cos * this.jy + sin * this.ky;
        double newJz = cos * this.jz + sin * this.kz;
        return new Orthonormal3DBasis(this.ix, this.iy, this.iz, newJx, newJy, newJz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis rotateKI(double angleInRadians) {
        if (angleInRadians == 0.0) {
            return this;
        }
        double cos = Math.cos(angleInRadians);
        double sin = Math.sin(angleInRadians);
        double newIx = -sin * this.kx + cos * this.ix;
        double newIy = -sin * this.ky + cos * this.iy;
        double newIz = -sin * this.kz + cos * this.iz;
        return new Orthonormal3DBasis(newIx, newIy, newIz, this.jx, this.jy, this.jz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis rotateIJ(double angleInRadians) {
        if (angleInRadians == 0.0) {
            return this;
        }
        double cos = Math.cos(angleInRadians);
        double sin = Math.sin(angleInRadians);
        double newIx = cos * this.ix + sin * this.jx;
        double newIy = cos * this.iy + sin * this.jy;
        double newIz = cos * this.iz + sin * this.jz;
        double newJx = -sin * this.ix + cos * this.jx;
        double newJy = -sin * this.iy + cos * this.jy;
        double newJz = -sin * this.iz + cos * this.jz;
        return new Orthonormal3DBasis(newIx, newIy, newIz, newJx, newJy, newJz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis rotate(double angleXYInRadians, double angleYZInRadians, double angleZXInRadians) {
        double sin;
        double cos;
        double ix = this.ix;
        double iy = this.iy;
        double iz = this.iz;
        double jx = this.jx;
        double jy = this.jy;
        double jz = this.jz;
        if (angleYZInRadians != 0.0) {
            cos = Math.cos(angleYZInRadians);
            sin = Math.sin(angleYZInRadians);
            double newIy = iz * sin + iy * cos;
            double newIz = iz * cos - iy * sin;
            double newJy = jz * sin + jy * cos;
            double newJz = jz * cos - jy * sin;
            iy = newIy;
            iz = newIz;
            jy = newJy;
            jz = newJz;
        }
        if (angleZXInRadians != 0.0) {
            cos = Math.cos(angleZXInRadians);
            sin = Math.sin(angleZXInRadians);
            double newIz = ix * sin + iz * cos;
            double newIx = ix * cos - iz * sin;
            double newJz = jx * sin + jz * cos;
            double newJx = jx * cos - jz * sin;
            iz = newIz;
            ix = newIx;
            jz = newJz;
            jx = newJx;
        }
        if (angleXYInRadians != 0.0) {
            cos = Math.cos(angleXYInRadians);
            sin = Math.sin(angleXYInRadians);
            double newIx = iy * sin + ix * cos;
            double newIy = iy * cos - ix * sin;
            double newJx = jy * sin + jx * cos;
            double newJy = jy * cos - jx * sin;
            ix = newIx;
            iy = newIy;
            jx = newJx;
            jy = newJy;
        }
        return new Orthonormal3DBasis(ix, iy, iz, jx, jy, jz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis rotate(double directionX, double directionY, double directionZ, double angle) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double mult = 1.0 / Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
        double id = this.ix * (directionX *= mult) + this.iy * (directionY *= mult) + this.iz * (directionZ *= mult);
        double idx = id * directionX;
        double idy = id * directionY;
        double idz = id * directionZ;
        double ax = this.ix - idx;
        double ay = this.iy - idy;
        double az = this.iz - idz;
        double aLength = Math.sqrt(ax * ax + ay * ay + az * az);
        mult = 1.0 / aLength;
        double bx = directionY * (az *= mult) - directionZ * (ay *= mult);
        double by = directionZ * (ax *= mult) - directionX * az;
        double bz = directionX * ay - directionY * ax;
        double newAx = cos * ax + sin * bx;
        double newAy = cos * ay + sin * by;
        double newAz = cos * az + sin * bz;
        mult = Math.abs(newAx * newAx + newAy * newAy + newAz * newAz - 1.0);
        if (d5 > 0.01) {
            throw new AssertionError((Object)("Internal error (|newA| = " + mult + " != 1) in rotate method"));
        }
        double newIx = idx + aLength * newAx;
        double newIy = idy + aLength * newAy;
        double newIz = idz + aLength * newAz;
        double jd = this.jx * directionX + this.jy * directionY + this.jz * directionZ;
        double jdx = jd * directionX;
        double jdy = jd * directionY;
        double jdz = jd * directionZ;
        ax = this.jx - jdx;
        ay = this.jy - jdy;
        az = this.jz - jdz;
        aLength = Math.sqrt(ax * ax + ay * ay + az * az);
        mult = 1.0 / aLength;
        bx = directionY * (az *= mult) - directionZ * (ay *= mult);
        by = directionZ * (ax *= mult) - directionX * az;
        bz = directionX * ay - directionY * ax;
        newAx = cos * ax + sin * bx;
        newAy = cos * ay + sin * by;
        newAz = cos * az + sin * bz;
        mult = Math.abs(newAx * newAx + newAy * newAy + newAz * newAz - 1.0);
        if (d4 > 0.01) {
            throw new AssertionError((Object)("Internal error (|newA| = " + mult + " != 1) in rotate method"));
        }
        double newJx = jdx + aLength * newAx;
        double newJy = jdy + aLength * newAy;
        double newJz = jdz + aLength * newAz;
        mult = Math.abs(newIx * newIx + newIy * newIy + newIz * newIz - 1.0);
        if (d3 > 0.01) {
            throw new AssertionError((Object)("Internal error (|newI| = " + mult + " != 1) in rotate method"));
        }
        mult = Math.abs(newJx * newJx + newJy * newJy + newJz * newJz - 1.0);
        if (d2 > 0.01) {
            throw new AssertionError((Object)("Internal error (|newJ| = " + mult + " != 1) in rotate method"));
        }
        mult = Math.abs(newIx * newJx + newIy * newJy + newIz * newJz);
        if (d > 0.01) {
            throw new AssertionError((Object)("Internal error (newI * newJ = " + mult + " != 0) in rotate method"));
        }
        return new Orthonormal3DBasis(newIx, newIy, newIz, newJx, newJy, newJz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis multiply(Orthonormal3DBasis other) {
        Objects.requireNonNull(other, "Null other basis");
        return new Orthonormal3DBasis(this.ix * other.ix + this.iy * other.jx + this.iz * other.kx, this.ix * other.iy + this.iy * other.jy + this.iz * other.ky, this.ix * other.iz + this.iy * other.jz + this.iz * other.kz, this.jx * other.ix + this.jy * other.jx + this.jz * other.kx, this.jx * other.iy + this.jy * other.jy + this.jz * other.ky, this.jx * other.iz + this.jy * other.jz + this.jz * other.kz, this.counter + 1).reviveIfNecessary();
    }

    public Orthonormal3DBasis inverse() {
        return new Orthonormal3DBasis(this.ix, this.jx, this.kx, this.iy, this.jy, this.ky, this.iz, this.jz, this.kz, this.counter + 1).reviveIfNecessary();
    }

    public double distanceSquare(Orthonormal3DBasis other) {
        Objects.requireNonNull(other, "Null other basis");
        return Orthonormal3DBasis.lengthSquare(other.ix - this.ix, other.iy - this.iy, other.iz - this.iz) + Orthonormal3DBasis.lengthSquare(other.jx - this.jx, other.jy - this.jy, other.jz - this.jz) + Orthonormal3DBasis.lengthSquare(other.kx - this.kx, other.ky - this.ky, other.kz - this.kz);
    }

    public String toString() {
        return "I=(" + this.ix + "," + this.iy + "," + this.iz + "),J=(" + this.jx + "," + this.jy + "," + this.jz + "),K=(" + this.kx + "," + this.ky + "," + this.kz + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Orthonormal3DBasis)) {
            return false;
        }
        Orthonormal3DBasis that = (Orthonormal3DBasis)o;
        return Double.doubleToLongBits(that.ix) == Double.doubleToLongBits(this.ix) && Double.doubleToLongBits(that.iy) == Double.doubleToLongBits(this.iy) && Double.doubleToLongBits(that.iz) == Double.doubleToLongBits(this.iz) && Double.doubleToLongBits(that.jx) == Double.doubleToLongBits(this.jx) && Double.doubleToLongBits(that.jy) == Double.doubleToLongBits(this.jy) && Double.doubleToLongBits(that.jz) == Double.doubleToLongBits(this.jz);
    }

    public int hashCode() {
        int result = 0;
        result = 37 * result + Orthonormal3DBasis.hashCode(this.ix);
        result = 37 * result + Orthonormal3DBasis.hashCode(this.iy);
        result = 37 * result + Orthonormal3DBasis.hashCode(this.iz);
        result = 37 * result + Orthonormal3DBasis.hashCode(this.jx);
        result = 37 * result + Orthonormal3DBasis.hashCode(this.jy);
        result = 37 * result + Orthonormal3DBasis.hashCode(this.jz);
        return result;
    }

    public static double lengthSquare(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static long lengthSquareInteger(long x, long y, long z) {
        return x * x + y * y + z * z;
    }

    public static double scalarProduct(double ax, double ay, double az, double bx, double by, double bz) {
        return ax * bx + ay * by + az * bz;
    }

    private Orthonormal3DBasis reviveIfNecessary() {
        if (this.counter <= 32) {
            return this;
        }
        return Orthonormal3DBasis.newBasis(this.ix, this.iy, this.iz, this.jx, this.jy, this.jz, false);
    }

    private static int hashCode(double value) {
        return Double.hashCode(value);
    }
}

