/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public abstract class ContrastingFunc
implements Func {
    protected ContrastingFunc() {
    }

    public static ContrastingFunc getInstance(final double m, final double threshold) {
        return new ContrastingFunc(){

            @Override
            public double get(double ... x) {
                if (x.length < 3) {
                    throw new IndexOutOfBoundsException("At least 3 arguments required");
                }
                if (x.length == 3) {
                    double w = x[0] < x[1] ? x[1] : Math.min(x[0], x[2]);
                    return m * (w - x[1]) / Math.max(x[2] - x[1], threshold);
                }
                double w = x[1] < x[2] ? x[2] : Math.min(x[1], x[3]);
                return m * x[0] * (w - x[2]) / (Math.max(x[3] - x[2], threshold) * x[1]);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                double w = x0 < x1 ? x1 : Math.min(x0, x2);
                return m * (w - x1) / Math.max(x2 - x1, threshold);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                double w = x1 < x2 ? x2 : Math.min(x1, x3);
                return m * x0 * (w - x2) / (Math.max(x3 - x2, threshold) * x1);
            }

            public String toString() {
                return "contrasting function f(x,y,a,b)=" + m + "*(x/y)*max(y'-a," + threshold + ")/(b-a), y'=y<a?a:y>b?b:y";
            }
        };
    }

    @Override
    public double get(double ... x) {
        if (x.length < 3) {
            throw new IndexOutOfBoundsException("At least 3 arguments required");
        }
        if (x.length == 3) {
            return this.get(x[0], x[1], x[2]);
        }
        return this.get(x[0], x[1], x[2], x[3]);
    }

    @Override
    public final double get() {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public final double get(double x0) {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public final double get(double x0, double x1) {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public abstract double get(double var1, double var3, double var5);

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return x0 / x1 * this.get(x1, x2, x3);
    }
}

