/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.Objects;
import net.algart.math.IRange;

public final class Range {
    final double min;
    final double max;

    Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public static Range of(double min, double max) {
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("Cannot create Range: min is NaN");
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("Cannot create Range: max is NaN");
        }
        if (min > max) {
            throw new IllegalArgumentException("Cannot create Range: min > max (min = " + min + ", max = " + max + ")");
        }
        return new Range(min, max);
    }

    @Deprecated
    public static Range valueOf(double min, double max) {
        return Range.of(min, max);
    }

    public static Range of(IRange iRange) {
        Objects.requireNonNull(iRange, "Null iRange argument");
        return new Range(iRange.min, iRange.max);
    }

    @Deprecated
    public static Range valueOf(IRange iRange) {
        return Range.of(iRange);
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double size() {
        return this.max - this.min;
    }

    public double cut(double value) {
        return value < this.min ? this.min : Math.min(value, this.max);
    }

    public boolean contains(double value) {
        return this.min <= value && value <= this.max;
    }

    public boolean contains(Range range) {
        return this.min <= range.min && range.max <= this.max;
    }

    public boolean intersects(Range range) {
        return this.min <= range.max && range.min <= this.max;
    }

    public Range expand(double value) {
        if (Double.isNaN(value)) {
            return this;
        }
        if (value == 0.0) {
            double min = StrictMath.min(value, this.min);
            double max = StrictMath.max(value, this.max);
            return new Range(min, max);
        }
        double min = Math.min(value, this.min);
        double max = Math.max(value, this.max);
        return new Range(min, max);
    }

    public IRange toIntegerRange() {
        return IRange.of((long)this.min, (long)this.max, true);
    }

    public IRange toRoundedRange() {
        return IRange.of(StrictMath.round(this.min), StrictMath.round(this.max), true);
    }

    public String toString() {
        return this.min + ".." + this.max;
    }

    public int hashCode() {
        long lMin = Double.doubleToLongBits(this.min);
        long lMax = Double.doubleToLongBits(this.max);
        int iMin = (int)lMin * 37 + (int)(lMin >>> 32);
        int iMax = (int)lMax * 37 + (int)(lMax >>> 32);
        return iMin * 37 + iMax;
    }

    public boolean equals(Object obj) {
        return obj instanceof Range && Double.doubleToLongBits(((Range)obj).min) == Double.doubleToLongBits(this.min) && Double.doubleToLongBits(((Range)obj).max) == Double.doubleToLongBits(this.max);
    }
}

