/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executable.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Repeater
implements Cloneable {
    static final boolean TRIMMING_CORRECTION_OF_REPEATED_TEXT = true;
    static final String CHARSET = "UTF-8";
    static final String[] BEGIN_OF_COMMENTS = new String[]{"//<<", "//[[", "/*", "(*", "#[[", "#<<", "<!--"};
    static final String[] END_OF_COMMENTS = new String[]{">>", "]]", "*/", "*)", "]]", ">>", "-->"};
    static final boolean[] IS_ONE_LINE_COMMENT = new boolean[]{true, true, false, false, true, true, false};
    static final String[] BEGIN_OF_COMMENTS_RE = new String[]{"//<<", "//\\[\\[", "/\\*", "\\(\\*", "#\\[\\[", "#<<", "<!--"};
    static final String[] END_OF_COMMENTS_RE = new String[]{">>", "\\]\\]", "\\*/", "\\*\\)", "\\]\\]", ">>", "-->"};
    static final String[] REPEAT_START = Repeater.appendByBraces("Repeat(", true, false);
    static final String REPEAT_MIDDLE_WARN = "Repeat.AutoGeneratedStart";
    static final String[] REPEAT_MIDDLE = Repeater.appendByBraces("Repeat.AutoGeneratedStart", true, false);
    static final String REPEAT_END_WARN = "Repeat.AutoGeneratedEnd";
    static final String[] REPEAT_END = Repeater.appendByBraces("Repeat.AutoGeneratedEnd", true, true);
    static final String REPEAT_INCLUDE_END_WARN = "Repeat.IncludeEnd";
    static final String[] REPEAT_INCLUDE_END = Repeater.appendByBraces("Repeat.IncludeEnd", true, true);
    static final String REPEAT_SECTION_START_RE = "Repeat\\.SectionStart";
    static final String REPEAT_SECTION_END_RE = "Repeat\\.SectionEnd";
    static final String ANY_REPEAT_RE = "//<<Repeat[\\.\\(].*?>>[ \\t]*|//\\[\\[Repeat[\\.\\(].*?\\]\\][ \\t]*|/\\*Repeat[\\.\\(].*?\\*/\\s*|\\(\\*Repeat[\\.\\(].*?\\*\\)\\s*|#\\[\\[Repeat[\\.\\(].*?\\]\\][ \\t]*|#<<Repeat[\\.\\(].*?>>[ \\t]*|<!--Repeat[\\.\\(].*?-->\\s*";
    static final String INCLUDE_OPTION = "INCLUDE_FROM_FILE";
    static final String INCLUDE_OPTION_ALT = "IFF";
    static final String THIS_FILE = "THIS_FILE";
    static final String SHIFT_OPTION = "SHIFT";
    static final String AUTO_GENERATION_WARNING = "!! Auto-generated: NOT EDIT !!";
    static final String INCLUDE_WARNING = "!! Auto-generated: NOT EDIT !!";
    static final Map<String, Pattern> allPatterns = Collections.synchronizedMap(new HashMap());
    static final Pattern PATTERN_LINE_START = Pattern.compile("^", 8);
    static final ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final Object lock = new Object();
    private File processedFile;
    private String processedContent;
    private boolean trimTrailingWhitespace;
    private boolean onlyTrimTrailingWhitespace;
    private boolean warningOnTabs;
    private boolean removeAllIncludes;
    String otherFileSection;
    int currentPosition;
    boolean shift;
    String[] regexps;
    String[][] replacements;
    private boolean someFilesChanged = false;
    private boolean exceptionOccurred = false;
    private static int msgMaxLen = 0;

    static String[] appendByBraces(String s, boolean fromLeft, boolean fromRight) {
        String[] result = new String[BEGIN_OF_COMMENTS.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (fromLeft ? BEGIN_OF_COMMENTS[k] : "") + s + (fromRight ? END_OF_COMMENTS[k] : "");
        }
        return result;
    }

    static Pattern compilePatternDotAll(String regex) {
        Pattern p = allPatterns.get(regex);
        if (p == null) {
            p = Pattern.compile(regex, 32);
            allPatterns.put(regex, p);
        }
        return p;
    }

    void setProcessedFile(File value) {
        this.processedFile = value;
    }

    void setTrimTrailingWhitespace(boolean value) {
        this.trimTrailingWhitespace = value;
    }

    void setOnlyTrimTrailingWhitespace(boolean value) {
        this.onlyTrimTrailingWhitespace = value;
    }

    void setWarningOnTabs(boolean value) {
        this.warningOnTabs = value;
    }

    void setRemoveAllIncludes(boolean value) {
        this.removeAllIncludes = value;
    }

    static String dup(char c, int len) {
        char[] chars = new char[len];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    static int countLines(String s) {
        int result = 1;
        Matcher m = Pattern.compile("\\r(?!\\n)|\\n|\\r\\n", 32).matcher(s);
        while (m.find()) {
            ++result;
        }
        return result;
    }

    int countLines() {
        return Repeater.countLines(this.processedContent.substring(0, this.currentPosition));
    }

    static String trimComments(String s) {
        if ((s = s.trim()).startsWith("//")) {
            s = s.substring(2).trim();
        } else if (s.startsWith("#")) {
            s = s.substring(1).trim();
        }
        return s;
    }

    static String read(File file) throws IOException {
        Object object = lock;
        synchronized (object) {
            String string;
            FileInputStream inputStream = new FileInputStream(file);
            StringBuilder sb = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, CHARSET);){
                int len;
                char[] buf = new char[32768];
                while ((len = reader.read(buf)) >= 0) {
                    sb.append(buf, 0, len);
                }
                string = sb.toString();
            }
            return string;
        }
    }

    void read() throws IOException {
        this.processedContent = Repeater.read(this.processedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(File file, String data) throws IOException {
        Object object = lock;
        synchronized (object) {
            FileOutputStream outputStream = new FileOutputStream(file);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, CHARSET);){
                writer.write(data);
            }
        }
    }

    void write(String s) throws IOException {
        Repeater.write(this.processedFile, s);
    }

    void parseCommands(String commands, String currentContent) throws SyntaxException, IOException {
        String commandsTail;
        int k;
        int c1 = commands.indexOf(")");
        if (c1 == -1) {
            throw new SyntaxException(": ) expected at line " + this.countLines());
        }
        String[] arguments = commands.substring(0, c1).split(",");
        ++c1;
        this.otherFileSection = null;
        this.shift = false;
        if (arguments.length >= 1) {
            if (arguments[0].equals(INCLUDE_OPTION) || arguments[0].equals(INCLUDE_OPTION_ALT)) {
                if (arguments.length != 3) {
                    throw new SyntaxException(": illegal number of arguments in (), correct arguments should be (\"INCLUDE_FROM_FILE\",otherFileName,otherFileSectionName) at line " + this.countLines());
                }
                if (this.removeAllIncludes) {
                    this.otherFileSection = "/**REMOVED**/";
                } else {
                    String s;
                    String otherFileName = arguments[1].trim();
                    if (otherFileName.equals(THIS_FILE)) {
                        s = currentContent;
                    } else {
                        File otherFile = new File(this.processedFile.getParent(), otherFileName);
                        s = Repeater.read(otherFile);
                        otherFileName = otherFile.toString();
                    }
                    for (k = 0; k < BEGIN_OF_COMMENTS_RE.length; ++k) {
                        Matcher m = Repeater.compilePatternDotAll(BEGIN_OF_COMMENTS_RE[k] + "Repeat\\.SectionStart\\s*" + arguments[2].trim() + END_OF_COMMENTS_RE[k] + "(.*?)" + BEGIN_OF_COMMENTS_RE[k] + "Repeat\\.SectionEnd\\s*" + arguments[2].trim() + END_OF_COMMENTS_RE[k]).matcher(s);
                        if (!m.find()) continue;
                        this.otherFileSection = m.group(1);
                        break;
                    }
                    if (this.otherFileSection == null) {
                        throw new SyntaxException(": " + otherFileName + " file doesn't contain requested section " + REPEAT_SECTION_START_RE.replaceAll("\\\\", "") + " " + arguments[2].trim() + " ..." + REPEAT_SECTION_END_RE.replaceAll("\\\\", "") + " " + arguments[2].trim() + " at line " + this.countLines());
                    }
                }
            } else if (arguments[0].equals(SHIFT_OPTION)) {
                this.shift = true;
            }
        }
        String[] lists = (commandsTail = commands.substring(c1)).trim().isEmpty() ? new String[]{} : commandsTail.split(";;");
        this.regexps = new String[lists.length];
        this.replacements = new String[lists.length][];
        for (k = 0; k < lists.length; ++k) {
            String repLast;
            int r = lists[k].indexOf("==>");
            if (r == -1) {
                throw new SyntaxException(": ==> expected at line " + this.countLines());
            }
            this.regexps[k] = Repeater.trimComments(lists[k].substring(0, r));
            if (this.regexps[k].isEmpty()) {
                throw new SyntaxException(": empty regexp before ==> at line " + this.countLines());
            }
            String[] rep = (lists[k].substring(r += "==>".length()) + " ").split(",,");
            if (rep.length > 1 && (repLast = rep[rep.length - 1].trim()).startsWith("...")) {
                int repLen;
                if (!(repLast = repLast.substring("...".length()).trim()).startsWith("(") || !repLast.endsWith(")")) {
                    repLen = k > 0 ? this.replacements[0].length : rep.length;
                } else {
                    repLast = repLast.substring(1, repLast.length() - 1);
                    try {
                        repLen = Integer.parseInt(repLast);
                    }
                    catch (NumberFormatException ex) {
                        throw new SyntaxException(": illegal replacement syntax (\"...(NNN)\" exprected) at line " + this.countLines());
                    }
                }
                repLen = Math.max(repLen, rep.length - 1);
                String[] repNew = new String[repLen];
                System.arraycopy(rep, 0, repNew, 0, rep.length - 1);
                for (int l = rep.length - 1; l < repLen; ++l) {
                    repNew[l] = rep[rep.length - 2];
                }
                rep = repNew;
            }
            this.replacements[k] = rep;
            if (k > 0 && this.replacements[k].length != this.replacements[0].length) {
                throw new SyntaxException(": different lengths of the following replacement lists (list #" + k + " contains " + this.replacements[k].length + " elements, list #0 contains " + this.replacements[0].length + " elements)" + String.format("%n", new Object[0]) + commandsTail + " at line " + this.countLines());
            }
            for (int i = 0; i < this.replacements[k].length; ++i) {
                String s = Repeater.trimComments(this.replacements[k][i]);
                if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                    s = s.substring(1, s.length() - 1);
                    s = s.replaceAll("\\\\\"", "\"");
                    s = s.replaceAll("\\\\\\\\", "\\");
                    s = s.replaceAll("\\\\,", ",");
                    s = s.replaceAll("\\\\.", ".");
                    s = s.replaceAll("\\\\n", "\n");
                    s = s.replaceAll("\\\\r", "\r");
                    s = s.replaceAll("\\\\b", "\b");
                    s = s.replaceAll("\\\\t", "\t");
                    s = s.replaceAll("\\\\f", "\f");
                }
                this.replacements[k][i] = s;
            }
        }
    }

    String processPass(String s, int passIndex) throws SyntaxException, IOException {
        StringBuilder sb = new StringBuilder();
        int q = 0;
        while (true) {
            int n;
            String[] endMarker;
            String repeatedText;
            int pComment;
            int p;
            if ((p = s.indexOf(REPEAT_START[passIndex], q)) == -1) break;
            int foundLen = REPEAT_START[passIndex].length();
            sb.append(s, q, p);
            this.currentPosition = p;
            String endOfComment = END_OF_COMMENTS[passIndex];
            int p1 = s.indexOf(endOfComment, p += foundLen);
            if (p1 == -1) {
                throw new SyntaxException(": comment not closed at line at line " + this.countLines());
            }
            String commands = s.substring(p, p1);
            String comment = "";
            if (pComment != -1) {
                for (pComment = commands.indexOf("!!"); pComment > 0 && commands.charAt(pComment - 1) <= ' '; --pComment) {
                }
                comment = commands.substring(pComment);
                commands = commands.substring(0, pComment);
            }
            this.parseCommands(commands, s);
            if (this.otherFileSection != null && !comment.contains("!! Auto-generated: NOT EDIT !!")) {
                comment = " !! Auto-generated: NOT EDIT !! ";
            }
            sb.append(REPEAT_START[passIndex]).append(commands).append(comment).append(endOfComment);
            int p2 = p1 += endOfComment.length();
            String p2Spaces = "";
            boolean oneLineComment = IS_ONE_LINE_COMMENT[passIndex];
            if (this.otherFileSection == null) {
                int p2Back;
                String middleMarkerWarn = REPEAT_MIDDLE[passIndex];
                p2 = s.indexOf(middleMarkerWarn, p1);
                foundLen = middleMarkerWarn.length();
                if (p2 == -1) {
                    throw new SyntaxException(": no " + middleMarkerWarn + " section after line " + Repeater.countLines(s.substring(0, p1)));
                }
                if (oneLineComment) {
                    char c;
                    boolean oneLineFound = false;
                    int p2LastSpace = p2;
                    for (p2Back = p2; p2Back > p1 && ((c = s.charAt(p2Back - 1)) == ' ' || c == '\t' || c == '\n' || c == '\r'); --p2Back) {
                        if (!(oneLineFound || c != ' ' && c != '\t')) {
                            p2LastSpace = p2Back - 1;
                        }
                        if (c != '\r' && (c != '\n' || p2Back > 1 && s.charAt(p2Back - 2) == '\r')) continue;
                        if (oneLineFound) {
                            if (c != '\r' || s.charAt(p2Back) != '\n') break;
                            ++p2Back;
                            break;
                        }
                        oneLineFound = true;
                    }
                    if (!oneLineFound) {
                        p2Back = p2;
                    } else {
                        p2Spaces = s.substring(p2Back, p2);
                    }
                }
                String paddedRepeatedText = s.substring(p1, p2);
                repeatedText = s.substring(p1, p2Back);
                p2 += foundLen;
                assert (endOfComment.equals(END_OF_COMMENTS[passIndex]));
                int p2Close = s.indexOf(endOfComment, p2);
                if (p2Close == -1) {
                    throw new SyntaxException(": comment not closed at line " + Repeater.countLines(s.substring(0, p1)));
                }
                comment = s.substring(p2, p2Close);
                if (!comment.contains("!! Auto-generated: NOT EDIT !!")) {
                    comment = " !! Auto-generated: NOT EDIT !! ";
                }
                p2 = p2Close + endOfComment.length();
                sb.append(paddedRepeatedText);
                sb.append(REPEAT_MIDDLE[passIndex]).append(comment).append(endOfComment);
                endMarker = REPEAT_END;
            } else {
                repeatedText = this.otherFileSection;
                endMarker = REPEAT_INCLUDE_END;
            }
            String endMarkerWarn = endMarker[passIndex];
            int p3 = s.indexOf(endMarkerWarn, p2);
            foundLen = endMarkerWarn.length();
            if (p3 == -1) {
                throw new SyntaxException(": " + endMarkerWarn + " marker expected after line " + Repeater.countLines(s.substring(0, p2)));
            }
            q = p3 += foundLen;
            repeatedText = Repeater.compilePatternDotAll(ANY_REPEAT_RE).matcher(repeatedText).replaceAll("");
            int n2 = n = this.replacements.length == 0 ? 1 : this.replacements[0].length;
            for (int k = 0; k < n; ++k) {
                Object correctedText = repeatedText;
                if (k == n - 1) {
                    correctedText = (String)correctedText + p2Spaces;
                } else if (!oneLineComment) {
                    correctedText = ((String)correctedText).stripTrailing();
                }
                for (int j = 0; j < this.replacements.length; ++j) {
                    String r = this.replacements[j][k];
                    Matcher m = Repeater.compilePatternDotAll("\\$INDEX\\(([\\w\\d\\,=\\s]*)\\)").matcher(r);
                    StringBuilder rsb = new StringBuilder();
                    while (m.find()) {
                        int start = 0;
                        int step = 1;
                        String[] indexParams = m.group(1).split(",");
                        try {
                            for (String indexParamOriginal : indexParams) {
                                String indexParam = indexParamOriginal.trim().toLowerCase();
                                if (indexParam.isEmpty()) continue;
                                if (indexParam.startsWith("start=")) {
                                    start = Integer.parseInt(indexParam.substring("start=".length()).trim());
                                    continue;
                                }
                                if (indexParam.startsWith("step=")) {
                                    step = Integer.parseInt(indexParam.substring("step=".length()).trim());
                                    continue;
                                }
                                throw new SyntaxException(": illegal param \"" + indexParam + "\" in $INDEX (correct example: \"$INDEX(start=0,step=3)\") at line " + this.countLines());
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new SyntaxException(": illegal $INDEX syntax (correct example: \"$INDEX(start=0,step=3)\") at line " + this.countLines());
                        }
                        m.appendReplacement(rsb, String.valueOf(start + k * step));
                    }
                    m.appendTail(rsb);
                    r = rsb.toString();
                    correctedText = Repeater.compilePatternDotAll(this.regexps[j]).matcher((CharSequence)correctedText).replaceAll(r);
                }
                if (this.otherFileSection == null && this.shift) {
                    String space = Repeater.dup(' ', 48);
                    if (((String)(correctedText = PATTERN_LINE_START.matcher((CharSequence)correctedText).replaceAll(space))).startsWith(space)) {
                        correctedText = ((String)correctedText).substring(space.length());
                    }
                }
                sb.append((String)correctedText);
            }
            sb.append(endMarker[passIndex]);
        }
        sb.append(s.substring(q));
        return sb.toString();
    }

    String process() throws SyntaxException, IOException {
        String s = this.processedContent;
        for (int passIndex = 0; passIndex < REPEAT_START.length; ++passIndex) {
            s = this.processPass(s, passIndex);
        }
        return s;
    }

    boolean someFilesChanged() {
        return this.someFilesChanged;
    }

    boolean exceptionOccurred() {
        return this.exceptionOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile() {
        block33: {
            if (!this.processedFile.exists()) {
                return;
            }
            String msg = "Processing " + String.valueOf(this.processedFile) + "... ";
            if (msg.length() > 80) {
                msg = "Processing (...)" + this.processedFile.toString().substring(msg.length() - 80) + "... ";
            }
            Object object = lock;
            synchronized (object) {
                msgMaxLen = Math.max(msgMaxLen, msg.length());
                System.out.print("\r" + Repeater.dup(' ', msgMaxLen) + "\r" + msg);
            }
            try {
                Object object2;
                boolean changed;
                String sCorrected;
                this.read();
                boolean trimmed = false;
                if (this.trimTrailingWhitespace) {
                    Object s = Repeater.compilePatternDotAll("[ \t]+(\n|\r)").matcher(this.processedContent).replaceAll("$1");
                    String rear = ((String)s).endsWith("\r\n") ? "\r\n" : (((String)s).endsWith("\r") ? "\r" : (((String)s).endsWith("\n") ? "\n" : ""));
                    s = Repeater.compilePatternDotAll("[ \t\r\n]*$").matcher((CharSequence)s).replaceAll("") + rear;
                    trimmed = !((String)s).equals(this.processedContent);
                    this.processedContent = s;
                }
                if (this.onlyTrimTrailingWhitespace) {
                    sCorrected = this.processedContent;
                } else {
                    sCorrected = this.process();
                    if (this.trimTrailingWhitespace) {
                        sCorrected = Repeater.compilePatternDotAll("[ \t]+(\n|\r)").matcher(sCorrected).replaceAll("$1");
                    }
                }
                boolean bl = changed = !sCorrected.equals(this.processedContent);
                if (this.warningOnTabs && sCorrected.contains("\t")) {
                    object2 = lock;
                    synchronized (object2) {
                        System.out.println("\r" + Repeater.dup(' ', msgMaxLen) + "\r" + msg);
                        System.out.println("WARNING! This file contains tabulation characters! We recommend to replace them by spaces in the IDE.");
                    }
                }
                if (changed || trimmed) {
                    this.write(sCorrected);
                    object2 = lock;
                    synchronized (object2) {
                        System.out.println("\r" + Repeater.dup(' ', msgMaxLen) + "\r" + msg + "O'K" + (changed ? "" : " (only trailing spaces)"));
                    }
                    this.someFilesChanged = true;
                    break block33;
                }
                object2 = lock;
                synchronized (object2) {
                    System.out.print("\r" + Repeater.dup(' ', msgMaxLen) + "\r");
                }
            }
            catch (IOException e) {
                Object object3 = lock;
                synchronized (object3) {
                    this.exceptionOccurred = true;
                    System.out.println();
                    System.err.println("I/O error while processing " + String.valueOf(this.processedFile));
                    System.err.println("  " + e.getMessage());
                }
            }
            catch (PatternSyntaxException | SyntaxException e) {
                Object object4 = lock;
                synchronized (object4) {
                    this.exceptionOccurred = true;
                    System.out.println();
                    System.err.println("Cannot process " + String.valueOf(this.processedFile));
                    System.err.println("  " + e.getMessage());
                }
            }
            catch (Throwable e) {
                Object object5 = lock;
                synchronized (object5) {
                    this.exceptionOccurred = true;
                    System.out.println();
                    System.out.println();
                    e.printStackTrace();
                    System.out.println();
                }
            }
        }
    }

    public void submitTask() {
        Repeater r;
        try {
            r = (Repeater)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        pool.submit(() -> r.processFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileMask(String fileMask) {
        File[] files;
        String ext;
        File path = new File(fileMask);
        File parent = path.getParentFile();
        String mask = path.getName();
        if (parent != null && "**".equals(parent.getName())) {
            if (!(parent = parent.getParentFile()).isDirectory()) {
                Object object = lock;
                synchronized (object) {
                    System.out.print("\r" + Repeater.dup(' ', msgMaxLen) + "\r");
                    System.err.println("Directory " + String.valueOf(parent) + " does not exist");
                }
                return;
            }
            File[] subDirs = parent.listFiles((dir, name) -> {
                File f = new File(dir, name);
                return f.isDirectory() && !f.isHidden();
            });
            if (subDirs != null) {
                for (File subDir : subDirs) {
                    File newParent = new File(subDir, "**");
                    this.processFileMask(new File(newParent, mask).getPath());
                }
            }
        }
        String string = ext = mask.startsWith("*.") ? mask.substring("*.".length()) : null;
        if (ext == null) {
            files = new File[]{new File(parent, mask)};
        } else {
            assert (parent != null);
            files = parent.listFiles((dir, name) -> name.endsWith("." + ext));
        }
        if (files != null) {
            for (File file : files) {
                this.setProcessedFile(file);
                this.submitTask();
            }
        }
    }

    public static void main(String[] args) {
        int startArgIndex = 0;
        boolean trimTrailingWhitespace = false;
        boolean onlyTrimTrailingWhitespace = false;
        boolean warningOnTabs = false;
        boolean removeAllIncludes = false;
        for (int k = 0; k < 3 && startArgIndex < args.length; ++k) {
            if (args[startArgIndex].equalsIgnoreCase("-trimTrailingWhitespace")) {
                trimTrailingWhitespace = true;
                ++startArgIndex;
                continue;
            }
            if (args[startArgIndex].equalsIgnoreCase("-onlyTrimTrailingWhitespace")) {
                onlyTrimTrailingWhitespace = true;
                ++startArgIndex;
                continue;
            }
            if (args[startArgIndex].equalsIgnoreCase("-warningOnTabs")) {
                warningOnTabs = true;
                ++startArgIndex;
                continue;
            }
            if (!args[startArgIndex].equalsIgnoreCase("-removeAllIncludes")) continue;
            removeAllIncludes = true;
            ++startArgIndex;
        }
        if (args.length == startArgIndex) {
            System.out.println("Usage:");
            System.out.println("    Repeater [-trimTrailingWhitespace|-onlyTrimTrailingWhitespace] [-warningOnTabs] [-removeAllIncludes] someTextFile1 someTextFile2 ...");
            System.out.println("File masks *.ext or **\\*.ext | **/*.ext (recurse subdirectories) may be used, for example:");
            System.out.println("    Repeater *.java");
            System.out.println("    Repeater **/*.java");
            System.out.println("(Last command processes all .java-files in current directory and all its subdirectories.)");
            return;
        }
        long t1 = System.currentTimeMillis();
        Repeater r = new Repeater();
        r.setTrimTrailingWhitespace(trimTrailingWhitespace);
        r.setOnlyTrimTrailingWhitespace(onlyTrimTrailingWhitespace);
        r.setWarningOnTabs(warningOnTabs);
        r.setRemoveAllIncludes(removeAllIncludes);
        for (int argIndex = startArgIndex; argIndex < args.length; ++argIndex) {
            String fileMask = args[argIndex];
            r.processFileMask(fileMask);
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException argIndex) {
            // empty catch block
        }
        if (r.exceptionOccurred()) {
            System.exit(1);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("\r" + Repeater.dup(' ', msgMaxLen) + "\rProcessing time " + (t2 - t1) + " ms");
        if (r.someFilesChanged()) {
            try {
                Thread.sleep(1000L);
                System.out.println();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class SyntaxException
    extends Exception {
        private static final long serialVersionUID = 1283256722407269023L;

        SyntaxException(String message) {
            super("Illegal Repeater syntax" + message);
        }
    }
}

