/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.JArrays;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.contexts.InterruptionException;
import net.algart.contours.ContourHeader;
import net.algart.contours.ContourLength;
import net.algart.contours.Contours;
import net.algart.contours.IntArrayTranslatingAppender;
import net.algart.contours.JoinedLabelsLists;
import net.algart.math.IRectangularArea;
import net.algart.math.rectangles.IRectangleFinder;

public final class ContourJoiner {
    public static final int MAX_GRID_STEP_LOG = 30;
    private static final int MIN_RECOMMENDED_GRID_STEP_LOG = 4;
    private static final int MAX_RECOMMENDED_GRID_MATRIX_SIZE = 0x2000000;
    private static final int EMPTY_POSITION = -1;
    private static final int REPACKING_DEFERRED_QUEUE_STEP = 16;
    private static final int REVIVING_VISITED_GRID_STEP = 64;
    private static final int CHECK_INTERRUPTION_STEP = 256;
    private final int DETAILED_DEBUG_LEVEL = 0;
    private JoiningOrder joiningOrder = JoiningOrder.UNORDERED;
    private boolean packResultContours = true;
    private int measureTimingLevel = 0;
    private BooleanSupplier interruptionChecker = null;
    private final Contours contours;
    private final Contours result;
    private final boolean useGrid;
    private final int gridStepLog;
    private final int numberOfContours;
    private final int[] reindexedLabels;
    private final JoinedLabelsLists joinedLists;
    private final int maxNumberOfJoinedContours;
    private final boolean[] alreadyProcessed;
    final int[] allMinX;
    final int[] allMaxX;
    final int[] allMinY;
    final int[] allMaxY;
    private final boolean[] allInternal;
    private volatile IRectangularArea containingRectangle = null;
    private int[] clusterContours = new int[256];
    private final int[] clusterContoursOffsets;
    private final int[] indexesOfClusterContours;
    private final int[] reverseIndexesOfContoursInCluster;
    private final int[] sortedIndexesOfClusterContours;
    private final IntArrayTranslatingAppender sortedIndexesOfClusterContoursAppender;
    private int numberOfClusterContours = 0;
    private final boolean[] possibleNeighboursInClusterSet;
    private final int[] possibleNeighboursIndexesInCluster;
    private int numberOfPossibleNeighbours = 0;
    private final long[] visitedGrid;
    private final int[] indexesOfNonZeroVisitedGridElements;
    private int nonZeroVisitedGridElementsCount = 0;
    private int[] compressedContoursPositions = new int[256];
    private long[] compressedContoursBitMaps8x8 = new long[256];
    private final int[] compressedContoursPositionsOffsets;
    private int compressedContoursPositionsLength = 0;
    private int visitedGridMinX = -1;
    private int visitedGridMaxX = -1;
    private int visitedGridMinY = -1;
    private int visitedGridMaxY = -1;
    private int visitedGridDimX = -1;
    private int visitedGridDimY = -1;
    private int visitedGridSize = -1;
    private final Contours deferredContours = Contours.newInstance();
    private int deferredContoursStart = 0;
    private final ContourHeader currentHeader = new ContourHeader();
    private boolean currentInternal = false;
    private int currentLabel = -1;
    private int reindexedCurrentLabel = -1;
    private int currentIndex = -1;
    private int[] current = JArrays.EMPTY_INTS;
    private boolean[] currentUsage = JArrays.EMPTY_BOOLEANS;
    private int currentNumberOfPoints = 0;
    private int currentLength = 0;
    int currentMinX = -1;
    int currentMaxX = -1;
    int currentMinY = -1;
    int currentMaxY = -1;
    private int[] currentPositionsForXPlusSegments;
    private int[] currentPositionsForYPlusSegments;
    private final MutableIntArray currentIndexesOfJoinedContours = net.algart.arrays.Arrays.SMM.newEmptyIntArray();
    private final IRectangleFinder rectangleFinder;
    private boolean joinedInternal = false;
    private int joinedIndex = -1;
    private int[] joined = null;
    private int joinedOffset = 0;
    private boolean[] joinedUsage = JArrays.EMPTY_BOOLEANS;
    private int joinedNumberOfPoints = 0;
    private int joinedLength = 0;
    private int joinedMinX = -1;
    private int joinedMaxX = -1;
    private int joinedMinY = -1;
    private int joinedMaxY = -1;
    private int intersectionMinX = -1;
    private int intersectionMinY = -1;
    private int intersectionDimX = -1;
    private int intersectionDimY = -1;
    private int intersectionDiffX = -1;
    private int intersectionDiffY = -1;
    private int intersectionMatrixSize = -1;
    private int[] joinedPositionsForXPlusSegments;
    private int[] joinedPositionsForYPlusSegments;
    private int[] joinResult = JArrays.EMPTY_INTS;
    private boolean joinResultInternal = false;
    private int joinResultNumberOfPoints = 0;
    private int[] joinAdditionalResult = JArrays.EMPTY_INTS;
    private boolean joinAdditionalResultInternal = false;
    private int joinAdditionalResultNumberOfPoints = 0;
    private int[] workPackedPoints = JArrays.EMPTY_INTS;
    private long tCreatingInitialization = 0L;
    private long tCreatingJoinedLists = 0L;
    private long tCreatingAllocating = 0L;
    private long tCreatingAllocatingMatrices = 0L;
    private long tCreatingAnalysingRectangles = 0L;
    private long tCreatingClusterRectangles = 0L;
    private long tTotalWork = 0L;
    private long tSimple = 0L;
    private long tBuildingCluster = 0L;
    private long tPreprocessingGrid = 0L;
    private long tInitializeNewCurrent = 0L;
    private long tFindInitialNeighbours = 0L;
    private long tReadingCurrent = 0L;
    private long tAnalysing = 0L;
    private long tRevivingGrid = 0L;
    private long tJoiningCheckingGridSuccess = 0L;
    private long tJoiningCheckingGridFail = 0L;
    private long tJoiningReadingNewJoined = 0L;
    private long tJoiningScanning1Success = 0L;
    private long tJoiningScanning1Fail = 0L;
    private long tJoiningScanning2Success = 0L;
    private long tJoiningScanning2Fail = 0L;
    private long tJoiningSwitching = 0L;
    private long tJoiningAddingToGridAndNeighbours = 0L;
    private long tWritingContours = 0L;
    private long tOffsetOfMinX = 0L;
    private long tFindFreeSegment = 0L;
    private long tFindFreeUnusedSegment = 0L;
    private int sMinCheckedContoursCount = Integer.MAX_VALUE;
    private int sMaxCheckedContoursCount = 0;
    private long sSumCheckedContoursCount = 0L;
    private int sNumberOfCheckedContoursLoops = 0;
    private int sMinJoinedContoursCount = Integer.MAX_VALUE;
    private int sMaxJoinedContoursCount = 0;
    private long sSumJoinedContoursCount = 0L;
    private int sNumberOfJoinedContours = 0;
    private int sMinDeferredContoursCount = Integer.MAX_VALUE;
    private int sMaxDeferredContoursCount = 0;
    private long sSumDeferredContoursCount = 0L;
    private long sNumberOfDeferredContoursChecks = 0L;
    private long sTotalNumberOfDeferredContours = 0L;
    private long sNumberOfScanningCurrent = 0L;
    private long sNumberOfSuccessfulScanningCurrent = 0L;
    private long sNumberOfScanningJoined = 0L;
    private long sNumberOfSuccessfulScanningJoined = 0L;

    private ContourJoiner(Contours contours, Integer gridStepLog, int[] joinedLabelsMap, int defaultJoinedLabel) {
        int gridMatrixSize;
        this.contours = Objects.requireNonNull(contours, "Null contours");
        if (defaultJoinedLabel < 0) {
            throw new IllegalArgumentException("Negative defaultJoinedLabel = " + defaultJoinedLabel);
        }
        if (gridStepLog != null) {
            if (gridStepLog < 0) {
                throw new IllegalArgumentException("Negative gridStepLog");
            }
            if (gridStepLog != 0 && (gridStepLog < 3 || gridStepLog > 30)) {
                throw new IllegalArgumentException("gridStepLog (grid step logarithm) = " + gridStepLog + " is non-zero and is out of required range 3..30");
            }
            this.useGrid = gridStepLog != 0;
        } else {
            this.useGrid = true;
        }
        long t1 = System.nanoTime();
        this.result = Contours.newInstance();
        this.numberOfContours = contours.numberOfContours();
        assert (this.numberOfContours <= 500000000);
        this.reindexedLabels = IntStream.range(0, contours.numberOfContours()).parallel().map(contourIndex -> ContourJoiner.reindex(contours.getObjectLabel(contourIndex), joinedLabelsMap, defaultJoinedLabel)).toArray();
        long t2 = System.nanoTime();
        this.tCreatingInitialization = t2 - t1;
        this.joinedLists = new JoinedLabelsLists(this.reindexedLabels);
        this.maxNumberOfJoinedContours = this.joinedLists.maxListLength;
        assert (this.maxNumberOfJoinedContours <= this.numberOfContours);
        long t3 = System.nanoTime();
        this.tCreatingJoinedLists = t3 - t2;
        this.alreadyProcessed = new boolean[this.numberOfContours];
        this.clusterContoursOffsets = new int[this.maxNumberOfJoinedContours + 1];
        this.compressedContoursPositionsOffsets = new int[this.maxNumberOfJoinedContours + 1];
        this.indexesOfClusterContours = new int[this.maxNumberOfJoinedContours];
        this.sortedIndexesOfClusterContours = new int[this.maxNumberOfJoinedContours];
        this.reverseIndexesOfContoursInCluster = new int[this.numberOfContours];
        this.possibleNeighboursIndexesInCluster = new int[this.maxNumberOfJoinedContours];
        this.possibleNeighboursInClusterSet = new boolean[this.numberOfContours];
        this.allMinX = new int[this.numberOfContours];
        this.allMaxX = new int[this.numberOfContours];
        this.allMinY = new int[this.numberOfContours];
        this.allMaxY = new int[this.numberOfContours];
        this.allInternal = new boolean[this.numberOfContours];
        int[] allMatrixSize = new int[this.numberOfContours];
        long t4 = System.nanoTime();
        this.tCreatingAllocating += t4 - t3;
        IntStream.range(0, this.numberOfContours + 255 >>> 8).parallel().forEach(block -> {
            int i;
            ContourHeader header = new ContourHeader();
            int to = (int)Math.min((long)i + 256L, (long)this.numberOfContours);
            for (i = block << 8; i < to; ++i) {
                contours.getHeader(header, i);
                this.allInternal[i] = header.isInternalContour();
                if (!this.hasNeighboursToJoin(i)) continue;
                int minX = header.minX();
                int maxX = header.maxX();
                int minY = header.minY();
                int maxY = header.maxY();
                this.allMinX[i] = minX;
                this.allMaxX[i] = maxX;
                this.allMinY[i] = minY;
                this.allMaxY[i] = maxY;
                int diffX = maxX - minX;
                int diffY = maxY - minY;
                if (diffX < 0 || diffY < 0) {
                    throw new AssertionError((Object)("Overflow in sizes of containing rectangle for contour #" + i + "; it must be impossible due to check of Contour2DArray.MAX_ABSOLUTE_COORDINATE"));
                }
                long matrixSize = (1L + (long)diffX) * (1L + (long)diffY);
                if (matrixSize > Integer.MAX_VALUE) {
                    throw new TooLargeArrayException("Containing rectangles of contours must have area <= Integer.MAX_VALUE pixels, but contour #" + i + " is " + (1L + (long)diffX) + "x" + (1L + (long)diffY));
                }
                allMatrixSize[i] = (int)matrixSize;
            }
        });
        int maxContainingMatrixSize = 0;
        for (int k = 0; k < this.numberOfContours; ++k) {
            int matrixSize = allMatrixSize[k];
            if (matrixSize <= maxContainingMatrixSize) continue;
            maxContainingMatrixSize = matrixSize;
        }
        long t5 = System.nanoTime();
        this.tCreatingAnalysingRectangles += t5 - t4;
        if (this.useGrid) {
            int chosenGridStepLog;
            this.joinedLists.initializeNonEmptyClusterRectangles(this.allMinX, this.allMaxX, this.allMinY, this.allMaxY);
            if (gridStepLog != null) {
                chosenGridStepLog = gridStepLog;
                gridMatrixSize = (int)this.joinedLists.maxClusterGridMatrixSize(chosenGridStepLog, true);
            } else {
                chosenGridStepLog = 4;
                long size = this.joinedLists.maxClusterGridMatrixSize(chosenGridStepLog, false);
                while (chosenGridStepLog < 30 && size > 0x2000000L) {
                    size = this.joinedLists.maxClusterGridMatrixSize(++chosenGridStepLog, false);
                }
                assert (size == (long)((int)size)) : "impossible: after division by 2^30, the cluster size is still > 33554432";
                gridMatrixSize = (int)size;
            }
            this.gridStepLog = chosenGridStepLog;
        } else {
            this.gridStepLog = -1;
            gridMatrixSize = -1;
        }
        long t6 = System.nanoTime();
        this.tCreatingClusterRectangles += t6 - t5;
        this.currentPositionsForXPlusSegments = new int[maxContainingMatrixSize];
        this.currentPositionsForYPlusSegments = new int[maxContainingMatrixSize];
        this.joinedPositionsForXPlusSegments = new int[maxContainingMatrixSize];
        this.joinedPositionsForYPlusSegments = new int[maxContainingMatrixSize];
        this.sortedIndexesOfClusterContoursAppender = new IntArrayTranslatingAppender(this.sortedIndexesOfClusterContours, i -> this.indexesOfClusterContours[i]);
        this.rectangleFinder = IRectangleFinder.getEmptyInstance();
        this.rectangleFinder.setIndexActual(i -> !this.alreadyProcessed[this.indexesOfClusterContours[i]]);
        this.visitedGrid = this.useGrid ? new long[gridMatrixSize] : null;
        this.indexesOfNonZeroVisitedGridElements = this.useGrid ? new int[gridMatrixSize] : null;
        long t7 = System.nanoTime();
        this.tCreatingAllocatingMatrices = t7 - t6;
    }

    public static ContourJoiner newInstance(Contours contours, Integer gridStepLog, int[] joinedLabelsMap) {
        Objects.requireNonNull(joinedLabelsMap, "Null joinedLabelsMap");
        return new ContourJoiner(contours, gridStepLog, joinedLabelsMap, 157);
    }

    public static ContourJoiner newInstance(Contours contours, Integer gridStepLog, int[] joinedLabelsMap, int defaultJoinedLabel) {
        return new ContourJoiner(contours, gridStepLog, joinedLabelsMap, defaultJoinedLabel);
    }

    public JoiningOrder getJoiningOrder() {
        return this.joiningOrder;
    }

    public ContourJoiner setJoiningOrder(JoiningOrder joiningOrder) {
        this.joiningOrder = Objects.requireNonNull(joiningOrder, "Null joining order");
        return this;
    }

    public boolean isPackResultContours() {
        return this.packResultContours;
    }

    public ContourJoiner setPackResultContours(boolean packResultContours) {
        this.packResultContours = packResultContours;
        return this;
    }

    public int getMeasureTimingLevel() {
        return this.measureTimingLevel;
    }

    public ContourJoiner setMeasureTimingLevel(int measureTimingLevel) {
        this.measureTimingLevel = measureTimingLevel;
        return this;
    }

    public BooleanSupplier getInterruptionChecker() {
        return this.interruptionChecker;
    }

    public ContourJoiner setInterruptionChecker(BooleanSupplier interruptionChecker) {
        this.interruptionChecker = interruptionChecker;
        return this;
    }

    public IRectangularArea containingRectangle() {
        IRectangularArea containingRectangle = this.containingRectangle;
        if (containingRectangle == null && this.numberOfContours > 0) {
            int containingMinX = Integer.MAX_VALUE;
            int containingMaxX = Integer.MIN_VALUE;
            int containingMinY = Integer.MAX_VALUE;
            int containingMaxY = Integer.MIN_VALUE;
            ContourHeader header = new ContourHeader();
            for (int k = 0; k < this.numberOfContours; ++k) {
                int maxY;
                int minY;
                int maxX;
                int minX;
                if (this.hasNeighboursToJoin(k)) {
                    minX = this.allMinX[k];
                    maxX = this.allMaxX[k];
                    minY = this.allMinY[k];
                    maxY = this.allMaxY[k];
                } else {
                    this.contours.getHeader(header, k);
                    minX = header.minX();
                    maxX = header.maxX();
                    minY = header.minY();
                    maxY = header.maxY();
                }
                if (minX < containingMinX) {
                    containingMinX = minX;
                }
                if (maxX > containingMaxX) {
                    containingMaxX = maxX;
                }
                if (minY < containingMinY) {
                    containingMinY = minY;
                }
                if (maxY <= containingMaxY) continue;
                containingMaxY = maxY;
            }
            this.containingRectangle = containingRectangle = IRectangularArea.of(containingMinX, containingMinY, containingMaxX, containingMaxY);
        }
        return containingRectangle;
    }

    public Contours joinContours() {
        long t1 = System.nanoTime();
        JArrays.fill(this.alreadyProcessed, false);
        this.result.clear();
        for (int k = 0; k < this.numberOfContours; ++k) {
            this.addContourAndItsContinuations(k);
        }
        long t2 = System.nanoTime();
        this.tTotalWork = t2 - t1;
        return this.result;
    }

    public boolean needToJoin(int objectIndex1, int objectIndex2) {
        return this.reindexedLabels[objectIndex1] == this.reindexedLabels[objectIndex2];
    }

    public boolean hasNeighboursToJoin(int objectIndex) {
        return this.joinedLists.hasNeighboursToJoin(this.reindexedLabels[objectIndex]);
    }

    public String timingInfo() {
        long tActualJoining = this.tRevivingGrid + this.tJoiningReadingNewJoined + this.tJoiningScanning1Success + this.tJoiningScanning1Fail + this.tJoiningScanning2Success + this.tJoiningScanning2Fail + this.tJoiningSwitching + this.tJoiningAddingToGridAndNeighbours;
        long tCreating = this.tCreatingInitialization + this.tCreatingJoinedLists + this.tCreatingAnalysingRectangles + this.tCreatingAllocating + this.tCreatingClusterRectangles + this.tCreatingAllocatingMatrices;
        String common = String.format(Locale.US, "%d contours joined to %d ones (%s, %s) in %.3f ms (%.6f ms/contour, maximal number of joined %d): \n  %.3f creating (%.3f initialization + %.3f joined lists + %.3f rectangles + %.3f clusters + %.3f and %.3f allocation);\n  %.3f processing", this.contours.numberOfContours(), this.result.numberOfContours(), this.joiningOrder.prettyName, this.useGrid ? "grid cells " + (1 << this.gridStepLog) + "x" + (1 << this.gridStepLog) : "no grid", (double)(tCreating + this.tTotalWork) * 1.0E-6, (double)(tCreating + this.tTotalWork) * 1.0E-6 / (double)this.contours.numberOfContours(), this.maxNumberOfJoinedContours, (double)tCreating * 1.0E-6, (double)this.tCreatingInitialization * 1.0E-6, (double)this.tCreatingJoinedLists * 1.0E-6, (double)this.tCreatingAnalysingRectangles * 1.0E-6, (double)this.tCreatingClusterRectangles * 1.0E-6, (double)this.tCreatingAllocating * 1.0E-6, (double)this.tCreatingAllocatingMatrices * 1.0E-6, (double)this.tTotalWork * 1.0E-6);
        if (this.measureTimingLevel == 0) {
            return common;
        }
        String newCurrent = String.format(Locale.US, "%s:\n    %.3f simple adding (no other contours with same label),\n    %.3f building cluster: unpacking contours with the same reindexed label,\n    %.3f preprocessing grid (reallocating, compressing contours),\n    %.3f initializing new current contour,\n    %.3f finding initial possible neighbours,\n    %.3f reading current contour,", common, (double)this.tSimple * 1.0E-6, (double)this.tBuildingCluster * 1.0E-6, (double)this.tPreprocessingGrid * 1.0E-6, (double)this.tInitializeNewCurrent * 1.0E-6, (double)this.tFindInitialNeighbours * 1.0E-6, (double)this.tReadingCurrent * 1.0E-6);
        String statistics = String.format(Locale.US, "\n    number of checks of contours before joining 1 new contour: min %d, max %d, mean %.3f, total %d\n    number of contours, joined to single one: min %d, max %d, mean %.3f, total %d\n    number of deferred contours: min %d, max %d, mean %.3f, total %d\n    number of successful/total scannings current contour: %d/%d\n    number of successful/total scannings joined contour: %d/%d", this.sMinCheckedContoursCount, this.sMaxCheckedContoursCount, (double)this.sSumCheckedContoursCount / (double)this.sNumberOfCheckedContoursLoops, this.sSumCheckedContoursCount, this.sMinJoinedContoursCount, this.sMaxJoinedContoursCount, (double)this.sSumJoinedContoursCount / (double)this.sNumberOfJoinedContours, this.sSumJoinedContoursCount, this.sMinDeferredContoursCount, this.sMaxDeferredContoursCount, (double)this.sSumDeferredContoursCount / (double)this.sNumberOfDeferredContoursChecks, this.sTotalNumberOfDeferredContours, this.sNumberOfSuccessfulScanningCurrent, this.sNumberOfScanningCurrent, this.sNumberOfSuccessfulScanningJoined, this.sNumberOfScanningJoined);
        if (this.measureTimingLevel == 1) {
            return String.format(Locale.US, "%s\n    %.3f analysis,\n    %.3f writing result contours%s", newCurrent, (double)this.tAnalysing * 1.0E-6, (double)this.tWritingContours * 1.0E-6, statistics);
        }
        return String.format(Locale.US, "%s\n    %.3f analysis, including:\n      %.6f quick checks (including rectangles)%s,\n      %.6f actual joining, including:\n        %.6f reviving visited grid,\n        %.6f initializing/reading 2nd (joined) contour,\n        %.6f/%.6f scanning current contour (success/fail),\n        %.6f/%.6f scanning joined contour (success/fail),\n        %.6f switching algorithm,\n        %.6f adding information to neighbours lists/grid,%s\n    %.3f writing result contours%s", newCurrent, (double)this.tAnalysing * 1.0E-6, (double)(this.tAnalysing - tActualJoining) * 1.0E-6, this.measureTimingLevel < 3 ? "" : String.format(Locale.US, ", including %.6f/%.6f checking grid (success/fail) ", (double)this.tJoiningCheckingGridSuccess * 1.0E-6, (double)this.tJoiningCheckingGridFail * 1.0E-6), (double)tActualJoining * 1.0E-6, (double)this.tRevivingGrid * 1.0E-6, (double)this.tJoiningReadingNewJoined * 1.0E-6, (double)this.tJoiningScanning1Success * 1.0E-6, (double)this.tJoiningScanning1Fail * 1.0E-6, (double)this.tJoiningScanning2Success * 1.0E-6, (double)this.tJoiningScanning2Fail * 1.0E-6, (double)this.tJoiningSwitching * 1.0E-6, (double)this.tJoiningAddingToGridAndNeighbours * 1.0E-6, this.measureTimingLevel < 3 ? "" : String.format(Locale.US, " including: \n          %.6f searching the leftmost point,\n          %.6f finding free segment (1st iteration),\n          %.6f finding free unused segment (further iterations),", (double)this.tOffsetOfMinX * 1.0E-6, (double)this.tFindFreeSegment * 1.0E-6, (double)this.tFindFreeUnusedSegment * 1.0E-6), (double)this.tWritingContours * 1.0E-6, statistics);
    }

    private void addContourAndItsContinuations(int contourIndex) {
        if (this.alreadyProcessed[contourIndex]) {
            return;
        }
        long t1 = this.nanoTime1();
        if (!this.hasNeighboursToJoin(contourIndex)) {
            this.contours.getHeader(this.currentHeader, contourIndex);
            this.currentHeader.clearContourTouchingMatrixBoundary();
            this.currentHeader.setObjectLabel(this.reindexedLabels[contourIndex]);
            if (this.packResultContours) {
                ContourLength contourLength = new ContourLength();
                long lengthAndOffset = this.contours.getContourLengthAndOffset(contourIndex);
                this.workPackedPoints = Contours.packContourAndReallocateResult(this.workPackedPoints, contourLength, this.contours.points, Contours.extractOffset(lengthAndOffset), Contours.extractLength(lengthAndOffset));
                this.result.addContour(this.currentHeader, this.workPackedPoints, 0, contourLength.getArrayLength());
            } else {
                this.result.addContour(this.contours, contourIndex);
            }
            this.tSimple += this.nanoTime1() - t1;
            return;
        }
        this.buildClusterWithSameReindexedLabel(contourIndex);
        long t2 = this.nanoTime1();
        this.tBuildingCluster += t2 - t1;
        this.preprocessCompressedContours();
        long t3 = this.nanoTime1();
        this.tPreprocessingGrid += t3 - t2;
        this.joinCluster();
    }

    private void buildClusterWithSameReindexedLabel(int contourIndex) {
        int count = 0;
        int pointsLength = 0;
        ContourLength contourLength = new ContourLength();
        int reindexed = this.reindexedLabels[contourIndex];
        int to = this.joinedLists.offsets[reindexed + 1];
        for (int i = this.joinedLists.offsets[reindexed]; i < to; ++i) {
            int index = this.joinedLists.indexes[i];
            assert (index >= contourIndex) : "invalid order in lists, built by buildJoinedLists()";
            this.indexesOfClusterContours[count] = index;
            this.reverseIndexesOfContoursInCluster[index] = count;
            this.current = this.contours.unpackContourAndReallocateResult(this.current, contourLength, index);
            int length = contourLength.getArrayLength();
            this.ensureCapacityForUnpackedClusterAndReallocate((long)pointsLength + (long)length);
            System.arraycopy(this.current, 0, this.clusterContours, pointsLength, length);
            this.clusterContoursOffsets[count] = pointsLength;
            pointsLength += length;
            ++count;
        }
        this.clusterContoursOffsets[count] = pointsLength;
        assert (count == this.joinedLists.length(reindexed));
        if (count <= 1) {
            throw new AssertionError((Object)("Empty cluster due to incorrect hasNeighboursToJoin: " + count));
        }
        this.numberOfClusterContours = count;
        if (this.useGrid) {
            int clusterMinX = this.joinedLists.clusterMinX[reindexed];
            int clusterMaxX = this.joinedLists.clusterMaxX[reindexed];
            int clusterMinY = this.joinedLists.clusterMinY[reindexed];
            int clusterMaxY = this.joinedLists.clusterMaxY[reindexed];
            this.initializeVisitedGrid(clusterMinX, clusterMaxX, clusterMinY, clusterMaxY);
        }
    }

    private void initializeVisitedGrid(int clusterMinX, int clusterMaxX, int clusterMinY, int clusterMaxY) {
        assert (this.useGrid);
        this.visitedGridMinX = clusterMinX >> this.gridStepLog;
        this.visitedGridMaxX = clusterMaxX >> this.gridStepLog;
        this.visitedGridMinY = clusterMinY >> this.gridStepLog;
        this.visitedGridMaxY = clusterMaxY >> this.gridStepLog;
        this.visitedGridDimX = this.visitedGridMaxX - this.visitedGridMinX + 1;
        this.visitedGridDimY = this.visitedGridMaxY - this.visitedGridMinY + 1;
        long gridMatrixSize = (long)this.visitedGridDimX * (long)this.visitedGridDimY;
        if (gridMatrixSize > (long)this.visitedGrid.length) {
            throw new AssertionError((Object)("Too large cluster: " + gridMatrixSize + " > maximal length " + this.visitedGrid.length + ", found in the constructor"));
        }
        this.visitedGridSize = (int)gridMatrixSize;
    }

    private void preprocessCompressedContours() {
        if (this.useGrid) {
            this.compressAllClusterContours();
            this.nonZeroVisitedGridElementsCount = 0;
            Arrays.fill(this.visitedGrid, 0, this.visitedGridSize, 0L);
        }
    }

    private void cleanupVisitedGrid() {
        if (!this.useGrid) {
            return;
        }
        if (this.nonZeroVisitedGridElementsCount >= this.visitedGridSize >> 1) {
            Arrays.fill(this.visitedGrid, 0, this.visitedGridSize, 0L);
        } else {
            for (int k = 0; k < this.nonZeroVisitedGridElementsCount; ++k) {
                this.visitedGrid[this.indexesOfNonZeroVisitedGridElements[k]] = 0L;
            }
        }
        this.nonZeroVisitedGridElementsCount = 0;
    }

    private void compressAllClusterContours() {
        assert (this.useGrid) : "this function must not be used when grid is not used: gridStepLog = " + this.gridStepLog;
        this.compressedContoursPositionsLength = 0;
        this.compressedContoursPositionsOffsets[0] = 0;
        for (int k = 0; k < this.numberOfClusterContours; ++k) {
            this.compressClusterContour(k);
            this.compressedContoursPositionsOffsets[k + 1] = this.compressedContoursPositionsLength;
        }
    }

    private void reviveVisitedGridForCurrentContour() {
        if (this.useGrid) {
            long t1 = this.nanoTime2();
            this.cleanupVisitedGrid();
            this.markPointsAtVisitedGridAndStoreNonZeroIndexes(this.current, 0, this.currentLength);
            int m = this.numberOfDeferredContours();
            for (int k = 0; k < m; ++k) {
                int pointsFrom = this.deferredContourOffset(k);
                int pointsTo = pointsFrom + this.deferredContourLength(k);
                this.markPointsAtVisitedGridAndStoreNonZeroIndexes(this.deferredContours.points, pointsFrom, pointsTo);
            }
            long t2 = this.nanoTime2();
            this.tRevivingGrid += t2 - t1;
        }
    }

    private void compressClusterContour(int indexInCluster) {
        int index = this.indexesOfClusterContours[indexInCluster];
        int minX = this.allMinX[index] >> this.gridStepLog;
        int minY = this.allMinY[index] >> this.gridStepLog;
        int dimX = (this.allMaxX[index] >> this.gridStepLog) - minX + 1;
        int dimY = (this.allMaxY[index] >> this.gridStepLog) - minY + 1;
        int from = this.clusterContoursOffsets[indexInCluster];
        int to = this.clusterContoursOffsets[indexInCluster + 1];
        this.compressContour(this.clusterContours, from, to, minX, minY, dimX, dimY);
    }

    private void compressContour(int[] points, int pointsFrom, int pointsTo, int minX, int minY, int dimX, int dimY) {
        int workSpaceSize = dimX * dimY;
        Arrays.fill(this.visitedGrid, 0, workSpaceSize, 0L);
        this.markPointsAtGrid(points, pointsFrom, pointsTo, minX, minY, dimX, dimY);
        this.retrieveAllCompressedPointsFromGrid(minX, minY, dimX, dimY);
    }

    private void markPointsAtGrid(int[] points, int pointsFrom, int pointsTo, int minX, int minY, int dimX, int dimY) {
        long[] workGrid = this.visitedGrid;
        int lastXBit = Integer.MAX_VALUE;
        int lastYBit = Integer.MAX_VALUE;
        int gridStepLogForBits = this.gridStepLog - 3;
        assert (gridStepLogForBits >= 0);
        for (int i = pointsFrom; i < pointsTo; i += 2) {
            int position;
            int xBit = points[i] >> gridStepLogForBits;
            int yBit = points[i + 1] >> gridStepLogForBits;
            if (xBit == lastXBit && yBit == lastYBit) continue;
            lastXBit = xBit;
            lastYBit = yBit;
            int x = xBit >> 3;
            int y = yBit >> 3;
            int bitInLong = (yBit & 7) << 3 | xBit & 7;
            int gridX = x - minX;
            int gridY = y - minY;
            assert (0 <= gridX && gridX < dimX) : "compressed gridX=" + gridX + " is out of range 0.." + dimX + "-1";
            assert (0 <= gridY && gridY < dimY) : "compressed gridY=" + gridY + " is out of range 0.." + dimY + "-1";
            int n = position = gridY * dimX + gridX;
            workGrid[n] = workGrid[n] | 1L << bitInLong;
        }
    }

    private void markPointsAtVisitedGridAndStoreNonZeroIndexes(int[] points, int pointsFrom, int pointsTo) {
        int minX = this.visitedGridMinX;
        int minY = this.visitedGridMinY;
        int dimX = this.visitedGridDimX;
        int dimY = this.visitedGridDimY;
        int lastXBit = Integer.MAX_VALUE;
        int lastYBit = Integer.MAX_VALUE;
        int gridStepLogForBits = this.gridStepLog - 3;
        assert (gridStepLogForBits >= 0);
        for (int i = pointsFrom; i < pointsTo; i += 2) {
            int xBit = points[i] >> gridStepLogForBits;
            int yBit = points[i + 1] >> gridStepLogForBits;
            if (xBit == lastXBit && yBit == lastYBit) continue;
            lastXBit = xBit;
            lastYBit = yBit;
            int x = xBit >> 3;
            int y = yBit >> 3;
            int bitInLong = (yBit & 7) << 3 | xBit & 7;
            int gridX = x - minX;
            int gridY = y - minY;
            assert (0 <= gridX && gridX < dimX) : "compressed gridX=" + gridX + " is out of range 0.." + dimX + "-1";
            assert (0 <= gridY && gridY < dimY) : "compressed gridY=" + gridY + " is out of range 0.." + dimY + "-1";
            int position = gridY * dimX + gridX;
            long previous = this.visitedGrid[position];
            this.visitedGrid[position] = previous | 1L << bitInLong;
            if (previous != 0L) continue;
            this.indexesOfNonZeroVisitedGridElements[this.nonZeroVisitedGridElementsCount++] = position;
        }
    }

    private void retrieveAllCompressedPointsFromGrid(int minX, int minY, int dimX, int dimY) {
        long[] workGrid = this.visitedGrid;
        int fullGridXFrom = minX - this.visitedGridMinX;
        int fullGridXTo = fullGridXFrom + dimX;
        assert (fullGridXFrom >= 0 && fullGridXTo <= this.visitedGridDimX) : "x-range " + fullGridXFrom + ".." + fullGridXTo + " is out of range 0.." + this.visitedGridDimX;
        int fullGridYFrom = minY - this.visitedGridMinY;
        int fullGridYTo = fullGridYFrom + dimY;
        assert (fullGridYFrom >= 0 && fullGridYTo <= this.visitedGridDimY) : " y-range " + fullGridYFrom + ".." + fullGridYTo + " is out of range 0.." + this.visitedGridDimY;
        int increment = this.visitedGridDimX - dimX;
        int fullGridOffset = fullGridYFrom * this.visitedGridDimX + fullGridXFrom;
        int count = this.compressedContoursPositionsLength;
        int offset = 0;
        for (int fullGridY = fullGridYFrom; fullGridY < fullGridYTo; ++fullGridY) {
            assert (fullGridOffset == fullGridY * this.visitedGridDimX + fullGridXFrom);
            int fullGridX = fullGridXFrom;
            while (fullGridX < fullGridXTo) {
                long bitMap8x8 = workGrid[offset];
                if (bitMap8x8 != 0L) {
                    if (count >= this.compressedContoursPositions.length) {
                        this.ensureCapacityForCompressedClusterAndReallocate((long)count + 1L);
                    }
                    this.compressedContoursPositions[count] = fullGridOffset;
                    this.compressedContoursBitMaps8x8[count] = bitMap8x8;
                    ++count;
                }
                ++fullGridOffset;
                ++fullGridX;
                ++offset;
            }
            fullGridOffset += increment;
        }
        this.compressedContoursPositionsLength = count;
    }

    private boolean isCompressedContourProbablyVisited(int indexInCluster) {
        long t1 = this.nanoTime3();
        assert (this.useGrid);
        int from = this.compressedContoursPositionsOffsets[indexInCluster];
        int to = this.compressedContoursPositionsOffsets[indexInCluster + 1];
        for (int i = from; i < to; ++i) {
            if ((this.visitedGrid[this.compressedContoursPositions[i]] & this.compressedContoursBitMaps8x8[i]) == 0L) continue;
            this.tJoiningCheckingGridSuccess += this.nanoTime3() - t1;
            return true;
        }
        this.tJoiningCheckingGridFail += this.nanoTime3() - t1;
        return false;
    }

    private void addCompressedContourToVisitedGrid(int indexInCluster) {
        if (!this.useGrid) {
            return;
        }
        int from = this.compressedContoursPositionsOffsets[indexInCluster];
        int to = this.compressedContoursPositionsOffsets[indexInCluster + 1];
        for (int i = from; i < to; ++i) {
            int position = this.compressedContoursPositions[i];
            assert (position >= 0 && position < this.visitedGridSize) : "position[" + i + "]=" + position + " is out of grid " + this.visitedGridDimX + "x" + this.visitedGridDimY + "=" + this.visitedGridSize;
            long bitMap8x8 = this.compressedContoursBitMaps8x8[i];
            assert (bitMap8x8 != 0L) : "Zero bitmap 8x8 at position " + position;
            long previous = this.visitedGrid[position];
            this.visitedGrid[position] = bitMap8x8 | previous;
            if (previous != 0L) continue;
            this.indexesOfNonZeroVisitedGridElements[this.nonZeroVisitedGridElementsCount++] = position;
        }
    }

    private void joinCluster() {
        assert (this.numberOfClusterContours > 1);
        this.reindexedCurrentLabel = this.reindexedLabels[this.indexesOfClusterContours[0]];
        this.rectangleFinder.setIndexedRectangles(this.allMinX, this.allMaxX, this.allMinY, this.allMaxY, this.indexesOfClusterContours, this.numberOfClusterContours);
        long joiningCount = 0L;
        for (int k = 0; k < this.numberOfClusterContours; ++k) {
            int currentIndex = this.indexesOfClusterContours[k];
            if (this.alreadyProcessed[currentIndex]) continue;
            long t1 = this.nanoTime1();
            this.initializeCurrentContour(k, currentIndex);
            this.removeAllPreviouslyAddedPossibleNeighbours();
            long t2 = this.nanoTime1();
            this.tInitializeNewCurrent += t2 - t1;
            this.addPossibleNeighbours(currentIndex);
            long t3 = this.nanoTime1();
            this.tFindInitialNeighbours += t3 - t2;
            this.readCurrentContour();
            long t4 = this.nanoTime1();
            this.tReadingCurrent += t4 - t3;
            do {
                boolean atLeastOneSuccessfullyJoined;
                t4 = this.nanoTime1();
                do {
                    if (this.interruptionChecker != null && ++joiningCount % 256L == 0L && this.interruptionChecker.getAsBoolean()) {
                        throw new InterruptionException("Contours joiner was interrupted while processing contour #" + this.indexesOfClusterContours[0] + "/" + this.numberOfContours + " after " + joiningCount + " joining actions");
                    }
                    if (joiningCount % 64L != 0L) continue;
                    this.reviveVisitedGridForCurrentContour();
                } while ((atLeastOneSuccessfullyJoined = this.growByContoursFromCluster()) && this.currentNumberOfPoints > 0);
                long t5 = this.nanoTime1();
                this.tAnalysing += t5 - t4;
                this.correctJoinedContoursStatistics();
                this.writeContour(this.current, this.currentNumberOfPoints, this.currentInternal);
                long t6 = this.nanoTime1();
                this.tWritingContours += t6 - t5;
            } while (this.loadCurrentContourFromDeferred());
            this.alreadyProcessed[currentIndex] = true;
        }
    }

    private boolean growByContoursFromCluster() {
        int m = this.numberOfPossibleNeighbours;
        boolean atLeastOneSuccessfullyJoined = false;
        boolean noGrid = !this.useGrid;
        for (int i = 0; i < m; ++i) {
            int joinedIndex = this.possibleNeighboursIndexesInCluster[i];
            assert (joinedIndex > this.currentIndex);
            if (this.alreadyProcessed[joinedIndex] || !noGrid && !this.isCompressedContourProbablyVisited(this.reverseIndexesOfContoursInCluster[joinedIndex]) || !this.joinContour(joinedIndex)) continue;
            this.alreadyProcessed[joinedIndex] = true;
            atLeastOneSuccessfullyJoined = true;
            break;
        }
        this.correctQuickChecksStatistics(m);
        return atLeastOneSuccessfullyJoined;
    }

    private void removeAllPreviouslyAddedPossibleNeighbours() {
        for (int k = 0; k < this.numberOfPossibleNeighbours; ++k) {
            this.possibleNeighboursInClusterSet[this.possibleNeighboursIndexesInCluster[k]] = false;
        }
        this.numberOfPossibleNeighbours = 0;
    }

    private void addPossibleNeighbours(int contourIndex) {
        this.sortedIndexesOfClusterContoursAppender.reset();
        this.rectangleFinder.findIntersecting(this.allMinX[contourIndex], this.allMaxX[contourIndex], this.allMinY[contourIndex], this.allMaxY[contourIndex], this.sortedIndexesOfClusterContoursAppender);
        int m = this.sortedIndexesOfClusterContoursAppender.offset();
        this.joiningOrder.sortIndexes(this, this.sortedIndexesOfClusterContours, m);
        for (int k = 0; k < m; ++k) {
            int possibleNeighbour = this.sortedIndexesOfClusterContours[k];
            if (possibleNeighbour <= this.currentIndex || this.possibleNeighboursInClusterSet[possibleNeighbour] || this.alreadyProcessed[possibleNeighbour]) continue;
            this.possibleNeighboursInClusterSet[possibleNeighbour] = true;
            this.possibleNeighboursIndexesInCluster[this.numberOfPossibleNeighbours++] = possibleNeighbour;
        }
    }

    private boolean joinContour(int joinedIndex) {
        long t1 = this.nanoTime2();
        this.initializeNewJoinedAndReallocatePositionsMatrices(joinedIndex);
        this.readNewJoined();
        long t2 = this.nanoTime2();
        this.tJoiningReadingNewJoined += t2 - t1;
        boolean canBeJoined = this.findPositionsOfCurrentContour();
        long t3 = this.nanoTime2();
        ++this.sNumberOfScanningCurrent;
        if (!canBeJoined) {
            this.tJoiningScanning1Fail += t3 - t2;
            return false;
        }
        this.tJoiningScanning1Success += t3 - t2;
        ++this.sNumberOfSuccessfulScanningCurrent;
        canBeJoined = this.findPositionsOfJoinedContourAndCheckCodirectionalSegmentsWithCurrentContour();
        long t4 = this.nanoTime2();
        ++this.sNumberOfScanningJoined;
        if (!canBeJoined) {
            this.tJoiningScanning2Fail += t4 - t3;
            return false;
        }
        this.tJoiningScanning2Success += t4 - t3;
        ++this.sNumberOfSuccessfulScanningJoined;
        this.clearUsage();
        this.addInformationAboutJoined();
        int iteration = 0;
        if (this.joinCurrentAndJoined(iteration++)) {
            this.exchangeMainAndAdditionalJoinResult();
            while (this.joinCurrentAndJoined(iteration++)) {
                this.saveJoinResultContourInDeferred();
            }
            this.exchangeMainAndAdditionalJoinResult();
        }
        this.exchangeCurrentAndJoinResult();
        long t5 = this.nanoTime2();
        this.tJoiningSwitching += t5 - t4;
        this.addPossibleNeighbours(joinedIndex);
        this.addCompressedContourToVisitedGrid(this.reverseIndexesOfContoursInCluster[joinedIndex]);
        long t6 = this.nanoTime2();
        this.tJoiningAddingToGridAndNeighbours += t6 - t5;
        return true;
    }

    private void exchangeCurrentAndJoinResult() {
        int[] tempArray = this.current;
        this.current = this.joinResult;
        this.joinResult = tempArray;
        int tempInt = this.currentNumberOfPoints;
        this.currentNumberOfPoints = this.joinResultNumberOfPoints;
        this.currentLength = 2 * this.currentNumberOfPoints;
        this.joinResultNumberOfPoints = tempInt;
        boolean tempBoolean = this.currentInternal;
        this.currentInternal = this.joinResultInternal;
        this.joinResultInternal = tempBoolean;
    }

    private void exchangeMainAndAdditionalJoinResult() {
        int[] tempArray = this.joinAdditionalResult;
        this.joinAdditionalResult = this.joinResult;
        this.joinResult = tempArray;
        int tempInt = this.joinAdditionalResultNumberOfPoints;
        this.joinAdditionalResultNumberOfPoints = this.joinResultNumberOfPoints;
        this.joinResultNumberOfPoints = tempInt;
        boolean tempBoolean = this.joinAdditionalResultInternal;
        this.joinAdditionalResultInternal = this.joinResultInternal;
        this.joinResultInternal = tempBoolean;
    }

    private int numberOfDeferredContours() {
        return this.deferredContours.numberOfContours() - this.deferredContoursStart;
    }

    private int deferredContourOffset(int indexOfDeferred) {
        return this.deferredContours.getContourOffset(this.deferredContoursStart + indexOfDeferred);
    }

    private int deferredContourLength(int indexOfDeferred) {
        return this.deferredContours.getContourLength(this.deferredContoursStart + indexOfDeferred);
    }

    private boolean loadCurrentContourFromDeferred() {
        int m = this.deferredContours.numberOfContours();
        assert (m >= this.deferredContoursStart);
        assert (this.deferredContoursStart < 16);
        if (m == this.deferredContoursStart) {
            return false;
        }
        this.currentInternal = this.deferredContours.isInternalContour(this.deferredContoursStart);
        ContourLength contourLength = new ContourLength();
        this.current = this.deferredContours.getContourPointsAndReallocateResult(this.current, contourLength, this.deferredContoursStart);
        this.currentNumberOfPoints = contourLength.getNumberOfPoints();
        this.currentLength = 2 * this.currentNumberOfPoints;
        ++this.deferredContoursStart;
        if (this.deferredContoursStart >= 16) {
            this.deferredContours.removeContoursRange(0, this.deferredContoursStart);
            this.deferredContoursStart = 0;
        }
        return true;
    }

    private void saveJoinResultContourInDeferred() {
        if (this.joinResultNumberOfPoints <= 0) {
            return;
        }
        ++this.sTotalNumberOfDeferredContours;
        this.currentHeader.clear();
        this.currentHeader.setInternalContour(this.joinResultInternal);
        this.deferredContours.addContour(this.currentHeader, this.joinResult, 0, 2 * this.joinResultNumberOfPoints);
    }

    private void writeContour(int[] contour, int numberOfPoints, boolean internalContour) {
        if (numberOfPoints <= 0) {
            return;
        }
        this.currentHeader.clear();
        this.currentHeader.setObjectLabel(this.reindexedCurrentLabel);
        this.currentHeader.setInternalContour(internalContour);
        int nonOptimizedLength = 2 * numberOfPoints;
        if (this.packResultContours) {
            ContourLength contourLength = new ContourLength();
            this.workPackedPoints = Contours.packContourAndReallocateResultUnchecked(this.workPackedPoints, contourLength, contour, 0, nonOptimizedLength);
            this.result.addContour(this.currentHeader, this.workPackedPoints, 0, contourLength.getArrayLength());
        } else {
            this.result.addContour(this.currentHeader, contour, 0, nonOptimizedLength);
        }
    }

    private void initializeCurrentContour(int indexInCluster, int currentIndex) {
        this.currentIndex = currentIndex;
        assert (this.hasNeighboursToJoin(currentIndex));
        this.currentMinX = this.allMinX[currentIndex];
        this.currentMaxX = this.allMaxX[currentIndex];
        this.currentMinY = this.allMinY[currentIndex];
        this.currentMaxY = this.allMaxY[currentIndex];
        this.cleanupVisitedGrid();
        this.addCompressedContourToVisitedGrid(indexInCluster);
    }

    private void readCurrentContour() {
        this.currentLabel = this.contours.getObjectLabel(this.currentIndex);
        this.currentInternal = this.allInternal[this.currentIndex];
        int indexInCluster = this.reverseIndexesOfContoursInCluster[this.currentIndex];
        int contourOffset = this.clusterContoursOffsets[indexInCluster];
        this.currentLength = this.clusterContoursOffsets[indexInCluster + 1] - contourOffset;
        this.currentNumberOfPoints = this.currentLength >> 1;
        this.ensureCapacityForCurrent(this.currentLength);
        System.arraycopy(this.clusterContours, contourOffset, this.current, 0, this.currentLength);
        this.currentIndexesOfJoinedContours.clear();
        this.currentIndexesOfJoinedContours.pushInt(this.currentIndex);
    }

    private void initializeNewJoinedAndReallocatePositionsMatrices(int joinedIndex) {
        this.joinedIndex = joinedIndex;
        this.joinedMinX = this.allMinX[joinedIndex];
        this.joinedMaxX = this.allMaxX[joinedIndex];
        this.joinedMinY = this.allMinY[joinedIndex];
        this.joinedMaxY = this.allMaxY[joinedIndex];
        this.intersectionMinX = Math.max(this.currentMinX, this.joinedMinX);
        int intersectionMaxX = Math.min(this.currentMaxX, this.joinedMaxX);
        this.intersectionMinY = Math.max(this.currentMinY, this.joinedMinY);
        int intersectionMaxY = Math.min(this.currentMaxY, this.joinedMaxY);
        if (this.intersectionMinX > intersectionMaxX || this.intersectionMinY > intersectionMaxY) {
            throw new AssertionError((Object)("Containing rectangles of current and joined contours does not intersect: " + this.currentMinX + ".." + this.currentMaxX + "x" + this.currentMinY + ".." + this.currentMaxY + " and " + this.joinedMinX + ".." + this.joinedMaxX + "x" + this.joinedMinY + ".." + this.joinedMaxY + "; it must be checked before this moment"));
        }
        this.intersectionDiffX = intersectionMaxX - this.intersectionMinX;
        this.intersectionDiffY = intersectionMaxY - this.intersectionMinY;
        this.intersectionDimX = this.intersectionDiffX + 1;
        this.intersectionDimY = this.intersectionDiffY + 1;
        long matrixSize = (long)this.intersectionDimX * (long)this.intersectionDimY;
        this.ensureCapacityForPositionsMatrices(matrixSize);
        assert (this.intersectionDimX > 0 && this.intersectionDimY > 0);
        this.intersectionMatrixSize = (int)matrixSize;
    }

    private void readNewJoined() {
        this.joinedInternal = this.allInternal[this.joinedIndex];
        int indexInCluster = this.reverseIndexesOfContoursInCluster[this.joinedIndex];
        this.joined = this.clusterContours;
        this.joinedOffset = this.clusterContoursOffsets[indexInCluster];
        this.joinedLength = this.clusterContoursOffsets[indexInCluster + 1] - this.joinedOffset;
        this.joinedNumberOfPoints = this.joinedLength >> 1;
    }

    private int joinedLabel() {
        return this.contours.getObjectLabel(this.joinedIndex);
    }

    private boolean joinCurrentAndJoined(int iteration) {
        this.joinResultNumberOfPoints = 0;
        CurrentOrJoinedContour oneFromTwo = new CurrentOrJoinedContour(iteration);
        int p = oneFromTwo.initializeSwitchingAlgorithm();
        if (p == -1) {
            return false;
        }
        this.ensureCapacityForJoinResultContour((long)this.currentLength + (long)this.joinedLength);
        int maxPossibleResultPosition = this.currentLength + this.joinedLength;
        int startPosition = p;
        CurrentOrJoinedSwitcher startSwitcher = oneFromTwo.switcher;
        int[] twoStartPositions = new int[]{-1, -1};
        twoStartPositions[oneFromTwo.switcher.index] = startPosition;
        int[] twoLastPositions = (int[])twoStartPositions.clone();
        boolean switchesOccured = false;
        int resultPosition = 0;
        do {
            boolean nonTrivialSituation;
            boolean skipTrivialSteps;
            this.checkInfiniteLoop(resultPosition, maxPossibleResultPosition);
            int x = oneFromTwo.x(p);
            int y = oneFromTwo.y(p);
            assert (!oneFromTwo.used(p)) : "Already used point " + x + "," + y + " appeared; it is impossible while correct scanning";
            int dx = x - this.intersectionMinX;
            int dy = y - this.intersectionMinY;
            int distance = 0;
            if (dx < 0 || dx > this.intersectionDiffX) {
                int distanceY;
                distance = dx < 0 ? -dx : dx - this.intersectionDiffX;
                int n = distanceY = dy < 0 ? -dy : dy - this.intersectionDiffY;
                if (distanceY > 0) {
                    distance += distanceY;
                }
            } else if (dy < 0 || dy > this.intersectionDiffY) {
                distance = dy < 0 ? -dy : dy - this.intersectionDiffY;
            }
            boolean bl = skipTrivialSteps = distance > 6;
            if (skipTrivialSteps) {
                int limit;
                --distance;
                int n = limit = oneFromTwo.switcher == startSwitcher && startPosition > p ? startPosition : oneFromTwo.length;
                if ((distance <<= 1) > limit - p) {
                    distance = limit - p;
                }
                oneFromTwo.copyTo(p, this.joinResult, resultPosition, distance);
                Arrays.fill(oneFromTwo.usage, p >> 1, p + distance >> 1, true);
                resultPosition += distance;
                if ((p += distance) == oneFromTwo.length) {
                    p = 0;
                }
            } else {
                this.joinResult[resultPosition++] = x;
                this.joinResult[resultPosition++] = y;
                oneFromTwo.use(p);
                p = oneFromTwo.cyclicNextEven(p);
            }
            int positionAtOther = oneFromTwo.other.positionAtContour(p, this);
            boolean bl2 = nonTrivialSituation = positionAtOther != -1;
            if (!nonTrivialSituation) continue;
            if (skipTrivialSteps) {
                throw new AssertionError((Object)"After skipping trivial steps we must not find anything yet (because of distance-- above)");
            }
            assert ((positionAtOther & 1) == 0);
            int checkedAtThis = oneFromTwo.switcher.positionAtContour(positionAtOther, this);
            if (checkedAtThis != p) {
                throw new AssertionError((Object)("Mutual positions of current and joined contours do not match: current position = " + p + ", mutual = " + checkedAtThis));
            }
            positionAtOther = oneFromTwo.cyclicNextEvenAtOther(positionAtOther);
            x = oneFromTwo.x(p);
            y = oneFromTwo.y(p);
            if (oneFromTwo.otherX(positionAtOther) != x || oneFromTwo.otherY(positionAtOther) != y) {
                throw new AssertionError((Object)"Different point at the current and joined contours");
            }
            int positionAtThis = oneFromTwo.switcher.positionAtContour(positionAtOther, this);
            twoLastPositions[oneFromTwo.switcher.index] = p;
            if (positionAtThis != -1) {
                p = oneFromTwo.cyclicNextEven(positionAtThis);
                if (oneFromTwo.x(p) != x || oneFromTwo.y(p) != y) {
                    throw new AssertionError((Object)("Invalid jump to #" + p + ": " + x + "," + y + " -> " + oneFromTwo.x(p) + "," + oneFromTwo.y(p) + " at " + oneFromTwo.switcher.name + " contour. " + this.contoursInfo()));
                }
            } else {
                oneFromTwo.switchToOther();
                p = positionAtOther;
            }
            switchesOccured = true;
            if (p == startPosition && oneFromTwo.switcher == startSwitcher) continue;
            oneFromTwo.checkReturningBackAfterSwitchOrJump(p, twoStartPositions, twoLastPositions);
        } while (p != startPosition || oneFromTwo.switcher != startSwitcher);
        if (!switchesOccured) {
            throw new AssertionError((Object)"No switches, though we must have counter-directional segments!");
        }
        this.joinResultNumberOfPoints = resultPosition >> 1;
        return true;
    }

    private void clearUsage() {
        this.ensureCapacityForUsage();
        Arrays.fill(this.currentUsage, 0, this.currentNumberOfPoints, false);
        Arrays.fill(this.joinedUsage, 0, this.joinedNumberOfPoints, false);
    }

    private void checkInfiniteLoop(int resultPosition, int maxPossibleResultPosition) {
        if (resultPosition >= maxPossibleResultPosition) {
            throw new AssertionError((Object)("Infinite loop whilee joining to the contour #" + this.currentIndex + " (0-based numbering, label " + this.currentLabel + ") a new contour #" + this.joinedIndex + " (label " + this.joinedLabel() + "): " + this.contoursInfo()));
        }
    }

    private void addInformationAboutJoined() {
        this.currentMinX = Math.min(this.currentMinX, this.joinedMinX);
        this.currentMaxX = Math.max(this.currentMaxX, this.joinedMaxX);
        this.currentMinY = Math.min(this.currentMinY, this.joinedMinY);
        this.currentMaxY = Math.max(this.currentMaxY, this.joinedMaxY);
        this.currentIndexesOfJoinedContours.pushInt(this.joinedIndex);
    }

    private boolean findPositionsOfCurrentContour() {
        JArrays.fillIntArray(this.currentPositionsForXPlusSegments, 0, this.intersectionMatrixSize, -1);
        JArrays.fillIntArray(this.currentPositionsForYPlusSegments, 0, this.intersectionMatrixSize, -1);
        int n = this.currentLength;
        assert (n > 0);
        int intersectionMinX = this.intersectionMinX;
        int intersectionMinY = this.intersectionMinY;
        int intersectionDiffX = this.intersectionDiffX;
        int intersectionDiffY = this.intersectionDiffY;
        int intersectionDimX = this.intersectionDimX;
        boolean hasPointsInsideJoinedRectangle = false;
        int i = 0;
        while (i < n) {
            int[] currentPositions;
            int distance;
            int x = this.current[i] - intersectionMinX;
            int y = this.current[i + 1] - intersectionMinY;
            if (x < 0 || x > intersectionDiffX) {
                int distanceY;
                distance = x < 0 ? -x : x - intersectionDiffX;
                int n2 = distanceY = y < 0 ? -y : y - intersectionDiffY;
                if (distanceY > 0) {
                    distance += distanceY;
                }
                i += distance << 1;
                continue;
            }
            if (y < 0 || y > intersectionDiffY) {
                distance = y < 0 ? -y : y - intersectionDiffY;
                i += distance << 1;
                continue;
            }
            int lastI = i == 0 ? n - 2 : i - 2;
            int lastX = this.current[lastI] - intersectionMinX;
            int lastY = this.current[lastI + 1] - intersectionMinY;
            i += 2;
            if (lastX < 0 || lastY < 0 || lastX > intersectionDiffX || lastY > intersectionDiffY) continue;
            hasPointsInsideJoinedRectangle = true;
            int dx = x - lastX;
            int dy = y - lastY;
            assert (dy != 0 ? dx == 0 && (dy == -1 || dy == 1) : dx == -1 || dx == 1) : "invalid segment in currently joined contour: " + lastX + "," + lastY + " -> " + x + "," + y + "; it was NOT CHECKED yet??";
            int disp = (dy < 0 ? y : lastY) * intersectionDimX + (dx < 0 ? x : lastX);
            int[] nArray = currentPositions = dy == 0 ? this.currentPositionsForXPlusSegments : this.currentPositionsForYPlusSegments;
            if (currentPositions[disp] != -1) {
                throw new IllegalArgumentException("One of the contours [#" + net.algart.arrays.Arrays.toString(this.currentIndexesOfJoinedContours, ", #", 500) + "] intersects itself, i.e. twice contains the segment " + (intersectionMinX + lastX) + "," + (intersectionMinY + lastY) + " - " + (intersectionMinX + x) + "," + (intersectionMinY + y) + "; such contours cannot be joined");
            }
            currentPositions[disp] = lastI;
        }
        return hasPointsInsideJoinedRectangle;
    }

    private boolean findPositionsOfJoinedContourAndCheckCodirectionalSegmentsWithCurrentContour() {
        JArrays.fillIntArray(this.joinedPositionsForXPlusSegments, 0, this.intersectionMatrixSize, -1);
        JArrays.fillIntArray(this.joinedPositionsForYPlusSegments, 0, this.intersectionMatrixSize, -1);
        boolean hasCommonPointsWithCurrentContour = false;
        int n = this.joinedLength;
        assert (n > 0);
        int intersectionMinX = this.intersectionMinX;
        int intersectionMinY = this.intersectionMinY;
        int intersectionDiffX = this.intersectionDiffX;
        int intersectionDiffY = this.intersectionDiffY;
        int intersectionDimX = this.intersectionDimX;
        int i = 0;
        while (i < n) {
            int[] joinedPositions;
            int distance;
            int x = this.joined[this.joinedOffset + i] - intersectionMinX;
            int y = this.joined[this.joinedOffset + i + 1] - intersectionMinY;
            if (x < 0 || x > intersectionDiffX) {
                int distanceY;
                distance = x < 0 ? -x : x - intersectionDiffX;
                int n2 = distanceY = y < 0 ? -y : y - intersectionDiffY;
                if (distanceY > 0) {
                    distance += distanceY;
                }
                i += distance << 1;
                continue;
            }
            if (y < 0 || y > intersectionDiffY) {
                distance = y < 0 ? -y : y - intersectionDiffY;
                i += distance << 1;
                continue;
            }
            int lastI = i == 0 ? n - 2 : i - 2;
            int lastX = this.joined[this.joinedOffset + lastI] - intersectionMinX;
            int lastY = this.joined[this.joinedOffset + lastI + 1] - intersectionMinY;
            i += 2;
            if (lastX < 0 || lastY < 0 || lastX > intersectionDiffX || lastY > intersectionDiffY) continue;
            int dx = x - lastX;
            int dy = y - lastY;
            assert (dy != 0 ? dx == 0 && (dy == -1 || dy == 1) : dx == -1 || dx == 1) : "invalid segment in unpacked contour: " + lastX + "," + lastY + " -> " + x + "," + y;
            int disp = (dy < 0 ? y : lastY) * intersectionDimX + (dx < 0 ? x : lastX);
            int[] nArray = joinedPositions = dy == 0 ? this.joinedPositionsForXPlusSegments : this.joinedPositionsForYPlusSegments;
            if (joinedPositions[disp] != -1) {
                throw new IllegalArgumentException("The contour #" + this.joinedIndex + " intersects itself, i.e. twice contains the segment " + (intersectionMinX + lastX) + "," + (intersectionMinY + lastY) + " - " + (intersectionMinX + x) + "," + (intersectionMinY + y) + "; such contours cannot be joined");
            }
            joinedPositions[disp] = lastI;
            int q = dy == 0 ? this.currentPositionsForXPlusSegments[disp] : this.currentPositionsForYPlusSegments[disp];
            if (q == -1) continue;
            int currentX = this.current[q] - intersectionMinX;
            int currentY = this.current[q + 1] - intersectionMinY;
            if (currentX == lastX && currentY == lastY) {
                return false;
            }
            assert (currentX == x && currentY == y) : "segments in current and joined contours do not match: " + lastX + "," + lastY + " -> " + x + "," + y + ", but " + currentX + "," + currentY;
            int nextQ = ContourJoiner.cyclicNextEven(q, this.currentLength);
            int currentNextX = this.current[nextQ] - intersectionMinX;
            int currentNextY = this.current[nextQ + 1] - intersectionMinY;
            assert (currentNextX == lastX && currentNextY == lastY) : "segments in current and joined contours do not match: " + lastX + "," + lastY + " -> " + x + "," + y + ", but " + currentNextX + "," + currentNextY;
            hasCommonPointsWithCurrentContour = true;
        }
        return hasCommonPointsWithCurrentContour;
    }

    private int positionOfMinX(int[] points, int offset, int numberOfPoints) {
        long t1 = this.nanoTime3();
        assert (numberOfPoints >= 1);
        int offsetOfMinX = offset;
        int minX = points[offset];
        int to = offset + 2 * numberOfPoints;
        for (int i = offset + 2; i < to; i += 2) {
            int x = points[i];
            if (x >= minX) continue;
            minX = x;
            offsetOfMinX = i;
        }
        long t2 = this.nanoTime3();
        this.tOffsetOfMinX += t2 - t1;
        return offsetOfMinX - offset;
    }

    private int positionAtJoined(int positionAtCurrent) {
        int q;
        int x = this.current[positionAtCurrent] - this.intersectionMinX;
        int y = this.current[positionAtCurrent + 1] - this.intersectionMinY;
        if (x < 0 || y < 0 || x >= this.intersectionDimX || y >= this.intersectionDimY) {
            return -1;
        }
        int nextPosition = ContourJoiner.cyclicNextEven(positionAtCurrent, this.currentLength);
        int nextX = this.current[nextPosition] - this.intersectionMinX;
        int nextY = this.current[nextPosition + 1] - this.intersectionMinY;
        if (nextX < 0 || nextY < 0 || nextX >= this.intersectionDimX || nextY >= this.intersectionDimY) {
            return -1;
        }
        int dx = nextX - x;
        int dy = nextY - y;
        assert (dy != 0 ? dx == 0 && (dy == -1 || dy == 1) : dx == -1 || dx == 1) : "invalid unpacked contour: dx = " + dx + ", dy = " + dy + " after the point #" + positionAtCurrent / 2 + "/" + this.currentLength / 2;
        int disp = (dy < 0 ? nextY : y) * this.intersectionDimX + (dx < 0 ? nextX : x);
        int n = q = dy == 0 ? this.joinedPositionsForXPlusSegments[disp] : this.joinedPositionsForYPlusSegments[disp];
        assert (q == -1 || (q & 1) == 0) : "odd value " + q + " is impossible in positions matrix";
        return q;
    }

    private int positionAtCurrent(int positionAtJoined) {
        int q;
        int x = this.joined[this.joinedOffset + positionAtJoined] - this.intersectionMinX;
        int y = this.joined[this.joinedOffset + positionAtJoined + 1] - this.intersectionMinY;
        if (x < 0 || y < 0 || x >= this.intersectionDimX || y >= this.intersectionDimY) {
            return -1;
        }
        int nextPosition = ContourJoiner.cyclicNextEven(positionAtJoined, this.joinedLength);
        int nextX = this.joined[this.joinedOffset + nextPosition] - this.intersectionMinX;
        int nextY = this.joined[this.joinedOffset + nextPosition + 1] - this.intersectionMinY;
        if (nextX < 0 || nextY < 0 || nextX >= this.intersectionDimX || nextY >= this.intersectionDimY) {
            return -1;
        }
        int dx = nextX - x;
        int dy = nextY - y;
        assert (dy != 0 ? dx == 0 && (dy == -1 || dy == 1) : dx == -1 || dx == 1) : "invalid unpacked contour: dx = " + dx + ", dy = " + dy + " after the point #" + positionAtJoined / 2 + "/" + this.joinedLength / 2;
        int disp = (dy < 0 ? nextY : y) * this.intersectionDimX + (dx < 0 ? nextX : x);
        int n = q = dy == 0 ? this.currentPositionsForXPlusSegments[disp] : this.currentPositionsForYPlusSegments[disp];
        assert (q == -1 || (q & 1) == 0) : "odd value " + q + " is impossible in positions matrix";
        return q;
    }

    private long nanoTime1() {
        return this.measureTimingLevel >= 1 ? System.nanoTime() : 0L;
    }

    private long nanoTime2() {
        return this.measureTimingLevel >= 2 ? System.nanoTime() : 0L;
    }

    private long nanoTime3() {
        return this.measureTimingLevel >= 3 ? System.nanoTime() : 0L;
    }

    private void correctQuickChecksStatistics(int checkedContoursCount) {
        this.sMinCheckedContoursCount = Math.min(this.sMinCheckedContoursCount, checkedContoursCount);
        this.sMaxCheckedContoursCount = Math.max(this.sMaxCheckedContoursCount, checkedContoursCount);
        this.sSumCheckedContoursCount += (long)checkedContoursCount;
        ++this.sNumberOfCheckedContoursLoops;
    }

    private void correctJoinedContoursStatistics() {
        int m = (int)this.currentIndexesOfJoinedContours.length();
        this.sMinJoinedContoursCount = Math.min(this.sMinJoinedContoursCount, m);
        this.sMaxJoinedContoursCount = Math.max(this.sMaxJoinedContoursCount, m);
        this.sSumJoinedContoursCount += (long)m;
        ++this.sNumberOfJoinedContours;
        m = this.numberOfDeferredContours();
        this.sMinDeferredContoursCount = Math.min(this.sMinDeferredContoursCount, m);
        this.sMaxDeferredContoursCount = Math.max(this.sMaxDeferredContoursCount, m);
        this.sSumDeferredContoursCount += (long)m;
        ++this.sNumberOfDeferredContoursChecks;
    }

    private String contoursInfo() {
        return "(The current contour is now a union of the following: [#" + net.algart.arrays.Arrays.toString(this.currentIndexesOfJoinedContours, ", #", 500) + "]; its points: " + JArrays.toString(JArrays.copyOfRange(this.current, 0, this.currentLength), ",", 2500) + "; points of joined: " + JArrays.toString(JArrays.copyOfRange(this.joined, 0, this.joinedLength), ",", 2500) + ".)";
    }

    private static int reindex(int objectLabel, int[] joinedLabelsMap, int defaultJoinedLabel) {
        if (objectLabel < 0) {
            throw new IllegalArgumentException("Objects in contours must be represented by zero or negative integers, but we have " + objectLabel);
        }
        if (joinedLabelsMap == null) {
            return defaultJoinedLabel;
        }
        if (objectLabel >= joinedLabelsMap.length) {
            return objectLabel;
        }
        int result = joinedLabelsMap[objectLabel];
        if (result < 0) {
            throw new IllegalArgumentException("Joined labels map must contain only non-negative elements, but it contains " + result);
        }
        return result;
    }

    private void ensureCapacityForUsage() {
        if (this.currentNumberOfPoints > this.currentUsage.length) {
            this.currentUsage = new boolean[Math.max(16, Math.max(this.currentNumberOfPoints, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.currentUsage.length))))];
        }
        if (this.joinedNumberOfPoints > this.joinedUsage.length) {
            this.joinedUsage = new boolean[Math.max(16, Math.max(this.joinedNumberOfPoints, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.joinedUsage.length))))];
        }
    }

    private void ensureCapacityForUnpackedClusterAndReallocate(long requiredLength) {
        if (requiredLength > (long)this.clusterContours.length) {
            if (requiredLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large contour array: > Integer.MAX_VALUE elements");
            }
            this.clusterContours = Arrays.copyOf(this.clusterContours, Math.max(16, Math.max((int)requiredLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.clusterContours.length)))));
        }
    }

    private void ensureCapacityForCompressedClusterAndReallocate(long requiredLength) {
        assert (this.compressedContoursBitMaps8x8.length == this.compressedContoursPositions.length);
        if (requiredLength > (long)this.compressedContoursPositions.length) {
            if (requiredLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large compressed positions array: > Integer.MAX_VALUE elements");
            }
            int newLength = Math.max(16, Math.max((int)requiredLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.compressedContoursPositions.length))));
            this.compressedContoursPositions = Arrays.copyOf(this.compressedContoursPositions, newLength);
            this.compressedContoursBitMaps8x8 = Arrays.copyOf(this.compressedContoursBitMaps8x8, newLength);
        }
    }

    private void ensureCapacityForCurrent(int requiredLength) {
        if (requiredLength > this.current.length) {
            this.current = new int[Math.max(16, Math.max(requiredLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.current.length))))];
        }
    }

    private void ensureCapacityForJoinResultContour(long requiredLength) {
        if (requiredLength > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large possible result of joining contours: 2 * " + requiredLength / 2L + " points >= 2^31");
        }
        if (requiredLength > (long)this.joinResult.length) {
            this.joinResult = new int[Math.max(16, Math.max((int)requiredLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.joinResult.length))))];
        }
    }

    private void ensureCapacityForPositionsMatrices(long requiredMatrixSize) {
        if (requiredMatrixSize > (long)this.currentPositionsForXPlusSegments.length) {
            if (requiredMatrixSize > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large intersection area: " + this.intersectionDimX + " x " + this.intersectionDimY + " >= 2^31 pixels, such contours cannot be joined (it occurred while attempt to join contour #" + this.joinedIndex + " with containing rectangle " + this.joinedMinX + ".." + this.joinedMaxX + " x " + this.joinedMinY + ".." + this.joinedMaxY + " to current contour, growing from #" + this.currentIndex + " and having now containing rectangle " + this.currentMinX + ".." + this.currentMaxX + " x " + this.currentMinY + ".." + this.currentMaxY + ")");
            }
            int newMatrixSize = Math.max(16, Math.max((int)requiredMatrixSize, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.currentPositionsForXPlusSegments.length))));
            this.currentPositionsForXPlusSegments = new int[newMatrixSize];
            this.currentPositionsForYPlusSegments = new int[newMatrixSize];
            this.joinedPositionsForXPlusSegments = new int[newMatrixSize];
            this.joinedPositionsForYPlusSegments = new int[newMatrixSize];
        }
    }

    private static int cyclicNextEven(int p, int length) {
        return (p += 2) == length ? 0 : p;
    }

    private static boolean cyclicLess(int start, int length, int a, int b) {
        assert (0 <= a && a < length) : "must be 0 <= " + a + " < " + length;
        assert (0 <= b && b < length) : "must be 0 <= " + b + " < " + length;
        assert (0 <= start && start < length) : "must be 0 <= " + start + " < " + length;
        if (a < start) {
            return b < start && a < b;
        }
        return b < start || a < b;
    }

    public static enum JoiningOrder {
        UNORDERED("unordered"){

            @Override
            void sortIndexes(ContourJoiner joiner, int[] indexes, int count) {
            }
        }
        ,
        NATURAL("natural"){

            @Override
            void sortIndexes(ContourJoiner joiner, int[] indexes, int count) {
                Arrays.parallelSort(indexes, 0, count);
            }
        }
        ,
        SMALL_FIRST("small-first"){

            @Override
            void sortIndexes(ContourJoiner joiner, int[] indexes, int count) {
                ArraySorter.getQuickSorter().sortIndexes(indexes, 0, count, (firstIndex, secondIndex) -> {
                    int diff1 = joiner.allMaxY[firstIndex] - joiner.allMinY[firstIndex];
                    int diff2 = joiner.allMaxY[secondIndex] - joiner.allMinY[secondIndex];
                    return diff1 < diff2 || diff1 == diff2 && firstIndex < secondIndex;
                });
            }
        }
        ,
        LARGE_FIRST("large-first"){

            @Override
            void sortIndexes(ContourJoiner joiner, int[] indexes, int count) {
                ArraySorter.getQuickSorter().sortIndexes(indexes, 0, count, (firstIndex, secondIndex) -> {
                    int diff1 = joiner.allMaxY[firstIndex] - joiner.allMinY[firstIndex];
                    int diff2 = joiner.allMaxY[secondIndex] - joiner.allMinY[secondIndex];
                    return diff1 > diff2 || diff1 == diff2 && firstIndex > secondIndex;
                });
            }
        };

        private final String prettyName;

        private JoiningOrder(String prettyName) {
            this.prettyName = prettyName;
        }

        abstract void sortIndexes(ContourJoiner var1, int[] var2, int var3);
    }

    private class CurrentOrJoinedContour {
        private final int iteration;
        CurrentOrJoinedSwitcher switcher = null;
        CurrentOrJoinedSwitcher other = null;
        int[] points = null;
        int offset = 0;
        int[] otherPoints = null;
        int otherOffset = 0;
        boolean[] usage = null;
        int length;
        int otherLength;

        private CurrentOrJoinedContour(int iteration) {
            assert (iteration >= 0);
            this.iteration = iteration;
        }

        void switchTo(CurrentOrJoinedSwitcher switcher) {
            this.switcher = switcher;
            if (switcher.isJoined()) {
                this.other = CurrentOrJoinedSwitcher.CURRENT;
                this.points = ContourJoiner.this.joined;
                this.offset = ContourJoiner.this.joinedOffset;
                this.otherPoints = ContourJoiner.this.current;
                this.otherOffset = 0;
                this.length = ContourJoiner.this.joinedLength;
                this.otherLength = ContourJoiner.this.currentLength;
                this.usage = ContourJoiner.this.joinedUsage;
            } else {
                this.other = CurrentOrJoinedSwitcher.JOINED;
                this.points = ContourJoiner.this.current;
                this.offset = 0;
                this.otherPoints = ContourJoiner.this.joined;
                this.otherOffset = ContourJoiner.this.joinedOffset;
                this.length = ContourJoiner.this.currentLength;
                this.otherLength = ContourJoiner.this.joinedLength;
                this.usage = ContourJoiner.this.currentUsage;
            }
        }

        int x(int p) {
            return this.points[this.offset + p];
        }

        int y(int p) {
            return this.points[this.offset + p + 1];
        }

        int otherX(int p) {
            return this.otherPoints[this.otherOffset + p];
        }

        int otherY(int p) {
            return this.otherPoints[this.otherOffset + p + 1];
        }

        boolean used(int p) {
            return this.usage[p >> 1];
        }

        void use(int p) {
            this.usage[p >> 1] = true;
        }

        void copyTo(int p, int[] result, int resultOffset, int length) {
            System.arraycopy(this.points, this.offset + p, result, resultOffset, length);
        }

        void switchToOther() {
            this.switchTo(this.other);
        }

        int initializeSwitchingAlgorithm() {
            int p;
            if ((long)ContourJoiner.this.currentNumberOfPoints + (long)ContourJoiner.this.joinedNumberOfPoints > 0x3FFFFEFFL) {
                throw new TooLargeArrayException("Too large contours: summary number of points in the joining result will be > 1073741567");
            }
            if (this.iteration == 0) {
                this.switchTo(CurrentOrJoinedSwitcher.CURRENT);
                p = ContourJoiner.this.positionOfMinX(ContourJoiner.this.current, 0, ContourJoiner.this.currentNumberOfPoints);
                int joinedMinXPosition = ContourJoiner.this.positionOfMinX(ContourJoiner.this.joined, ContourJoiner.this.joinedOffset, ContourJoiner.this.joinedNumberOfPoints);
                if (this.otherX(joinedMinXPosition) < this.x(p)) {
                    p = joinedMinXPosition;
                    this.switchToOther();
                }
                p = this.findSegmentBelongingToOnlyThisOneFromTwo(p);
                boolean bl = ContourJoiner.this.joinResultInternal = this.switcher.isJoined() ? ContourJoiner.this.joinedInternal : ContourJoiner.this.currentInternal;
                if (p == -1) {
                    assert (this.switcher.isCurrent()) : "Joined contour cannot be a subset of current, because its minX was < minX of the current contour";
                    this.switchToOther();
                    p = this.findSegmentBelongingToOnlyThisOneFromTwo(0);
                }
            } else {
                this.switchTo(CurrentOrJoinedSwitcher.JOINED);
                p = this.findUnusedSegmentBelongingToOnlyThisOneFromTwo();
                if (p == -1) {
                    this.switchToOther();
                    p = this.findUnusedSegmentBelongingToOnlyThisOneFromTwo();
                }
                ContourJoiner.this.joinResultInternal = !ContourJoiner.this.joinedInternal;
            }
            return p;
        }

        private int findSegmentBelongingToOnlyThisOneFromTwo(int startPosition) {
            long t1 = ContourJoiner.this.nanoTime3();
            int p = startPosition;
            int result = -1;
            int n = this.length;
            for (int count = 0; count < n; count += 2) {
                if (this.other.positionAtContour(p, ContourJoiner.this) == -1) {
                    result = p;
                    break;
                }
                if ((p += 2) != n) continue;
                p = 0;
            }
            long t2 = ContourJoiner.this.nanoTime3();
            ContourJoiner.this.tFindFreeSegment += t2 - t1;
            return result;
        }

        private int findUnusedSegmentBelongingToOnlyThisOneFromTwo() {
            long t1 = ContourJoiner.this.nanoTime3();
            int p = 0;
            int result = -1;
            int n = this.length;
            for (int count = 0; count < n; count += 2) {
                boolean used = this.usage[p >> 1];
                if (!used && this.other.positionAtContour(p, ContourJoiner.this) == -1) {
                    result = p;
                    break;
                }
                if ((p += 2) != n) continue;
                p = 0;
            }
            long t2 = ContourJoiner.this.nanoTime3();
            ContourJoiner.this.tFindFreeUnusedSegment += t2 - t1;
            return result;
        }

        private int cyclicNextEven(int p) {
            return (p += 2) == this.length ? 0 : p;
        }

        private int cyclicNextEvenAtOther(int p) {
            return (p += 2) == this.otherLength ? 0 : p;
        }

        private void checkReturningBackAfterSwitchOrJump(int p, int[] twoStartPositions, int[] twoLastPositions) {
            int oneFromTwoStartPosition = twoStartPositions[this.switcher.index];
            if (oneFromTwoStartPosition == -1) {
                twoStartPositions[this.switcher.index] = p;
            } else {
                int lastPosition = twoLastPositions[this.switcher.index];
                if (lastPosition == -1) {
                    throw new AssertionError((Object)"Last position was not initialize yet!");
                }
                if (ContourJoiner.cyclicLess(oneFromTwoStartPosition, this.length, p, lastPosition)) {
                    throw new AssertionError((Object)("Returning back: cannot join to the current contour #" + ContourJoiner.this.currentIndex + " (0-based numbering, label #" + ContourJoiner.this.currentLabel + ", " + ContourJoiner.this.currentNumberOfPoints + " segments) a new joined contour #" + ContourJoiner.this.joinedIndex + " (label #" + ContourJoiner.this.joinedLabel() + ", " + ContourJoiner.this.joinedNumberOfPoints + " segments), because " + this.other.name + " contour returned back to an earlier point #" + p / 2 + "/" + this.length / 2 + " [x=" + this.points[p] + ",y=" + this.points[p + 1] + "] at " + this.switcher.name + " contour (it is before the last point at this contour #" + lastPosition / 2 + "/" + this.length / 2 + " [x=" + this.points[lastPosition] + ",y=" + this.points[lastPosition + 1] + "], and we started scanning it from point #" + oneFromTwoStartPosition / 2 + "/" + this.length / 2 + " [x=" + this.points[oneFromTwoStartPosition] + ",y=" + this.points[oneFromTwoStartPosition + 1] + "]). It is possible if some of contours are self-intersecting; such contours cannot be joined. " + ContourJoiner.this.contoursInfo()));
                }
            }
        }

        private void debugPrintStarting(int p) {
            System.out.printf("[%d, %d deferred] Starting joining %d (%d, internal=%s, %d points) to %d (%d, internal=%s, %d points): #%d in %s%n", new Object[]{this.iteration, ContourJoiner.this.deferredContours.numberOfContours(), ContourJoiner.this.joinedIndex, ContourJoiner.this.joinedLabel(), ContourJoiner.this.joinedInternal, ContourJoiner.this.joinedNumberOfPoints, ContourJoiner.this.currentIndex, ContourJoiner.this.currentLabel, ContourJoiner.this.currentInternal, ContourJoiner.this.currentNumberOfPoints, p / 2, this.switcher});
        }

        private void debugPrintSkipping(int p, int previousX, int previousY, int distance) {
            System.out.printf("[%d] Joining %d (%d, %d points) to %d (%d, %d points): #%d in %s, skipping %d: %d,%d -> %d,%d (%s)%n", new Object[]{this.iteration, ContourJoiner.this.joinedIndex, ContourJoiner.this.joinedLabel(), ContourJoiner.this.joinedNumberOfPoints, ContourJoiner.this.currentIndex, ContourJoiner.this.currentLabel, ContourJoiner.this.currentNumberOfPoints, p / 2, this.switcher, distance, previousX, previousY, this.points[p % this.length], this.points[(p + 1) % this.length], net.algart.arrays.Arrays.toString(ContourJoiner.this.currentIndexesOfJoinedContours, ",", 200)});
        }

        private void debugPrintPoint(int p) {
            System.out.printf("[%d] Joining %d (%d, %d points) to %d (%d, %d points): #%d in %s, %d,%d -> %d,%d (%s)%n", new Object[]{this.iteration, ContourJoiner.this.joinedIndex, ContourJoiner.this.joinedLabel(), ContourJoiner.this.joinedNumberOfPoints, ContourJoiner.this.currentIndex, ContourJoiner.this.currentLabel, ContourJoiner.this.currentNumberOfPoints, p / 2, this.switcher, this.points[p], this.points[p + 1], this.points[(p + 2) % this.length], this.points[(p + 3) % this.length], net.algart.arrays.Arrays.toString(ContourJoiner.this.currentIndexesOfJoinedContours, ",", 200)});
        }

        private void debugPrintJump(int p) {
            System.out.printf("  JUMPING in %s: point #%d%n", new Object[]{this.switcher, p / 2});
        }

        private void debugPrintSwitching(int p) {
            System.out.printf("  SWITCHING to %s: point #%d: %d,%d%n", new Object[]{this.switcher, p / 2, this.points[p], this.points[p + 1]});
        }
    }

    private static enum CurrentOrJoinedSwitcher {
        CURRENT(0, "current"){

            @Override
            int positionAtContour(int p, ContourJoiner joiner) {
                return joiner.positionAtCurrent(p);
            }

            @Override
            boolean isCurrent() {
                return true;
            }

            @Override
            boolean isJoined() {
                return false;
            }
        }
        ,
        JOINED(1, "joined"){

            @Override
            int positionAtContour(int p, ContourJoiner joiner) {
                return joiner.positionAtJoined(p);
            }

            @Override
            boolean isCurrent() {
                return false;
            }

            @Override
            boolean isJoined() {
                return true;
            }
        };

        final int index;
        final String name;

        private CurrentOrJoinedSwitcher(int index, String name) {
            this.index = index;
            this.name = name;
        }

        abstract boolean isCurrent();

        abstract boolean isJoined();

        abstract int positionAtContour(int var1, ContourJoiner var2);
    }
}

