/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Locale;
import java.util.Objects;
import net.algart.contexts.Context;
import net.algart.contexts.ProgressUpdater;

public class SubtaskContext
implements Context {
    private final Context parentContext;
    private final double fromPart;
    private final double toPart;

    public SubtaskContext(Context parentContext, double fromPart, double toPart) {
        Objects.requireNonNull(parentContext, "Null parentContext argument");
        if (fromPart < 0.0) {
            throw new IllegalArgumentException("Illegal fromPart=" + fromPart + " (must be in range 0.0..1.0)");
        }
        if (toPart > 1.0) {
            throw new IllegalArgumentException("Illegal toPart=" + toPart + " (must be in range 0.0..1.0)");
        }
        if (fromPart > toPart) {
            throw new IllegalArgumentException("Illegal fromPart=" + fromPart + " or toPart=" + toPart + " (fromPart must not be greater than toPart)");
        }
        this.parentContext = parentContext;
        this.fromPart = fromPart;
        this.toPart = toPart;
    }

    public SubtaskContext(Context parentContext, long from, long to, long total) {
        Objects.requireNonNull(parentContext, "Null parentContext argument");
        if (total < 0L) {
            throw new IllegalArgumentException("Negative total=" + total);
        }
        if (from < 0L) {
            throw new IllegalArgumentException("Illegal from=" + from + " (must be in range 0.." + total + ")");
        }
        if (to > total) {
            throw new IllegalArgumentException("Illegal to=" + to + " (must be in range 0.." + total + ")");
        }
        if (from > to) {
            throw new IllegalArgumentException("Illegal from=" + from + " or to=" + to + " (\"from\" must not be greater than \"to\")");
        }
        this.parentContext = parentContext;
        if (total == 0L) {
            assert (from == 0L);
            assert (to == 0L);
            this.fromPart = 0.0;
            this.toPart = 1.0;
        } else {
            this.fromPart = (double)from / (double)total;
            this.toPart = to == total ? 1.0 : (double)to / (double)total;
        }
    }

    @Override
    public final <T extends Context> T as(Class<T> contextClass) {
        T castedParentContext = this.parentContext.as(contextClass);
        if (contextClass == ProgressUpdater.class) {
            return (T)((Context)contextClass.cast(new ProgressUpdaterSubtaskContext((ProgressUpdater)castedParentContext)));
        }
        return (T)((Context)contextClass.cast(Proxy.newProxyInstance(castedParentContext.getClass().getClassLoader(), new Class[]{contextClass}, (InvocationHandler)new SubtaskInvocationHandler((Context)castedParentContext))));
    }

    @Override
    public final boolean is(Class<? extends Context> contextClass) {
        return this.parentContext.is(contextClass);
    }

    public String toString() {
        return String.format(Locale.US, "subtask context %.3f..%.3f of %s", this.fromPart, this.toPart, this.parentContext);
    }

    private class ProgressUpdaterSubtaskContext
    implements ProgressUpdater {
        private final ProgressUpdater parentProgressUpdater;

        private ProgressUpdaterSubtaskContext(ProgressUpdater parentProgressUpdater) {
            this.parentProgressUpdater = SubtaskContext.this.parentContext.as(ProgressUpdater.class);
        }

        @Override
        public final <T extends Context> T as(Class<T> contextClass) {
            if (contextClass == ProgressUpdater.class) {
                return (T)((Context)contextClass.cast(this));
            }
            return SubtaskContext.this.as(contextClass);
        }

        @Override
        public final boolean is(Class<? extends Context> contextClass) {
            return SubtaskContext.this.is(contextClass);
        }

        @Override
        public void updateProgress(double readyPart, boolean force) {
            this.parentProgressUpdater.updateProgress(SubtaskContext.this.fromPart + readyPart * (SubtaskContext.this.toPart - SubtaskContext.this.fromPart), force);
        }

        public String toString() {
            return String.format(Locale.US, "subtask progress updater %.3f..%.3f of %s", SubtaskContext.this.fromPart, SubtaskContext.this.toPart, SubtaskContext.this.parentContext);
        }
    }

    private class SubtaskInvocationHandler
    implements InvocationHandler {
        private final Context castedParentContext;

        private SubtaskInvocationHandler(Context castedParentContext) {
            this.castedParentContext = castedParentContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (name.equals("as") && parameterTypes.length == 1 && parameterTypes[0] == Class.class) {
                return SubtaskContext.this.as((Class)args[0]);
            }
            try {
                return method.invoke((Object)this.castedParentContext, args);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError("Internal error in " + String.valueOf(SubtaskContext.class), e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

