/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Arrays;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;

public class PackedBitArrays {
    private PackedBitArrays() {
    }

    public static long unpackedLength(long numberOfLongs) {
        if (numberOfLongs < 0L) {
            throw new IllegalArgumentException("Negative packed length");
        }
        if (numberOfLongs >= 0x200000000000000L) {
            throw new TooLargeArrayException("Too large packed length: number of unpacked bits >= 2^63");
        }
        return numberOfLongs << 6;
    }

    public static long unpackedLength(long[] array) {
        return (long)array.length << 6;
    }

    public static long packedLength(long numberOfBits) {
        if (numberOfBits < 0L) {
            throw new IllegalArgumentException("Negative unpacked length");
        }
        return numberOfBits + 63L >>> 6;
    }

    public static int packedLength32(long numberOfBits) {
        if (numberOfBits < 0L) {
            throw new IllegalArgumentException("Negative unpacked length");
        }
        long result = numberOfBits + 63L >>> 6;
        if (result > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of bits " + numberOfBits + ": number of packed longs " + result + " >= 2^31");
        }
        return (int)result;
    }

    public static int packedLength32(int numberOfBits) {
        if (numberOfBits < 0) {
            throw new IllegalArgumentException("Negative unpacked length");
        }
        return numberOfBits + 63 >>> 6;
    }

    public static boolean getBit(long[] src, long index) {
        return (src[(int)(index >>> 6)] & 1L << (int)(index & 0x3FL)) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBit(long[] dest, long index, boolean value) {
        long[] lArray = dest;
        synchronized (dest) {
            if (value) {
                int n = (int)(index >>> 6);
                dest[n] = dest[n] | 1L << (int)(index & 0x3FL);
            } else {
                int n = (int)(index >>> 6);
                dest[n] = dest[n] & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public static void setBitNoSync(long[] dest, long index, boolean value) {
        if (value) {
            int n = (int)(index >>> 6);
            dest[n] = dest[n] | 1L << (int)(index & 0x3FL);
        } else {
            int n = (int)(index >>> 6);
            dest[n] = dest[n] & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static long getBits64(long[] src, long srcPos, int count) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IndexOutOfBoundsException("Negative srcPos argument: " + srcPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
        }
        return PackedBitArrays.getBits64Impl(src, srcPos, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBits64(long[] dest, long destPos, long bits, int count) {
        Objects.requireNonNull(dest, "Null dest");
        if (destPos < 0L) {
            throw new IndexOutOfBoundsException("Negative destPos argument: " + destPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64 method");
        }
        long[] lArray = dest;
        synchronized (dest) {
            PackedBitArrays.setBits64Impl(dest, destPos, bits, count);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    public static void setBits64NoSync(long[] dest, long destPos, long bits, int count) {
        Objects.requireNonNull(dest, "Null dest");
        if (destPos < 0L) {
            throw new IndexOutOfBoundsException("Negative destPos argument: " + destPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64NoSync method");
        }
        PackedBitArrays.setBits64Impl(dest, destPos, bits, count);
    }

    public static int bitHashCode(long[] array, long fromIndex, long toIndex) {
        CRC32 sum = new CRC32();
        PackedBitArrays.updateBitHashCode(array, fromIndex, toIndex, sum);
        return fromIndex == toIndex ? 0 : (int)sum.getValue();
    }

    public static void updateBitHashCode(long[] array, long fromIndex, long toIndex, Checksum hash) {
        Objects.requireNonNull(hash, "Null hash argument");
        if (fromIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (array == null) {
            if (toIndex > 0L) {
                throw new ArrayIndexOutOfBoundsException("Bit array index out of range for null array: end index = " + toIndex);
            }
        } else if (toIndex > (long)array.length << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: end index = " + toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        boolean[] bits = new boolean[4096];
        for (long pos = fromIndex; pos < toIndex; pos += (long)bits.length) {
            int len = (int)Math.min((long)bits.length, toIndex - pos);
            PackedBitArrays.unpackBits(bits, 0, array, pos, len);
            JArrays.updateArrayHashCode(bits, 0, len, hash);
        }
    }

    public static boolean bitEquals(long[] array1, long pos1, long[] array2, long pos2, long length) {
        long length2;
        long length1 = array1 == null ? 0L : (long)array1.length << 6;
        long l = length2 = array2 == null ? 0L : (long)array2.length << 6;
        if (pos1 < 0L) {
            throw new ArrayIndexOutOfBoundsException("Negative bit array initial index: pos1 = " + pos1);
        }
        if (pos2 < 0L) {
            throw new ArrayIndexOutOfBoundsException("Negative bit array initial index: pos2 = " + pos2);
        }
        if (length < 0L) {
            throw new ArrayIndexOutOfBoundsException("Negative number of compared elements: length = " + length);
        }
        if (pos1 + length > length1) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: pos1 + length = " + (pos1 + length));
        }
        if (pos2 + length > length2) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: pos2 + length = " + (pos2 + length));
        }
        if (array1 == array2) {
            return array1 == null || pos1 == pos2;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (length == 0L) {
            return true;
        }
        if ((pos1 & 0x3FL) == (pos2 & 0x3FL)) {
            int first1 = (int)(pos1 >>> 6);
            int first2 = (int)(pos2 >>> 6);
            int last1 = (int)(pos1 + length - 1L >>> 6);
            int last2 = (int)(pos2 + length - 1L >>> 6);
            if (first1 == last1) {
                long mask = -(1L << (int)(pos1 & 0x3FL));
                int ofs = (int)(pos1 + length & 0x3FL);
                if (ofs != 0) {
                    mask &= (1L << ofs) - 1L;
                }
                return (array1[first1] & mask) == (array2[first2] & mask);
            }
            if ((pos1 & 0x3FL) != 0L) {
                long fromMask = -(1L << (int)(pos1 & 0x3FL));
                if ((array1[first1] & fromMask) != (array2[first2] & fromMask)) {
                    return false;
                }
                ++first1;
                ++first2;
            }
            if ((pos1 + length & 0x3FL) != 0L) {
                long toMask = (1L << (int)(pos1 + length & 0x3FL)) - 1L;
                if ((array1[last1] & toMask) != (array2[last2] & toMask)) {
                    return false;
                }
                --last1;
            }
            if (first1 <= last1) {
                return JArrays.arrayEquals(array1, first1, array2, first2, last1 - first1 + 1);
            }
            return true;
        }
        long pos1Max = pos1 + length;
        while (pos1 < pos1Max) {
            if ((array1[(int)(pos1 >>> 6)] >>> (int)(pos1 & 0x3FL) & 1L) != (array2[(int)(pos2 >>> 6)] >>> (int)(pos2 & 0x3FL) & 1L)) {
                return false;
            }
            ++pos1;
            ++pos2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void copyBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (src == dest && srcPos <= destPos && srcPos + count > destPos) {
            long sPrev;
            if (sPosRem == dPosRem) {
                if (sPos == dPos) {
                    return;
                }
                int sPosStart = sPos++;
                int dPosStart = dPos++;
                if (cntStart > 0) {
                    count -= (long)cntStart;
                }
                int cnt = (int)(count >>> 6);
                int cntFinish = (int)(count & 0x3FL);
                if (cntFinish > 0) {
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos + cnt] = src[sPos + cnt] & maskFinish | dest[dPos + cnt] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                }
                System.arraycopy(src, sPos, dest, dPos, cnt);
                if (cntStart <= 0) return;
                long[] maskFinish = dest;
                // MONITORENTER : dest
                dest[dPosStart] = src[sPosStart] & maskStart | dest[dPosStart] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : maskFinish
                return;
            }
            int shift = dPosRem - sPosRem;
            int sPosStart = sPos++;
            int dPosStart = dPos;
            int sPosRemStart = sPosRem;
            if (cntStart > 0) {
                sPosRem = sPosRem + cntStart <= 64 ? (sPosRem += cntStart) : sPosRem + cntStart & 0x3F;
                count -= (long)cntStart;
                ++dPos;
            }
            int cnt2 = (int)(count >>> 6);
            long dPosMin = dPos;
            sPos += cnt2;
            dPos += cnt2;
            int cntFinish = (int)(count & 0x3FL);
            int sPosRem64 = 64 - sPosRem;
            if (cntFinish > 0) {
                long v;
                long maskFinish = (1L << cntFinish) - 1L;
                if (sPosRem + cntFinish <= 64) {
                    sPrev = src[sPos];
                    v = sPrev >>> sPosRem;
                } else {
                    sPrev = src[sPos];
                    v = sPrev >>> sPosRem | src[sPos + 1] << sPosRem64;
                }
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = v & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
            } else {
                sPrev = src[sPos];
            }
            while ((long)dPos > dPosMin) {
                long l = sPrev << sPosRem64;
                sPrev = src[--sPos];
                dest[--dPos] = l | sPrev >>> sPosRem;
            }
            if (cntStart <= 0) return;
            long v = sPosRemStart + cntStart <= 64 ? (shift > 0 ? src[sPosStart] << shift : src[sPosStart] >>> -shift) : src[sPosStart] >>> -shift | src[sPosStart + 1] << 64 + shift;
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPosStart] = v & maskStart | dest[dPosStart] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            return;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] shift = dest;
                // MONITORENTER : dest
                dest[dPos] = src[sPos] & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : shift
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int cnt = (int)(count >>> 6);
            System.arraycopy(src, sPos, dest, dPos, cnt);
            sPos += cnt;
            dPos += cnt;
            int cntFinish = (int)(count & 0x3FL);
            if (cntFinish <= 0) return;
            long maskFinish = (1L << cntFinish) - 1L;
            long[] cnt2 = dest;
            // MONITORENTER : dest
            dest[dPos] = src[sPos] & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : cnt2
            return;
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] dPosMin = dest;
            // MONITORENTER : dest
            dest[dPos] = v & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : dPosMin
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[dPos] = l | sNext << sPosRem64;
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = v & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    public static void copyBitsNoSync(long[] dest, long destPos, long[] src, long srcPos, long count) {
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (src == dest && srcPos <= destPos && srcPos + count > destPos) {
            if (sPosRem == dPosRem) {
                if (sPos == dPos) {
                    return;
                }
                int sPosStart = sPos++;
                int dPosStart = dPos++;
                if (cntStart > 0) {
                    count -= (long)cntStart;
                }
                int cnt = (int)(count >>> 6);
                int cntFinish = (int)(count & 0x3FL);
                if (cntFinish > 0) {
                    long maskFinish = (1L << cntFinish) - 1L;
                    dest[dPos + cnt] = src[sPos + cnt] & maskFinish | dest[dPos + cnt] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                }
                System.arraycopy(src, sPos, dest, dPos, cnt);
                if (cntStart > 0) {
                    dest[dPosStart] = src[sPosStart] & maskStart | dest[dPosStart] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                long sPrev;
                int shift = dPosRem - sPosRem;
                int sPosStart = sPos++;
                int dPosStart = dPos;
                int sPosRemStart = sPosRem;
                if (cntStart > 0) {
                    sPosRem = sPosRem + cntStart <= 64 ? (sPosRem += cntStart) : sPosRem + cntStart & 0x3F;
                    count -= (long)cntStart;
                    ++dPos;
                }
                int cnt = (int)(count >>> 6);
                long dPosMin = dPos;
                sPos += cnt;
                dPos += cnt;
                int cntFinish = (int)(count & 0x3FL);
                int sPosRem64 = 64 - sPosRem;
                if (cntFinish > 0) {
                    long v;
                    long maskFinish = (1L << cntFinish) - 1L;
                    if (sPosRem + cntFinish <= 64) {
                        sPrev = src[sPos];
                        v = sPrev >>> sPosRem;
                    } else {
                        sPrev = src[sPos];
                        v = sPrev >>> sPosRem | src[sPos + 1] << sPosRem64;
                    }
                    dest[dPos] = v & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    sPrev = src[sPos];
                }
                while ((long)dPos > dPosMin) {
                    long l = sPrev << sPosRem64;
                    sPrev = src[--sPos];
                    dest[--dPos] = l | sPrev >>> sPosRem;
                }
                if (cntStart > 0) {
                    long v = sPosRemStart + cntStart <= 64 ? (shift > 0 ? src[sPosStart] << shift : src[sPosStart] >>> -shift) : src[sPosStart] >>> -shift | src[sPosStart + 1] << 64 + shift;
                    dest[dPosStart] = v & maskStart | dest[dPosStart] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
        } else if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                dest[dPos] = src[sPos] & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int cnt = (int)(count >>> 6);
            System.arraycopy(src, sPos, dest, dPos, cnt);
            sPos += cnt;
            dPos += cnt;
            int cntFinish = (int)(count & 0x3FL);
            if (cntFinish > 0) {
                long maskFinish = (1L << cntFinish) - 1L;
                dest[dPos] = src[sPos] & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            long sNext;
            int shift = dPosRem - sPosRem;
            if (cntStart > 0) {
                long v;
                if (sPosRem + cntStart <= 64) {
                    if (shift > 0) {
                        sNext = src[sPos];
                        v = sNext << shift;
                    } else {
                        sNext = src[sPos];
                        v = sNext >>> -shift;
                    }
                    sPosRem += cntStart;
                } else {
                    sNext = src[sPos + 1];
                    v = src[sPos] >>> -shift | sNext << 64 + shift;
                    ++sPos;
                    sPosRem = sPosRem + cntStart & 0x3F;
                }
                dest[dPos] = v & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                if ((count -= (long)cntStart) == 0L) {
                    return;
                }
                ++dPos;
            } else {
                if (count == 0L) {
                    return;
                }
                sNext = src[sPos];
            }
            int sPosRem64 = 64 - sPosRem;
            int dPosMax = dPos + (int)(count >>> 6);
            while (dPos < dPosMax) {
                long l = sNext >>> sPosRem;
                sNext = src[++sPos];
                dest[dPos] = l | sNext << sPosRem64;
                ++dPos;
            }
            int cntFinish = (int)(count & 0x3FL);
            if (cntFinish > 0) {
                long maskFinish = (1L << cntFinish) - 1L;
                long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
                dest[dPos] = v & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public static long[] packBits(boolean[] src, long srcPos, long count) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (srcPos > (long)src.length) {
            throw new IllegalArgumentException("The source position " + srcPos + " is out of the array boolean[" + src.length + "]");
        }
        if (count > (long)src.length - srcPos) {
            throw new IllegalArgumentException("Too short source array boolean[" + src.length + "]: it does not contain " + count + " bits since position " + srcPos);
        }
        assert (count == (long)((int)count));
        long[] dest = new long[(int)PackedBitArrays.packedLength(count)];
        int sPos = (int)srcPos;
        int cnt = (int)count >>> 6;
        for (int k = 0; k < cnt; ++k) {
            int low = (src[sPos] ? 1 : 0) | (src[sPos + 1] ? 2 : 0) | (src[sPos + 2] ? 4 : 0) | (src[sPos + 3] ? 8 : 0) | (src[sPos + 4] ? 16 : 0) | (src[sPos + 5] ? 32 : 0) | (src[sPos + 6] ? 64 : 0) | (src[sPos + 7] ? 128 : 0) | (src[sPos + 8] ? 256 : 0) | (src[sPos + 9] ? 512 : 0) | (src[sPos + 10] ? 1024 : 0) | (src[sPos + 11] ? 2048 : 0) | (src[sPos + 12] ? 4096 : 0) | (src[sPos + 13] ? 8192 : 0) | (src[sPos + 14] ? 16384 : 0) | (src[sPos + 15] ? 32768 : 0) | (src[sPos + 16] ? 65536 : 0) | (src[sPos + 17] ? 131072 : 0) | (src[sPos + 18] ? 262144 : 0) | (src[sPos + 19] ? 524288 : 0) | (src[sPos + 20] ? 0x100000 : 0) | (src[sPos + 21] ? 0x200000 : 0) | (src[sPos + 22] ? 0x400000 : 0) | (src[sPos + 23] ? 0x800000 : 0) | (src[sPos + 24] ? 0x1000000 : 0) | (src[sPos + 25] ? 0x2000000 : 0) | (src[sPos + 26] ? 0x4000000 : 0) | (src[sPos + 27] ? 0x8000000 : 0) | (src[sPos + 28] ? 0x10000000 : 0) | (src[sPos + 29] ? 0x20000000 : 0) | (src[sPos + 30] ? 0x40000000 : 0) | (src[sPos + 31] ? Integer.MIN_VALUE : 0);
            int high = (src[sPos += 32] ? 1 : 0) | (src[sPos + 1] ? 2 : 0) | (src[sPos + 2] ? 4 : 0) | (src[sPos + 3] ? 8 : 0) | (src[sPos + 4] ? 16 : 0) | (src[sPos + 5] ? 32 : 0) | (src[sPos + 6] ? 64 : 0) | (src[sPos + 7] ? 128 : 0) | (src[sPos + 8] ? 256 : 0) | (src[sPos + 9] ? 512 : 0) | (src[sPos + 10] ? 1024 : 0) | (src[sPos + 11] ? 2048 : 0) | (src[sPos + 12] ? 4096 : 0) | (src[sPos + 13] ? 8192 : 0) | (src[sPos + 14] ? 16384 : 0) | (src[sPos + 15] ? 32768 : 0) | (src[sPos + 16] ? 65536 : 0) | (src[sPos + 17] ? 131072 : 0) | (src[sPos + 18] ? 262144 : 0) | (src[sPos + 19] ? 524288 : 0) | (src[sPos + 20] ? 0x100000 : 0) | (src[sPos + 21] ? 0x200000 : 0) | (src[sPos + 22] ? 0x400000 : 0) | (src[sPos + 23] ? 0x800000 : 0) | (src[sPos + 24] ? 0x1000000 : 0) | (src[sPos + 25] ? 0x2000000 : 0) | (src[sPos + 26] ? 0x4000000 : 0) | (src[sPos + 27] ? 0x8000000 : 0) | (src[sPos + 28] ? 0x10000000 : 0) | (src[sPos + 29] ? 0x20000000 : 0) | (src[sPos + 30] ? 0x40000000 : 0) | (src[sPos + 31] ? Integer.MIN_VALUE : 0);
            sPos += 32;
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = (int)count & 0x3F;
        for (int k = 0; k < countFinish; ++k) {
            if (src[sPos]) {
                int n = cnt;
                dest[n] = dest[n] | 1L << k;
            } else {
                int n = cnt;
                dest[n] = dest[n] & (1L << k ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++sPos;
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBits(long[] dest, long destPos, boolean[] src, int srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos]) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos]) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsInverted(long[] dest, long destPos, boolean[] src, int srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos]) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] | 1L << (int)(destPos & 0x3FL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] ? 0 : 1) | (src[srcPos + 1] ? 0 : 2) | (src[srcPos + 2] ? 0 : 4) | (src[srcPos + 3] ? 0 : 8) | (src[srcPos + 4] ? 0 : 16) | (src[srcPos + 5] ? 0 : 32) | (src[srcPos + 6] ? 0 : 64) | (src[srcPos + 7] ? 0 : 128) | (src[srcPos + 8] ? 0 : 256) | (src[srcPos + 9] ? 0 : 512) | (src[srcPos + 10] ? 0 : 1024) | (src[srcPos + 11] ? 0 : 2048) | (src[srcPos + 12] ? 0 : 4096) | (src[srcPos + 13] ? 0 : 8192) | (src[srcPos + 14] ? 0 : 16384) | (src[srcPos + 15] ? 0 : 32768) | (src[srcPos + 16] ? 0 : 65536) | (src[srcPos + 17] ? 0 : 131072) | (src[srcPos + 18] ? 0 : 262144) | (src[srcPos + 19] ? 0 : 524288) | (src[srcPos + 20] ? 0 : 0x100000) | (src[srcPos + 21] ? 0 : 0x200000) | (src[srcPos + 22] ? 0 : 0x400000) | (src[srcPos + 23] ? 0 : 0x800000) | (src[srcPos + 24] ? 0 : 0x1000000) | (src[srcPos + 25] ? 0 : 0x2000000) | (src[srcPos + 26] ? 0 : 0x4000000) | (src[srcPos + 27] ? 0 : 0x8000000) | (src[srcPos + 28] ? 0 : 0x10000000) | (src[srcPos + 29] ? 0 : 0x20000000) | (src[srcPos + 30] ? 0 : 0x40000000) | (src[srcPos + 31] ? 0 : Integer.MIN_VALUE);
            int high = (src[srcPos += 32] ? 0 : 1) | (src[srcPos + 1] ? 0 : 2) | (src[srcPos + 2] ? 0 : 4) | (src[srcPos + 3] ? 0 : 8) | (src[srcPos + 4] ? 0 : 16) | (src[srcPos + 5] ? 0 : 32) | (src[srcPos + 6] ? 0 : 64) | (src[srcPos + 7] ? 0 : 128) | (src[srcPos + 8] ? 0 : 256) | (src[srcPos + 9] ? 0 : 512) | (src[srcPos + 10] ? 0 : 1024) | (src[srcPos + 11] ? 0 : 2048) | (src[srcPos + 12] ? 0 : 4096) | (src[srcPos + 13] ? 0 : 8192) | (src[srcPos + 14] ? 0 : 16384) | (src[srcPos + 15] ? 0 : 32768) | (src[srcPos + 16] ? 0 : 65536) | (src[srcPos + 17] ? 0 : 131072) | (src[srcPos + 18] ? 0 : 262144) | (src[srcPos + 19] ? 0 : 524288) | (src[srcPos + 20] ? 0 : 0x100000) | (src[srcPos + 21] ? 0 : 0x200000) | (src[srcPos + 22] ? 0 : 0x400000) | (src[srcPos + 23] ? 0 : 0x800000) | (src[srcPos + 24] ? 0 : 0x1000000) | (src[srcPos + 25] ? 0 : 0x2000000) | (src[srcPos + 26] ? 0 : 0x4000000) | (src[srcPos + 27] ? 0 : 0x8000000) | (src[srcPos + 28] ? 0 : 0x10000000) | (src[srcPos + 29] ? 0 : 0x20000000) | (src[srcPos + 30] ? 0 : 0x40000000) | (src[srcPos + 31] ? 0 : Integer.MIN_VALUE);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos]) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] | 1L << (int)(destPos & 0x3FL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void packBitsNoSync(long[] dest, long destPos, boolean[] src, int srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos]) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; ++k) {
            int low = (src[srcPos] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] ? 1 : 0) | (src[srcPos + 1] ? 2 : 0) | (src[srcPos + 2] ? 4 : 0) | (src[srcPos + 3] ? 8 : 0) | (src[srcPos + 4] ? 16 : 0) | (src[srcPos + 5] ? 32 : 0) | (src[srcPos + 6] ? 64 : 0) | (src[srcPos + 7] ? 128 : 0) | (src[srcPos + 8] ? 256 : 0) | (src[srcPos + 9] ? 512 : 0) | (src[srcPos + 10] ? 1024 : 0) | (src[srcPos + 11] ? 2048 : 0) | (src[srcPos + 12] ? 4096 : 0) | (src[srcPos + 13] ? 8192 : 0) | (src[srcPos + 14] ? 16384 : 0) | (src[srcPos + 15] ? 32768 : 0) | (src[srcPos + 16] ? 65536 : 0) | (src[srcPos + 17] ? 131072 : 0) | (src[srcPos + 18] ? 262144 : 0) | (src[srcPos + 19] ? 524288 : 0) | (src[srcPos + 20] ? 0x100000 : 0) | (src[srcPos + 21] ? 0x200000 : 0) | (src[srcPos + 22] ? 0x400000 : 0) | (src[srcPos + 23] ? 0x800000 : 0) | (src[srcPos + 24] ? 0x1000000 : 0) | (src[srcPos + 25] ? 0x2000000 : 0) | (src[srcPos + 26] ? 0x4000000 : 0) | (src[srcPos + 27] ? 0x8000000 : 0) | (src[srcPos + 28] ? 0x10000000 : 0) | (src[srcPos + 29] ? 0x20000000 : 0) | (src[srcPos + 30] ? 0x40000000 : 0) | (src[srcPos + 31] ? Integer.MIN_VALUE : 0);
            srcPos += 32;
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
            destPos += 64L;
        }
        int countFinish = count & 0x3F;
        if (countFinish > 0) {
            int srcPosMax = srcPos + countFinish;
            while (srcPos < srcPosMax) {
                if (src[srcPos]) {
                    int n4 = (int)(destPos >>> 6);
                    dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n5 = (int)(destPos >>> 6);
                    dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, char[] src, int srcPos, int count, char threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, char[] src, int srcPos, int count, char threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, char[] src, int srcPos, int count, char threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, char[] src, int srcPos, int count, char threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, byte[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFF) > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFF) > threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) > threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) > threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) > threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) > threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) > threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) > threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) > threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) > threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) > threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) > threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) > threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) > threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) > threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) > threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) > threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) > threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) > threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) > threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) > threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) > threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) > threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) > threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) > threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) > threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) > threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) > threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) > threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) > threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) > threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) > threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) > threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFF) > threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) > threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) > threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) > threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) > threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) > threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) > threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) > threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) > threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) > threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) > threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) > threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) > threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) > threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) > threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) > threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) > threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) > threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) > threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) > threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) > threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) > threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) > threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) > threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) > threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) > threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) > threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) > threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) > threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) > threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) > threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFF) > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, byte[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFF) < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFF) < threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) < threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) < threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) < threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) < threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) < threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) < threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) < threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) < threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) < threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) < threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) < threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) < threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) < threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) < threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) < threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) < threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) < threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) < threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) < threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) < threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) < threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) < threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) < threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) < threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) < threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) < threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) < threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) < threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) < threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) < threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) < threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFF) < threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) < threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) < threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) < threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) < threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) < threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) < threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) < threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) < threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) < threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) < threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) < threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) < threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) < threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) < threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) < threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) < threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) < threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) < threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) < threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) < threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) < threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) < threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) < threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) < threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) < threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) < threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) < threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) < threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) < threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) < threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFF) < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, byte[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFF) >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFF) >= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) >= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) >= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) >= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) >= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) >= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) >= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) >= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) >= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) >= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) >= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) >= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) >= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) >= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) >= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) >= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) >= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) >= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) >= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) >= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) >= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) >= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) >= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) >= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) >= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) >= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) >= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) >= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) >= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) >= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) >= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) >= threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFF) >= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) >= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) >= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) >= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) >= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) >= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) >= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) >= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) >= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) >= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) >= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) >= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) >= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) >= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) >= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) >= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) >= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) >= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) >= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) >= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) >= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) >= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) >= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) >= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) >= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) >= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) >= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) >= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) >= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) >= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) >= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFF) >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, byte[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFF) <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFF) <= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) <= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) <= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) <= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) <= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) <= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) <= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) <= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) <= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) <= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) <= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) <= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) <= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) <= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) <= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) <= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) <= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) <= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) <= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) <= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) <= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) <= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) <= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) <= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) <= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) <= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) <= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) <= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) <= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) <= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) <= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) <= threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFF) <= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFF) <= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFF) <= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFF) <= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFF) <= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFF) <= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFF) <= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFF) <= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFF) <= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFF) <= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFF) <= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFF) <= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFF) <= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFF) <= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFF) <= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFF) <= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFF) <= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFF) <= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFF) <= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFF) <= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFF) <= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFF) <= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFF) <= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFF) <= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFF) <= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFF) <= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFF) <= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFF) <= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFF) <= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFF) <= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFF) <= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFF) <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFF) <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, short[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFFFF) > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFFFF) > threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) > threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) > threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) > threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) > threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) > threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) > threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) > threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) > threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) > threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) > threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) > threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) > threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) > threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) > threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) > threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) > threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) > threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) > threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) > threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) > threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) > threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) > threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) > threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) > threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) > threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) > threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) > threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) > threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) > threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) > threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) > threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFFFF) > threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) > threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) > threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) > threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) > threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) > threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) > threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) > threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) > threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) > threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) > threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) > threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) > threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) > threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) > threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) > threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) > threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) > threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) > threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) > threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) > threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) > threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) > threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) > threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) > threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) > threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) > threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) > threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) > threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) > threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) > threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFFFF) > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, short[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFFFF) < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFFFF) < threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) < threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) < threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) < threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) < threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) < threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) < threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) < threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) < threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) < threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) < threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) < threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) < threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) < threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) < threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) < threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) < threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) < threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) < threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) < threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) < threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) < threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) < threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) < threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) < threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) < threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) < threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) < threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) < threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) < threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) < threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) < threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFFFF) < threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) < threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) < threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) < threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) < threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) < threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) < threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) < threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) < threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) < threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) < threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) < threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) < threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) < threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) < threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) < threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) < threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) < threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) < threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) < threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) < threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) < threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) < threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) < threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) < threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) < threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) < threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) < threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) < threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) < threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) < threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFFFF) < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, short[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFFFF) >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFFFF) >= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) >= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) >= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) >= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) >= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) >= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) >= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) >= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) >= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) >= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) >= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) >= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) >= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) >= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) >= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) >= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) >= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) >= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) >= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) >= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) >= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) >= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) >= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) >= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) >= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) >= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) >= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) >= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) >= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) >= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) >= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) >= threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFFFF) >= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) >= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) >= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) >= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) >= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) >= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) >= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) >= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) >= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) >= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) >= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) >= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) >= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) >= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) >= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) >= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) >= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) >= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) >= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) >= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) >= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) >= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) >= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) >= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) >= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) >= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) >= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) >= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) >= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) >= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) >= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFFFF) >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, short[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if ((src[srcPos] & 0xFFFF) <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = ((src[srcPos] & 0xFFFF) <= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) <= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) <= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) <= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) <= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) <= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) <= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) <= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) <= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) <= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) <= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) <= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) <= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) <= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) <= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) <= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) <= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) <= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) <= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) <= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) <= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) <= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) <= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) <= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) <= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) <= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) <= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) <= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) <= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) <= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) <= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) <= threshold ? Integer.MIN_VALUE : 0);
            int high = ((src[srcPos += 32] & 0xFFFF) <= threshold ? 1 : 0) | ((src[srcPos + 1] & 0xFFFF) <= threshold ? 2 : 0) | ((src[srcPos + 2] & 0xFFFF) <= threshold ? 4 : 0) | ((src[srcPos + 3] & 0xFFFF) <= threshold ? 8 : 0) | ((src[srcPos + 4] & 0xFFFF) <= threshold ? 16 : 0) | ((src[srcPos + 5] & 0xFFFF) <= threshold ? 32 : 0) | ((src[srcPos + 6] & 0xFFFF) <= threshold ? 64 : 0) | ((src[srcPos + 7] & 0xFFFF) <= threshold ? 128 : 0) | ((src[srcPos + 8] & 0xFFFF) <= threshold ? 256 : 0) | ((src[srcPos + 9] & 0xFFFF) <= threshold ? 512 : 0) | ((src[srcPos + 10] & 0xFFFF) <= threshold ? 1024 : 0) | ((src[srcPos + 11] & 0xFFFF) <= threshold ? 2048 : 0) | ((src[srcPos + 12] & 0xFFFF) <= threshold ? 4096 : 0) | ((src[srcPos + 13] & 0xFFFF) <= threshold ? 8192 : 0) | ((src[srcPos + 14] & 0xFFFF) <= threshold ? 16384 : 0) | ((src[srcPos + 15] & 0xFFFF) <= threshold ? 32768 : 0) | ((src[srcPos + 16] & 0xFFFF) <= threshold ? 65536 : 0) | ((src[srcPos + 17] & 0xFFFF) <= threshold ? 131072 : 0) | ((src[srcPos + 18] & 0xFFFF) <= threshold ? 262144 : 0) | ((src[srcPos + 19] & 0xFFFF) <= threshold ? 524288 : 0) | ((src[srcPos + 20] & 0xFFFF) <= threshold ? 0x100000 : 0) | ((src[srcPos + 21] & 0xFFFF) <= threshold ? 0x200000 : 0) | ((src[srcPos + 22] & 0xFFFF) <= threshold ? 0x400000 : 0) | ((src[srcPos + 23] & 0xFFFF) <= threshold ? 0x800000 : 0) | ((src[srcPos + 24] & 0xFFFF) <= threshold ? 0x1000000 : 0) | ((src[srcPos + 25] & 0xFFFF) <= threshold ? 0x2000000 : 0) | ((src[srcPos + 26] & 0xFFFF) <= threshold ? 0x4000000 : 0) | ((src[srcPos + 27] & 0xFFFF) <= threshold ? 0x8000000 : 0) | ((src[srcPos + 28] & 0xFFFF) <= threshold ? 0x10000000 : 0) | ((src[srcPos + 29] & 0xFFFF) <= threshold ? 0x20000000 : 0) | ((src[srcPos + 30] & 0xFFFF) <= threshold ? 0x40000000 : 0) | ((src[srcPos + 31] & 0xFFFF) <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if ((src[srcPos] & 0xFFFF) <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, int[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, int[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, int[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, int[] src, int srcPos, int count, int threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, long[] src, int srcPos, int count, long threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, long[] src, int srcPos, int count, long threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, long[] src, int srcPos, int count, long threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, long[] src, int srcPos, int count, long threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, float[] src, int srcPos, int count, float threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, float[] src, int srcPos, int count, float threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, float[] src, int srcPos, int count, float threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, float[] src, int srcPos, int count, float threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreater(long[] dest, long destPos, double[] src, int srcPos, int count, double threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] > threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] > threshold ? 1 : 0) | (src[srcPos + 1] > threshold ? 2 : 0) | (src[srcPos + 2] > threshold ? 4 : 0) | (src[srcPos + 3] > threshold ? 8 : 0) | (src[srcPos + 4] > threshold ? 16 : 0) | (src[srcPos + 5] > threshold ? 32 : 0) | (src[srcPos + 6] > threshold ? 64 : 0) | (src[srcPos + 7] > threshold ? 128 : 0) | (src[srcPos + 8] > threshold ? 256 : 0) | (src[srcPos + 9] > threshold ? 512 : 0) | (src[srcPos + 10] > threshold ? 1024 : 0) | (src[srcPos + 11] > threshold ? 2048 : 0) | (src[srcPos + 12] > threshold ? 4096 : 0) | (src[srcPos + 13] > threshold ? 8192 : 0) | (src[srcPos + 14] > threshold ? 16384 : 0) | (src[srcPos + 15] > threshold ? 32768 : 0) | (src[srcPos + 16] > threshold ? 65536 : 0) | (src[srcPos + 17] > threshold ? 131072 : 0) | (src[srcPos + 18] > threshold ? 262144 : 0) | (src[srcPos + 19] > threshold ? 524288 : 0) | (src[srcPos + 20] > threshold ? 0x100000 : 0) | (src[srcPos + 21] > threshold ? 0x200000 : 0) | (src[srcPos + 22] > threshold ? 0x400000 : 0) | (src[srcPos + 23] > threshold ? 0x800000 : 0) | (src[srcPos + 24] > threshold ? 0x1000000 : 0) | (src[srcPos + 25] > threshold ? 0x2000000 : 0) | (src[srcPos + 26] > threshold ? 0x4000000 : 0) | (src[srcPos + 27] > threshold ? 0x8000000 : 0) | (src[srcPos + 28] > threshold ? 0x10000000 : 0) | (src[srcPos + 29] > threshold ? 0x20000000 : 0) | (src[srcPos + 30] > threshold ? 0x40000000 : 0) | (src[srcPos + 31] > threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] > threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLess(long[] dest, long destPos, double[] src, int srcPos, int count, double threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] < threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] < threshold ? 1 : 0) | (src[srcPos + 1] < threshold ? 2 : 0) | (src[srcPos + 2] < threshold ? 4 : 0) | (src[srcPos + 3] < threshold ? 8 : 0) | (src[srcPos + 4] < threshold ? 16 : 0) | (src[srcPos + 5] < threshold ? 32 : 0) | (src[srcPos + 6] < threshold ? 64 : 0) | (src[srcPos + 7] < threshold ? 128 : 0) | (src[srcPos + 8] < threshold ? 256 : 0) | (src[srcPos + 9] < threshold ? 512 : 0) | (src[srcPos + 10] < threshold ? 1024 : 0) | (src[srcPos + 11] < threshold ? 2048 : 0) | (src[srcPos + 12] < threshold ? 4096 : 0) | (src[srcPos + 13] < threshold ? 8192 : 0) | (src[srcPos + 14] < threshold ? 16384 : 0) | (src[srcPos + 15] < threshold ? 32768 : 0) | (src[srcPos + 16] < threshold ? 65536 : 0) | (src[srcPos + 17] < threshold ? 131072 : 0) | (src[srcPos + 18] < threshold ? 262144 : 0) | (src[srcPos + 19] < threshold ? 524288 : 0) | (src[srcPos + 20] < threshold ? 0x100000 : 0) | (src[srcPos + 21] < threshold ? 0x200000 : 0) | (src[srcPos + 22] < threshold ? 0x400000 : 0) | (src[srcPos + 23] < threshold ? 0x800000 : 0) | (src[srcPos + 24] < threshold ? 0x1000000 : 0) | (src[srcPos + 25] < threshold ? 0x2000000 : 0) | (src[srcPos + 26] < threshold ? 0x4000000 : 0) | (src[srcPos + 27] < threshold ? 0x8000000 : 0) | (src[srcPos + 28] < threshold ? 0x10000000 : 0) | (src[srcPos + 29] < threshold ? 0x20000000 : 0) | (src[srcPos + 30] < threshold ? 0x40000000 : 0) | (src[srcPos + 31] < threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] < threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsGreaterOrEqual(long[] dest, long destPos, double[] src, int srcPos, int count, double threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] >= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] >= threshold ? 1 : 0) | (src[srcPos + 1] >= threshold ? 2 : 0) | (src[srcPos + 2] >= threshold ? 4 : 0) | (src[srcPos + 3] >= threshold ? 8 : 0) | (src[srcPos + 4] >= threshold ? 16 : 0) | (src[srcPos + 5] >= threshold ? 32 : 0) | (src[srcPos + 6] >= threshold ? 64 : 0) | (src[srcPos + 7] >= threshold ? 128 : 0) | (src[srcPos + 8] >= threshold ? 256 : 0) | (src[srcPos + 9] >= threshold ? 512 : 0) | (src[srcPos + 10] >= threshold ? 1024 : 0) | (src[srcPos + 11] >= threshold ? 2048 : 0) | (src[srcPos + 12] >= threshold ? 4096 : 0) | (src[srcPos + 13] >= threshold ? 8192 : 0) | (src[srcPos + 14] >= threshold ? 16384 : 0) | (src[srcPos + 15] >= threshold ? 32768 : 0) | (src[srcPos + 16] >= threshold ? 65536 : 0) | (src[srcPos + 17] >= threshold ? 131072 : 0) | (src[srcPos + 18] >= threshold ? 262144 : 0) | (src[srcPos + 19] >= threshold ? 524288 : 0) | (src[srcPos + 20] >= threshold ? 0x100000 : 0) | (src[srcPos + 21] >= threshold ? 0x200000 : 0) | (src[srcPos + 22] >= threshold ? 0x400000 : 0) | (src[srcPos + 23] >= threshold ? 0x800000 : 0) | (src[srcPos + 24] >= threshold ? 0x1000000 : 0) | (src[srcPos + 25] >= threshold ? 0x2000000 : 0) | (src[srcPos + 26] >= threshold ? 0x4000000 : 0) | (src[srcPos + 27] >= threshold ? 0x8000000 : 0) | (src[srcPos + 28] >= threshold ? 0x10000000 : 0) | (src[srcPos + 29] >= threshold ? 0x20000000 : 0) | (src[srcPos + 30] >= threshold ? 0x40000000 : 0) | (src[srcPos + 31] >= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] >= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void packBitsLessOrEqual(long[] dest, long destPos, double[] src, int srcPos, int count, double threshold) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (destPos & 0x3FL) == 0L ? 0 : 64 - (int)(destPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        if (countStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            int srcPosMax = srcPos + countStart;
            while (srcPos < srcPosMax) {
                if (src[srcPos] <= threshold) {
                    int n2 = (int)(destPos >>> 6);
                    dest[n2] = dest[n2] | 1L << (int)(destPos & 0x3FL);
                } else {
                    int n3 = (int)(destPos >>> 6);
                    dest[n3] = dest[n3] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++srcPos;
                ++destPos;
            }
            // MONITOREXIT : lArray
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(destPos >>> 6); k < kMax; srcPos += 32, destPos += 64L, ++k) {
            int low = (src[srcPos] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            int high = (src[srcPos += 32] <= threshold ? 1 : 0) | (src[srcPos + 1] <= threshold ? 2 : 0) | (src[srcPos + 2] <= threshold ? 4 : 0) | (src[srcPos + 3] <= threshold ? 8 : 0) | (src[srcPos + 4] <= threshold ? 16 : 0) | (src[srcPos + 5] <= threshold ? 32 : 0) | (src[srcPos + 6] <= threshold ? 64 : 0) | (src[srcPos + 7] <= threshold ? 128 : 0) | (src[srcPos + 8] <= threshold ? 256 : 0) | (src[srcPos + 9] <= threshold ? 512 : 0) | (src[srcPos + 10] <= threshold ? 1024 : 0) | (src[srcPos + 11] <= threshold ? 2048 : 0) | (src[srcPos + 12] <= threshold ? 4096 : 0) | (src[srcPos + 13] <= threshold ? 8192 : 0) | (src[srcPos + 14] <= threshold ? 16384 : 0) | (src[srcPos + 15] <= threshold ? 32768 : 0) | (src[srcPos + 16] <= threshold ? 65536 : 0) | (src[srcPos + 17] <= threshold ? 131072 : 0) | (src[srcPos + 18] <= threshold ? 262144 : 0) | (src[srcPos + 19] <= threshold ? 524288 : 0) | (src[srcPos + 20] <= threshold ? 0x100000 : 0) | (src[srcPos + 21] <= threshold ? 0x200000 : 0) | (src[srcPos + 22] <= threshold ? 0x400000 : 0) | (src[srcPos + 23] <= threshold ? 0x800000 : 0) | (src[srcPos + 24] <= threshold ? 0x1000000 : 0) | (src[srcPos + 25] <= threshold ? 0x2000000 : 0) | (src[srcPos + 26] <= threshold ? 0x4000000 : 0) | (src[srcPos + 27] <= threshold ? 0x8000000 : 0) | (src[srcPos + 28] <= threshold ? 0x10000000 : 0) | (src[srcPos + 29] <= threshold ? 0x20000000 : 0) | (src[srcPos + 30] <= threshold ? 0x40000000 : 0) | (src[srcPos + 31] <= threshold ? Integer.MIN_VALUE : 0);
            dest[k] = (long)low & 0xFFFFFFFFL | (long)high << 32;
        }
        int countFinish = count & 0x3F;
        if (countFinish <= 0) return;
        long[] lArray = dest;
        // MONITORENTER : dest
        int srcPosMax = srcPos + countFinish;
        while (true) {
            if (srcPos >= srcPosMax) {
                // MONITOREXIT : lArray
                return;
            }
            if (src[srcPos] <= threshold) {
                int n4 = (int)(destPos >>> 6);
                dest[n4] = dest[n4] | 1L << (int)(destPos & 0x3FL);
            } else {
                int n5 = (int)(destPos >>> 6);
                dest[n5] = dest[n5] & (1L << (int)(destPos & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static boolean[] unpackBits(long[] src, long srcPos, long count) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        boolean[] result = new boolean[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length);
        return result;
    }

    public static void unpackBits(boolean[] dest, int destPos, long[] src, long srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0;
            dest[destPos + 1] = (low & 2) != 0;
            dest[destPos + 2] = (low & 4) != 0;
            dest[destPos + 3] = (low & 8) != 0;
            dest[destPos + 4] = (low & 0x10) != 0;
            dest[destPos + 5] = (low & 0x20) != 0;
            dest[destPos + 6] = (low & 0x40) != 0;
            dest[destPos + 7] = (low & 0x80) != 0;
            dest[destPos + 8] = (low & 0x100) != 0;
            dest[destPos + 9] = (low & 0x200) != 0;
            dest[destPos + 10] = (low & 0x400) != 0;
            dest[destPos + 11] = (low & 0x800) != 0;
            dest[destPos + 12] = (low & 0x1000) != 0;
            dest[destPos + 13] = (low & 0x2000) != 0;
            dest[destPos + 14] = (low & 0x4000) != 0;
            dest[destPos + 15] = (low & 0x8000) != 0;
            dest[destPos + 16] = (low & 0x10000) != 0;
            dest[destPos + 17] = (low & 0x20000) != 0;
            dest[destPos + 18] = (low & 0x40000) != 0;
            dest[destPos + 19] = (low & 0x80000) != 0;
            dest[destPos + 20] = (low & 0x100000) != 0;
            dest[destPos + 21] = (low & 0x200000) != 0;
            dest[destPos + 22] = (low & 0x400000) != 0;
            dest[destPos + 23] = (low & 0x800000) != 0;
            dest[destPos + 24] = (low & 0x1000000) != 0;
            dest[destPos + 25] = (low & 0x2000000) != 0;
            dest[destPos + 26] = (low & 0x4000000) != 0;
            dest[destPos + 27] = (low & 0x8000000) != 0;
            dest[destPos + 28] = (low & 0x10000000) != 0;
            dest[destPos + 29] = (low & 0x20000000) != 0;
            dest[destPos + 30] = (low & 0x40000000) != 0;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0;
            dest[destPos + 32] = (high & 1) != 0;
            dest[destPos + 33] = (high & 2) != 0;
            dest[destPos + 34] = (high & 4) != 0;
            dest[destPos + 35] = (high & 8) != 0;
            dest[destPos + 36] = (high & 0x10) != 0;
            dest[destPos + 37] = (high & 0x20) != 0;
            dest[destPos + 38] = (high & 0x40) != 0;
            dest[destPos + 39] = (high & 0x80) != 0;
            dest[destPos + 40] = (high & 0x100) != 0;
            dest[destPos + 41] = (high & 0x200) != 0;
            dest[destPos + 42] = (high & 0x400) != 0;
            dest[destPos + 43] = (high & 0x800) != 0;
            dest[destPos + 44] = (high & 0x1000) != 0;
            dest[destPos + 45] = (high & 0x2000) != 0;
            dest[destPos + 46] = (high & 0x4000) != 0;
            dest[destPos + 47] = (high & 0x8000) != 0;
            dest[destPos + 48] = (high & 0x10000) != 0;
            dest[destPos + 49] = (high & 0x20000) != 0;
            dest[destPos + 50] = (high & 0x40000) != 0;
            dest[destPos + 51] = (high & 0x80000) != 0;
            dest[destPos + 52] = (high & 0x100000) != 0;
            dest[destPos + 53] = (high & 0x200000) != 0;
            dest[destPos + 54] = (high & 0x400000) != 0;
            dest[destPos + 55] = (high & 0x800000) != 0;
            dest[destPos + 56] = (high & 0x1000000) != 0;
            dest[destPos + 57] = (high & 0x2000000) != 0;
            dest[destPos + 58] = (high & 0x4000000) != 0;
            dest[destPos + 59] = (high & 0x8000000) != 0;
            dest[destPos + 60] = (high & 0x10000000) != 0;
            dest[destPos + 61] = (high & 0x20000000) != 0;
            dest[destPos + 62] = (high & 0x40000000) != 0;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L;
            ++srcPos;
            ++destPos;
        }
    }

    public static boolean[] unpackBits(long[] src, long srcPos, long count, boolean bit0Value, boolean bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        boolean[] result = new boolean[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(boolean[] dest, int destPos, long[] src, long srcPos, int count, boolean bit0Value, boolean bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(boolean[] dest, int destPos, long[] src, long srcPos, int count, boolean bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(boolean[] dest, int destPos, long[] src, long srcPos, int count, boolean bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static char[] unpackBitsToChars(long[] src, long srcPos, long count, char bit0Value, char bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        char[] result = new char[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(char[] dest, int destPos, long[] src, long srcPos, int count, char bit0Value, char bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(char[] dest, int destPos, long[] src, long srcPos, int count, char bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(char[] dest, int destPos, long[] src, long srcPos, int count, char bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static byte[] unpackBitsToBytes(long[] src, long srcPos, long count, byte bit0Value, byte bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        byte[] result = new byte[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(byte[] dest, int destPos, long[] src, long srcPos, int count, byte bit0Value, byte bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(byte[] dest, int destPos, long[] src, long srcPos, int count, byte bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(byte[] dest, int destPos, long[] src, long srcPos, int count, byte bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static short[] unpackBitsToShorts(long[] src, long srcPos, long count, short bit0Value, short bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        short[] result = new short[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(short[] dest, int destPos, long[] src, long srcPos, int count, short bit0Value, short bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(short[] dest, int destPos, long[] src, long srcPos, int count, short bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(short[] dest, int destPos, long[] src, long srcPos, int count, short bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static int[] unpackBitsToInts(long[] src, long srcPos, long count, int bit0Value, int bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        int[] result = new int[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(int[] dest, int destPos, long[] src, long srcPos, int count, int bit0Value, int bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(int[] dest, int destPos, long[] src, long srcPos, int count, int bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(int[] dest, int destPos, long[] src, long srcPos, int count, int bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static long[] unpackBitsToLongs(long[] src, long srcPos, long count, long bit0Value, long bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        long[] result = new long[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(long[] dest, int destPos, long[] src, long srcPos, int count, long bit0Value, long bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(long[] dest, int destPos, long[] src, long srcPos, int count, long bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(long[] dest, int destPos, long[] src, long srcPos, int count, long bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static float[] unpackBitsToFloats(long[] src, long srcPos, long count, float bit0Value, float bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        float[] result = new float[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(float[] dest, int destPos, long[] src, long srcPos, int count, float bit0Value, float bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(float[] dest, int destPos, long[] src, long srcPos, int count, float bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(float[] dest, int destPos, long[] src, long srcPos, int count, float bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static double[] unpackBitsToDoubles(long[] src, long srcPos, long count, double bit0Value, double bit1Value) {
        Objects.requireNonNull(src, "Null src");
        if (srcPos < 0L) {
            throw new IllegalArgumentException("Negative srcPos = " + srcPos);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count = " + count);
        }
        if (count > PackedBitArrays.unpackedLength(src) - srcPos) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it cannot contain " + count + " bits since position " + srcPos);
        }
        if (count > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large bit array for unpacking to Java array: " + count + " >= 2^31 bits");
        }
        double[] result = new double[(int)count];
        PackedBitArrays.unpackBits(result, 0, src, srcPos, result.length, bit0Value, bit1Value);
        return result;
    }

    public static void unpackBits(double[] dest, int destPos, long[] src, long srcPos, int count, double bit0Value, double bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackUnitBits(double[] dest, int destPos, long[] src, long srcPos, int count, double bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void unpackZeroBits(double[] dest, int destPos, long[] src, long srcPos, int count, double bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static <T> void unpackBits(T[] dest, int destPos, long[] src, long srcPos, int count, T bit0Value, T bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (bit0Value == bit1Value) {
            Arrays.fill(dest, destPos, destPos + count, bit0Value);
            return;
        }
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            dest[destPos] = (low & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 1] = (low & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 2] = (low & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 3] = (low & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 4] = (low & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 5] = (low & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 6] = (low & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 7] = (low & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 8] = (low & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 9] = (low & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 10] = (low & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 11] = (low & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 12] = (low & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 13] = (low & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 14] = (low & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 15] = (low & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 16] = (low & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 17] = (low & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 18] = (low & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 19] = (low & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 20] = (low & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 21] = (low & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 22] = (low & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 23] = (low & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 24] = (low & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 25] = (low & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 26] = (low & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 27] = (low & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 28] = (low & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 29] = (low & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 30] = (low & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 31] = (low & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            dest[destPos + 32] = (high & 1) != 0 ? bit1Value : bit0Value;
            dest[destPos + 33] = (high & 2) != 0 ? bit1Value : bit0Value;
            dest[destPos + 34] = (high & 4) != 0 ? bit1Value : bit0Value;
            dest[destPos + 35] = (high & 8) != 0 ? bit1Value : bit0Value;
            dest[destPos + 36] = (high & 0x10) != 0 ? bit1Value : bit0Value;
            dest[destPos + 37] = (high & 0x20) != 0 ? bit1Value : bit0Value;
            dest[destPos + 38] = (high & 0x40) != 0 ? bit1Value : bit0Value;
            dest[destPos + 39] = (high & 0x80) != 0 ? bit1Value : bit0Value;
            dest[destPos + 40] = (high & 0x100) != 0 ? bit1Value : bit0Value;
            dest[destPos + 41] = (high & 0x200) != 0 ? bit1Value : bit0Value;
            dest[destPos + 42] = (high & 0x400) != 0 ? bit1Value : bit0Value;
            dest[destPos + 43] = (high & 0x800) != 0 ? bit1Value : bit0Value;
            dest[destPos + 44] = (high & 0x1000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 45] = (high & 0x2000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 46] = (high & 0x4000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 47] = (high & 0x8000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 48] = (high & 0x10000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 49] = (high & 0x20000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 50] = (high & 0x40000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 51] = (high & 0x80000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 52] = (high & 0x100000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 53] = (high & 0x200000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 54] = (high & 0x400000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 55] = (high & 0x800000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 56] = (high & 0x1000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 57] = (high & 0x2000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 58] = (high & 0x4000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 59] = (high & 0x8000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 60] = (high & 0x10000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 61] = (high & 0x20000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 62] = (high & 0x40000000) != 0 ? bit1Value : bit0Value;
            dest[destPos + 63] = (high & Integer.MIN_VALUE) != 0 ? bit1Value : bit0Value;
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            dest[destPos] = (src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L ? bit1Value : bit0Value;
            ++srcPos;
            ++destPos;
        }
    }

    public static <T> void unpackUnitBits(T[] dest, int destPos, long[] src, long srcPos, int count, T bit1Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF) != 0) {
                if ((low & 1) != 0) {
                    dest[destPos] = bit1Value;
                }
                if ((low & 2) != 0) {
                    dest[destPos + 1] = bit1Value;
                }
                if ((low & 4) != 0) {
                    dest[destPos + 2] = bit1Value;
                }
                if ((low & 8) != 0) {
                    dest[destPos + 3] = bit1Value;
                }
                if ((low & 0x10) != 0) {
                    dest[destPos + 4] = bit1Value;
                }
                if ((low & 0x20) != 0) {
                    dest[destPos + 5] = bit1Value;
                }
                if ((low & 0x40) != 0) {
                    dest[destPos + 6] = bit1Value;
                }
                if ((low & 0x80) != 0) {
                    dest[destPos + 7] = bit1Value;
                }
                if ((low & 0x100) != 0) {
                    dest[destPos + 8] = bit1Value;
                }
                if ((low & 0x200) != 0) {
                    dest[destPos + 9] = bit1Value;
                }
                if ((low & 0x400) != 0) {
                    dest[destPos + 10] = bit1Value;
                }
                if ((low & 0x800) != 0) {
                    dest[destPos + 11] = bit1Value;
                }
                if ((low & 0x1000) != 0) {
                    dest[destPos + 12] = bit1Value;
                }
                if ((low & 0x2000) != 0) {
                    dest[destPos + 13] = bit1Value;
                }
                if ((low & 0x4000) != 0) {
                    dest[destPos + 14] = bit1Value;
                }
                if ((low & 0x8000) != 0) {
                    dest[destPos + 15] = bit1Value;
                }
            }
            if ((low & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != 0) {
                if ((low & 0x10000) != 0) {
                    dest[destPos + 16] = bit1Value;
                }
                if ((low & 0x20000) != 0) {
                    dest[destPos + 17] = bit1Value;
                }
                if ((low & 0x40000) != 0) {
                    dest[destPos + 18] = bit1Value;
                }
                if ((low & 0x80000) != 0) {
                    dest[destPos + 19] = bit1Value;
                }
                if ((low & 0x100000) != 0) {
                    dest[destPos + 20] = bit1Value;
                }
                if ((low & 0x200000) != 0) {
                    dest[destPos + 21] = bit1Value;
                }
                if ((low & 0x400000) != 0) {
                    dest[destPos + 22] = bit1Value;
                }
                if ((low & 0x800000) != 0) {
                    dest[destPos + 23] = bit1Value;
                }
                if ((low & 0x1000000) != 0) {
                    dest[destPos + 24] = bit1Value;
                }
                if ((low & 0x2000000) != 0) {
                    dest[destPos + 25] = bit1Value;
                }
                if ((low & 0x4000000) != 0) {
                    dest[destPos + 26] = bit1Value;
                }
                if ((low & 0x8000000) != 0) {
                    dest[destPos + 27] = bit1Value;
                }
                if ((low & 0x10000000) != 0) {
                    dest[destPos + 28] = bit1Value;
                }
                if ((low & 0x20000000) != 0) {
                    dest[destPos + 29] = bit1Value;
                }
                if ((low & 0x40000000) != 0) {
                    dest[destPos + 30] = bit1Value;
                }
                if ((low & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 31] = bit1Value;
                }
            }
            if ((high & 0xFFFF) == 65535) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF) != 0) {
                if ((high & 1) != 0) {
                    dest[destPos + 32] = bit1Value;
                }
                if ((high & 2) != 0) {
                    dest[destPos + 33] = bit1Value;
                }
                if ((high & 4) != 0) {
                    dest[destPos + 34] = bit1Value;
                }
                if ((high & 8) != 0) {
                    dest[destPos + 35] = bit1Value;
                }
                if ((high & 0x10) != 0) {
                    dest[destPos + 36] = bit1Value;
                }
                if ((high & 0x20) != 0) {
                    dest[destPos + 37] = bit1Value;
                }
                if ((high & 0x40) != 0) {
                    dest[destPos + 38] = bit1Value;
                }
                if ((high & 0x80) != 0) {
                    dest[destPos + 39] = bit1Value;
                }
                if ((high & 0x100) != 0) {
                    dest[destPos + 40] = bit1Value;
                }
                if ((high & 0x200) != 0) {
                    dest[destPos + 41] = bit1Value;
                }
                if ((high & 0x400) != 0) {
                    dest[destPos + 42] = bit1Value;
                }
                if ((high & 0x800) != 0) {
                    dest[destPos + 43] = bit1Value;
                }
                if ((high & 0x1000) != 0) {
                    dest[destPos + 44] = bit1Value;
                }
                if ((high & 0x2000) != 0) {
                    dest[destPos + 45] = bit1Value;
                }
                if ((high & 0x4000) != 0) {
                    dest[destPos + 46] = bit1Value;
                }
                if ((high & 0x8000) != 0) {
                    dest[destPos + 47] = bit1Value;
                }
            }
            if ((high & 0xFFFF0000) == -65536) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit1Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != 0) {
                if ((high & 0x10000) != 0) {
                    dest[destPos + 48] = bit1Value;
                }
                if ((high & 0x20000) != 0) {
                    dest[destPos + 49] = bit1Value;
                }
                if ((high & 0x40000) != 0) {
                    dest[destPos + 50] = bit1Value;
                }
                if ((high & 0x80000) != 0) {
                    dest[destPos + 51] = bit1Value;
                }
                if ((high & 0x100000) != 0) {
                    dest[destPos + 52] = bit1Value;
                }
                if ((high & 0x200000) != 0) {
                    dest[destPos + 53] = bit1Value;
                }
                if ((high & 0x400000) != 0) {
                    dest[destPos + 54] = bit1Value;
                }
                if ((high & 0x800000) != 0) {
                    dest[destPos + 55] = bit1Value;
                }
                if ((high & 0x1000000) != 0) {
                    dest[destPos + 56] = bit1Value;
                }
                if ((high & 0x2000000) != 0) {
                    dest[destPos + 57] = bit1Value;
                }
                if ((high & 0x4000000) != 0) {
                    dest[destPos + 58] = bit1Value;
                }
                if ((high & 0x8000000) != 0) {
                    dest[destPos + 59] = bit1Value;
                }
                if ((high & 0x10000000) != 0) {
                    dest[destPos + 60] = bit1Value;
                }
                if ((high & 0x20000000) != 0) {
                    dest[destPos + 61] = bit1Value;
                }
                if ((high & 0x40000000) != 0) {
                    dest[destPos + 62] = bit1Value;
                }
                if ((high & Integer.MIN_VALUE) != 0) {
                    dest[destPos + 63] = bit1Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) != 0L) {
                dest[destPos] = bit1Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static <T> void unpackZeroBits(T[] dest, int destPos, long[] src, long srcPos, int count, T bit0Value) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int fillPos = -1;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int iMax;
            int i;
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            if ((low & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos, 16);
                    fillPos = destPos;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF) != 65535) {
                if ((low & 1) == 0) {
                    dest[destPos] = bit0Value;
                }
                if ((low & 2) == 0) {
                    dest[destPos + 1] = bit0Value;
                }
                if ((low & 4) == 0) {
                    dest[destPos + 2] = bit0Value;
                }
                if ((low & 8) == 0) {
                    dest[destPos + 3] = bit0Value;
                }
                if ((low & 0x10) == 0) {
                    dest[destPos + 4] = bit0Value;
                }
                if ((low & 0x20) == 0) {
                    dest[destPos + 5] = bit0Value;
                }
                if ((low & 0x40) == 0) {
                    dest[destPos + 6] = bit0Value;
                }
                if ((low & 0x80) == 0) {
                    dest[destPos + 7] = bit0Value;
                }
                if ((low & 0x100) == 0) {
                    dest[destPos + 8] = bit0Value;
                }
                if ((low & 0x200) == 0) {
                    dest[destPos + 9] = bit0Value;
                }
                if ((low & 0x400) == 0) {
                    dest[destPos + 10] = bit0Value;
                }
                if ((low & 0x800) == 0) {
                    dest[destPos + 11] = bit0Value;
                }
                if ((low & 0x1000) == 0) {
                    dest[destPos + 12] = bit0Value;
                }
                if ((low & 0x2000) == 0) {
                    dest[destPos + 13] = bit0Value;
                }
                if ((low & 0x4000) == 0) {
                    dest[destPos + 14] = bit0Value;
                }
                if ((low & 0x8000) == 0) {
                    dest[destPos + 15] = bit0Value;
                }
            }
            if ((low & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 16, 16);
                    fillPos = destPos + 16;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 16; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((low & 0xFFFF0000) != -65536) {
                if ((low & 0x10000) == 0) {
                    dest[destPos + 16] = bit0Value;
                }
                if ((low & 0x20000) == 0) {
                    dest[destPos + 17] = bit0Value;
                }
                if ((low & 0x40000) == 0) {
                    dest[destPos + 18] = bit0Value;
                }
                if ((low & 0x80000) == 0) {
                    dest[destPos + 19] = bit0Value;
                }
                if ((low & 0x100000) == 0) {
                    dest[destPos + 20] = bit0Value;
                }
                if ((low & 0x200000) == 0) {
                    dest[destPos + 21] = bit0Value;
                }
                if ((low & 0x400000) == 0) {
                    dest[destPos + 22] = bit0Value;
                }
                if ((low & 0x800000) == 0) {
                    dest[destPos + 23] = bit0Value;
                }
                if ((low & 0x1000000) == 0) {
                    dest[destPos + 24] = bit0Value;
                }
                if ((low & 0x2000000) == 0) {
                    dest[destPos + 25] = bit0Value;
                }
                if ((low & 0x4000000) == 0) {
                    dest[destPos + 26] = bit0Value;
                }
                if ((low & 0x8000000) == 0) {
                    dest[destPos + 27] = bit0Value;
                }
                if ((low & 0x10000000) == 0) {
                    dest[destPos + 28] = bit0Value;
                }
                if ((low & 0x20000000) == 0) {
                    dest[destPos + 29] = bit0Value;
                }
                if ((low & 0x40000000) == 0) {
                    dest[destPos + 30] = bit0Value;
                }
                if ((low & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 31] = bit0Value;
                }
            }
            if ((high & 0xFFFF) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 32, 16);
                    fillPos = destPos + 32;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 32; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF) != 65535) {
                if ((high & 1) == 0) {
                    dest[destPos + 32] = bit0Value;
                }
                if ((high & 2) == 0) {
                    dest[destPos + 33] = bit0Value;
                }
                if ((high & 4) == 0) {
                    dest[destPos + 34] = bit0Value;
                }
                if ((high & 8) == 0) {
                    dest[destPos + 35] = bit0Value;
                }
                if ((high & 0x10) == 0) {
                    dest[destPos + 36] = bit0Value;
                }
                if ((high & 0x20) == 0) {
                    dest[destPos + 37] = bit0Value;
                }
                if ((high & 0x40) == 0) {
                    dest[destPos + 38] = bit0Value;
                }
                if ((high & 0x80) == 0) {
                    dest[destPos + 39] = bit0Value;
                }
                if ((high & 0x100) == 0) {
                    dest[destPos + 40] = bit0Value;
                }
                if ((high & 0x200) == 0) {
                    dest[destPos + 41] = bit0Value;
                }
                if ((high & 0x400) == 0) {
                    dest[destPos + 42] = bit0Value;
                }
                if ((high & 0x800) == 0) {
                    dest[destPos + 43] = bit0Value;
                }
                if ((high & 0x1000) == 0) {
                    dest[destPos + 44] = bit0Value;
                }
                if ((high & 0x2000) == 0) {
                    dest[destPos + 45] = bit0Value;
                }
                if ((high & 0x4000) == 0) {
                    dest[destPos + 46] = bit0Value;
                }
                if ((high & 0x8000) == 0) {
                    dest[destPos + 47] = bit0Value;
                }
            }
            if ((high & 0xFFFF0000) == 0) {
                if (fillPos >= 0) {
                    System.arraycopy(dest, fillPos, dest, destPos + 48, 16);
                    fillPos = destPos + 48;
                } else {
                    iMax = i + 16;
                    for (i = fillPos = destPos + 48; i < iMax; ++i) {
                        dest[i] = bit0Value;
                    }
                }
            } else if ((high & 0xFFFF0000) != -65536) {
                if ((high & 0x10000) == 0) {
                    dest[destPos + 48] = bit0Value;
                }
                if ((high & 0x20000) == 0) {
                    dest[destPos + 49] = bit0Value;
                }
                if ((high & 0x40000) == 0) {
                    dest[destPos + 50] = bit0Value;
                }
                if ((high & 0x80000) == 0) {
                    dest[destPos + 51] = bit0Value;
                }
                if ((high & 0x100000) == 0) {
                    dest[destPos + 52] = bit0Value;
                }
                if ((high & 0x200000) == 0) {
                    dest[destPos + 53] = bit0Value;
                }
                if ((high & 0x400000) == 0) {
                    dest[destPos + 54] = bit0Value;
                }
                if ((high & 0x800000) == 0) {
                    dest[destPos + 55] = bit0Value;
                }
                if ((high & 0x1000000) == 0) {
                    dest[destPos + 56] = bit0Value;
                }
                if ((high & 0x2000000) == 0) {
                    dest[destPos + 57] = bit0Value;
                }
                if ((high & 0x4000000) == 0) {
                    dest[destPos + 58] = bit0Value;
                }
                if ((high & 0x8000000) == 0) {
                    dest[destPos + 59] = bit0Value;
                }
                if ((high & 0x10000000) == 0) {
                    dest[destPos + 60] = bit0Value;
                }
                if ((high & 0x20000000) == 0) {
                    dest[destPos + 61] = bit0Value;
                }
                if ((high & 0x40000000) == 0) {
                    dest[destPos + 62] = bit0Value;
                }
                if ((high & Integer.MIN_VALUE) == 0) {
                    dest[destPos + 63] = bit0Value;
                }
            }
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            if ((src[(int)(srcPos >>> 6)] & 1L << (int)(srcPos & 0x3FL)) == 0L) {
                dest[destPos] = bit0Value;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void addBitsToInts(int[] dest, int destPos, long[] src, long srcPos, int count) {
        int k;
        int countStart;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int n = countStart = (srcPos & 0x3FL) == 0L ? 0 : 64 - (int)(srcPos & 0x3FL);
        if (countStart > count) {
            countStart = count;
        }
        int destPosMax = destPos + countStart;
        while (destPos < destPosMax) {
            int n2 = destPos++;
            dest[n2] = dest[n2] + (int)(src[(int)(srcPos >>> 6)] >>> (int)(srcPos & 0x3FL) & 1L);
            ++srcPos;
        }
        int cnt = (count -= countStart) >>> 6;
        int kMax = k + cnt;
        for (k = (int)(srcPos >>> 6); k < kMax; ++k) {
            int low = (int)src[k];
            int high = (int)(src[k] >>> 32);
            srcPos += 64L;
            int n3 = destPos;
            dest[n3] = dest[n3] + (low & 1);
            int n4 = destPos + 1;
            dest[n4] = dest[n4] + (low >>> 1 & 1);
            int n5 = destPos + 2;
            dest[n5] = dest[n5] + (low >>> 2 & 1);
            int n6 = destPos + 3;
            dest[n6] = dest[n6] + (low >>> 3 & 1);
            int n7 = destPos + 4;
            dest[n7] = dest[n7] + (low >>> 4 & 1);
            int n8 = destPos + 5;
            dest[n8] = dest[n8] + (low >>> 5 & 1);
            int n9 = destPos + 6;
            dest[n9] = dest[n9] + (low >>> 6 & 1);
            int n10 = destPos + 7;
            dest[n10] = dest[n10] + (low >>> 7 & 1);
            int n11 = destPos + 8;
            dest[n11] = dest[n11] + (low >>> 8 & 1);
            int n12 = destPos + 9;
            dest[n12] = dest[n12] + (low >>> 9 & 1);
            int n13 = destPos + 10;
            dest[n13] = dest[n13] + (low >>> 10 & 1);
            int n14 = destPos + 11;
            dest[n14] = dest[n14] + (low >>> 11 & 1);
            int n15 = destPos + 12;
            dest[n15] = dest[n15] + (low >>> 12 & 1);
            int n16 = destPos + 13;
            dest[n16] = dest[n16] + (low >>> 13 & 1);
            int n17 = destPos + 14;
            dest[n17] = dest[n17] + (low >>> 14 & 1);
            int n18 = destPos + 15;
            dest[n18] = dest[n18] + (low >>> 15 & 1);
            int n19 = destPos + 16;
            dest[n19] = dest[n19] + (low >>> 16 & 1);
            int n20 = destPos + 17;
            dest[n20] = dest[n20] + (low >>> 17 & 1);
            int n21 = destPos + 18;
            dest[n21] = dest[n21] + (low >>> 18 & 1);
            int n22 = destPos + 19;
            dest[n22] = dest[n22] + (low >>> 19 & 1);
            int n23 = destPos + 20;
            dest[n23] = dest[n23] + (low >>> 20 & 1);
            int n24 = destPos + 21;
            dest[n24] = dest[n24] + (low >>> 21 & 1);
            int n25 = destPos + 22;
            dest[n25] = dest[n25] + (low >>> 22 & 1);
            int n26 = destPos + 23;
            dest[n26] = dest[n26] + (low >>> 23 & 1);
            int n27 = destPos + 24;
            dest[n27] = dest[n27] + (low >>> 24 & 1);
            int n28 = destPos + 25;
            dest[n28] = dest[n28] + (low >>> 25 & 1);
            int n29 = destPos + 26;
            dest[n29] = dest[n29] + (low >>> 26 & 1);
            int n30 = destPos + 27;
            dest[n30] = dest[n30] + (low >>> 27 & 1);
            int n31 = destPos + 28;
            dest[n31] = dest[n31] + (low >>> 28 & 1);
            int n32 = destPos + 29;
            dest[n32] = dest[n32] + (low >>> 29 & 1);
            int n33 = destPos + 30;
            dest[n33] = dest[n33] + (low >>> 30 & 1);
            int n34 = destPos + 31;
            dest[n34] = dest[n34] + (low >>> 31 & 1);
            int n35 = destPos + 32;
            dest[n35] = dest[n35] + (high & 1);
            int n36 = destPos + 33;
            dest[n36] = dest[n36] + (high >>> 1 & 1);
            int n37 = destPos + 34;
            dest[n37] = dest[n37] + (high >>> 2 & 1);
            int n38 = destPos + 35;
            dest[n38] = dest[n38] + (high >>> 3 & 1);
            int n39 = destPos + 36;
            dest[n39] = dest[n39] + (high >>> 4 & 1);
            int n40 = destPos + 37;
            dest[n40] = dest[n40] + (high >>> 5 & 1);
            int n41 = destPos + 38;
            dest[n41] = dest[n41] + (high >>> 6 & 1);
            int n42 = destPos + 39;
            dest[n42] = dest[n42] + (high >>> 7 & 1);
            int n43 = destPos + 40;
            dest[n43] = dest[n43] + (high >>> 8 & 1);
            int n44 = destPos + 41;
            dest[n44] = dest[n44] + (high >>> 9 & 1);
            int n45 = destPos + 42;
            dest[n45] = dest[n45] + (high >>> 10 & 1);
            int n46 = destPos + 43;
            dest[n46] = dest[n46] + (high >>> 11 & 1);
            int n47 = destPos + 44;
            dest[n47] = dest[n47] + (high >>> 12 & 1);
            int n48 = destPos + 45;
            dest[n48] = dest[n48] + (high >>> 13 & 1);
            int n49 = destPos + 46;
            dest[n49] = dest[n49] + (high >>> 14 & 1);
            int n50 = destPos + 47;
            dest[n50] = dest[n50] + (high >>> 15 & 1);
            int n51 = destPos + 48;
            dest[n51] = dest[n51] + (high >>> 16 & 1);
            int n52 = destPos + 49;
            dest[n52] = dest[n52] + (high >>> 17 & 1);
            int n53 = destPos + 50;
            dest[n53] = dest[n53] + (high >>> 18 & 1);
            int n54 = destPos + 51;
            dest[n54] = dest[n54] + (high >>> 19 & 1);
            int n55 = destPos + 52;
            dest[n55] = dest[n55] + (high >>> 20 & 1);
            int n56 = destPos + 53;
            dest[n56] = dest[n56] + (high >>> 21 & 1);
            int n57 = destPos + 54;
            dest[n57] = dest[n57] + (high >>> 22 & 1);
            int n58 = destPos + 55;
            dest[n58] = dest[n58] + (high >>> 23 & 1);
            int n59 = destPos + 56;
            dest[n59] = dest[n59] + (high >>> 24 & 1);
            int n60 = destPos + 57;
            dest[n60] = dest[n60] + (high >>> 25 & 1);
            int n61 = destPos + 58;
            dest[n61] = dest[n61] + (high >>> 26 & 1);
            int n62 = destPos + 59;
            dest[n62] = dest[n62] + (high >>> 27 & 1);
            int n63 = destPos + 60;
            dest[n63] = dest[n63] + (high >>> 28 & 1);
            int n64 = destPos + 61;
            dest[n64] = dest[n64] + (high >>> 29 & 1);
            int n65 = destPos + 62;
            dest[n65] = dest[n65] + (high >>> 30 & 1);
            int n66 = destPos + 63;
            dest[n66] = dest[n66] + (high >>> 31 & 1);
            destPos += 64;
        }
        int countFinish = count & 0x3F;
        int destPosMax2 = destPos + countFinish;
        while (destPos < destPosMax2) {
            int n67 = destPos++;
            dest[n67] = dest[n67] + (int)(src[(int)(srcPos >>> 6)] >>> (int)(srcPos & 0x3FL) & 1L);
            ++srcPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fillBits(long[] dest, long destPos, long count, boolean value) {
        Objects.requireNonNull(dest, "Null dest");
        int dPos = (int)(destPos >>> 6);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            long[] lArray = dest;
            // MONITORENTER : dest
            if (value) {
                int n = dPos;
                dest[n] = dest[n] | maskStart;
            } else {
                int n = dPos;
                dest[n] = dest[n] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            }
            // MONITOREXIT : lArray
            count -= (long)cntStart;
            ++dPos;
        }
        long longValue = value ? -1L : 0L;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            dest[dPos] = longValue;
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long[] lArray = dest;
        // MONITORENTER : dest
        if (value) {
            int n = dPos;
            dest[n] = dest[n] | maskFinish;
            return;
        }
        int n = dPos;
        dest[n] = dest[n] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    public static void fillBitsNoSync(long[] dest, long destPos, long count, boolean value) {
        Objects.requireNonNull(dest, "Null dest");
        int dPos = (int)(destPos >>> 6);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            if (value) {
                int n = dPos;
                dest[n] = dest[n] | maskStart;
            } else {
                int n = dPos;
                dest[n] = dest[n] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            }
            count -= (long)cntStart;
            ++dPos;
        }
        long longValue = value ? -1L : 0L;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            dest[dPos] = longValue;
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish > 0) {
            long maskFinish = (1L << cntFinish) - 1L;
            if (value) {
                int n = dPos;
                dest[n] = dest[n] | maskFinish;
            } else {
                int n = dPos;
                dest[n] = dest[n] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public static boolean areBitsZero(long[] array, long pos, long count) {
        Objects.requireNonNull(array, "Null array");
        int sPos = (int)(pos >>> 6);
        int sPosRem = (int)(pos & 0x3FL);
        int cntStart = -sPosRem & 0x3F;
        long maskStart = -1L << sPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << sPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            if ((array[sPos] & maskStart) != 0L) {
                return false;
            }
            count -= (long)cntStart;
            ++sPos;
        }
        int dPosMax = sPos + (int)(count >>> 6);
        while (sPos < dPosMax) {
            if (array[sPos] != 0L) {
                return false;
            }
            ++sPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish > 0) {
            long maskFinish = (1L << cntFinish) - 1L;
            return (array[sPos] & maskFinish) == 0L;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void notBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                dest[dPos] = src[sPos] ^ 0xFFFFFFFFFFFFFFFFL;
                ++dPos;
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[dPos] = (l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL;
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    public static void notBits(long[] dest, long destPos, long count) {
        PackedBitArrays.notBits(dest, destPos, dest, destPos, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void andBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                int n = dPos++;
                dest[n] = dest[n] & (src[sPos] | maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    int n = dPos;
                    dest[n] = dest[n] & (src[sPos] | maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] & src[sPos];
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            int n = dPos++;
            dest[n] = dest[n] & (v | maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[n] = dest[n] & (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        int n = dPos;
        dest[n] = dest[n] & (v | maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void orBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                int n = dPos++;
                dest[n] = dest[n] | src[sPos] & maskStart;
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    int n = dPos;
                    dest[n] = dest[n] | src[sPos] & maskFinish;
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] | src[sPos];
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            int n = dPos++;
            dest[n] = dest[n] | v & maskStart;
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[n] = dest[n] | (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        int n = dPos;
        dest[n] = dest[n] | v & maskFinish;
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void xorBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (dest[dPos] ^ src[sPos]) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (dest[dPos] ^ src[sPos]) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] ^ src[sPos];
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (dest[dPos] ^ v) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[n] = dest[n] ^ (l | sNext << sPosRem64);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (dest[dPos] ^ v) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void andNotBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = dest[dPos] & (src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = dest[dPos] & (src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] & (src[sPos] ^ 0xFFFFFFFFFFFFFFFFL);
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = dest[dPos] & (v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[n] = dest[n] & ((l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = dest[dPos] & (v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void orNotBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        long sNext;
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        int sPos = (int)(srcPos >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (sPosRem == dPosRem) {
            if (cntStart > 0) {
                long[] lArray = dest;
                // MONITORENTER : dest
                dest[dPos] = (dest[dPos] | src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
                // MONITOREXIT : lArray
                count -= (long)cntStart;
                ++dPos;
                ++sPos;
            }
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = (dest[dPos] | src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                int n = dPos++;
                dest[n] = dest[n] | src[sPos] ^ 0xFFFFFFFFFFFFFFFFL;
                ++sPos;
            }
        }
        int shift = dPosRem - sPosRem;
        if (cntStart > 0) {
            long v;
            if (sPosRem + cntStart <= 64) {
                if (shift > 0) {
                    sNext = src[sPos];
                    v = sNext << shift;
                } else {
                    sNext = src[sPos];
                    v = sNext >>> -shift;
                }
                sPosRem += cntStart;
            } else {
                sNext = src[sPos + 1];
                v = src[sPos] >>> -shift | sNext << 64 + shift;
                ++sPos;
                sPosRem = sPosRem + cntStart & 0x3F;
            }
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = (dest[dPos] | v ^ 0xFFFFFFFFFFFFFFFFL) & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        } else {
            if (count == 0L) {
                return;
            }
            sNext = src[sPos];
        }
        int sPosRem64 = 64 - sPosRem;
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            int n = dPos++;
            long l = sNext >>> sPosRem;
            sNext = src[++sPos];
            dest[n] = dest[n] | (l | sNext << sPosRem64) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem + cntFinish <= 64 ? sNext >>> sPosRem : sNext >>> sPosRem | src[sPos + 1] << sPosRem64;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = (dest[dPos] | v ^ 0xFFFFFFFFFFFFFFFFL) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void reverseBits(long[] dest, long destPos, long[] src, long srcPos, long count) {
        Objects.requireNonNull(dest, "Null dest");
        Objects.requireNonNull(src, "Null src");
        if (count == 0L) {
            return;
        }
        int sPos = (int)((srcPos += count) >>> 6);
        int dPos = (int)(destPos >>> 6);
        int sPosRem = (int)(srcPos & 0x3FL);
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << dPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            long v;
            if (sPosRem >= cntStart) {
                v = src[sPos] >>> sPosRem - cntStart;
                sPosRem -= cntStart;
            } else {
                v = sPosRem == 0 ? src[sPos - 1] >>> 64 - cntStart : src[sPos] << cntStart - sPosRem | src[sPos - 1] >>> 64 + sPosRem - cntStart;
                --sPos;
                sPosRem = sPosRem - cntStart & 0x3F;
            }
            v = Long.reverse(v) >>> 64 - cntStart;
            long[] lArray = dest;
            // MONITORENTER : dest
            dest[dPos] = v << dPosRem & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            // MONITOREXIT : lArray
            if ((count -= (long)cntStart) == 0L) {
                return;
            }
            ++dPos;
        }
        if (sPosRem == 0) {
            int dPosMax = dPos + (int)(count >>> 6);
            while (true) {
                if (dPos >= dPosMax) {
                    int cntFinish = (int)(count & 0x3FL);
                    if (cntFinish <= 0) return;
                    long maskFinish = (1L << cntFinish) - 1L;
                    long[] lArray = dest;
                    // MONITORENTER : dest
                    dest[dPos] = Long.reverse(src[sPos - 1]) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
                    // MONITOREXIT : lArray
                    return;
                }
                dest[dPos] = Long.reverse(src[--sPos]);
                ++dPos;
            }
        }
        int sPosRem64 = 64 - sPosRem;
        long sNext = src[sPos];
        int dPosMax = dPos + (int)(count >>> 6);
        while (dPos < dPosMax) {
            long l = sNext << sPosRem64;
            sNext = src[--sPos];
            dest[dPos] = Long.reverse(l | sNext >>> sPosRem);
            ++dPos;
        }
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish <= 0) return;
        long maskFinish = (1L << cntFinish) - 1L;
        long v = sPosRem >= cntFinish ? sNext << sPosRem64 : sNext << sPosRem64 | src[sPos - 1] >>> sPosRem;
        long[] lArray = dest;
        // MONITORENTER : dest
        dest[dPos] = Long.reverse(v) & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        // MONITOREXIT : lArray
    }

    public static long indexOfBit(long[] src, long lowIndex, long highIndex, boolean value) {
        long maskFinish;
        int index;
        int cntFinish;
        Objects.requireNonNull(src, "Null src");
        if (lowIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: low index = " + lowIndex);
        }
        if (highIndex > (long)src.length << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: high index = " + highIndex);
        }
        if (lowIndex >= highIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        int sPos = (int)(lowIndex >>> 6);
        int sPosRem = (int)(lowIndex & 0x3FL);
        int cntStart = -sPosRem & 0x3F;
        long fromAligned = lowIndex - (long)sPosRem;
        long maskStart = -1L << sPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << sPosRem + cntStart) - 1L;
        }
        if (cntStart > 0) {
            int index2 = Long.numberOfTrailingZeros((value ? src[sPos] : src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskStart);
            if (index2 != 64) {
                return fromAligned + (long)index2;
            }
            count -= (long)cntStart;
            ++sPos;
            fromAligned += 64L;
        }
        if (value) {
            sPosMax = sPos + (int)(count >>> 6);
            while (sPos < sPosMax) {
                index = Long.numberOfTrailingZeros(src[sPos]);
                if (index != 64) {
                    return fromAligned + (long)index;
                }
                ++sPos;
                fromAligned += 64L;
            }
        } else {
            sPosMax = sPos + (int)(count >>> 6);
            while (sPos < sPosMax) {
                index = Long.numberOfTrailingZeros(src[sPos] ^ 0xFFFFFFFFFFFFFFFFL);
                if (index != 64) {
                    return fromAligned + (long)index;
                }
                ++sPos;
                fromAligned += 64L;
            }
        }
        if ((cntFinish = (int)(count & 0x3FL)) > 0 && (index = Long.numberOfTrailingZeros((value ? src[sPos] : src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & (maskFinish = (1L << cntFinish) - 1L))) != 64) {
            return fromAligned + (long)index;
        }
        return -1L;
    }

    public static long lastIndexOfBit(long[] src, long lowIndex, long highIndex, boolean value) {
        long maskFinish;
        int index;
        int cntFinish;
        Objects.requireNonNull(src, "Null src");
        if (lowIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: low index = " + lowIndex);
        }
        if (highIndex > (long)src.length << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: high index = " + highIndex);
        }
        if (lowIndex >= highIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        int sPos = (int)(highIndex - 1L >>> 6);
        int cntStart = (int)highIndex & 0x3F;
        long fromAligned = (highIndex - 1L & 0xFFFFFFFFFFFFFFC0L) + 63L;
        long maskStart = (1L << cntStart) - 1L;
        if ((long)cntStart > count) {
            maskStart &= -1L << (int)((long)cntStart - count);
            cntStart = (int)count;
        }
        if (cntStart > 0) {
            int index2 = Long.numberOfLeadingZeros((value ? src[sPos] : src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & maskStart);
            if (index2 != 64) {
                return fromAligned - (long)index2;
            }
            count -= (long)cntStart;
            --sPos;
            fromAligned -= 64L;
        }
        if (value) {
            sPosMin = sPos - (int)(count >>> 6);
            while (sPos > sPosMin) {
                index = Long.numberOfLeadingZeros(src[sPos]);
                if (index != 64) {
                    return fromAligned - (long)index;
                }
                --sPos;
                fromAligned -= 64L;
            }
        } else {
            sPosMin = sPos - (int)(count >>> 6);
            while (sPos > sPosMin) {
                index = Long.numberOfLeadingZeros(src[sPos] ^ 0xFFFFFFFFFFFFFFFFL);
                if (index != 64) {
                    return fromAligned - (long)index;
                }
                --sPos;
                fromAligned -= 64L;
            }
        }
        if ((cntFinish = (int)(count & 0x3FL)) > 0 && (index = Long.numberOfLeadingZeros((value ? src[sPos] : src[sPos] ^ 0xFFFFFFFFFFFFFFFFL) & (maskFinish = -1L << 64 - cntFinish))) != 64) {
            return fromAligned - (long)index;
        }
        return -1L;
    }

    public static long cardinality(long[] src, long fromIndex, long toIndex) {
        Objects.requireNonNull(src, "Null src argument in cardinality method");
        if (fromIndex < 0L) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex);
        }
        if (toIndex > (long)src.length << 6) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: end index = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("Bit array index out of range: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        long count = toIndex - fromIndex;
        int sPos = (int)(fromIndex >>> 6);
        int sPosRem = (int)(fromIndex & 0x3FL);
        int cntStart = -sPosRem & 0x3F;
        long maskStart = -1L << sPosRem;
        if ((long)cntStart > count) {
            cntStart = (int)count;
            maskStart &= (1L << sPosRem + cntStart) - 1L;
        }
        long result = 0L;
        if (cntStart > 0) {
            result += (long)Long.bitCount(src[sPos] & maskStart);
            count -= (long)cntStart;
            ++sPos;
        }
        int sPosMax = sPos + (int)(count >>> 6);
        result += PackedBitArrays.bitCount(src, sPos, sPosMax);
        sPos = sPosMax;
        int cntFinish = (int)(count & 0x3FL);
        if (cntFinish > 0) {
            long maskFinish = (1L << cntFinish) - 1L;
            result += (long)Long.bitCount(src[sPos] & maskFinish);
        }
        return result;
    }

    static long bitCount(long[] src, int from, int to) {
        long result = 0L;
        for (int i = from; i < to; ++i) {
            result += (long)Long.bitCount(src[i]);
        }
        return result;
    }

    static long getBits64Impl(long[] src, long srcPos, int count) {
        long srcPosDiv64 = srcPos >>> 6;
        if (count == 0 || srcPosDiv64 >= (long)src.length) {
            return 0L;
        }
        int sPosRem = (int)(srcPos & 0x3FL);
        int sPos = (int)srcPosDiv64;
        int bitsLeft = 64 - sPosRem;
        if (count > bitsLeft) {
            long actualBitsLow = src[sPos] >>> sPosRem;
            if (++sPos >= src.length) {
                return actualBitsLow;
            }
            long actualBitsHigh = src[sPos] & -1L >>> 64 - (count - bitsLeft);
            return actualBitsLow | actualBitsHigh << bitsLeft;
        }
        return (src[sPos] & -1L >>> bitsLeft - count) >>> sPosRem;
    }

    static void setBits64Impl(long[] dest, long destPos, long bits, int count) {
        long destPosDiv64 = destPos >>> 6;
        if (count == 0 || destPosDiv64 >= (long)dest.length) {
            return;
        }
        int dPosRem = (int)(destPos & 0x3FL);
        int cntStart = -dPosRem & 0x3F;
        long maskStart = -1L << dPosRem;
        if (cntStart > count) {
            cntStart = count;
            maskStart &= (1L << dPosRem + count) - 1L;
        }
        int dPos = (int)destPosDiv64;
        if (cntStart > 0) {
            dest[dPos] = bits << dPosRem & maskStart | dest[dPos] & (maskStart ^ 0xFFFFFFFFFFFFFFFFL);
            ++dPos;
            count -= cntStart;
            bits >>>= cntStart;
        }
        if (count > 0 && dPos < dest.length) {
            long maskFinish = (2L << count - 1) - 1L;
            dest[dPos] = bits & maskFinish | dest[dPos] & (maskFinish ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

