/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutablePNumberArray;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePNumberArray;

public interface PNumberArray
extends PArray {
    public Class<? extends PNumberArray> type();

    public Class<? extends UpdatablePNumberArray> updatableType();

    public Class<? extends MutablePNumberArray> mutableType();

    default public Matrix<? extends PNumberArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    public static UpdatablePNumberArray newArray(MemoryModel memoryModel, Class<?> elementType, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(elementType, "Null element type");
        if (!Arrays.isNumberElementType(elementType)) {
            throw new IllegalArgumentException("Not a numeric primitive type: " + String.valueOf(elementType));
        }
        return (UpdatablePNumberArray)memoryModel.newUnresizableArray(elementType, length);
    }

    public static UpdatablePNumberArray newArray(Class<?> elementType, long length) {
        return PNumberArray.newArray(Arrays.SMM, elementType, length);
    }

    public static UpdatablePNumberArray as(Object array) {
        return SimpleMemoryModel.asUpdatablePNumberArray(array);
    }
}

