/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractInterleavingBandsOperation;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatablePArray;

abstract class InterleavingBandsUnpacker
extends AbstractInterleavingBandsOperation {
    final UpdatablePArray[] bands;
    final PArray packed;

    InterleavingBandsUnpacker(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
        super(context, Objects.requireNonNull(bands), Objects.requireNonNull(packed));
        this.bands = bands;
        this.packed = packed;
    }

    public static InterleavingBandsUnpacker getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
        if (InterleavingBandsUnpacker.allBandsDirect(bands)) {
            if (packed instanceof CharArray) {
                return DirectForChars.getInstance(context, bands, packed);
            }
            if (packed instanceof ByteArray) {
                return DirectForBytes.getInstance(context, bands, packed);
            }
            if (packed instanceof ShortArray) {
                return DirectForShorts.getInstance(context, bands, packed);
            }
            if (packed instanceof IntArray) {
                return DirectForInts.getInstance(context, bands, packed);
            }
            if (packed instanceof LongArray) {
                return DirectForLongs.getInstance(context, bands, packed);
            }
            if (packed instanceof FloatArray) {
                return DirectForFloats.getInstance(context, bands, packed);
            }
            if (packed instanceof DoubleArray) {
                return DirectForDoubles.getInstance(context, bands, packed);
            }
            assert (packed instanceof BitArray);
        }
        if (packed instanceof BitArray) {
            return new ForBooleans(context, bands, packed);
        }
        if (packed instanceof CharArray) {
            return new ForChars(context, bands, packed);
        }
        if (packed instanceof ByteArray) {
            return new ForBytes(context, bands, packed);
        }
        if (packed instanceof ShortArray) {
            return new ForShorts(context, bands, packed);
        }
        if (packed instanceof IntArray) {
            return new ForInts(context, bands, packed);
        }
        if (packed instanceof LongArray) {
            return new ForLongs(context, bands, packed);
        }
        if (packed instanceof FloatArray) {
            return new ForFloats(context, bands, packed);
        }
        if (packed instanceof DoubleArray) {
            return new ForDoubles(context, bands, packed);
        }
        throw new AssertionError((Object)("Illegal " + String.valueOf(packed)));
    }

    @Override
    public void process() {
        if (this.bands.length == 1) {
            Arrays.copy(this.context(), this.bands[0], this.packed);
        } else {
            super.process();
        }
    }

    @Override
    public abstract void close();

    @Override
    protected abstract void processSubArr(long var1, int var3, int var4);

    static class DirectForChars
    extends InterleavingBandsUnpacker {
        final char[][] bandArrays;
        final int[] bandArraysOffsets;
        final char[][] threadPackedArray;

        DirectForChars(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new char[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (char[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new char[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (char[])CHAR_BUFFERS.requestArray();
            }
        }

        public static DirectForChars getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForChars(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                CHAR_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            char[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                char[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForChars {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                char[] packedArray = this.threadPackedArray[threadIndex];
                char[] band0 = this.bandArrays[0];
                char[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForChars {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                char[] packedArray = this.threadPackedArray[threadIndex];
                char[] band0 = this.bandArrays[0];
                char[] band1 = this.bandArrays[1];
                char[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForChars {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                char[] packedArray = this.threadPackedArray[threadIndex];
                char[] band0 = this.bandArrays[0];
                char[] band1 = this.bandArrays[1];
                char[] band2 = this.bandArrays[2];
                char[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForBytes
    extends InterleavingBandsUnpacker {
        final byte[][] bandArrays;
        final int[] bandArraysOffsets;
        final byte[][] threadPackedArray;

        DirectForBytes(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new byte[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (byte[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new byte[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (byte[])BYTE_BUFFERS.requestArray();
            }
        }

        public static DirectForBytes getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForBytes(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                BYTE_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            byte[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                byte[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForBytes {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                byte[] packedArray = this.threadPackedArray[threadIndex];
                byte[] band0 = this.bandArrays[0];
                byte[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForBytes {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                byte[] packedArray = this.threadPackedArray[threadIndex];
                byte[] band0 = this.bandArrays[0];
                byte[] band1 = this.bandArrays[1];
                byte[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForBytes {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                byte[] packedArray = this.threadPackedArray[threadIndex];
                byte[] band0 = this.bandArrays[0];
                byte[] band1 = this.bandArrays[1];
                byte[] band2 = this.bandArrays[2];
                byte[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForShorts
    extends InterleavingBandsUnpacker {
        final short[][] bandArrays;
        final int[] bandArraysOffsets;
        final short[][] threadPackedArray;

        DirectForShorts(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new short[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (short[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new short[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (short[])SHORT_BUFFERS.requestArray();
            }
        }

        public static DirectForShorts getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForShorts(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                SHORT_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            short[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                short[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForShorts {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                short[] packedArray = this.threadPackedArray[threadIndex];
                short[] band0 = this.bandArrays[0];
                short[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForShorts {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                short[] packedArray = this.threadPackedArray[threadIndex];
                short[] band0 = this.bandArrays[0];
                short[] band1 = this.bandArrays[1];
                short[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForShorts {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                short[] packedArray = this.threadPackedArray[threadIndex];
                short[] band0 = this.bandArrays[0];
                short[] band1 = this.bandArrays[1];
                short[] band2 = this.bandArrays[2];
                short[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForInts
    extends InterleavingBandsUnpacker {
        final int[][] bandArrays;
        final int[] bandArraysOffsets;
        final int[][] threadPackedArray;

        DirectForInts(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new int[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (int[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new int[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (int[])INT_BUFFERS.requestArray();
            }
        }

        public static DirectForInts getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForInts(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                INT_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            int[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForInts {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                int[] packedArray = this.threadPackedArray[threadIndex];
                int[] band0 = this.bandArrays[0];
                int[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForInts {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                int[] packedArray = this.threadPackedArray[threadIndex];
                int[] band0 = this.bandArrays[0];
                int[] band1 = this.bandArrays[1];
                int[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForInts {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                int[] packedArray = this.threadPackedArray[threadIndex];
                int[] band0 = this.bandArrays[0];
                int[] band1 = this.bandArrays[1];
                int[] band2 = this.bandArrays[2];
                int[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForLongs
    extends InterleavingBandsUnpacker {
        final long[][] bandArrays;
        final int[] bandArraysOffsets;
        final long[][] threadPackedArray;

        DirectForLongs(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new long[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (long[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new long[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (long[])LONG_BUFFERS.requestArray();
            }
        }

        public static DirectForLongs getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForLongs(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                LONG_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            long[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                long[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForLongs {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                long[] packedArray = this.threadPackedArray[threadIndex];
                long[] band0 = this.bandArrays[0];
                long[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForLongs {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                long[] packedArray = this.threadPackedArray[threadIndex];
                long[] band0 = this.bandArrays[0];
                long[] band1 = this.bandArrays[1];
                long[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForLongs {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                long[] packedArray = this.threadPackedArray[threadIndex];
                long[] band0 = this.bandArrays[0];
                long[] band1 = this.bandArrays[1];
                long[] band2 = this.bandArrays[2];
                long[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForFloats
    extends InterleavingBandsUnpacker {
        final float[][] bandArrays;
        final int[] bandArraysOffsets;
        final float[][] threadPackedArray;

        DirectForFloats(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new float[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (float[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new float[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (float[])FLOAT_BUFFERS.requestArray();
            }
        }

        public static DirectForFloats getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForFloats(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                FLOAT_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            float[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                float[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForFloats {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                float[] packedArray = this.threadPackedArray[threadIndex];
                float[] band0 = this.bandArrays[0];
                float[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForFloats {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                float[] packedArray = this.threadPackedArray[threadIndex];
                float[] band0 = this.bandArrays[0];
                float[] band1 = this.bandArrays[1];
                float[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForFloats {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                float[] packedArray = this.threadPackedArray[threadIndex];
                float[] band0 = this.bandArrays[0];
                float[] band1 = this.bandArrays[1];
                float[] band2 = this.bandArrays[2];
                float[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class DirectForDoubles
    extends InterleavingBandsUnpacker {
        final double[][] bandArrays;
        final int[] bandArraysOffsets;
        final double[][] threadPackedArray;

        DirectForDoubles(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            this.bandArrays = new double[bands.length][];
            this.bandArraysOffsets = new int[bands.length];
            for (int b = 0; b < bands.length; ++b) {
                this.bandArrays[b] = (double[])((DirectAccessible)((Object)bands[b])).javaArray();
                this.bandArraysOffsets[b] = ((DirectAccessible)((Object)bands[b])).javaArrayOffset();
            }
            this.threadPackedArray = new double[this.numberOfTasks()][];
            for (int k = 0; k < this.threadPackedArray.length; ++k) {
                this.threadPackedArray[k] = (double[])DOUBLE_BUFFERS.requestArray();
            }
        }

        public static DirectForDoubles getInstance(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            return switch (bands.length) {
                case 2 -> new For2Channels(context, bands, packed);
                case 3 -> new For3Channels(context, bands, packed);
                case 4 -> new For4Channels(context, bands, packed);
                default -> new DirectForDoubles(context, bands, packed);
            };
        }

        @Override
        public void close() {
            for (int k = this.threadPackedArray.length - 1; k >= 0; --k) {
                DOUBLE_BUFFERS.releaseArray(this.threadPackedArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            double[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                double[] bandArray = this.bandArrays[b];
                int p = (int)position + this.bandArraysOffsets[b];
                int pTo = p + count;
                int disp = b;
                while (p < pTo) {
                    bandArray[p] = packedArray[disp];
                    ++p;
                    disp += step;
                }
            }
        }

        static class For2Channels
        extends DirectForDoubles {
            For2Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 2);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                double[] packedArray = this.threadPackedArray[threadIndex];
                double[] band0 = this.bandArrays[0];
                double[] band1 = this.bandArrays[1];
                this.packed.getData(2L * position, packedArray, 0, 2 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                }
            }
        }

        static class For3Channels
        extends DirectForDoubles {
            For3Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 3);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                double[] packedArray = this.threadPackedArray[threadIndex];
                double[] band0 = this.bandArrays[0];
                double[] band1 = this.bandArrays[1];
                double[] band2 = this.bandArrays[2];
                this.packed.getData(3L * position, packedArray, 0, 3 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                }
            }
        }

        static class For4Channels
        extends DirectForDoubles {
            For4Channels(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
                super(context, bands, packed);
                assert (bands.length == 4);
            }

            @Override
            protected void processSubArr(long position, int count, int threadIndex) {
                assert (count <= this.blockSize) : "Illegal count in processSubArr";
                double[] packedArray = this.threadPackedArray[threadIndex];
                double[] band0 = this.bandArrays[0];
                double[] band1 = this.bandArrays[1];
                double[] band2 = this.bandArrays[2];
                double[] band3 = this.bandArrays[3];
                this.packed.getData(4L * position, packedArray, 0, 4 * count);
                int p0 = (int)position + this.bandArraysOffsets[0];
                int p1 = (int)position + this.bandArraysOffsets[1];
                int p2 = (int)position + this.bandArraysOffsets[2];
                int p3 = (int)position + this.bandArraysOffsets[3];
                int p0To = p0 + count;
                int disp = 0;
                while (p0 < p0To) {
                    band0[p0++] = packedArray[disp++];
                    band1[p1++] = packedArray[disp++];
                    band2[p2++] = packedArray[disp++];
                    band3[p3++] = packedArray[disp++];
                }
            }
        }
    }

    static class ForBooleans
    extends InterleavingBandsUnpacker {
        private final boolean[][] threadBandArray = new boolean[this.numberOfTasks()][];
        private final boolean[][] threadPackedArray = new boolean[this.numberOfTasks()][];

        ForBooleans(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (boolean[])BOOLEAN_BUFFERS.requestArray();
                this.threadPackedArray[k] = (boolean[])BOOLEAN_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                BOOLEAN_BUFFERS.releaseArray(this.threadPackedArray[k]);
                BOOLEAN_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            boolean[] bandArray = this.threadBandArray[threadIndex];
            boolean[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForChars
    extends InterleavingBandsUnpacker {
        private final char[][] threadBandArray = new char[this.numberOfTasks()][];
        private final char[][] threadPackedArray = new char[this.numberOfTasks()][];

        ForChars(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (char[])CHAR_BUFFERS.requestArray();
                this.threadPackedArray[k] = (char[])CHAR_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                CHAR_BUFFERS.releaseArray(this.threadPackedArray[k]);
                CHAR_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            char[] bandArray = this.threadBandArray[threadIndex];
            char[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForBytes
    extends InterleavingBandsUnpacker {
        private final byte[][] threadBandArray = new byte[this.numberOfTasks()][];
        private final byte[][] threadPackedArray = new byte[this.numberOfTasks()][];

        ForBytes(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (byte[])BYTE_BUFFERS.requestArray();
                this.threadPackedArray[k] = (byte[])BYTE_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                BYTE_BUFFERS.releaseArray(this.threadPackedArray[k]);
                BYTE_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            byte[] bandArray = this.threadBandArray[threadIndex];
            byte[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForShorts
    extends InterleavingBandsUnpacker {
        private final short[][] threadBandArray = new short[this.numberOfTasks()][];
        private final short[][] threadPackedArray = new short[this.numberOfTasks()][];

        ForShorts(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (short[])SHORT_BUFFERS.requestArray();
                this.threadPackedArray[k] = (short[])SHORT_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                SHORT_BUFFERS.releaseArray(this.threadPackedArray[k]);
                SHORT_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            short[] bandArray = this.threadBandArray[threadIndex];
            short[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForInts
    extends InterleavingBandsUnpacker {
        private final int[][] threadBandArray = new int[this.numberOfTasks()][];
        private final int[][] threadPackedArray = new int[this.numberOfTasks()][];

        ForInts(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (int[])INT_BUFFERS.requestArray();
                this.threadPackedArray[k] = (int[])INT_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                INT_BUFFERS.releaseArray(this.threadPackedArray[k]);
                INT_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            int[] bandArray = this.threadBandArray[threadIndex];
            int[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForLongs
    extends InterleavingBandsUnpacker {
        private final long[][] threadBandArray = new long[this.numberOfTasks()][];
        private final long[][] threadPackedArray = new long[this.numberOfTasks()][];

        ForLongs(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (long[])LONG_BUFFERS.requestArray();
                this.threadPackedArray[k] = (long[])LONG_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                LONG_BUFFERS.releaseArray(this.threadPackedArray[k]);
                LONG_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            long[] bandArray = this.threadBandArray[threadIndex];
            long[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForFloats
    extends InterleavingBandsUnpacker {
        private final float[][] threadBandArray = new float[this.numberOfTasks()][];
        private final float[][] threadPackedArray = new float[this.numberOfTasks()][];

        ForFloats(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (float[])FLOAT_BUFFERS.requestArray();
                this.threadPackedArray[k] = (float[])FLOAT_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                FLOAT_BUFFERS.releaseArray(this.threadPackedArray[k]);
                FLOAT_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            float[] bandArray = this.threadBandArray[threadIndex];
            float[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }

    static class ForDoubles
    extends InterleavingBandsUnpacker {
        private final double[][] threadBandArray = new double[this.numberOfTasks()][];
        private final double[][] threadPackedArray = new double[this.numberOfTasks()][];

        ForDoubles(ArrayContext context, UpdatablePArray[] bands, PArray packed) {
            super(context, bands, packed);
            for (int k = 0; k < this.threadBandArray.length; ++k) {
                this.threadBandArray[k] = (double[])DOUBLE_BUFFERS.requestArray();
                this.threadPackedArray[k] = (double[])DOUBLE_BUFFERS.requestArray();
            }
        }

        @Override
        public void close() {
            for (int k = this.threadBandArray.length - 1; k >= 0; --k) {
                DOUBLE_BUFFERS.releaseArray(this.threadPackedArray[k]);
                DOUBLE_BUFFERS.releaseArray(this.threadBandArray[k]);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            assert (count <= this.blockSize) : "Illegal count in processSubArr";
            double[] bandArray = this.threadBandArray[threadIndex];
            double[] packedArray = this.threadPackedArray[threadIndex];
            int step = this.bands.length;
            this.packed.getData(position * (long)step, packedArray, 0, count * step);
            for (int b = 0; b < this.bands.length; ++b) {
                int k = 0;
                int disp = b;
                while (k < count) {
                    bandArray[k] = packedArray[disp];
                    ++k;
                    disp += step;
                }
                this.bands[b].setData(position, bandArray, 0, count);
            }
        }
    }
}

