/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.DataBitStorage;
import net.algart.arrays.DataStorage;
import net.algart.arrays.JBuffers;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PackedBitBuffers;
import net.algart.arrays.TooLargeArrayException;

class DirectDataStorages {
    private DirectDataStorages() {
    }

    static class DirectDoubleStorage
    extends DirectStorage {
        private DoubleBuffer db;

        DirectDoubleStorage() {
        }

        DirectDoubleStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.db = byteBuffer.asDoubleBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectDoubleStorage();
        }

        public String toString() {
            return "direct NIO double storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        @Override
        final double getDouble(long index) {
            return this.db.get((int)index);
        }

        @Override
        final void setDouble(long index, double value) {
            this.db.put((int)index, value);
        }

        @Override
        final long indexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfDouble(this.db, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfDouble(this.db, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.db.put((int)destIndex, this.db.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            double v1 = this.db.get(i1);
            double v2 = this.db.get(i2);
            this.db.put(i1, v2);
            this.db.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            DoubleBuffer dup = this.db.duplicate();
            dup.position((int)pos);
            dup.get((double[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            DoubleBuffer dup = this.db.duplicate();
            dup.position((int)pos);
            dup.put((double[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillDoubleBuffer(this.db, (int)pos, (int)count, (Double)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, doubleZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectDoubleStorage) {
                JBuffers.copyDoubleBuffer(this.db, (int)destPos, ((DirectDoubleStorage)src).db, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectDoubleStorage) {
                JBuffers.swapDoubleBuffer(((DirectDoubleStorage)another).db, (int)anotherPos, this.db, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.db = this.bb == null ? null : this.bb.asDoubleBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minDoubleArrayAndBuffer((double[])destArray, destArrayOffset, this.db, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxDoubleArrayAndBuffer((double[])destArray, destArrayOffset, this.db, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addDoubleBufferToArray(destArray, destArrayOffset, this.db, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addDoubleBufferToArray(destArray, destArrayOffset, this.db, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractDoubleBufferFromArray((double[])destArray, destArrayOffset, this.db, (int)pos, count);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfDoubleArrayAndBuffer((double[])destArray, destArrayOffset, this.db, (int)pos, count);
        }
    }

    static class DirectFloatStorage
    extends DirectStorage {
        private FloatBuffer fb;

        DirectFloatStorage() {
        }

        DirectFloatStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.fb = byteBuffer.asFloatBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectFloatStorage();
        }

        public String toString() {
            return "direct NIO float storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 2;
        }

        @Override
        final float getFloat(long index) {
            return this.fb.get((int)index);
        }

        @Override
        final void setFloat(long index, float value) {
            this.fb.put((int)index, value);
        }

        @Override
        final long indexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfFloat(this.fb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfFloat(this.fb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.fb.put((int)destIndex, this.fb.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            float v1 = this.fb.get(i1);
            float v2 = this.fb.get(i2);
            this.fb.put(i1, v2);
            this.fb.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            FloatBuffer dup = this.fb.duplicate();
            dup.position((int)pos);
            dup.get((float[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            FloatBuffer dup = this.fb.duplicate();
            dup.position((int)pos);
            dup.put((float[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillFloatBuffer(this.fb, (int)pos, (int)count, ((Float)fillerWrapper).floatValue());
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, floatZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectFloatStorage) {
                JBuffers.copyFloatBuffer(this.fb, (int)destPos, ((DirectFloatStorage)src).fb, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectFloatStorage) {
                JBuffers.swapFloatBuffer(((DirectFloatStorage)another).fb, (int)anotherPos, this.fb, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.fb = this.bb == null ? null : this.bb.asFloatBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minFloatArrayAndBuffer((float[])destArray, destArrayOffset, this.fb, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxFloatArrayAndBuffer((float[])destArray, destArrayOffset, this.fb, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addFloatBufferToArray(destArray, destArrayOffset, this.fb, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addFloatBufferToArray(destArray, destArrayOffset, this.fb, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractFloatBufferFromArray((float[])destArray, destArrayOffset, this.fb, (int)pos, count);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfFloatArrayAndBuffer((float[])destArray, destArrayOffset, this.fb, (int)pos, count);
        }
    }

    static class DirectLongStorage
    extends DirectStorage {
        private LongBuffer lb;

        DirectLongStorage() {
        }

        DirectLongStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.lb = byteBuffer.asLongBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectLongStorage();
        }

        public String toString() {
            return "direct NIO long storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        @Override
        final long getLong(long index) {
            return this.lb.get((int)index);
        }

        @Override
        final void setLong(long index, long value) {
            this.lb.put((int)index, value);
        }

        @Override
        final long indexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfLong(this.lb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfLong(this.lb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.lb.put((int)destIndex, this.lb.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            long v1 = this.lb.get(i1);
            long v2 = this.lb.get(i2);
            this.lb.put(i1, v2);
            this.lb.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            LongBuffer dup = this.lb.duplicate();
            dup.position((int)pos);
            dup.get((long[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            LongBuffer dup = this.lb.duplicate();
            dup.position((int)pos);
            dup.put((long[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillLongBuffer(this.lb, (int)pos, (int)count, (Long)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, longZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectLongStorage) {
                JBuffers.copyLongBuffer(this.lb, (int)destPos, ((DirectLongStorage)src).lb, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectLongStorage) {
                JBuffers.swapLongBuffer(((DirectLongStorage)another).lb, (int)anotherPos, this.lb, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.lb = this.bb == null ? null : this.bb.asLongBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minLongArrayAndBuffer((long[])destArray, destArrayOffset, this.lb, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxLongArrayAndBuffer((long[])destArray, destArrayOffset, this.lb, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addLongBufferToArray(destArray, destArrayOffset, this.lb, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addLongBufferToArray(destArray, destArrayOffset, this.lb, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractLongBufferFromArray((long[])destArray, destArrayOffset, this.lb, (int)pos, count);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfLongArrayAndBuffer((long[])destArray, destArrayOffset, this.lb, (int)pos, count);
        }
    }

    static class DirectIntStorage
    extends DirectStorage {
        private IntBuffer ib;

        DirectIntStorage() {
        }

        DirectIntStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.ib = byteBuffer.asIntBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectIntStorage();
        }

        public String toString() {
            return "direct NIO int storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 2;
        }

        @Override
        final int getInt(long index) {
            return this.ib.get((int)index);
        }

        @Override
        final void setInt(long index, int value) {
            this.ib.put((int)index, value);
        }

        @Override
        final long indexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfInt(this.ib, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfInt(this.ib, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.ib.put((int)destIndex, this.ib.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            int v1 = this.ib.get(i1);
            int v2 = this.ib.get(i2);
            this.ib.put(i1, v2);
            this.ib.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            IntBuffer dup = this.ib.duplicate();
            dup.position((int)pos);
            dup.get((int[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            IntBuffer dup = this.ib.duplicate();
            dup.position((int)pos);
            dup.put((int[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillIntBuffer(this.ib, (int)pos, (int)count, (Integer)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, intZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectIntStorage) {
                JBuffers.copyIntBuffer(this.ib, (int)destPos, ((DirectIntStorage)src).ib, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectIntStorage) {
                JBuffers.swapIntBuffer(((DirectIntStorage)another).ib, (int)anotherPos, this.ib, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.ib = this.bb == null ? null : this.bb.asIntBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minIntArrayAndBuffer((int[])destArray, destArrayOffset, this.ib, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxIntArrayAndBuffer((int[])destArray, destArrayOffset, this.ib, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addIntBufferToArray(destArray, destArrayOffset, this.ib, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addIntBufferToArray(destArray, destArrayOffset, this.ib, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractIntBufferFromArray((int[])destArray, destArrayOffset, this.ib, (int)pos, count, truncateOverflows);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfIntArrayAndBuffer((int[])destArray, destArrayOffset, this.ib, (int)pos, count, truncateOverflows);
        }
    }

    static class DirectCharStorage
    extends DirectStorage {
        private CharBuffer cb;

        DirectCharStorage() {
        }

        DirectCharStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.cb = byteBuffer.asCharBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectCharStorage();
        }

        public String toString() {
            return "direct NIO char storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 1;
        }

        @Override
        final char getChar(long index) {
            return this.cb.get((int)index);
        }

        @Override
        final void setChar(long index, char value) {
            this.cb.put((int)index, value);
        }

        @Override
        final long indexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfChar(this.cb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfChar(this.cb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.cb.put((int)destIndex, this.cb.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            char v1 = this.cb.get(i1);
            char v2 = this.cb.get(i2);
            this.cb.put(i1, v2);
            this.cb.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            CharBuffer dup = this.cb.duplicate();
            dup.position((int)pos);
            dup.get((char[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            CharBuffer dup = this.cb.duplicate();
            dup.position((int)pos);
            dup.put((char[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillCharBuffer(this.cb, (int)pos, (int)count, ((Character)fillerWrapper).charValue());
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, charZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectCharStorage) {
                JBuffers.copyCharBuffer(this.cb, (int)destPos, ((DirectCharStorage)src).cb, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectCharStorage) {
                JBuffers.swapCharBuffer(((DirectCharStorage)another).cb, (int)anotherPos, this.cb, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.cb = this.bb == null ? null : this.bb.asCharBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minCharArrayAndBuffer((char[])destArray, destArrayOffset, this.cb, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxCharArrayAndBuffer((char[])destArray, destArrayOffset, this.cb, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addCharBufferToArray(destArray, destArrayOffset, this.cb, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addCharBufferToArray(destArray, destArrayOffset, this.cb, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractCharBufferFromArray((char[])destArray, destArrayOffset, this.cb, (int)pos, count, truncateOverflows);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfCharArrayAndBuffer((char[])destArray, destArrayOffset, this.cb, (int)pos, count);
        }
    }

    static class DirectShortStorage
    extends DirectStorage {
        private ShortBuffer sb;

        DirectShortStorage() {
        }

        DirectShortStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.sb = byteBuffer.asShortBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectShortStorage();
        }

        public String toString() {
            return "direct NIO short storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 1;
        }

        @Override
        final short getShort(long index) {
            return this.sb.get((int)index);
        }

        @Override
        final void setShort(long index, short value) {
            this.sb.put((int)index, value);
        }

        @Override
        final long indexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfShort(this.sb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfShort(this.sb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.sb.put((int)destIndex, this.sb.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            short v1 = this.sb.get(i1);
            short v2 = this.sb.get(i2);
            this.sb.put(i1, v2);
            this.sb.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            ShortBuffer dup = this.sb.duplicate();
            dup.position((int)pos);
            dup.get((short[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            ShortBuffer dup = this.sb.duplicate();
            dup.position((int)pos);
            dup.put((short[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillShortBuffer(this.sb, (int)pos, (int)count, (Short)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, shortZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectShortStorage) {
                JBuffers.copyShortBuffer(this.sb, (int)destPos, ((DirectShortStorage)src).sb, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectShortStorage) {
                JBuffers.swapShortBuffer(((DirectShortStorage)another).sb, (int)anotherPos, this.sb, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void setSpecificBuffer() {
            this.sb = this.bb == null ? null : this.bb.asShortBuffer();
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minShortArrayAndBuffer((short[])destArray, destArrayOffset, this.sb, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxShortArrayAndBuffer((short[])destArray, destArrayOffset, this.sb, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addShortBufferToArray(destArray, destArrayOffset, this.sb, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addShortBufferToArray(destArray, destArrayOffset, this.sb, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractShortBufferFromArray((short[])destArray, destArrayOffset, this.sb, (int)pos, count, truncateOverflows);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfShortArrayAndBuffer((short[])destArray, destArrayOffset, this.sb, (int)pos, count);
        }
    }

    static class DirectByteStorage
    extends DirectStorage {
        DirectByteStorage() {
        }

        DirectByteStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectByteStorage();
        }

        public String toString() {
            return "direct NIO byte storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 0;
        }

        @Override
        final byte getByte(long index) {
            return this.bb.get((int)index);
        }

        @Override
        final void setByte(long index, byte value) {
            this.bb.put((int)index, value);
        }

        @Override
        final long indexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.indexOfByte(this.bb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            if (lowIndex >= highIndex) {
                return -1L;
            }
            return JBuffers.lastIndexOfByte(this.bb, (int)lowIndex, (int)highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.bb.put((int)destIndex, this.bb.get((int)srcIndex));
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            byte v1 = this.bb.get(i1);
            byte v2 = this.bb.get(i2);
            this.bb.put(i1, v2);
            this.bb.put(i2, v1);
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            ByteBuffer dup = this.bb.duplicate();
            dup.position((int)pos);
            dup.get((byte[])destArray, destArrayOffset, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            ByteBuffer dup = this.bb.duplicate();
            dup.position((int)pos);
            dup.put((byte[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            JBuffers.fillByteBuffer(this.bb, (int)pos, (int)count, (Byte)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, byteZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectByteStorage) {
                JBuffers.copyByteBuffer(this.bb, (int)destPos, ((DirectByteStorage)src).bb, (int)srcPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectByteStorage) {
                JBuffers.swapByteBuffer(((DirectByteStorage)another).bb, (int)anotherPos, this.bb, (int)thisPos, (int)count);
                return true;
            }
            return false;
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.minByteArrayAndBuffer((byte[])destArray, destArrayOffset, this.bb, (int)pos, count);
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxByteArrayAndBuffer((byte[])destArray, destArrayOffset, this.bb, (int)pos, count);
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addByteBufferToArray(destArray, destArrayOffset, this.bb, (int)pos, count);
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addByteBufferToArray(destArray, destArrayOffset, this.bb, (int)pos, count, mult);
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractByteBufferFromArray((byte[])destArray, destArrayOffset, this.bb, (int)pos, count, truncateOverflows);
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfByteArrayAndBuffer((byte[])destArray, destArrayOffset, this.bb, (int)pos, count);
        }

        @Override
        void setSpecificBuffer() {
        }
    }

    static class DirectBitStorage
    extends DirectStorage
    implements DataBitStorage {
        private LongBuffer lb;

        DirectBitStorage() {
        }

        DirectBitStorage(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
            this.lb = byteBuffer.asLongBuffer();
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new DirectBitStorage();
        }

        public String toString() {
            return "direct NIO bit storage: @" + Integer.toHexString(System.identityHashCode(this.bb)) + " on " + String.valueOf(this.bb);
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        @Override
        final boolean getBit(long index) {
            int ii = (int)(index >>> 6);
            int bit = (int)index & 0x3F;
            return (this.lb.get(ii) & 1L << bit) != 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void setBit(long index, boolean value) {
            int ii = (int)(index >>> 6);
            int bit = (int)index & 0x3F;
            LongBuffer longBuffer = this.lb;
            synchronized (longBuffer) {
                if (value) {
                    this.lb.put(ii, this.lb.get(ii) | 1L << bit);
                } else {
                    this.lb.put(ii, this.lb.get(ii) & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }

        @Override
        final void setBitNoSync(long index, boolean value) {
            int ii = (int)(index >>> 6);
            int bit = (int)index & 0x3F;
            if (value) {
                this.lb.put(ii, this.lb.get(ii) | 1L << bit);
            } else {
                this.lb.put(ii, this.lb.get(ii) & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }

        @Override
        long getBits64(long arrayPos, int count) {
            return PackedBitBuffers.getBits64(this.lb, arrayPos, count);
        }

        @Override
        void setBits64(long arrayPos, long bits, int count) {
            PackedBitBuffers.setBits64(this.lb, arrayPos, bits, count);
        }

        @Override
        void setBits64NoSync(long arrayPos, long bits, int count) {
            PackedBitBuffers.setBits64NoSync(this.lb, arrayPos, bits, count);
        }

        @Override
        final long indexOfBit(long lowIndex, long highIndex, boolean value) {
            return PackedBitBuffers.indexOfBit(this.lb, lowIndex, highIndex, value);
        }

        @Override
        final long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            return PackedBitBuffers.lastIndexOfBit(this.lb, lowIndex, highIndex, value);
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            this.setBit(destIndex, this.getBit(srcIndex));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void swap(long firstIndex, long secondIndex) {
            int ii1 = (int)(firstIndex >>> 6);
            int bit1 = (int)firstIndex & 0x3F;
            int ii2 = (int)(secondIndex >>> 6);
            int bit2 = (int)secondIndex & 0x3F;
            LongBuffer longBuffer = this.lb;
            synchronized (longBuffer) {
                boolean v2;
                long l1 = this.lb.get(ii1);
                long l2 = this.lb.get(ii2);
                boolean v1 = (l1 & 1L << bit1) != 0L;
                boolean bl = v2 = (l2 & 1L << bit2) != 0L;
                if (v1 != v2) {
                    if (v2) {
                        this.lb.put(ii1, l1 | 1L << bit1);
                    } else {
                        this.lb.put(ii1, l1 & (1L << bit1 ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                    l2 = this.lb.get(ii2);
                    if (v1) {
                        this.lb.put(ii2, l2 | 1L << bit2);
                    } else {
                        this.lb.put(ii2, l2 & (1L << bit2 ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }

        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            PackedBitBuffers.unpackBits((boolean[])destArray, destArrayOffset, this.lb, pos, count);
        }

        @Override
        public void getBits(long pos, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.copyBits(LongBuffer.wrap(destArray), destArrayOffset, this.lb, pos, count);
        }

        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            PackedBitBuffers.packBits(this.lb, pos, (boolean[])srcArray, srcArrayOffset, count);
        }

        @Override
        public void setBits(long pos, long[] srcArray, long srcArrayOffset, long count) {
            PackedBitBuffers.copyBits(this.lb, pos, LongBuffer.wrap(srcArray), srcArrayOffset, count);
        }

        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            PackedBitBuffers.fillBits(this.lb, pos, count, (Boolean)fillerWrapper);
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, booleanZero);
        }

        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            if (src instanceof DirectBitStorage) {
                PackedBitBuffers.copyBits(this.lb, destPos, ((DirectBitStorage)src).lb, srcPos, count);
                return true;
            }
            return false;
        }

        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            if (another instanceof DirectBitStorage) {
                PackedBitBuffers.swapBits(((DirectBitStorage)another).lb, anotherPos, this.lb, thisPos, count);
                return true;
            }
            return false;
        }

        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("minData is not supported for bit storages");
        }

        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("maxData is not supported for bit storages");
        }

        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("addData is not supported for bit storages");
        }

        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            throw new UnsupportedOperationException("addData is not supported for bit storages");
        }

        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            throw new UnsupportedOperationException("subtractData is not supported for bit storages");
        }

        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            throw new UnsupportedOperationException("absDiffData is not supported for bit storages");
        }

        @Override
        public void andBits(long pos, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.andBits(destArray, destArrayOffset, this.lb, pos, count);
        }

        @Override
        public void orBits(long pos, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.orBits(destArray, destArrayOffset, this.lb, pos, count);
        }

        @Override
        public void xorBits(long pos, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.xorBits(destArray, destArrayOffset, this.lb, pos, count);
        }

        @Override
        public void andNotBits(long pos, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.andNotBits(destArray, destArrayOffset, this.lb, pos, count);
        }

        @Override
        void setSpecificBuffer() {
            this.lb = this.bb == null ? null : this.bb.asLongBuffer();
        }
    }

    static abstract class DirectStorage
    extends DataStorage {
        ByteBuffer bb;
        boolean unresizable = false;

        DirectStorage() {
        }

        @Override
        MemoryModel newCompatibleMemoryModel() {
            return BufferMemoryModel.getInstance();
        }

        @Override
        ByteOrder byteOrder() {
            return ByteOrder.nativeOrder();
        }

        @Override
        void allocate(long capacity, boolean unresizable) {
            this.unresizable = unresizable;
            this.bb = this.newByteBuffer(capacity);
            this.setSpecificBuffer();
        }

        @Override
        DataStorage changeCapacity(long newCapacity, long offset, long length) {
            if (this.unresizable) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed changeCapacity)");
            }
            DirectStorage result = (DirectStorage)this.newCompatibleEmptyStorage(false);
            ByteBuffer byteBuffer = this.newByteBuffer(newCapacity);
            if (this instanceof DirectBitStorage) {
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                PackedBitBuffers.copyBits(longBuffer, 0L, ((DirectBitStorage)this).lb, offset, length);
                result.bb = byteBuffer;
            } else {
                JBuffers.copyByteBuffer(byteBuffer, 0, this.bb, (int)offset << this.bytesPerBufferElementLog(), (int)length << this.bytesPerBufferElementLog());
                result.bb = byteBuffer;
            }
            result.setSpecificBuffer();
            return result;
        }

        abstract void setSpecificBuffer();

        private ByteBuffer newByteBuffer(long capacity) {
            if (capacity < 0L) {
                throw new AssertionError((Object)"Negative capacity in package-private method");
            }
            long arrayLength = capacity;
            if (this instanceof DirectBitStorage) {
                arrayLength = PackedBitBuffers.packedLength(capacity);
            }
            long byteBufferLength = arrayLength << this.bytesPerBufferElementLog();
            if (arrayLength != (long)((int)arrayLength) || byteBufferLength != (long)((int)byteBufferLength)) {
                throw new TooLargeArrayException("Too large desired array capacity for BufferMemoryModel: " + capacity + " = 0x" + Long.toHexString(capacity) + " (" + String.valueOf(this) + ")");
            }
            ByteBuffer result = ByteBuffer.allocateDirect((int)byteBufferLength);
            result.order(ByteOrder.nativeOrder());
            return result;
        }
    }
}

