/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import net.algart.arrays.AbstractDataFileModel;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataFile;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.MappedDataStorages;

public class DefaultDataFileModel
extends AbstractDataFileModel
implements DataFileModel<File> {
    private static final int DEFAULT_NUMBER_OF_BANKS = MappedDataStorages.MappingSettings.nearestCorrectNumberOfBanks(Math.max(0, (int)Math.min(Integer.MAX_VALUE, (long)InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.numberOfBanksPerCPU", 3) * (long)InternalUtils.availableProcessors())));
    private static final int DEFAULT_BANK_SIZE = InternalUtils.JAVA_32 ? MappedDataStorages.MappingSettings.nearestCorrectBankSize(InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.bankSize32", 0x400000)) : MappedDataStorages.MappingSettings.nearestCorrectBankSize(InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.bankSize", 0x1000000));
    private static final int DEFAULT_RESIZABLE_BANK_SIZE = InternalUtils.JAVA_32 ? MappedDataStorages.MappingSettings.nearestCorrectBankSize(InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.resizableBankSize32", 0x200000)) : MappedDataStorages.MappingSettings.nearestCorrectBankSize(InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.resizableBankSize", 0x400000));
    private static final int DEFAULT_SINGLE_MAPPING_LIMIT = InternalUtils.JAVA_32 ? Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.singleMappingLimit32", 0x400000)) : Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.singleMappingLimit", 0x10000000));
    private static final boolean DEFAULT_AUTO_RESIZING_ON_MAPPING = InternalUtils.getBooleanProperty("net.algart.arrays.DefaultDataFileModel.autoResizingOnMapping", false);
    private static final boolean DEFAULT_LAZY_WRITING = InternalUtils.getBooleanProperty("net.algart.arrays.DefaultDataFileModel.lazyWriting", InternalUtils.JAVA_7);
    private static final String DEFAULT_FILE_WRITE_MODE = InternalUtils.getStringProperty("net.algart.arrays.DefaultDataFileModel.fileWriteMode", "rwd");
    private static final long DEFAULT_PREFIX_SIZE = Math.max(0L, (long)InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.prefixSize", 0));
    private static final int OPEN_SLEEP_DELAY = 200;
    private static final int OPEN_TIMEOUT = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.openTimeout", 5000));
    private static final int MAP_SLEEP_DELAY = 200;
    private static final int MAP_TIMEOUT = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.mapTimeout", 600));
    private static final int MAP_TIMEOUT_WITH_GC = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.mapTimeoutWithGc", 400));
    private static final int FORCE_SLEEP_DELAY = 250;
    private static final int FORCE_TIMEOUT = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.forceTimeout", 15000));
    private static final int MEMORY_UTILIZATION_FORCE_TIMEOUT = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.memoryUtilizationForceTimeout", 1000));
    private static final int WRITE_THROUGH_FORCE_TIMEOUT = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.writeThroughForceTimeout", 500));
    private static final int NEXT_RELOAD_MIN_DELAY = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.DefaultDataFileModel.nextReloadMinDelay", 2000));
    private static final long MAX_MAPPED_MEMORY = Math.min(0x100000000000000L, Math.max(0L, InternalUtils.getLongPropertyWithImportant("net.algart.arrays.maxMappedMemory", 0x20000000L)));
    static final boolean UNSAFE_UNMAP_ON_EXIT = false;
    static final boolean UNSAFE_UNMAP_ON_DISPOSE = false;
    static final boolean UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY = InternalUtils.getBooleanProperty("net.algart.arrays.DefaultDataFileModel.unsafeUnmapOnExceedingMaxMappedMemory", false);
    static final boolean GC_ON_EXCEEDING_MAX_MAPPED_MEMORY = InternalUtils.getBooleanProperty("net.algart.arrays.DefaultDataFileModel.gcOnExceedingMaxMappedMemory", !UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY);
    private static final boolean CACHE_MAPPINGS = true;
    private final boolean lazyWriting;

    public static boolean defaultLazyWriting() {
        return DEFAULT_LAZY_WRITING;
    }

    public static long maxMappedMemory() {
        return MAX_MAPPED_MEMORY;
    }

    public DefaultDataFileModel() {
        this(null, DEFAULT_PREFIX_SIZE, DefaultDataFileModel.defaultLazyWriting());
    }

    public DefaultDataFileModel(boolean lazyWriting) {
        this(null, DEFAULT_PREFIX_SIZE, lazyWriting);
    }

    public DefaultDataFileModel(File tempPath) {
        this(tempPath, DEFAULT_PREFIX_SIZE, DefaultDataFileModel.defaultLazyWriting());
    }

    public DefaultDataFileModel(File tempPath, boolean lazyWriting) {
        this(tempPath, DEFAULT_PREFIX_SIZE, lazyWriting);
    }

    public DefaultDataFileModel(File tempPath, long prefixSize, boolean lazyWriting) {
        super(tempPath, prefixSize);
        this.lazyWriting = lazyWriting;
    }

    public final boolean isLazyWriting() {
        return this.lazyWriting;
    }

    @Override
    public DataFile getDataFile(File path, ByteOrder byteOrder) {
        Objects.requireNonNull(path, "Null path argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder argument");
        return new MappableFile(path, byteOrder, this.lazyWriting);
    }

    @Override
    public File getPath(DataFile dataFile) {
        return ((MappableFile)dataFile).file;
    }

    @Override
    public boolean isAutoDeletionRequested() {
        return true;
    }

    @Override
    public int recommendedNumberOfBanks() {
        return DEFAULT_NUMBER_OF_BANKS;
    }

    @Override
    public int recommendedBankSize(boolean unresizable) {
        return unresizable ? DEFAULT_BANK_SIZE : DEFAULT_RESIZABLE_BANK_SIZE;
    }

    @Override
    public int recommendedSingleMappingLimit() {
        return DEFAULT_SINGLE_MAPPING_LIMIT;
    }

    @Override
    public boolean autoResizingOnMapping() {
        return DEFAULT_AUTO_RESIZING_ON_MAPPING;
    }

    @Override
    public String temporaryFilePrefix() {
        return "mapmm";
    }

    public String toString() {
        return "default data file model: " + this.recommendedNumberOfBanks() + " banks per " + this.recommendedBankSize(true) + "/" + this.recommendedBankSize(false) + " bytes, " + (String)(this.recommendedSingleMappingLimit() > 0 ? "single mapping until " + this.recommendedSingleMappingLimit() + " bytes, " : "") + (this.lazyWriting ? "lazy-writing" : "write-through");
    }

    private static RandomAccessFile openWithSeveralAttempts(File file, boolean readOnly) throws FileNotFoundException {
        long t1 = System.nanoTime();
        int numberOfAttempts = 0;
        FileNotFoundException exception = null;
        RandomAccessFile result = null;
        int timeoutInMillis = OPEN_TIMEOUT;
        while (true) {
            try {
                result = new RandomAccessFile(file, readOnly ? "r" : DEFAULT_FILE_WRITE_MODE);
            }
            catch (FileNotFoundException e) {
                if (readOnly && !file.exists()) {
                    throw e;
                }
                exception = e;
                ++numberOfAttempts;
                if (timeoutInMillis <= 0) break;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                timeoutInMillis -= 200;
                continue;
            }
            break;
        }
        long t2 = System.nanoTime();
        if (result == null) {
            assert (exception != null);
            LargeMemoryModel.LOGGER.warning(String.format(Locale.US, "MMMM open: cannot open file in %.2f sec, " + numberOfAttempts + " attempts (%s; %s)", (double)(t2 - t1) * 1.0E-9, file, exception));
            throw exception;
        }
        return result;
    }

    private static MappedByteBuffer mapWithSeveralAttempts(String fileName, FileChannel fileChannel, FileChannel.MapMode mode, long position, long size) throws IOException {
        long t1 = System.nanoTime();
        int numberOfAttempts = 0;
        int numberOfGc = 0;
        IOException exception = null;
        MappedByteBuffer result = null;
        int timeoutInMilliseconds = MAP_TIMEOUT + MAP_TIMEOUT_WITH_GC;
        while (true) {
            try {
                result = Arrays.SystemSettings.globalDiskSynchronizer().doSynchronously(fileName, () -> fileChannel.map(mode, position, size));
            }
            catch (Exception ex) {
                if (!(ex instanceof IOException)) {
                    throw new AssertionError((Object)("Unexpected exception type: " + String.valueOf(ex)));
                }
                exception = (IOException)ex;
                ++numberOfAttempts;
                if (timeoutInMilliseconds <= 0) break;
                boolean doGc = timeoutInMilliseconds <= MAP_TIMEOUT_WITH_GC;
                LargeMemoryModel.LOGGER.config("MMMM map: problem with mapping data, new attempt #" + numberOfAttempts + (doGc ? " with gc" : ""));
                if (doGc) {
                    System.gc();
                    ++numberOfGc;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex2) {
                    break;
                }
                timeoutInMilliseconds -= 200;
                continue;
            }
            break;
        }
        long t2 = System.nanoTime();
        if (result == null) {
            assert (exception != null);
            LargeMemoryModel.LOGGER.warning(String.format(Locale.US, "MMMM map: cannot map data in %.2f sec, " + numberOfAttempts + " attempts" + (String)(numberOfGc > 0 ? ", " + numberOfGc + " with gc" : "") + " (%s; %s)", (double)(t2 - t1) * 1.0E-9, fileName, exception));
            throw exception;
        }
        return result;
    }

    private static Error forceWithSeveralAttempts(String fileName, MappedByteBuffer mbb, DataFile.Range range, boolean memoryUtilization, int timeoutInMillis) {
        Error resultError;
        int attemptCount = 0;
        long t1 = System.currentTimeMillis();
        while (true) {
            resultError = null;
            try {
                ++attemptCount;
                Arrays.SystemSettings.globalDiskSynchronizer().doSynchronously(fileName, () -> {
                    mbb.force();
                    return null;
                });
            }
            catch (Throwable ex) {
                if (ex instanceof Error) {
                    resultError = (Error)ex;
                }
                if (ex instanceof Exception) {
                    resultError = new IOError(ex);
                }
                throw new IOError((Throwable)((Object)new AssertionError((Object)("Invalid class of caught exception: " + String.valueOf(ex.getClass())))));
            }
            if (resultError == null || timeoutInMillis <= 0 || MappedDataStorages.shutdownInProgress) break;
            try {
                Thread.sleep(Math.min(250, timeoutInMillis));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
            timeoutInMillis -= 250;
        }
        if (resultError != null) {
            long t2 = System.currentTimeMillis();
            LargeMemoryModel.LOGGER.warning(String.format(Locale.US, "MMMM " + (memoryUtilization ? "memory utilization" : "flush") + ": cannot force data at %s in %.2f sec, %d attempts (%s; %s)", range, (double)(t2 - t1) * 0.001, attemptCount, fileName, resultError));
        }
        return resultError;
    }

    private static void unsafeUnmap(MappedByteBuffer mbb) throws Exception {
        Method getCleanerMethod = mbb.getClass().getMethod("cleaner", new Class[0]);
        getCleanerMethod.setAccessible(true);
        Object cleaner = getCleanerMethod.invoke((Object)mbb, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.invoke(cleaner, new Object[0]);
    }

    static class MappableFile
    implements DataFile {
        private static final AtomicLong CURRENT_FILE_INDEX = new AtomicLong(0L);
        private static final Set<RangeWeakReference<ByteBuffer>> ALL_WRITABLE_MAPPINGS = Collections.synchronizedSet(new HashSet());
        private static volatile long unforcedMappingMemory = 0L;
        final File file;
        final Long fileIndex;
        private final ByteOrder byteOrder;
        private final boolean lazyWriting;
        private boolean readOnly = false;
        private RandomAccessFile raf;
        FileChannel fc;
        final ReferenceQueue<ByteBuffer> reaped = new ReferenceQueue();
        final Map<DataFile.Range, RangeWeakReference<ByteBuffer>> mappingCache = Collections.synchronizedMap(new HashMap());

        MappableFile(File file, ByteOrder byteOrder, boolean lazyWriting) {
            Objects.requireNonNull(file, "Null file argument");
            Objects.requireNonNull(byteOrder, "Null byteOrder argument");
            this.file = file.getAbsoluteFile();
            this.fileIndex = CURRENT_FILE_INDEX.getAndIncrement();
            this.byteOrder = byteOrder;
            this.lazyWriting = lazyWriting;
        }

        @Override
        public final ByteOrder byteOrder() {
            return this.byteOrder;
        }

        @Override
        public final DataFile.OpenResult open(boolean readOnly) {
            DataFile.OpenResult result = DataFile.OpenResult.OPENED;
            if (this.raf == null) {
                this.readOnly = readOnly;
                try {
                    if (!readOnly && !this.file.exists()) {
                        result = DataFile.OpenResult.CREATED;
                    }
                    this.raf = DefaultDataFileModel.openWithSeveralAttempts(this.file, readOnly);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                this.fc = this.raf.getChannel();
            }
            this.reap();
            return result;
        }

        @Override
        public void close() {
            if (this.raf != null) {
                try {
                    this.fc.close();
                    this.raf.close();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                finally {
                    this.raf = null;
                    this.fc = null;
                }
            }
            this.reap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void force() {
            ArrayList<RangeWeakReference<ByteBuffer>> ranges;
            if (!this.lazyWriting) {
                return;
            }
            Map<DataFile.Range, RangeWeakReference<ByteBuffer>> map = this.mappingCache;
            synchronized (map) {
                ranges = new ArrayList<RangeWeakReference<ByteBuffer>>(this.mappingCache.values());
            }
            Collections.sort(ranges);
            LargeMemoryModel.LOGGER.fine("MMMM flush: forcing all cache (" + ranges.size() + " blocks) for " + String.valueOf(this));
            int count = 0;
            long totalBytes = 0L;
            long t1 = System.nanoTime();
            for (RangeWeakReference rangeWeakReference : ranges) {
                MappedByteBuffer mbb;
                if (rangeWeakReference == null || (mbb = (MappedByteBuffer)rangeWeakReference.get()) == null) continue;
                LargeMemoryModel.LOGGER.finer("MMMM flush: forcing " + String.valueOf(rangeWeakReference) + " of " + String.valueOf(this));
                Error e = DefaultDataFileModel.forceWithSeveralAttempts(this.file.getPath(), mbb, rangeWeakReference.key, false, FORCE_TIMEOUT);
                if (e != null) {
                    rangeWeakReference.errorWhileForcing = true;
                    throw e;
                }
                ++count;
                totalBytes += rangeWeakReference.key.length();
            }
            long t2 = System.nanoTime();
            LargeMemoryModel.LOGGER.fine(String.format(Locale.US, "MMMM flush: %d blocks (%.2f MB, %.3f ms, %.3f MB/sec) are forced for %s", count, (double)totalBytes / 1048576.0, (double)(t2 - t1) * 1.0E-6, (double)totalBytes / 1048576.0 / ((double)(t2 - t1) * 1.0E-9), this));
            if (this.raf != null) {
                try {
                    t1 = System.nanoTime();
                    this.fc.force(false);
                    t2 = System.nanoTime();
                    LargeMemoryModel.LOGGER.fine(String.format(Locale.US, "MMMM flush: forcing FileChannel (%.3f ms) for %s", (double)(t2 - t1) * 1.0E-6, this));
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
        }

        @Override
        public final boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public DataFile.BufferHolder map(DataFile.Range range, boolean notLoadDataFromFile) {
            try {
                boolean foundInCache;
                FileChannel.MapMode mode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
                RangeWeakReference br = this.mappingCache.get(range);
                MappedByteBuffer mbb = br == null ? null : (MappedByteBuffer)((Reference)br).get();
                boolean bl = foundInCache = mbb != null;
                if (foundInCache) {
                    br.unused = false;
                    LargeMemoryModel.LOGGER.finest("MMMM quick loading " + String.valueOf(br.key) + " of " + String.valueOf(this));
                } else {
                    this.reap();
                    if (MAX_MAPPED_MEMORY > 0L) {
                        MappableFile.utilizeMemory(range.length());
                    }
                    mbb = DefaultDataFileModel.mapWithSeveralAttempts(this.file.getPath(), this.fc, mode, range.position(), range.length());
                    mbb.order(this.byteOrder);
                    br = UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY ? new UnmappableRangeWeakReference(mbb, this.fileIndex, this.file.getPath(), range, this.reaped) : new RangeWeakReference<ByteBuffer>(mbb, this.fileIndex, this.file.getPath(), range, this.reaped);
                    this.mappingCache.put(range, br);
                    if (MAX_MAPPED_MEMORY > 0L) {
                        ALL_WRITABLE_MAPPINGS.add(br);
                    }
                    LargeMemoryModel.LOGGER.finest("MMMM caching " + String.valueOf(range) + " of " + String.valueOf(this));
                }
                return new MappedByteBufferHolder(mbb, br, this.file.getPath(), range, this.lazyWriting, foundInCache);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }

        @Override
        public final long length() {
            try {
                return this.raf.length();
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }

        @Override
        public final void length(long newLength) {
            try {
                this.raf.setLength(newLength);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }

        public String toString() {
            return this.file.toString();
        }

        void reap() {
            RangeWeakReference br;
            while ((br = (RangeWeakReference)this.reaped.poll()) != null) {
                if (MAX_MAPPED_MEMORY > 0L) {
                    ALL_WRITABLE_MAPPINGS.remove(br);
                }
                this.mappingCache.remove(br.key);
                LargeMemoryModel.LOGGER.finest("MMMM removing " + String.valueOf(br.key) + " of " + String.valueOf(this));
            }
        }

        final boolean exists() {
            return this.file.exists();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean unsafeUnmapAll() throws Exception {
            TreeSet<RangeWeakReference<ByteBuffer>> ranges;
            if (this.getClass() != MappableFile.class) {
                return true;
            }
            Map<DataFile.Range, RangeWeakReference<ByteBuffer>> map = this.mappingCache;
            synchronized (map) {
                Set<RangeWeakReference<ByteBuffer>> set = ALL_WRITABLE_MAPPINGS;
                synchronized (set) {
                    ranges = new TreeSet<RangeWeakReference<ByteBuffer>>(this.mappingCache.values());
                    ALL_WRITABLE_MAPPINGS.removeAll(ranges);
                    this.mappingCache.clear();
                }
            }
            boolean result = true;
            for (RangeWeakReference rangeWeakReference : ranges) {
                MappedByteBuffer mbb = rangeWeakReference == null ? null : (MappedByteBuffer)rangeWeakReference.get();
                if (mbb == null) continue;
                if (rangeWeakReference.unused) {
                    DefaultDataFileModel.unsafeUnmap(mbb);
                    continue;
                }
                result = false;
            }
            return result;
        }

        static String byteBufferToString(ByteBuffer bb) {
            if (bb == null) {
                return "no buffer";
            }
            StringBuilder sb = new StringBuilder();
            int len = bb.limit();
            for (int k = 0; k < len; ++k) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(InternalUtils.toHexString(bb.get(k)));
                if (k != 4 || len <= 10) continue;
                k = len - 6;
                sb.append("...,");
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void utilizeMemory(long mappedLength) {
            long t4;
            long t3;
            long t2;
            long t1;
            int count = 0;
            long totalBytes = 0L;
            Set<RangeWeakReference<ByteBuffer>> set = ALL_WRITABLE_MAPPINGS;
            synchronized (set) {
                if (unforcedMappingMemory <= MAX_MAPPED_MEMORY) {
                    unforcedMappingMemory += mappedLength;
                    return;
                }
                unforcedMappingMemory = 0L;
                t1 = System.nanoTime();
                ArrayList<RangeWeakReference<ByteBuffer>> ranges = new ArrayList<RangeWeakReference<ByteBuffer>>(ALL_WRITABLE_MAPPINGS);
                ALL_WRITABLE_MAPPINGS.clear();
                Collections.sort(ranges);
                LargeMemoryModel.LOGGER.fine("MMMM memory utilization: forcing all cache (" + ranges.size() + " blocks)");
                t2 = System.nanoTime();
                for (RangeWeakReference rangeWeakReference : ranges) {
                    MappedByteBuffer mbb;
                    if (rangeWeakReference == null || rangeWeakReference.errorWhileForcing || (mbb = (MappedByteBuffer)rangeWeakReference.get()) == null) continue;
                    LargeMemoryModel.LOGGER.finer("MMMM memory utilization: forcing " + String.valueOf(rangeWeakReference));
                    Error e = DefaultDataFileModel.forceWithSeveralAttempts(rangeWeakReference.fileName, mbb, rangeWeakReference.key, true, MEMORY_UTILIZATION_FORCE_TIMEOUT);
                    if (e != null) {
                        rangeWeakReference.errorWhileForcing = true;
                    }
                    if (UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY) {
                        assert (rangeWeakReference instanceof UnmappableRangeWeakReference);
                        ((UnmappableRangeWeakReference)rangeWeakReference).unsafeUnmap();
                    }
                    ++count;
                    totalBytes += rangeWeakReference.key.length();
                    if (!MappedDataStorages.shutdownInProgress) continue;
                    break;
                }
                t3 = System.nanoTime();
                if (GC_ON_EXCEEDING_MAX_MAPPED_MEMORY) {
                    for (int k = 0; k < 2; ++k) {
                        System.gc();
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                t4 = System.nanoTime();
            }
            if (GC_ON_EXCEEDING_MAX_MAPPED_MEMORY) {
                LargeMemoryModel.LOGGER.log(Arrays.SystemSettings.profilingMode() ? Level.CONFIG : Level.FINE, String.format(Locale.US, "MMMM memory utilization" + (UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY ? " with unmapping: " : ": ") + "%.4f sec, %d blocks are forced (%.2f MB, %.3f ms preparing + %.3f ms + %.3f ms gc, %.3f MB/sec)", (double)(t4 - t1) * 1.0E-9, count, (double)totalBytes / 1048576.0, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)totalBytes / 1048576.0 / ((double)(t3 - t2) * 1.0E-9)));
            } else {
                LargeMemoryModel.LOGGER.log(Arrays.SystemSettings.profilingMode() ? Level.CONFIG : Level.FINE, String.format(Locale.US, "MMMM memory utilization" + (UNSAFE_UNMAP_ON_EXCEEDING_MAX_MAPPED_MEMORY ? " with unmapping: " : ": ") + "%.4f sec, %d blocks are forced (%.2f MB, %.3f ms preparing + %.3f ms, %.3f MB/sec)", (double)(t4 - t1) * 1.0E-9, count, (double)totalBytes / 1048576.0, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)totalBytes / 1048576.0 / ((double)(t3 - t2) * 1.0E-9)));
            }
        }

        static class MappedByteBufferHolder
        implements DataFile.BufferHolder {
            private MappedByteBuffer mbb;
            private boolean preloaded = false;
            private long lastLoadTime = -1L;
            private final RangeWeakReference<?> br;
            private final String fileName;
            private final DataFile.Range range;
            private final boolean lazyWriting;
            private final boolean fromCache;

            MappedByteBufferHolder(MappedByteBuffer mbb, RangeWeakReference<?> br, String fileName, DataFile.Range range, boolean lazyWriting, boolean fromCache) {
                this.mbb = mbb;
                this.br = br;
                this.fileName = fileName;
                this.range = range;
                this.lazyWriting = lazyWriting;
                this.fromCache = fromCache;
            }

            @Override
            public DataFile.Range range() {
                return this.range;
            }

            @Override
            public ByteBuffer data() {
                Objects.requireNonNull(this.mbb, "Cannot call data() method: the buffer was already unmapped or disposed");
                return this.mbb;
            }

            @Override
            public Object mappingObject() {
                return this.fromCache ? null : this.mbb;
            }

            @Override
            public void load() {
                Objects.requireNonNull(this.mbb, "Cannot call load() method: the buffer was already unmapped or disposed");
                if (!this.preloaded || System.currentTimeMillis() - this.lastLoadTime > (long)NEXT_RELOAD_MIN_DELAY) {
                    try {
                        Arrays.SystemSettings.globalDiskSynchronizer().doSynchronously(this.fileName, () -> {
                            this.mbb.load();
                            return null;
                        });
                    }
                    catch (Exception ex) {
                        throw new AssertionError((Object)("Unexpected exception: " + String.valueOf(ex)));
                    }
                    this.preloaded = true;
                    this.lastLoadTime = System.currentTimeMillis();
                }
            }

            @Override
            public void flush(boolean forcePhysicalWriting) {
                Objects.requireNonNull(this.mbb, "Cannot call flush() method: the buffer was already unmapped or disposed");
                if (forcePhysicalWriting || !this.lazyWriting && !this.br.errorWhileForcing) {
                    LargeMemoryModel.LOGGER.finer("MMMM flush: forcing " + String.valueOf(this));
                    Error e = DefaultDataFileModel.forceWithSeveralAttempts(this.fileName, this.mbb, this.range, false, forcePhysicalWriting ? FORCE_TIMEOUT : WRITE_THROUGH_FORCE_TIMEOUT);
                    if (e != null) {
                        this.br.errorWhileForcing = true;
                        if (forcePhysicalWriting) {
                            throw e;
                        }
                    }
                }
            }

            @Override
            public void unmap(boolean forcePhysicalWriting) {
                Objects.requireNonNull(this.mbb, "Cannot call unmap() method: the buffer was already unmapped or disposed");
                this.br.unused = true;
                try {
                    if (forcePhysicalWriting || !this.lazyWriting) {
                        LargeMemoryModel.LOGGER.finer("MMMM unmap: forcing " + String.valueOf(this));
                        DefaultDataFileModel.forceWithSeveralAttempts(this.fileName, this.mbb, this.range, false, WRITE_THROUGH_FORCE_TIMEOUT);
                    }
                }
                finally {
                    this.mbb = null;
                }
            }

            @Override
            public boolean dispose() {
                Objects.requireNonNull(this.mbb, "Cannot call dispose() method: the buffer was already unmapped or disposed");
                this.unmap(false);
                return true;
            }

            @Override
            public boolean isLoadedFromCache() {
                return this.fromCache;
            }

            public String toString() {
                return "mapping " + String.valueOf(this.range) + " of " + this.fileName + " [" + MappableFile.byteBufferToString(this.mbb) + "]";
            }
        }
    }

    static class UnmappableRangeWeakReference
    extends RangeWeakReference<ByteBuffer> {
        private boolean unmapped = false;

        UnmappableRangeWeakReference(MappedByteBuffer referent, Long fileIndex, String fileName, DataFile.Range key, ReferenceQueue<ByteBuffer> q) {
            super(referent, fileIndex, fileName, key, q);
        }

        public synchronized void unsafeUnmap() {
            if (!this.unused) {
                return;
            }
            if (this.unmapped) {
                return;
            }
            MappedByteBuffer mbb = (MappedByteBuffer)super.get();
            this.unmapped = true;
            try {
                DefaultDataFileModel.unsafeUnmap(mbb);
            }
            catch (Exception e) {
                LargeMemoryModel.LOGGER.log(Level.WARNING, "MMMM unsafe unmapping: " + String.valueOf(e), e);
            }
        }

        @Override
        public synchronized ByteBuffer get() {
            return this.unmapped ? null : (ByteBuffer)super.get();
        }

        @Override
        public String toString() {
            return (this.unmapped ? "UNMAPPED " : "") + super.toString();
        }
    }

    static class RangeWeakReference<T>
    extends WeakReference<T>
    implements Comparable<RangeWeakReference<T>> {
        final Long fileIndex;
        final String fileName;
        final DataFile.Range key;
        volatile boolean unused = false;
        volatile boolean errorWhileForcing = false;

        RangeWeakReference(T referent, Long fileIndex, String fileName, DataFile.Range key, ReferenceQueue<T> q) {
            super(referent, q);
            assert (fileIndex != null);
            assert (key != null);
            this.fileIndex = fileIndex;
            this.fileName = fileName;
            this.key = key;
        }

        @Override
        public int compareTo(RangeWeakReference<T> o) {
            return this.fileIndex < o.fileIndex ? -1 : (this.fileIndex > o.fileIndex ? 1 : this.key.compareTo(o.key));
        }

        public String toString() {
            return (this.unused ? "unused " : "") + "weak mapping " + String.valueOf(this.key) + " (file #" + this.fileIndex + ")";
        }

        public int hashCode() {
            return this.fileIndex.hashCode() * 37 + this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RangeWeakReference)) {
                return false;
            }
            RangeWeakReference rwr = (RangeWeakReference)o;
            return this.fileIndex == rwr.fileIndex && this.key.equals(rwr.key);
        }
    }
}

