/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface DataFile {
    public ByteOrder byteOrder();

    public OpenResult open(boolean var1);

    public void close();

    public void force();

    public boolean isReadOnly();

    public BufferHolder map(Range var1, boolean var2);

    public long length();

    public void length(long var1);

    public static interface BufferHolder {
        public Range range();

        public ByteBuffer data();

        public Object mappingObject();

        public void load();

        public void flush(boolean var1);

        public void unmap(boolean var1);

        public boolean dispose();

        public boolean isLoadedFromCache();
    }

    public static final class Range
    implements Comparable<Range> {
        private final long position;
        private final long length;

        private Range(long position, long length) {
            if (position < 0L) {
                throw new IllegalArgumentException("Negative position argument: " + position);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length argument: " + position);
            }
            this.position = position;
            this.length = length;
        }

        public static Range of(long position, long length) {
            return new Range(position, length);
        }

        public long position() {
            return this.position;
        }

        public long length() {
            return this.length;
        }

        @Override
        public int compareTo(Range o) {
            return Long.compare(this.position, o.position);
        }

        public String toString() {
            return Long.toHexString(this.position) + "h..+" + Long.toHexString(this.length) + "h";
        }

        public int hashCode() {
            int v1 = (int)(this.position >>> 32) * 37 + (int)this.position;
            int v2 = (int)(this.length >>> 32) * 37 + (int)this.length;
            return v1 * 37 + v2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) {
                return false;
            }
            Range r = (Range)obj;
            return r.position == this.position && r.length == this.length;
        }
    }

    public static enum OpenResult {
        OPENED,
        CREATED;

    }
}

