/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.ref.SoftReference;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.TooLargeArrayException;

public final class ByteJArrayHolder {
    private SoftReference<byte[]> reference = new SoftReference<byte[]>(new byte[0]);
    private final Object lock = new Object();

    public byte[] quickNew(Matrix<?> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        return this.quickNew(matrix.size());
    }

    public byte[] quickNew(long newArrayLength) {
        if (newArrayLength < 0L) {
            throw new IllegalArgumentException("Zero or negative array new array length");
        }
        if (newArrayLength != (long)((int)newArrayLength)) {
            throw new TooLargeArrayException("Too large requested array: " + newArrayLength + " elements");
        }
        return this.quickNew((int)newArrayLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] quickNew(int newArrayLength) {
        if (newArrayLength < 0) {
            throw new IllegalArgumentException("Zero or negative array new array length");
        }
        Object object = this.lock;
        synchronized (object) {
            byte[] oldArray = this.reference.get();
            if (oldArray != null && oldArray.length == newArrayLength) {
                return oldArray;
            }
            byte[] result = new byte[newArrayLength];
            this.reference = new SoftReference<byte[]>(result);
            return result;
        }
    }

    public byte[] quickClone(byte[] array) {
        byte[] result = this.quickNew(array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }
}

