/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixIndexer;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysSubMatrixCyclicIndexer
implements ArraysSubMatrixIndexer {
    private static final boolean DEBUG_MODE = false;
    private final Array baseArray;
    private final UpdatableArray updatableBaseArray;
    private final BitArray baseBitArray;
    private final UpdatableBitArray updatableBaseBitArray;
    private final CharArray baseCharArray;
    private final UpdatableCharArray updatableBaseCharArray;
    private final ByteArray baseByteArray;
    private final UpdatableByteArray updatableBaseByteArray;
    private final ShortArray baseShortArray;
    private final UpdatableShortArray updatableBaseShortArray;
    private final IntArray baseIntArray;
    private final UpdatableIntArray updatableBaseIntArray;
    private final LongArray baseLongArray;
    private final UpdatableLongArray updatableBaseLongArray;
    private final FloatArray baseFloatArray;
    private final UpdatableFloatArray updatableBaseFloatArray;
    private final DoubleArray baseDoubleArray;
    private final UpdatableDoubleArray updatableBaseDoubleArray;
    private final ObjectArray<Object> baseObjectArray;
    private final UpdatableObjectArray<Object> updatableBaseObjectArray;
    private final long[] pos;
    private final long pos0;
    private final long[] dim;
    private final long dim0;
    private final long size;
    private final long[] baseDimMul;
    private final long[] dividers;
    private final long baseDim0;
    private final long repeatingStep;
    private final long baseSize;
    private final boolean pseudoCyclic;

    ArraysSubMatrixCyclicIndexer(Matrix<? extends Array> baseMatrix, long[] pos, long[] dim, boolean pseudoCyclic) {
        int k;
        this.baseArray = baseMatrix.array();
        this.updatableBaseArray = this.baseArray instanceof UpdatableArray ? (UpdatableArray)this.baseArray : null;
        this.baseBitArray = this.baseArray instanceof BitArray ? (BitArray)this.baseArray : null;
        this.updatableBaseBitArray = this.baseArray instanceof UpdatableBitArray ? (UpdatableBitArray)this.baseArray : null;
        this.baseCharArray = this.baseArray instanceof CharArray ? (CharArray)this.baseArray : null;
        this.updatableBaseCharArray = this.baseArray instanceof UpdatableCharArray ? (UpdatableCharArray)this.baseArray : null;
        this.baseByteArray = this.baseArray instanceof ByteArray ? (ByteArray)this.baseArray : null;
        this.updatableBaseByteArray = this.baseArray instanceof UpdatableByteArray ? (UpdatableByteArray)this.baseArray : null;
        this.baseShortArray = this.baseArray instanceof ShortArray ? (ShortArray)this.baseArray : null;
        this.updatableBaseShortArray = this.baseArray instanceof UpdatableShortArray ? (UpdatableShortArray)this.baseArray : null;
        this.baseIntArray = this.baseArray instanceof IntArray ? (IntArray)this.baseArray : null;
        this.updatableBaseIntArray = this.baseArray instanceof UpdatableIntArray ? (UpdatableIntArray)this.baseArray : null;
        this.baseLongArray = this.baseArray instanceof LongArray ? (LongArray)this.baseArray : null;
        this.updatableBaseLongArray = this.baseArray instanceof UpdatableLongArray ? (UpdatableLongArray)this.baseArray : null;
        this.baseFloatArray = this.baseArray instanceof FloatArray ? (FloatArray)this.baseArray : null;
        this.updatableBaseFloatArray = this.baseArray instanceof UpdatableFloatArray ? (UpdatableFloatArray)this.baseArray : null;
        this.baseDoubleArray = this.baseArray instanceof DoubleArray ? (DoubleArray)this.baseArray : null;
        this.updatableBaseDoubleArray = this.baseArray instanceof UpdatableDoubleArray ? (UpdatableDoubleArray)this.baseArray : null;
        this.baseObjectArray = this.baseArray instanceof ObjectArray ? ((ObjectArray)this.baseArray).cast(Object.class) : null;
        UpdatableObjectArray<Object> updatableObjectArray = this.updatableBaseObjectArray = this.baseArray instanceof UpdatableObjectArray ? ((UpdatableObjectArray)this.baseArray).cast(Object.class) : null;
        assert (dim.length == baseMatrix.dimCount());
        assert (pos.length == dim.length);
        for (int k2 = 0; k2 < pos.length; ++k2) {
            assert (dim[k2] >= 0L);
            assert (pos[k2] <= Long.MAX_VALUE - dim[k2]);
        }
        int n = dim.length;
        int q = 0;
        long collapsedDimensions = 1L;
        while (q < dim.length - 1 && pos[q] == 0L && dim[q] == baseMatrix.dim(q)) {
            collapsedDimensions *= dim[q];
            ++q;
            --n;
        }
        assert (n > 0);
        long[] baseDim = new long[n];
        this.pos = new long[n];
        this.dim = new long[n];
        for (k = 0; k < n; ++k) {
            baseDim[k] = baseMatrix.dim(k + q);
            this.pos[k] = pos[k + q];
            this.dim[k] = dim[k + q];
        }
        baseDim[0] = baseDim[0] * collapsedDimensions;
        this.pos[0] = this.pos[0] * collapsedDimensions;
        this.dim[0] = this.dim[0] * collapsedDimensions;
        this.baseDim0 = baseDim[0];
        this.pos0 = this.pos[0];
        this.dim0 = this.dim[0];
        this.size = Arrays.longMul(dim);
        assert (this.size >= 0L);
        assert (this.size == Arrays.longMul(this.dim));
        this.baseDimMul = new long[n];
        for (k = 0; k < n; ++k) {
            this.baseDimMul[k] = k == 0 ? 1L : this.baseDimMul[k - 1] * baseDim[k - 1];
        }
        this.dividers = new long[this.pos.length];
        for (k = this.pos.length - 1; k >= 0; --k) {
            this.dividers[k] = k == this.pos.length - 1 || !pseudoCyclic ? baseDim[k] : this.dividers[k + 1] * baseDim[k];
        }
        this.repeatingStep = this.dividers[0];
        this.baseSize = this.baseArray.length();
        this.pseudoCyclic = pseudoCyclic;
        assert (this.dividers[0] == (pseudoCyclic ? this.baseSize : this.baseDim0));
    }

    @Override
    public boolean bitsBlocksImplemented() {
        return true;
    }

    @Override
    public boolean indexOfImplemented() {
        return true;
    }

    @Override
    public long translate(long index) {
        int k;
        assert (index >= 0L && index < this.size);
        if (this.dim.length == 1) {
            long coord = this.pos0 + index;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return coord;
        }
        long a = index;
        long b = a / this.dim0;
        long subCoord0 = a - b * this.dim0;
        long baseCoord0 = this.pos0 + subCoord0;
        assert (this.pos0 < 0L || baseCoord0 >= 0L);
        if ((baseCoord0 %= this.repeatingStep) < 0L) {
            baseCoord0 += this.repeatingStep;
        }
        a = b;
        long indexInBase = baseCoord0;
        for (k = 1; k < this.dim.length - 1; ++k) {
            b = a / this.dim[k];
            long subCoordK = a - b * this.dim[k];
            long baseCoordK = this.pos[k] + subCoordK;
            assert (this.pos[k] < 0L || baseCoordK >= 0L);
            if ((baseCoordK %= this.dividers[k]) < 0L) {
                baseCoordK += this.dividers[k];
            }
            a = b;
            if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
            assert (this.pseudoCyclic);
            assert ((indexInBase -= this.baseSize) >= 0L);
        }
        assert (k == this.dim.length - 1);
        long baseCoordLast = this.pos[k] + a;
        assert (this.pos[k] < 0L || baseCoordLast >= 0L);
        if ((baseCoordLast %= this.dividers[k]) < 0L) {
            baseCoordLast += this.dividers[k];
        }
        if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
            assert (this.pseudoCyclic);
            assert ((indexInBase -= this.baseSize) >= 0L);
        }
        return indexInBase;
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (this.dim.length == 1) {
            if (count == 0) {
                return;
            }
            long coord = this.pos0 + arrayPos;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.getDataInLine(coord, 0L, destArray, destArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == arrayPos) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            int len = (int)Math.min(this.dim0 - subCoord0, (long)count);
            assert (len > 0) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.getDataInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, destArray, destArrayOffset, len);
            index += (long)len;
            destArrayOffset += len;
            count -= len;
        }
    }

    private void getDataInLine(long indexInBase, long repeatingStart, Object destArray, int destArrayOffset, int len) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        while (len > 0) {
            int m = (int)Math.min(repeatingLimit - indexInBase, (long)len);
            this.baseArray.getData(indexInBase, destArray, destArrayOffset, m);
            indexInBase = repeatingStart;
            destArrayOffset += m;
            len -= m;
        }
    }

    @Override
    public void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (this.dim.length == 1) {
            if (count == 0) {
                return;
            }
            long coord = this.pos0 + arrayPos;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.setDataInLine(coord, 0L, srcArray, srcArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == arrayPos) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            int len = (int)Math.min(this.dim0 - subCoord0, (long)count);
            assert (len > 0) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.setDataInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, srcArray, srcArrayOffset, len);
            index += (long)len;
            srcArrayOffset += len;
            count -= len;
        }
    }

    private void setDataInLine(long indexInBase, long repeatingStart, Object srcArray, int srcArrayOffset, int len) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        while (len > 0) {
            int m = (int)Math.min(repeatingLimit - indexInBase, (long)len);
            this.updatableBaseArray.setData(indexInBase, srcArray, srcArrayOffset, m);
            indexInBase = repeatingStart;
            srcArrayOffset += m;
            len -= m;
        }
    }

    @Override
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + arrayPos;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.getBitsInLine(coord, 0L, destArray, destArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == arrayPos) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.getBitsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, destArray, destArrayOffset, len);
            index += len;
            destArrayOffset += len;
            count -= len;
        }
    }

    private void getBitsInLine(long indexInBase, long repeatingStart, long[] destArray, long destArrayOffset, long len) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        while (len > 0L) {
            long m = Math.min(repeatingLimit - indexInBase, len);
            this.baseBitArray.getBits(indexInBase, destArray, destArrayOffset, m);
            indexInBase = repeatingStart;
            destArrayOffset += m;
            len -= m;
        }
    }

    @Override
    public void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + arrayPos;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.setBitsInLine(coord, 0L, srcArray, srcArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == arrayPos) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.setBitsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, srcArray, srcArrayOffset, len);
            index += len;
            srcArrayOffset += len;
            count -= len;
        }
    }

    private void setBitsInLine(long indexInBase, long repeatingStart, long[] srcArray, long srcArrayOffset, long len) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        while (len > 0L) {
            long m = Math.min(repeatingLimit - indexInBase, len);
            this.updatableBaseBitArray.setBits(indexInBase, srcArray, srcArrayOffset, m);
            indexInBase = repeatingStart;
            srcArrayOffset += m;
            len -= m;
        }
    }

    @Override
    public long indexOfBit(long lowIndex, long highIndex, boolean value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfBitInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfBitInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfBitInLine(long indexInBase, long repeatingStart, long len, boolean value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseBitArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseBitArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseBitArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfBitInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfBitInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfBitInLine(long indexInBase, long repeatingStart, long len, boolean value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseBitArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseBitArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillBits(long position, long count, boolean value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillBitsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillBitsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillBitsInLine(long indexInBase, long repeatingStart, long len, boolean value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseBitArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseBitArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseBitArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfChar(long lowIndex, long highIndex, char value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfCharInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfCharInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfCharInLine(long indexInBase, long repeatingStart, long len, char value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseCharArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseCharArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseCharArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfCharInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfCharInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfCharInLine(long indexInBase, long repeatingStart, long len, char value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseCharArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseCharArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillChars(long position, long count, char value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillCharsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillCharsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillCharsInLine(long indexInBase, long repeatingStart, long len, char value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseCharArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseCharArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseCharArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfByte(long lowIndex, long highIndex, byte value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfByteInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfByteInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfByteInLine(long indexInBase, long repeatingStart, long len, byte value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseByteArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseByteArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseByteArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfByteInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfByteInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfByteInLine(long indexInBase, long repeatingStart, long len, byte value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseByteArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseByteArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillBytes(long position, long count, byte value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillBytesInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillBytesInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillBytesInLine(long indexInBase, long repeatingStart, long len, byte value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseByteArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseByteArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseByteArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfShort(long lowIndex, long highIndex, short value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfShortInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfShortInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfShortInLine(long indexInBase, long repeatingStart, long len, short value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseShortArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseShortArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseShortArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfShortInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfShortInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfShortInLine(long indexInBase, long repeatingStart, long len, short value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseShortArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseShortArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillShorts(long position, long count, short value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillShortsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillShortsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillShortsInLine(long indexInBase, long repeatingStart, long len, short value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseShortArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseShortArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseShortArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfInt(long lowIndex, long highIndex, int value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfIntInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfIntInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfIntInLine(long indexInBase, long repeatingStart, long len, int value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseIntArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseIntArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseIntArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfIntInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfIntInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfIntInLine(long indexInBase, long repeatingStart, long len, int value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseIntArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseIntArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillInts(long position, long count, int value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillIntsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillIntsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillIntsInLine(long indexInBase, long repeatingStart, long len, int value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseIntArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseIntArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseIntArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfLong(long lowIndex, long highIndex, long value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfLongInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfLongInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfLongInLine(long indexInBase, long repeatingStart, long len, long value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseLongArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseLongArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseLongArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfLongInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfLongInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfLongInLine(long indexInBase, long repeatingStart, long len, long value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseLongArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseLongArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillLongs(long position, long count, long value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillLongsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillLongsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillLongsInLine(long indexInBase, long repeatingStart, long len, long value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseLongArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseLongArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseLongArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfFloat(long lowIndex, long highIndex, float value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfFloatInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfFloatInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfFloatInLine(long indexInBase, long repeatingStart, long len, float value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseFloatArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseFloatArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseFloatArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfFloatInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfFloatInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfFloatInLine(long indexInBase, long repeatingStart, long len, float value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseFloatArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseFloatArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillFloats(long position, long count, float value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillFloatsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillFloatsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillFloatsInLine(long indexInBase, long repeatingStart, long len, float value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseFloatArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseFloatArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseFloatArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfDouble(long lowIndex, long highIndex, double value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfDoubleInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfDoubleInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfDoubleInLine(long indexInBase, long repeatingStart, long len, double value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseDoubleArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseDoubleArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseDoubleArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfDoubleInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfDoubleInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfDoubleInLine(long indexInBase, long repeatingStart, long len, double value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseDoubleArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseDoubleArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillDoubles(long position, long count, double value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillDoublesInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillDoublesInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillDoublesInLine(long indexInBase, long repeatingStart, long len, double value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseDoubleArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseDoubleArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseDoubleArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }

    @Override
    public long indexOfObject(long lowIndex, long highIndex, Object value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + lowIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.indexOfObjectInLine(coord, 0L, count, value)) == -1L ? -1L : lowIndex + result - coord;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == lowIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.indexOfObjectInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != -1L) {
                return index + result - indexInBase;
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfObjectInLine(long indexInBase, long repeatingStart, long len, Object value) {
        if (len <= 0L) {
            return -1L;
        }
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            return this.baseObjectArray.indexOf(indexInBase, indexInBase + len, value);
        }
        long result = this.baseObjectArray.indexOf(indexInBase, repeatingLimit, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseObjectArray.indexOf(repeatingStart, len >= this.repeatingStep ? indexInBase : indexInBase + len - this.repeatingStep, value);
        if (result != -1L) {
            return this.repeatingStep + result;
        }
        return -1L;
    }

    @Override
    public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.baseSize == 0L) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result;
            long coord = this.pos0 + highIndex;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            return (result = this.lastIndexOfObjectInLine(coord, 0L, count, value)) == Long.MAX_VALUE ? -1L : highIndex + result - coord;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            long result;
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == highIndex) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast - 1L;
                subCoord0 = this.dim0 - 1L;
            }
            bLast = b;
            long len = Math.min(subCoord0 + 1L, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            if ((result = this.lastIndexOfObjectInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value)) != Long.MAX_VALUE) {
                return index + result - indexInBase;
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfObjectInLine(long indexInBase, long repeatingStart, long len, Object value) {
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        assert (indexInBase >= repeatingStart && indexInBase < repeatingStart + this.repeatingStep);
        if (len <= indexInBase - repeatingStart + 1L) {
            long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - len, indexInBase + 1L, value);
            return result == -1L ? Long.MAX_VALUE : result;
        }
        long result = this.baseObjectArray.lastIndexOf(repeatingStart, indexInBase + 1L, value);
        if (result != -1L) {
            return result;
        }
        result = this.baseObjectArray.lastIndexOf(len >= this.repeatingStep ? indexInBase + 1L : indexInBase + 1L + this.repeatingStep - len, repeatingStart + this.repeatingStep, value);
        if (result != -1L) {
            return result - this.repeatingStep;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillObjects(long position, long count, Object value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            if ((coord %= this.baseDim0) < 0L) {
                coord += this.baseDim0;
            }
            this.fillObjectsInLine(coord, 0L, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            if ((baseCoord0 %= this.repeatingStep) < 0L) {
                baseCoord0 += this.repeatingStep;
            }
            a = b;
            long indexInBase = baseCoord0;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                if ((baseCoordK %= this.dividers[k]) < 0L) {
                    baseCoordK += this.dividers[k];
                }
                a = b;
                if ((indexInBase += baseCoordK * this.baseDimMul[k]) >= 0L && indexInBase < this.baseSize) continue;
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            if ((baseCoordLast %= this.dividers[k]) < 0L) {
                baseCoordLast += this.dividers[k];
            }
            if ((indexInBase += baseCoordLast * this.baseDimMul[k]) < 0L || indexInBase >= this.baseSize) {
                assert (this.pseudoCyclic);
                assert ((indexInBase -= this.baseSize) >= 0L);
            }
            this.fillObjectsInLine(indexInBase, this.pseudoCyclic ? 0L : indexInBase - baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillObjectsInLine(long indexInBase, long repeatingStart, long len, Object value) {
        long repeatingLimit = repeatingStart + this.repeatingStep;
        assert (indexInBase >= repeatingStart && indexInBase < repeatingLimit);
        if (len <= repeatingLimit - indexInBase) {
            this.updatableBaseObjectArray.fill(indexInBase, len, value);
            return;
        }
        this.updatableBaseObjectArray.fill(indexInBase, repeatingLimit - indexInBase, value);
        this.updatableBaseObjectArray.fill(repeatingStart, len >= this.repeatingStep ? indexInBase - repeatingStart : len - (repeatingLimit - indexInBase), value);
    }
}

