/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferArraysImpl;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBitStorage;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;

class ArraysMinMaxGetDataOp {
    private static final boolean OPTIMIZE_AND_OR_ALIGNMENT = true;
    private static final boolean OPTIMIZE_MIN_MAX_FOR_JARRAYS = true;
    private static final boolean OPTIMIZE_MIN_MAX_FOR_JBUFFERS = InternalUtils.SERVER_OPTIMIZATION;
    private final PArray[] x;
    private final PArray result;
    private final boolean isBit;
    private final long length;
    private final Object[] jaOrDStor;
    private final long[] saShift;
    private final long[] subArrayOffset;
    private final JArrayPool quickPositionsPool;
    private final JArrayPool jaOrDStorOffsetsPool;
    private final JArrayPool bufferPool;
    private final ArrayMinMaxOp ammo;
    private final boolean isMin;
    static final long SAFE = -100L;
    static final long SAFE_IN_PLACE_TO_ARRAY_0_WITH_SAME_OFFSET = -101L;
    static final long DANGEROUS = -102L;
    static final int ALL_OFFSETS = -1;

    ArraysMinMaxGetDataOp(PArray result, PArray[] x, ArrayMinMaxOp ammo, boolean isMin) {
        if (x.length == 0) {
            throw new AssertionError((Object)"Empty x[] argument");
        }
        this.length = result.length();
        for (PArray xk : x) {
            if (xk.elementType() != result.elementType()) {
                throw new AssertionError((Object)"Different x[] / result element types");
            }
            if (xk.length() != this.length) {
                throw new AssertionError((Object)"Different x[] / result lengths");
            }
        }
        this.x = x;
        this.result = result;
        this.isBit = this.x[0] instanceof BitArray;
        this.jaOrDStor = new Object[this.x.length];
        this.subArrayOffset = new long[this.x.length];
        this.saShift = new long[this.x.length];
        this.quickPositionsPool = ArraysFuncImpl.smallLongBuffers(this.x.length);
        for (int k = 0; k < this.x.length; ++k) {
            Array array = this.x[k];
            if (Arrays.isShifted(array)) {
                this.saShift[k] = Arrays.getShift(array);
                array = Arrays.getUnderlyingArrays(array)[0];
            }
            Object object = this.jaOrDStor[k] = this.isBit ? (Object)Arrays.longJavaArrayInternal((BitArray)array) : Arrays.javaArrayInternal(array);
            if (this.jaOrDStor[k] != null) {
                this.subArrayOffset[k] = this.isBit ? Arrays.longJavaArrayOffsetInternal((BitArray)array) : (long)Arrays.javaArrayOffsetInternal(array);
                continue;
            }
            if (!(array instanceof BufferArraysImpl.AbstractBufferArray)) continue;
            this.jaOrDStor[k] = ((BufferArraysImpl.AbstractBufferArray)array).storage;
            this.subArrayOffset[k] = ((BufferArraysImpl.AbstractBufferArray)array).offset;
        }
        this.jaOrDStorOffsetsPool = ArraysFuncImpl.smallLongBuffers(this.x.length);
        this.bufferPool = this.x[0] instanceof CharArray ? ArraysFuncImpl.CHAR_BUFFERS : (this.x[0] instanceof ByteArray ? ArraysFuncImpl.BYTE_BUFFERS : (this.x[0] instanceof ShortArray ? ArraysFuncImpl.SHORT_BUFFERS : (this.x[0] instanceof IntArray ? ArraysFuncImpl.INT_BUFFERS : (this.x[0] instanceof LongArray ? ArraysFuncImpl.LONG_BUFFERS : (this.x[0] instanceof FloatArray ? ArraysFuncImpl.FLOAT_BUFFERS : (this.x[0] instanceof DoubleArray ? ArraysFuncImpl.DOUBLE_BUFFERS : null))))));
        this.ammo = ammo;
        this.isMin = isMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.x[0].getClass());
        }
        if (arrayPos > this.x[0].length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x[0].length(), this.x[0].getClass());
        }
        while (count > 0) {
            int len;
            if (this.isBit) {
                len = Math.min(count, 524288);
                long[] buf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                try {
                    int gap = Arrays.goodStartOffsetInArrayOfLongs((BitArray)this.result, arrayPos, 256);
                    ((BitArray)this.result).getBits(arrayPos, buf, gap, len);
                    PackedBitArrays.unpackBits((boolean[])destArray, destArrayOffset, buf, gap, len);
                }
                finally {
                    ArraysFuncImpl.BIT_BUFFERS.releaseArray(buf);
                }
            }
            Object destBuf = null;
            long[] jaOrDStorOffsets = (long[])this.jaOrDStorOffsetsPool.requestArray();
            try {
                len = Math.min(count, this.bufferPool.arrayLength());
                long analyzeResult = ArraysMinMaxGetDataOp.analyzeSourceArrays(this.jaOrDStor, this.saShift, this.subArrayOffset, arrayPos, this.length, len, destArray, destArrayOffset, -1, jaOrDStorOffsets);
                Object dest = destArray;
                int destOffset = destArrayOffset;
                if (analyzeResult == -102L) {
                    dest = destBuf = this.bufferPool.requestArray();
                    destOffset = 0;
                }
                if (analyzeResult != -101L) {
                    this.x[0].getData(arrayPos, dest, destOffset, len);
                }
                for (int k = 1; k < this.x.length; ++k) {
                    boolean optimizeJBuffer = false;
                    boolean optimizeJArray = false;
                    if (jaOrDStorOffsets[k] != -1L) {
                        optimizeJBuffer = this.jaOrDStor[k] instanceof DataStorage;
                        boolean bl = optimizeJArray = !optimizeJBuffer;
                    }
                    if (OPTIMIZE_MIN_MAX_FOR_JBUFFERS && optimizeJBuffer) {
                        DataStorage storage = (DataStorage)this.jaOrDStor[k];
                        if (this.isMin) {
                            storage.minData(jaOrDStorOffsets[k], dest, destOffset, len);
                            continue;
                        }
                        storage.maxData(jaOrDStorOffsets[k], dest, destOffset, len);
                        continue;
                    }
                    if (optimizeJArray) {
                        this.ammo.process(dest, destOffset, this.jaOrDStor[k], (int)jaOrDStorOffsets[k], len);
                        continue;
                    }
                    Object buf = null;
                    try {
                        buf = this.bufferPool.requestArray();
                        this.x[k].getData(arrayPos, buf, 0, len);
                        this.ammo.process(dest, destOffset, buf, 0, len);
                        continue;
                    }
                    finally {
                        this.bufferPool.releaseArray(buf);
                    }
                }
                if (analyzeResult == -102L) {
                    System.arraycopy(destBuf, 0, destArray, destArrayOffset, len);
                }
                this.jaOrDStorOffsetsPool.releaseArray(jaOrDStorOffsets);
                this.bufferPool.releaseArray(destBuf);
            }
            catch (Throwable throwable) {
                this.jaOrDStorOffsetsPool.releaseArray(jaOrDStorOffsets);
                this.bufferPool.releaseArray(destBuf);
                throw throwable;
            }
            destArrayOffset += len;
            arrayPos += (long)len;
            count -= len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        if (!this.isBit) {
            throw new AssertionError((Object)("Illegal usage of " + this.getClass().getName() + ".getBits"));
        }
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0L) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.getClass());
        }
        if (arrayPos > this.x[0].length() - count) {
            throw AbstractArray.rangeException(arrayPos + count - 1L, this.x[0].length(), this.getClass());
        }
        BitArray x0 = (BitArray)this.x[0];
        while (count > 0L) {
            int len = (int)Math.min(count, 524288L);
            int processedArraysCount = 0;
            long positionsMap = 0L;
            long goodPositionsMap = 0L;
            long analyzeResult = ArraysMinMaxGetDataOp.analyzeSourceArrays(this.jaOrDStor, this.saShift, this.subArrayOffset, arrayPos, this.length, len, destArray, destArrayOffset, -1, null);
            long[] longBuf = null;
            long[] destLongBuf = null;
            long[] quickPositions = null;
            try {
                int k;
                longBuf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                destLongBuf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                quickPositions = (long[])this.quickPositionsPool.requestArray();
                long[] dest = destArray;
                long destOffset = destArrayOffset;
                int gap = Arrays.goodStartOffsetInArrayOfLongs(x0, arrayPos, 256);
                if (this.x.length >= 3) {
                    for (k = 0; k < this.x.length; ++k) {
                        quickPositions[k] = ((BitArray)this.x[k]).nextQuickPosition(arrayPos);
                        if (quickPositions[k] == -1L) continue;
                        int sh = (int)(arrayPos - quickPositions[k]) & 0x3F;
                        if ((positionsMap & 1L << sh) != 0L) {
                            goodPositionsMap |= 1L << sh;
                        }
                        positionsMap |= 1L << sh;
                    }
                }
                if (goodPositionsMap != 0L) {
                    boolean firstArray = true;
                    int lastSh = -1;
                    for (int sh = 0; sh < 64; ++sh) {
                        if ((goodPositionsMap & 1L << sh) == 0L) continue;
                        if (lastSh != -1) {
                            PackedBitArrays.copyBits(destLongBuf, sh, destLongBuf, lastSh, len);
                        }
                        for (int k2 = 0; k2 < this.x.length; ++k2) {
                            if (quickPositions[k2] == -1L || ((int)(arrayPos - quickPositions[k2]) & 0x3F) != sh) continue;
                            if (firstArray) {
                                ((BitArray)this.x[k2]).getBits(arrayPos, destLongBuf, sh, len);
                                firstArray = false;
                            } else {
                                this.processBits(k2, arrayPos, destLongBuf, sh, len, sh, longBuf);
                            }
                            ++processedArraysCount;
                        }
                        lastSh = sh;
                    }
                    assert (lastSh != -1) : "lastSh == -1: goodPositionsMap = " + Long.toBinaryString(goodPositionsMap);
                    dest = destLongBuf;
                    destOffset = lastSh;
                } else {
                    if (analyzeResult == -102L) {
                        dest = destLongBuf;
                        destOffset = gap;
                    }
                    if (analyzeResult != -101L) {
                        x0.getBits(arrayPos, dest, destOffset, len);
                    }
                    processedArraysCount = 1;
                }
                int n = k = goodPositionsMap != 0L ? 0 : 1;
                while (k < this.x.length) {
                    int sh;
                    long qp;
                    if (goodPositionsMap == 0L || (qp = ((BitArray)this.x[k]).nextQuickPosition(arrayPos)) == -1L || (goodPositionsMap & 1L << (sh = (int)(arrayPos - qp) & 0x3F)) == 0L) {
                        this.processBits(k, arrayPos, dest, destOffset, len, gap, longBuf);
                        ++processedArraysCount;
                    }
                    ++k;
                }
                if (dest != destArray) {
                    assert (dest == destLongBuf);
                    PackedBitArrays.copyBits(destArray, destArrayOffset, dest, destOffset, len);
                }
                this.quickPositionsPool.releaseArray(quickPositions);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(longBuf);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(destLongBuf);
            }
            catch (Throwable throwable) {
                this.quickPositionsPool.releaseArray(quickPositions);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(longBuf);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(destLongBuf);
                throw throwable;
            }
            if (processedArraysCount != this.x.length) {
                throw new AssertionError((Object)("Not all or too many arrays are processed: " + processedArraysCount + " instead of " + this.x.length));
            }
            destArrayOffset += (long)len;
            arrayPos += (long)len;
            count -= (long)len;
        }
    }

    static long analyzeSourceArrays(Object[] jaOrDStor, long[] saShift, long[] subArrayOffset, long arrayPos, long arrayLength, long len, Object destArray, long destArrayOffset, int desiredOffsetIndex, long[] jaOrDStorOffsets) {
        boolean dangerousDestOverlapPossible = false;
        boolean inPlaceOp = false;
        int inPlaceCount = 0;
        int startIndex = desiredOffsetIndex == -1 ? 0 : desiredOffsetIndex;
        int endIndex = desiredOffsetIndex == -1 ? jaOrDStor.length - 1 : desiredOffsetIndex;
        for (int k = startIndex; k <= endIndex; ++k) {
            long ofs;
            boolean optimizeJArray;
            long p = arrayPos;
            boolean optimizeJBuffer = jaOrDStor[k] instanceof DataStorage;
            boolean bl = optimizeJArray = !optimizeJBuffer && jaOrDStor[k] != null;
            if ((optimizeJArray || optimizeJBuffer) && (p -= saShift[k]) < 0L && (p += arrayLength) >= arrayLength - len) {
                optimizeJBuffer = false;
                optimizeJArray = false;
            }
            if (optimizeJArray || optimizeJBuffer) {
                ofs = p + subArrayOffset[k];
                assert (ofs >= 0L);
            } else {
                ofs = -1L;
            }
            if (desiredOffsetIndex != -1) {
                return ofs;
            }
            if (optimizeJArray) {
                if (jaOrDStor[k] == destArray) {
                    if (k == 0) {
                        inPlaceOp = destArrayOffset == ofs;
                    } else {
                        dangerousDestOverlapPossible = inPlaceOp ? (dangerousDestOverlapPossible |= ++inPlaceCount >= 2 || ofs < destArrayOffset) : true;
                    }
                }
            } else if (!optimizeJBuffer) {
                dangerousDestOverlapPossible = true;
            }
            if (jaOrDStorOffsets == null) continue;
            jaOrDStorOffsets[k] = ofs;
        }
        if (dangerousDestOverlapPossible) {
            return -102L;
        }
        if (inPlaceOp) {
            return -101L;
        }
        return -100L;
    }

    private void processBits(int xIndex, long arrayPos, long[] dest, long destOffset, int len, int gap, long[] longBuf) {
        boolean optimizeJArray;
        long p = arrayPos;
        boolean optimizeJBuffer = this.jaOrDStor[xIndex] instanceof DataStorage;
        boolean bl = optimizeJArray = !optimizeJBuffer && this.jaOrDStor[xIndex] != null;
        if ((optimizeJArray || optimizeJBuffer) && (p -= this.saShift[xIndex]) < 0L && (p += this.length) >= this.length - (long)len) {
            optimizeJBuffer = false;
            optimizeJArray = false;
        }
        if (optimizeJBuffer) {
            DataBitStorage storage = (DataBitStorage)this.jaOrDStor[xIndex];
            if (this.isMin) {
                storage.andBits(p + this.subArrayOffset[xIndex], dest, destOffset, len);
            } else {
                storage.orBits(p + this.subArrayOffset[xIndex], dest, destOffset, len);
            }
        } else if (optimizeJArray) {
            if (this.isMin) {
                PackedBitArrays.andBits(dest, destOffset, (long[])this.jaOrDStor[xIndex], p + this.subArrayOffset[xIndex], len);
            } else {
                PackedBitArrays.orBits(dest, destOffset, (long[])this.jaOrDStor[xIndex], p + this.subArrayOffset[xIndex], len);
            }
        } else {
            ((BitArray)this.x[xIndex]).getBits(arrayPos, longBuf, gap, len);
            if (this.isMin) {
                PackedBitArrays.andBits(dest, destOffset, longBuf, gap, len);
            } else {
                PackedBitArrays.orBits(dest, destOffset, longBuf, gap, len);
            }
        }
    }

    static ArrayMinMaxOp getByteMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minByteArray((byte[])dest, destOffset, (byte[])src, srcOffset, len);
            }

            public String toString() {
                return "byte array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getByteMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxByteArray((byte[])dest, destOffset, (byte[])src, srcOffset, len);
            }

            public String toString() {
                return "byte array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getCharMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minCharArray((char[])dest, destOffset, (char[])src, srcOffset, len);
            }

            public String toString() {
                return "char array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getCharMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxCharArray((char[])dest, destOffset, (char[])src, srcOffset, len);
            }

            public String toString() {
                return "char array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getShortMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minShortArray((short[])dest, destOffset, (short[])src, srcOffset, len);
            }

            public String toString() {
                return "short array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getShortMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxShortArray((short[])dest, destOffset, (short[])src, srcOffset, len);
            }

            public String toString() {
                return "short array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getIntMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minIntArray((int[])dest, destOffset, (int[])src, srcOffset, len);
            }

            public String toString() {
                return "int array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getIntMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxIntArray((int[])dest, destOffset, (int[])src, srcOffset, len);
            }

            public String toString() {
                return "int array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getLongMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minLongArray((long[])dest, destOffset, (long[])src, srcOffset, len);
            }

            public String toString() {
                return "long array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getLongMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxLongArray((long[])dest, destOffset, (long[])src, srcOffset, len);
            }

            public String toString() {
                return "long array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getFloatMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minFloatArray((float[])dest, destOffset, (float[])src, srcOffset, len);
            }

            public String toString() {
                return "float array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getFloatMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxFloatArray((float[])dest, destOffset, (float[])src, srcOffset, len);
            }

            public String toString() {
                return "float array maximum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getDoubleMinOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.minDoubleArray((double[])dest, destOffset, (double[])src, srcOffset, len);
            }

            public String toString() {
                return "double array minimum (Java)";
            }
        };
    }

    static ArrayMinMaxOp getDoubleMaxOp() {
        return new ArrayMinMaxOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.maxDoubleArray((double[])dest, destOffset, (double[])src, srcOffset, len);
            }

            public String toString() {
                return "double array maximum (Java)";
            }
        };
    }

    private static interface ArrayMinMaxOp {
        public void process(Object var1, int var2, Object var3, int var4, int var5);
    }
}

