/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.ArraysMinMaxGetDataOp;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferArraysImpl;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.CopiesArraysImpl;
import net.algart.arrays.DataBitStorage;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;

class ArraysDiffGetDataOp {
    private static final boolean OPTIMIZE_SUBTRACT_FOR_JARRAYS = true;
    private static final boolean OPTIMIZE_SUBTRACT_FOR_JBUFFERS = InternalUtils.SERVER_OPTIMIZATION;
    private final PArray[] x;
    private final PArray result;
    private final boolean isBit;
    private final long length;
    private final Object[] jaOrDStor;
    private final long[] saShift;
    private final long[] subArrayOffset;
    private final JArrayPool bufferPool;
    private final ArrayDiffOp ado;
    private final boolean isAbsDiff;
    private final boolean truncateOverflows;

    ArraysDiffGetDataOp(PArray result, PArray x0, PArray x1, ArrayDiffOp ado, boolean isAbsDiff, boolean truncateOverflows) {
        this.length = result.length();
        for (PArray xk : this.x = new PArray[]{x0, x1}) {
            if (xk.elementType() != result.elementType()) {
                throw new AssertionError((Object)"Different x[] / result element types");
            }
            if (xk.length() != this.length) {
                throw new AssertionError((Object)"Different x[] / result lengths");
            }
        }
        this.result = result;
        this.isBit = this.x[0] instanceof BitArray;
        this.jaOrDStor = new Object[this.x.length];
        this.subArrayOffset = new long[this.x.length];
        this.saShift = new long[this.x.length];
        for (int k = 0; k < this.x.length; ++k) {
            Array array = this.x[k];
            if (Arrays.isShifted(array)) {
                this.saShift[k] = Arrays.getShift(array);
                array = Arrays.getUnderlyingArrays(array)[0];
            }
            Object object = this.jaOrDStor[k] = this.isBit ? (Object)Arrays.longJavaArrayInternal((BitArray)array) : Arrays.javaArrayInternal(array);
            if (this.jaOrDStor[k] != null) {
                long l = this.subArrayOffset[k] = this.isBit ? Arrays.longJavaArrayOffsetInternal((BitArray)array) : (long)Arrays.javaArrayOffsetInternal(array);
            }
            if (this.jaOrDStor[k] != null || !(array instanceof BufferArraysImpl.AbstractBufferArray)) continue;
            this.jaOrDStor[k] = ((BufferArraysImpl.AbstractBufferArray)array).storage;
            this.subArrayOffset[k] = ((BufferArraysImpl.AbstractBufferArray)array).offset;
        }
        this.bufferPool = this.x[0] instanceof CharArray ? ArraysFuncImpl.CHAR_BUFFERS : (this.x[0] instanceof ByteArray ? ArraysFuncImpl.BYTE_BUFFERS : (this.x[0] instanceof ShortArray ? ArraysFuncImpl.SHORT_BUFFERS : (this.x[0] instanceof IntArray ? ArraysFuncImpl.INT_BUFFERS : (this.x[0] instanceof LongArray ? ArraysFuncImpl.LONG_BUFFERS : (this.x[0] instanceof FloatArray ? ArraysFuncImpl.FLOAT_BUFFERS : (this.x[0] instanceof DoubleArray ? ArraysFuncImpl.DOUBLE_BUFFERS : null))))));
        this.ado = ado;
        this.isAbsDiff = isAbsDiff;
        this.truncateOverflows = truncateOverflows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.x[0].getClass());
        }
        if (arrayPos > this.x[0].length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x[0].length(), this.x[0].getClass());
        }
        while (count > 0) {
            int len;
            if (this.isBit) {
                len = Math.min(count, 524288);
                long[] buf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                try {
                    int gap = Arrays.goodStartOffsetInArrayOfLongs((BitArray)this.result, arrayPos, 256);
                    ((BitArray)this.result).getBits(arrayPos, buf, gap, len);
                    PackedBitArrays.unpackBits((boolean[])destArray, destArrayOffset, buf, gap, len);
                }
                finally {
                    ArraysFuncImpl.BIT_BUFFERS.releaseArray(buf);
                }
            }
            Object destBuf = null;
            try {
                len = Math.min(count, this.bufferPool.arrayLength());
                long analyzeResult = ArraysMinMaxGetDataOp.analyzeSourceArrays(this.jaOrDStor, this.saShift, this.subArrayOffset, arrayPos, this.length, len, destArray, destArrayOffset, -1, null);
                Object dest = destArray;
                int destOffset = destArrayOffset;
                if (analyzeResult == -102L) {
                    dest = destBuf = this.bufferPool.requestArray();
                    destOffset = 0;
                }
                if (analyzeResult != -101L) {
                    this.x[0].getData(arrayPos, dest, destOffset, len);
                }
                for (int k = 1; k < this.x.length; ++k) {
                    boolean optimizeJBuffer = false;
                    boolean optimizeJArray = false;
                    long jaOrDStorOffset = ArraysMinMaxGetDataOp.analyzeSourceArrays(this.jaOrDStor, this.saShift, this.subArrayOffset, arrayPos, this.length, len, destArray, destArrayOffset, k, null);
                    if (jaOrDStorOffset != -1L) {
                        optimizeJBuffer = this.jaOrDStor[k] instanceof DataStorage;
                        boolean bl = optimizeJArray = !optimizeJBuffer;
                    }
                    if (OPTIMIZE_SUBTRACT_FOR_JBUFFERS && optimizeJBuffer) {
                        DataStorage storage = (DataStorage)this.jaOrDStor[k];
                        if (this.isAbsDiff) {
                            storage.absDiffData(jaOrDStorOffset, dest, destOffset, len, this.truncateOverflows);
                            continue;
                        }
                        storage.subtractData(jaOrDStorOffset, dest, destOffset, len, this.truncateOverflows);
                        continue;
                    }
                    if (optimizeJArray) {
                        this.ado.process(dest, destOffset, this.jaOrDStor[k], (int)jaOrDStorOffset, len);
                        continue;
                    }
                    Object buf = null;
                    try {
                        buf = this.bufferPool.requestArray();
                        this.x[k].getData(arrayPos, buf, 0, len);
                        this.ado.process(dest, destOffset, buf, 0, len);
                        continue;
                    }
                    finally {
                        this.bufferPool.releaseArray(buf);
                    }
                }
                if (analyzeResult == -102L) {
                    System.arraycopy(destBuf, 0, destArray, destArrayOffset, len);
                }
                this.bufferPool.releaseArray(destBuf);
            }
            catch (Throwable throwable) {
                this.bufferPool.releaseArray(destBuf);
                throw throwable;
            }
            destArrayOffset += len;
            arrayPos += (long)len;
            count -= len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        if (!this.isBit) {
            throw new AssertionError((Object)("Illegal usage of " + this.getClass().getName() + ".getBits"));
        }
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0L) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.getClass());
        }
        if (arrayPos > this.x[0].length() - count) {
            throw AbstractArray.rangeException(arrayPos + count - 1L, this.x[0].length(), this.getClass());
        }
        while (count > 0L) {
            int len = (int)Math.min(count, 524288L);
            long analyzeResult = ArraysMinMaxGetDataOp.analyzeSourceArrays(this.jaOrDStor, this.saShift, this.subArrayOffset, arrayPos, this.length, len, destArray, destArrayOffset, -1, null);
            long[] longBuf = null;
            long[] destLongBuf = null;
            try {
                longBuf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                long[] dest = destArray;
                long destOffset = destArrayOffset;
                int gap = Arrays.goodStartOffsetInArrayOfLongs((BitArray)this.x[0], arrayPos, 256);
                if (analyzeResult == -102L) {
                    destLongBuf = (long[])ArraysFuncImpl.BIT_BUFFERS.requestArray();
                    dest = destLongBuf;
                    destOffset = gap;
                }
                if (analyzeResult != -101L) {
                    ((BitArray)this.x[0]).getBits(arrayPos, dest, destOffset, len);
                }
                for (int k = 1; k < this.x.length; ++k) {
                    this.processBits(k, arrayPos, dest, destOffset, len, gap, longBuf);
                }
                if (dest != destArray) {
                    assert (dest == destLongBuf);
                    PackedBitArrays.copyBits(destArray, destArrayOffset, dest, destOffset, len);
                }
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(longBuf);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(destLongBuf);
            }
            catch (Throwable throwable) {
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(longBuf);
                ArraysFuncImpl.BIT_BUFFERS.releaseArray(destLongBuf);
                throw throwable;
            }
            destArrayOffset += (long)len;
            arrayPos += (long)len;
            count -= (long)len;
        }
    }

    private void processBits(int xIndex, long arrayPos, long[] dest, long destOffset, int len, int gap, long[] longBuf) {
        boolean optimizeJArray;
        long p = arrayPos;
        boolean optimizeJBuffer = this.jaOrDStor[xIndex] instanceof DataStorage;
        boolean bl = optimizeJArray = !optimizeJBuffer && this.jaOrDStor[xIndex] != null;
        if ((optimizeJArray || optimizeJBuffer) && (p -= this.saShift[xIndex]) < 0L && (p += this.length) >= this.length - (long)len) {
            optimizeJBuffer = false;
            optimizeJArray = false;
        }
        if (optimizeJBuffer) {
            DataBitStorage storage = (DataBitStorage)this.jaOrDStor[xIndex];
            if (this.isAbsDiff) {
                storage.xorBits(p + this.subArrayOffset[xIndex], dest, destOffset, len);
            } else {
                storage.andNotBits(p + this.subArrayOffset[xIndex], dest, destOffset, len);
            }
        } else if (optimizeJArray) {
            if (this.isAbsDiff) {
                PackedBitArrays.xorBits(dest, destOffset, (long[])this.jaOrDStor[xIndex], p + this.subArrayOffset[xIndex], len);
            } else {
                PackedBitArrays.andNotBits(dest, destOffset, (long[])this.jaOrDStor[xIndex], p + this.subArrayOffset[xIndex], len);
            }
        } else if (this.isAbsDiff && this.x[xIndex] instanceof CopiesArraysImpl.CopiesBitArray) {
            if (((CopiesArraysImpl.CopiesBitArray)this.x[xIndex]).element) {
                PackedBitArrays.notBits(dest, destOffset, dest, destOffset, len);
            }
        } else {
            ((BitArray)this.x[xIndex]).getBits(arrayPos, longBuf, gap, len);
            if (this.isAbsDiff) {
                PackedBitArrays.xorBits(dest, destOffset, longBuf, gap, len);
            } else {
                PackedBitArrays.andNotBits(dest, destOffset, longBuf, gap, len);
            }
        }
    }

    static ArrayDiffOp getByteSubtractOp(final boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractByteArray((byte[])dest, destOffset, (byte[])src, srcOffset, len, truncateOverflows);
            }

            public String toString() {
                return "byte array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getCharSubtractOp(final boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractCharArray((char[])dest, destOffset, (char[])src, srcOffset, len, truncateOverflows);
            }

            public String toString() {
                return "char array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getShortSubtractOp(final boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractShortArray((short[])dest, destOffset, (short[])src, srcOffset, len, truncateOverflows);
            }

            public String toString() {
                return "short array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getIntSubtractOp(final boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractIntArray((int[])dest, destOffset, (int[])src, srcOffset, len, truncateOverflows);
            }

            public String toString() {
                return "int array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getLongSubtractOp(boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractLongArray((long[])dest, destOffset, (long[])src, srcOffset, len);
            }

            public String toString() {
                return "long array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getFloatSubtractOp(boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractFloatArray((float[])dest, destOffset, (float[])src, srcOffset, len);
            }

            public String toString() {
                return "float array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getDoubleSubtractOp(boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.subtractDoubleArray((double[])dest, destOffset, (double[])src, srcOffset, len);
            }

            public String toString() {
                return "double array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getByteAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfByteArray((byte[])dest, destOffset, (byte[])src, srcOffset, len);
            }

            public String toString() {
                return "byte array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getCharAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfCharArray((char[])dest, destOffset, (char[])src, srcOffset, len);
            }

            public String toString() {
                return "char array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getShortAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfShortArray((short[])dest, destOffset, (short[])src, srcOffset, len);
            }

            public String toString() {
                return "short array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getLongAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfLongArray((long[])dest, destOffset, (long[])src, srcOffset, len);
            }

            public String toString() {
                return "long array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getFloatAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfFloatArray((float[])dest, destOffset, (float[])src, srcOffset, len);
            }

            public String toString() {
                return "float array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getDoubleAbsDiffOp() {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfDoubleArray((double[])dest, destOffset, (double[])src, srcOffset, len);
            }

            public String toString() {
                return "double array subtraction (Java)";
            }
        };
    }

    static ArrayDiffOp getIntAbsDiffOp(final boolean truncateOverflows) {
        return new ArrayDiffOp(){

            @Override
            public void process(Object dest, int destOffset, Object src, int srcOffset, int len) {
                JArrays.absDiffOfIntArray((int[])dest, destOffset, (int[])src, srcOffset, len, truncateOverflows);
            }

            public String toString() {
                return "byte array subtraction (Java)";
            }
        };
    }

    private static interface ArrayDiffOp {
        public void process(Object var1, int var2, Object var3, int var4, int var5);
    }
}

