/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.PackedBitArrays;
import net.algart.math.functions.Func;

class ArraysBitTableGetDataOp {
    private static final int BOOLEAN_BUFFER_LENGTH = 32768;
    private static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 32768);
    private final ReentrantLock lock = new ReentrantLock();
    private final BitArray x0;
    private final DataBitBuffer dbuf;
    boolean[] booleanTable;
    char[] charTable;
    byte[] byteTable;
    short[] shortTable;
    int[] intTable;
    long[] longTable;
    float[] floatTable;
    double[] doubleTable;
    private final int destElementTypeCode;

    ArraysBitTableGetDataOp(boolean truncateOverflows, BitArray x0, Func f, int destElementTypeCode) {
        this.x0 = x0;
        this.dbuf = x0.nextQuickPosition(0L) == -1L ? null : (DataBitBuffer)Arrays.bufferInternal(x0, DataBuffer.AccessMode.READ);
        double[] w = new double[]{0.0, 1.0};
        switch (destElementTypeCode) {
            case 1: {
                this.booleanTable = new boolean[2];
                for (int k = 0; k < w.length; ++k) {
                    this.booleanTable[k] = f.get(w[k]) != 0.0;
                }
                break;
            }
            case 2: {
                this.charTable = new char[2];
                if (truncateOverflows) {
                    for (int k = 0; k < w.length; ++k) {
                        int v = (int)f.get(w[k]);
                        this.charTable[k] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }
                } else {
                    for (int k = 0; k < w.length; ++k) {
                        this.charTable[k] = (char)f.get(w[k]);
                    }
                }
                break;
            }
            case 3: {
                this.byteTable = new byte[2];
                if (truncateOverflows) {
                    for (int k = 0; k < w.length; ++k) {
                        int v = (int)f.get(w[k]);
                        this.byteTable[k] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                    }
                } else {
                    for (int k = 0; k < w.length; ++k) {
                        this.byteTable[k] = (byte)f.get(w[k]);
                    }
                }
                break;
            }
            case 4: {
                this.shortTable = new short[2];
                if (truncateOverflows) {
                    for (int k = 0; k < w.length; ++k) {
                        int v = (int)f.get(w[k]);
                        this.shortTable[k] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                    }
                } else {
                    for (int k = 0; k < w.length; ++k) {
                        this.shortTable[k] = (short)f.get(w[k]);
                    }
                }
                break;
            }
            case 5: {
                this.intTable = new int[2];
                if (truncateOverflows) {
                    for (int k = 0; k < w.length; ++k) {
                        this.intTable[k] = (int)f.get(w[k]);
                    }
                } else {
                    for (int k = 0; k < w.length; ++k) {
                        this.intTable[k] = (int)f.get(w[k]);
                    }
                }
                break;
            }
            case 6: {
                this.longTable = new long[2];
                for (int k = 0; k < w.length; ++k) {
                    this.longTable[k] = (long)f.get(w[k]);
                }
                break;
            }
            case 7: {
                this.floatTable = new float[2];
                for (int k = 0; k < w.length; ++k) {
                    this.floatTable[k] = (float)f.get(w[k]);
                }
                break;
            }
            case 8: {
                this.doubleTable = new double[2];
                for (int k = 0; k < w.length; ++k) {
                    this.doubleTable[k] = f.get(w[k]);
                }
                break;
            }
        }
        this.destElementTypeCode = destElementTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x0.length(), this.x0.getClass());
        }
        if (arrayPos > this.x0.length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x0.length(), this.x0.getClass());
        }
        while (count > 0) {
            if (this.dbuf != null) {
                this.lock.lock();
                direct = this.dbuf.isDirect();
                unlocked = false;
                try {
                    this.dbuf.map(arrayPos, count);
                    len = this.dbuf.cnt();
                    if (!ArraysBitTableGetDataOp.$assertionsDisabled && (long)len != this.dbuf.count()) {
                        throw new AssertionError((Object)"too large buffer");
                    }
                    data /* !! */  = (boolean[])this.dbuf.data();
                    fromIndex = this.dbuf.fromIndex();
                    if (direct) {
                        unlocked = true;
                        this.lock.unlock();
                    }
                    switch (this.destElementTypeCode) {
                        case 1: {
                            dest /* !! */  = (boolean[])destArray;
                            PackedBitArrays.unpackBits(dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.booleanTable[0], this.booleanTable[1]);
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            dest /* !! */  = (boolean[])((char[])destArray);
                            PackedBitArrays.unpackBits((char[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.charTable[0], this.charTable[1]);
                            ** break;
lbl35:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            dest /* !! */  = (boolean[])((byte[])destArray);
                            PackedBitArrays.unpackBits((byte[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.byteTable[0], this.byteTable[1]);
                            ** break;
lbl40:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            dest /* !! */  = (boolean[])((short[])destArray);
                            PackedBitArrays.unpackBits((short[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.shortTable[0], this.shortTable[1]);
                            ** break;
lbl45:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            dest /* !! */  = (boolean[])((int[])destArray);
                            PackedBitArrays.unpackBits((int[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.intTable[0], this.intTable[1]);
                            ** break;
lbl50:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            dest /* !! */  = (boolean[])((long[])destArray);
                            PackedBitArrays.unpackBits((long[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.longTable[0], this.longTable[1]);
                            ** break;
lbl55:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            dest /* !! */  = (boolean[])((float[])destArray);
                            PackedBitArrays.unpackBits((float[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.floatTable[0], this.floatTable[1]);
                            ** break;
lbl60:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            dest /* !! */  = (boolean[])((double[])destArray);
                            PackedBitArrays.unpackBits((double[])dest /* !! */ , destArrayOffset, (long[])data /* !! */ , fromIndex, len, this.doubleTable[0], this.doubleTable[1]);
                            ** break;
lbl65:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Illegal destElementTypeCode");
                        }
                    }
                }
                finally {
                    if (!unlocked) {
                        this.lock.unlock();
                    }
                }
                destArrayOffset += len;
            } else {
                data /* !! */  = (boolean[])ArraysBitTableGetDataOp.BOOLEAN_BUFFERS.requestArray();
                try {
                    len = Math.min(count, data /* !! */ .length);
                    this.x0.getData(arrayPos, data /* !! */ , 0, len);
                    switch (this.destElementTypeCode) {
                        case 1: {
                            dest /* !! */  = (boolean[])destArray;
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.booleanTable[1] : this.booleanTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 2: {
                            dest /* !! */  = (boolean[])((char[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.charTable[1] : this.charTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 3: {
                            dest /* !! */  = (boolean[])((byte[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.byteTable[1] : this.byteTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 4: {
                            dest /* !! */  = (boolean[])((short[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.shortTable[1] : this.shortTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 5: {
                            dest /* !! */  = (boolean[])((int[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.intTable[1] : this.intTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 6: {
                            dest /* !! */  = (boolean[])((long[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.longTable[1] : this.longTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 7: {
                            dest /* !! */  = (boolean[])((float[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.floatTable[1] : this.floatTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        case 8: {
                            dest /* !! */  = (boolean[])((double[])destArray);
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = data /* !! */ [j] != false ? this.doubleTable[1] : this.doubleTable[0];
                                ++j;
                                ++destArrayOffset;
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Illegal destElementTypeCode");
                        }
                    }
                }
                finally {
                    ArraysBitTableGetDataOp.BOOLEAN_BUFFERS.releaseArray(data /* !! */ );
                }
            }
            arrayPos += (long)len;
            count -= len;
        }
    }
}

