/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.PArray;
import net.algart.math.functions.Func;

class ArraysAnyCoordFuncGetDataOp {
    private final boolean truncateOverflows;
    private final long[] dim;
    private final long dimX;
    private final long dimXY;
    private final long length;
    private final PArray result;
    private final Func f;
    private final int destElementTypeCode;

    ArraysAnyCoordFuncGetDataOp(PArray result, boolean truncateOverflows, long[] dim, Func f, int destElementTypeCode) {
        this.truncateOverflows = truncateOverflows;
        this.dim = dim;
        this.dimX = dim[0];
        this.dimXY = dim.length > 1 ? dim[0] * dim[1] : dim[0];
        this.length = result.length();
        this.result = result;
        assert (Arrays.longMul(dim) == result.length());
        this.f = f;
        this.destElementTypeCode = destElementTypeCode;
    }

    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.length, this.result.getClass());
        }
        if (arrayPos > this.length - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.result.getClass());
        }
        int destArrayOffsetMax = destArrayOffset + count;
        double[] coordinates = new double[this.dim.length];
        switch (this.destElementTypeCode) {
            case 1: {
                boolean[] dest = (boolean[])destArray;
                if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = v != 0.0;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = v != 0.0;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = v != 0.0;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = v != 0.0;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 2: {
                char[] dest = (char[])destArray;
                if (this.truncateOverflows) {
                    if (this.dim.length == 1) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)arrayPos);
                            dest[destArrayOffset] = (char)(v < 0.0 ? 0 : (char)(v > 65535.0 ? 65535 : (char)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 2) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                            dest[destArrayOffset] = (char)(v < 0.0 ? 0 : (char)(v > 65535.0 ? 65535 : (char)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 3) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                            dest[destArrayOffset] = (char)(v < 0.0 ? 0 : (char)(v > 65535.0 ? 65535 : (char)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else {
                        while (destArrayOffset < destArrayOffsetMax) {
                            ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                            double v = this.f.get(coordinates);
                            dest[destArrayOffset] = (char)(v < 0.0 ? 0 : (char)(v > 65535.0 ? 65535 : (char)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    }
                } else if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (char)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (char)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (char)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (char)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 3: {
                byte[] dest = (byte[])destArray;
                if (this.truncateOverflows) {
                    if (this.dim.length == 1) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)arrayPos);
                            dest[destArrayOffset] = (byte)(v < 0.0 ? 0 : (byte)(v > 255.0 ? -1 : (byte)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 2) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                            dest[destArrayOffset] = (byte)(v < 0.0 ? 0 : (byte)(v > 255.0 ? -1 : (byte)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 3) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                            dest[destArrayOffset] = (byte)(v < 0.0 ? 0 : (byte)(v > 255.0 ? -1 : (byte)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else {
                        while (destArrayOffset < destArrayOffsetMax) {
                            ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                            double v = this.f.get(coordinates);
                            dest[destArrayOffset] = (byte)(v < 0.0 ? 0 : (byte)(v > 255.0 ? -1 : (byte)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    }
                } else if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (byte)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (byte)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (byte)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (byte)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 4: {
                short[] dest = (short[])destArray;
                if (this.truncateOverflows) {
                    if (this.dim.length == 1) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)arrayPos);
                            dest[destArrayOffset] = (short)(v < 0.0 ? 0 : (short)(v > 65535.0 ? -1 : (short)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 2) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                            dest[destArrayOffset] = (short)(v < 0.0 ? 0 : (short)(v > 65535.0 ? -1 : (short)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 3) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                            dest[destArrayOffset] = (short)(v < 0.0 ? 0 : (short)(v > 65535.0 ? -1 : (short)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else {
                        while (destArrayOffset < destArrayOffsetMax) {
                            ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                            double v = this.f.get(coordinates);
                            dest[destArrayOffset] = (short)(v < 0.0 ? 0 : (short)(v > 65535.0 ? -1 : (short)v));
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    }
                } else if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (short)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (short)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (short)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (short)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 5: {
                int[] dest = (int[])destArray;
                if (this.truncateOverflows) {
                    if (this.dim.length == 1) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)arrayPos);
                            dest[destArrayOffset] = (int)v;
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 2) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                            dest[destArrayOffset] = (int)v;
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else if (this.dim.length == 3) {
                        while (destArrayOffset < destArrayOffsetMax) {
                            double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                            dest[destArrayOffset] = (int)v;
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    } else {
                        while (destArrayOffset < destArrayOffsetMax) {
                            ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                            double v = this.f.get(coordinates);
                            dest[destArrayOffset] = (int)v;
                            ++destArrayOffset;
                            ++arrayPos;
                        }
                    }
                } else if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (int)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (int)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (int)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (int)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 6: {
                long[] dest = (long[])destArray;
                if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (long)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (long)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (long)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (long)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 7: {
                float[] dest = (float[])destArray;
                if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)arrayPos);
                        dest[destArrayOffset] = (float)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        dest[destArrayOffset] = (float)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        dest[destArrayOffset] = (float)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        double v = this.f.get(coordinates);
                        dest[destArrayOffset] = (float)v;
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            case 8: {
                double[] dest = (double[])destArray;
                if (this.dim.length == 1) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v;
                        dest[destArrayOffset] = v = this.f.get((double)arrayPos);
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 2) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v;
                        dest[destArrayOffset] = v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos / this.dimX));
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else if (this.dim.length == 3) {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v;
                        dest[destArrayOffset] = v = this.f.get((double)(arrayPos % this.dimX), (double)(arrayPos % this.dimXY / this.dimX), (double)(arrayPos / this.dimXY));
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                } else {
                    while (destArrayOffset < destArrayOffsetMax) {
                        double v;
                        ArraysFuncImpl.coordinatesInDoubles(arrayPos, this.dim, coordinates);
                        dest[destArrayOffset] = v = this.f.get(coordinates);
                        ++destArrayOffset;
                        ++arrayPos;
                    }
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal destElementTypeCode");
            }
        }
    }
}

