/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.ArrayExchanger;
import net.algart.arrays.JArrays;

public class ArraySelector {
    private static final long THRESHOLD = 4L;

    private ArraySelector() {
    }

    public static ArraySelector getQuickSelector() {
        return new ArraySelector();
    }

    public void select(long numberOfElements, long[] percentileIndexes, ArrayComparator comparator, ArrayExchanger exchanger) {
        ArraySelector.checkPercentileIndexes(percentileIndexes, numberOfElements);
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, numberOfElements, comparator, exchanger);
    }

    public void select(long numberOfElements, double[] percentileLevels, ArrayComparator comparator, ArrayExchanger exchanger) {
        if (numberOfElements <= 0L) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + numberOfElements);
        }
        ArraySelector.checkPercentileLevels(percentileLevels);
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, numberOfElements, comparator, exchanger);
    }

    public void select(long from, long to, long requiredIndex, ArrayComparator comparator, ArrayExchanger exchanger) {
        Objects.requireNonNull(comparator, "Null comparator");
        Objects.requireNonNull(exchanger, "Null exchanger");
        if (from < 0L || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        long left = from;
        long right = to - 1L;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (true) {
            if (requiredIndex == left) {
                ArraySelector.selectMin(left, right, comparator, exchanger);
                return;
            }
            if (requiredIndex == right) {
                ArraySelector.selectMax(left, right, comparator, exchanger);
                return;
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            if (right - left < 4L) break;
            long base = left + right >>> 1;
            if (comparator.less(base, left)) {
                exchanger.swap(base, left);
            }
            if (comparator.less(right, base)) {
                exchanger.swap(right, base);
                if (comparator.less(base, left)) {
                    exchanger.swap(base, left);
                }
            }
            exchanger.swap(left + 1L, base);
            base = left + 1L;
            long i = left + 1L;
            long j = right;
            while (true) {
                if (comparator.less(++i, base)) continue;
                while (comparator.less(base, --j)) {
                }
                if (i >= j) break;
                exchanger.swap(i, j);
            }
            exchanger.swap(j, base);
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return;
            }
            if (requiredIndex < j) {
                right = j - 1L;
                continue;
            }
            left = j + 1L;
        }
        ArraySelector.sortLittleArray(left, right, comparator, exchanger);
    }

    public void select(int[] percentileIndexes, byte[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, byte[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public byte select(int from, int to, int requiredIndex, byte[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            byte b;
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                byte a = array[left];
                byte b2 = array[base];
                byte c = array[right];
                if ((b2 & 0xFF) < (a & 0xFF)) {
                    a = b2;
                    b2 = array[left];
                }
                if ((c & 0xFF) < (b2 & 0xFF)) {
                    array[right] = b2;
                    b2 = c;
                    if ((b2 & 0xFF) < (a & 0xFF)) {
                        b2 = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b2;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                byte a = array[left];
                b = array[afterLeft];
                byte c = array[beforeRight];
                byte d = array[right];
                if ((b & 0xFF) < (a & 0xFF)) {
                    a = b;
                    b = array[left];
                }
                if ((d & 0xFF) < (c & 0xFF)) {
                    d = c;
                    c = array[right];
                }
                if ((a & 0xFF) < (c & 0xFF)) {
                    array[left] = a;
                    if ((b & 0xFF) < (d & 0xFF)) {
                        array[right] = d;
                        if ((b & 0xFF) < (c & 0xFF)) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if ((d & 0xFF) < (b & 0xFF)) {
                        array[right] = b;
                        if ((d & 0xFF) < (a & 0xFF)) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            byte a = array[left];
            byte c = array[right];
            int base = left + right >>> 1;
            b = array[base];
            if ((b & 0xFF) < (a & 0xFF)) {
                a = b;
                b = array[left];
            }
            if ((c & 0xFF) < (b & 0xFF)) {
                array[right] = b;
                b = c;
                if ((b & 0xFF) < (a & 0xFF)) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            byte tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if ((array[++i] & 0xFF) < (b & 0xFF)) {
                    continue;
                }
                while ((b & 0xFF) < (array[--j] & 0xFF)) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, char[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, char[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public char select(int from, int to, int requiredIndex, char[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            char b;
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                char a = array[left];
                char b2 = array[base];
                char c = array[right];
                if (b2 < a) {
                    a = b2;
                    b2 = array[left];
                }
                if (c < b2) {
                    array[right] = b2;
                    b2 = c;
                    if (b2 < a) {
                        b2 = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b2;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                char a = array[left];
                b = array[afterLeft];
                char c = array[beforeRight];
                char d = array[right];
                if (b < a) {
                    a = b;
                    b = array[left];
                }
                if (d < c) {
                    d = c;
                    c = array[right];
                }
                if (a < c) {
                    array[left] = a;
                    if (b < d) {
                        array[right] = d;
                        if (b < c) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if (d < b) {
                        array[right] = b;
                        if (d < a) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            char a = array[left];
            char c = array[right];
            int base = left + right >>> 1;
            b = array[base];
            if (b < a) {
                a = b;
                b = array[left];
            }
            if (c < b) {
                array[right] = b;
                b = c;
                if (b < a) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            char tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if (array[++i] < b) {
                    continue;
                }
                while (b < array[--j]) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, short[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, short[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public short select(int from, int to, int requiredIndex, short[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            short b;
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                short a = array[left];
                short b2 = array[base];
                short c = array[right];
                if ((b2 & 0xFFFF) < (a & 0xFFFF)) {
                    a = b2;
                    b2 = array[left];
                }
                if ((c & 0xFFFF) < (b2 & 0xFFFF)) {
                    array[right] = b2;
                    b2 = c;
                    if ((b2 & 0xFFFF) < (a & 0xFFFF)) {
                        b2 = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b2;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                short a = array[left];
                b = array[afterLeft];
                short c = array[beforeRight];
                short d = array[right];
                if ((b & 0xFFFF) < (a & 0xFFFF)) {
                    a = b;
                    b = array[left];
                }
                if ((d & 0xFFFF) < (c & 0xFFFF)) {
                    d = c;
                    c = array[right];
                }
                if ((a & 0xFFFF) < (c & 0xFFFF)) {
                    array[left] = a;
                    if ((b & 0xFFFF) < (d & 0xFFFF)) {
                        array[right] = d;
                        if ((b & 0xFFFF) < (c & 0xFFFF)) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if ((d & 0xFFFF) < (b & 0xFFFF)) {
                        array[right] = b;
                        if ((d & 0xFFFF) < (a & 0xFFFF)) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            short a = array[left];
            short c = array[right];
            int base = left + right >>> 1;
            b = array[base];
            if ((b & 0xFFFF) < (a & 0xFFFF)) {
                a = b;
                b = array[left];
            }
            if ((c & 0xFFFF) < (b & 0xFFFF)) {
                array[right] = b;
                b = c;
                if ((b & 0xFFFF) < (a & 0xFFFF)) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            short tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if ((array[++i] & 0xFFFF) < (b & 0xFFFF)) {
                    continue;
                }
                while ((b & 0xFFFF) < (array[--j] & 0xFFFF)) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, int[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, int[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public int select(int from, int to, int requiredIndex, int[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            int b;
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                int a = array[left];
                int b2 = array[base];
                int c = array[right];
                if (b2 < a) {
                    a = b2;
                    b2 = array[left];
                }
                if (c < b2) {
                    array[right] = b2;
                    b2 = c;
                    if (b2 < a) {
                        b2 = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b2;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                int a = array[left];
                b = array[afterLeft];
                int c = array[beforeRight];
                int d = array[right];
                if (b < a) {
                    a = b;
                    b = array[left];
                }
                if (d < c) {
                    d = c;
                    c = array[right];
                }
                if (a < c) {
                    array[left] = a;
                    if (b < d) {
                        array[right] = d;
                        if (b < c) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if (d < b) {
                        array[right] = b;
                        if (d < a) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            int a = array[left];
            int c = array[right];
            int base = left + right >>> 1;
            b = array[base];
            if (b < a) {
                a = b;
                b = array[left];
            }
            if (c < b) {
                array[right] = b;
                b = c;
                if (b < a) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            int tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if (array[++i] < b) {
                    continue;
                }
                while (b < array[--j]) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, long[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, long[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public long select(int from, int to, int requiredIndex, long[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                long a = array[left];
                long b = array[base];
                long c = array[right];
                if (b < a) {
                    a = b;
                    b = array[left];
                }
                if (c < b) {
                    array[right] = b;
                    b = c;
                    if (b < a) {
                        b = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                long a = array[left];
                long b = array[afterLeft];
                long c = array[beforeRight];
                long d = array[right];
                if (b < a) {
                    a = b;
                    b = array[left];
                }
                if (d < c) {
                    d = c;
                    c = array[right];
                }
                if (a < c) {
                    array[left] = a;
                    if (b < d) {
                        array[right] = d;
                        if (b < c) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if (d < b) {
                        array[right] = b;
                        if (d < a) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            long a = array[left];
            long c = array[right];
            int base = left + right >>> 1;
            long b = array[base];
            if (b < a) {
                a = b;
                b = array[left];
            }
            if (c < b) {
                array[right] = b;
                b = c;
                if (b < a) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            long tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if (array[++i] < b) {
                    continue;
                }
                while (b < array[--j]) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, float[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, float[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public float select(int from, int to, int requiredIndex, float[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            float b;
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                float a = array[left];
                float b2 = array[base];
                float c = array[right];
                if (Float.compare(b2, a) < 0) {
                    a = b2;
                    b2 = array[left];
                }
                if (Float.compare(c, b2) < 0) {
                    array[right] = b2;
                    b2 = c;
                    if (Float.compare(b2, a) < 0) {
                        b2 = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b2;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                float a = array[left];
                b = array[afterLeft];
                float c = array[beforeRight];
                float d = array[right];
                if (Float.compare(b, a) < 0) {
                    a = b;
                    b = array[left];
                }
                if (Float.compare(d, c) < 0) {
                    d = c;
                    c = array[right];
                }
                if (Float.compare(a, c) < 0) {
                    array[left] = a;
                    if (Float.compare(b, d) < 0) {
                        array[right] = d;
                        if (Float.compare(b, c) < 0) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if (Float.compare(d, b) < 0) {
                        array[right] = b;
                        if (Float.compare(d, a) < 0) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            float a = array[left];
            float c = array[right];
            int base = left + right >>> 1;
            b = array[base];
            if (Float.compare(b, a) < 0) {
                a = b;
                b = array[left];
            }
            if (Float.compare(c, b) < 0) {
                array[right] = b;
                b = c;
                if (Float.compare(b, a) < 0) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            float tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if (Float.compare(array[++i], b) < 0) {
                    continue;
                }
                while (Float.compare(b, array[--j]) < 0) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public void select(int[] percentileIndexes, double[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileIndexes, 0, percentileIndexes.length - 1, length, array);
    }

    public void select(double[] percentileLevels, double[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        this.selectSomePercentiles(percentileLevels, 0, percentileLevels.length - 1, length, array);
    }

    public double select(int from, int to, int requiredIndex, double[] array) {
        Objects.requireNonNull(array, "Null array");
        if (from < 0 || from >= to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: must be 0 <= from < to");
        }
        int left = from;
        int right = to - 1;
        if (requiredIndex < left || requiredIndex > right) {
            throw new IllegalArgumentException("Index " + requiredIndex + " is out of range " + left + ".." + right);
        }
        while (requiredIndex != left) {
            if (requiredIndex == right) {
                return ArraySelector.selectMax(left, right, array);
            }
            assert (requiredIndex > left);
            assert (requiredIndex < right);
            int difference = right - left;
            if (difference == 2) {
                int base = left + 1;
                double a = array[left];
                double b = array[base];
                double c = array[right];
                if (Double.compare(b, a) < 0) {
                    a = b;
                    b = array[left];
                }
                if (Double.compare(c, b) < 0) {
                    array[right] = b;
                    b = c;
                    if (Double.compare(b, a) < 0) {
                        b = a;
                        a = c;
                    }
                }
                array[left] = a;
                array[base] = b;
                return array[requiredIndex];
            }
            if (difference == 3) {
                int afterLeft = left + 1;
                int beforeRight = right - 1;
                double a = array[left];
                double b = array[afterLeft];
                double c = array[beforeRight];
                double d = array[right];
                if (Double.compare(b, a) < 0) {
                    a = b;
                    b = array[left];
                }
                if (Double.compare(d, c) < 0) {
                    d = c;
                    c = array[right];
                }
                if (Double.compare(a, c) < 0) {
                    array[left] = a;
                    if (Double.compare(b, d) < 0) {
                        array[right] = d;
                        if (Double.compare(b, c) < 0) {
                            array[afterLeft] = b;
                            array[beforeRight] = c;
                        } else {
                            array[afterLeft] = c;
                            array[beforeRight] = b;
                        }
                    } else {
                        array[afterLeft] = c;
                        array[beforeRight] = d;
                        array[right] = b;
                    }
                } else {
                    array[left] = c;
                    if (Double.compare(d, b) < 0) {
                        array[right] = b;
                        if (Double.compare(d, a) < 0) {
                            array[afterLeft] = d;
                            array[beforeRight] = a;
                        } else {
                            array[afterLeft] = a;
                            array[beforeRight] = d;
                        }
                    } else {
                        array[afterLeft] = a;
                        array[beforeRight] = b;
                        array[right] = d;
                    }
                }
                return array[requiredIndex];
            }
            double a = array[left];
            double c = array[right];
            int base = left + right >>> 1;
            double b = array[base];
            if (Double.compare(b, a) < 0) {
                a = b;
                b = array[left];
            }
            if (Double.compare(c, b) < 0) {
                array[right] = b;
                b = c;
                if (Double.compare(b, a) < 0) {
                    b = a;
                    a = c;
                }
            }
            array[left] = a;
            double tmp = array[left + 1];
            array[left + 1] = b;
            array[base] = tmp;
            base = left + 1;
            int i = left + 1;
            int j = right;
            while (true) {
                if (Double.compare(array[++i], b) < 0) {
                    continue;
                }
                while (Double.compare(b, array[--j]) < 0) {
                }
                if (i >= j) break;
                a = array[i];
                array[i] = array[j];
                array[j] = a;
            }
            array[base] = array[j];
            array[j] = b;
            assert (left <= j);
            assert (j <= right);
            if (requiredIndex == j) {
                return array[requiredIndex];
            }
            if (requiredIndex < j) {
                right = j - 1;
                continue;
            }
            left = j + 1;
        }
        return ArraySelector.selectMin(left, right, array);
    }

    public static long percentileIndex(double percentileLevel, long numberOfElements) {
        return Math.round(percentileLevel * (double)(numberOfElements - 1L));
    }

    public static int percentileIndex(double percentileLevel, int numberOfElements) {
        return (int)Math.round(percentileLevel * (double)(numberOfElements - 1));
    }

    public static void checkPercentileIndexes(long[] percentileIndexes, long numberOfElements) {
        if (numberOfElements <= 0L) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + numberOfElements);
        }
        Objects.requireNonNull(percentileIndexes, "Null percentile indexes");
        for (int k = 0; k < percentileIndexes.length; ++k) {
            if (percentileIndexes[k] < 0L || percentileIndexes[k] >= numberOfElements) {
                throw new IllegalArgumentException("Illegal percentile index #" + k + " = " + percentileIndexes[k] + ": out of range 0.." + (numberOfElements - 1L));
            }
            if (k <= 0 || percentileIndexes[k] >= percentileIndexes[k - 1]) continue;
            throw new IllegalArgumentException("Illegal percentile indexes order: index #" + (k - 1) + " > index #" + k + " in array (" + JArrays.toString(percentileIndexes, ", ", 1024) + ")");
        }
    }

    public static void checkPercentileIndexes(int[] percentileIndexes, int numberOfElements) {
        Objects.requireNonNull(percentileIndexes, "Null percentile indexes");
        for (int k = 0; k < percentileIndexes.length; ++k) {
            if (percentileIndexes[k] < 0 || percentileIndexes[k] >= numberOfElements) {
                throw new IllegalArgumentException("Illegal percentile index #" + k + " = " + percentileIndexes[k] + ": out of range 0.." + (numberOfElements - 1));
            }
            if (k <= 0 || percentileIndexes[k] >= percentileIndexes[k - 1]) continue;
            throw new IllegalArgumentException("Illegal percentile indexes order: index #" + (k - 1) + " > index #" + k + " in array (" + JArrays.toString(percentileIndexes, ", ", 1024) + ")");
        }
    }

    public static void checkPercentileLevels(double[] percentileLevels) {
        Objects.requireNonNull(percentileLevels, "Null percentile levels");
        if (percentileLevels.length == 0) {
            throw new IllegalArgumentException("No percentile levels");
        }
        for (int k = 0; k < percentileLevels.length; ++k) {
            if (Double.isNaN(percentileLevels[k]) || percentileLevels[k] < 0.0 || percentileLevels[k] > 1.0) {
                throw new IllegalArgumentException("Illegal percentile level #" + k + " = " + percentileLevels[k] + ": out of range 0..1");
            }
            if (k <= 0 || !(percentileLevels[k] < percentileLevels[k - 1])) continue;
            throw new IllegalArgumentException("Illegal percentile levels order: level #" + (k - 1) + " > level #" + k + " in array (" + JArrays.toString(percentileLevels, ", ", 1024) + ")");
        }
    }

    public String toString() {
        return "QuickSelect algorithm";
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, long numberOfElements, ArrayComparator comparator, ArrayExchanger exchanger) {
        long right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        long base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        long left = leftPercentile == 0 ? 0L : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1L;
        long l = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1L : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1L;
        if (base >= left && base <= right) {
            this.select(left, right + 1L, base, comparator, exchanger);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, comparator, exchanger);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, comparator, exchanger);
        }
    }

    private void selectSomePercentiles(long[] percentileIndexes, int leftPercentile, int rightPercentile, long numberOfElements, ArrayComparator comparator, ArrayExchanger exchanger) {
        long right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        long base = percentileIndexes[basePercentile];
        long left = leftPercentile == 0 ? 0L : percentileIndexes[leftPercentile - 1] + 1L;
        long l = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1L : percentileIndexes[rightPercentile + 1] - 1L;
        if (base >= left && base <= right) {
            this.select(left, right + 1L, base, comparator, exchanger);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, comparator, exchanger);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, comparator, exchanger);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, byte[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, byte[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, char[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, char[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, short[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, short[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, int[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, int[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, long[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, long[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, float[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, float[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(double[] percentileLevels, int leftPercentile, int rightPercentile, int numberOfElements, double[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = ArraySelector.percentileIndex(percentileLevels[basePercentile], numberOfElements);
        int left = leftPercentile == 0 ? 0 : ArraySelector.percentileIndex(percentileLevels[leftPercentile - 1], numberOfElements) + 1;
        int n = right = rightPercentile == percentileLevels.length - 1 ? numberOfElements - 1 : ArraySelector.percentileIndex(percentileLevels[rightPercentile + 1], numberOfElements) - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileLevels, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileLevels, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private void selectSomePercentiles(int[] percentileIndexes, int leftPercentile, int rightPercentile, int numberOfElements, double[] array) {
        int right;
        int basePercentile = leftPercentile + rightPercentile >>> 1;
        int base = percentileIndexes[basePercentile];
        int left = leftPercentile == 0 ? 0 : percentileIndexes[leftPercentile - 1] + 1;
        int n = right = rightPercentile == percentileIndexes.length - 1 ? numberOfElements - 1 : percentileIndexes[rightPercentile + 1] - 1;
        if (base >= left && base <= right) {
            this.select(left, right + 1, base, array);
        }
        if (basePercentile > leftPercentile) {
            this.selectSomePercentiles(percentileIndexes, leftPercentile, basePercentile - 1, numberOfElements, array);
        }
        if (rightPercentile > basePercentile) {
            this.selectSomePercentiles(percentileIndexes, basePercentile + 1, rightPercentile, numberOfElements, array);
        }
    }

    private static void selectMin(long left, long right, ArrayComparator comparator, ArrayExchanger exchanger) {
        for (long i = left + 1L; i <= right; ++i) {
            if (!comparator.less(i, left)) continue;
            exchanger.swap(left, i);
        }
    }

    private static void selectMax(long left, long right, ArrayComparator comparator, ArrayExchanger exchanger) {
        for (long i = right - 1L; i >= left; --i) {
            if (!comparator.less(right, i)) continue;
            exchanger.swap(right, i);
        }
    }

    private static void sortLittleArray(long left, long right, ArrayComparator comparator, ArrayExchanger exchanger) {
        for (long i = left + 1L; i <= right; ++i) {
            for (long j = i - 1L; j >= left && comparator.less(j + 1L, j); --j) {
                exchanger.swap(j, j + 1L);
            }
        }
    }

    private static byte selectMin(int left, int right, byte[] array) {
        int index = left;
        int result = array[left] & 0xFF;
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i] & 0xFF;
            if (v >= result) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = (byte)result;
        }
        return (byte)result;
    }

    private static byte selectMax(int left, int right, byte[] array) {
        int index = right;
        int result = array[right] & 0xFF;
        for (int i = right - 1; i >= left; --i) {
            int v = array[i] & 0xFF;
            if (result >= v) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = (byte)result;
        }
        return (byte)result;
    }

    private static void sortArray3(int left, int right, byte[] array) {
        int base = left + 1;
        byte a = array[left];
        byte b = array[base];
        byte c = array[right];
        if ((b & 0xFF) < (a & 0xFF)) {
            a = b;
            b = array[left];
        }
        if ((c & 0xFF) < (b & 0xFF)) {
            array[right] = b;
            b = c;
            if ((b & 0xFF) < (a & 0xFF)) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, byte[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        byte a = array[left];
        byte b = array[afterLeft];
        byte c = array[beforeRight];
        byte d = array[right];
        if ((b & 0xFF) < (a & 0xFF)) {
            a = b;
            b = array[left];
        }
        if ((d & 0xFF) < (c & 0xFF)) {
            d = c;
            c = array[right];
        }
        if ((a & 0xFF) < (c & 0xFF)) {
            array[left] = a;
            if ((b & 0xFF) < (d & 0xFF)) {
                array[right] = d;
                if ((b & 0xFF) < (c & 0xFF)) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if ((d & 0xFF) < (b & 0xFF)) {
                array[right] = b;
                if ((d & 0xFF) < (a & 0xFF)) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, byte[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i] & 0xFF;
            for (int j = i - 1; j >= left && v < (array[j] & 0xFF); --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = (byte)v;
        }
    }

    private static char selectMin(int left, int right, char[] array) {
        int index = left;
        char result = array[left];
        for (int i = left + 1; i <= right; ++i) {
            char v = array[i];
            if (v >= result) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = result;
        }
        return result;
    }

    private static char selectMax(int left, int right, char[] array) {
        int index = right;
        char result = array[right];
        for (int i = right - 1; i >= left; --i) {
            char v = array[i];
            if (result >= v) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = result;
        }
        return result;
    }

    private static void sortArray3(int left, int right, char[] array) {
        int base = left + 1;
        char a = array[left];
        char b = array[base];
        char c = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (c < b) {
            array[right] = b;
            b = c;
            if (b < a) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, char[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        char a = array[left];
        char b = array[afterLeft];
        char c = array[beforeRight];
        char d = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (d < c) {
            d = c;
            c = array[right];
        }
        if (a < c) {
            array[left] = a;
            if (b < d) {
                array[right] = d;
                if (b < c) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if (d < b) {
                array[right] = b;
                if (d < a) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, char[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            char v = array[i];
            for (int j = i - 1; j >= left && v < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = v;
        }
    }

    private static short selectMin(int left, int right, short[] array) {
        int index = left;
        int result = array[left] & 0xFFFF;
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i] & 0xFFFF;
            if (v >= result) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = (short)result;
        }
        return (short)result;
    }

    private static short selectMax(int left, int right, short[] array) {
        int index = right;
        int result = array[right] & 0xFFFF;
        for (int i = right - 1; i >= left; --i) {
            int v = array[i] & 0xFFFF;
            if (result >= v) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = (short)result;
        }
        return (short)result;
    }

    private static void sortArray3(int left, int right, short[] array) {
        int base = left + 1;
        short a = array[left];
        short b = array[base];
        short c = array[right];
        if ((b & 0xFFFF) < (a & 0xFFFF)) {
            a = b;
            b = array[left];
        }
        if ((c & 0xFFFF) < (b & 0xFFFF)) {
            array[right] = b;
            b = c;
            if ((b & 0xFFFF) < (a & 0xFFFF)) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, short[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        short a = array[left];
        short b = array[afterLeft];
        short c = array[beforeRight];
        short d = array[right];
        if ((b & 0xFFFF) < (a & 0xFFFF)) {
            a = b;
            b = array[left];
        }
        if ((d & 0xFFFF) < (c & 0xFFFF)) {
            d = c;
            c = array[right];
        }
        if ((a & 0xFFFF) < (c & 0xFFFF)) {
            array[left] = a;
            if ((b & 0xFFFF) < (d & 0xFFFF)) {
                array[right] = d;
                if ((b & 0xFFFF) < (c & 0xFFFF)) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if ((d & 0xFFFF) < (b & 0xFFFF)) {
                array[right] = b;
                if ((d & 0xFFFF) < (a & 0xFFFF)) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, short[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i] & 0xFFFF;
            for (int j = i - 1; j >= left && v < (array[j] & 0xFFFF); --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = (short)v;
        }
    }

    private static int selectMin(int left, int right, int[] array) {
        int index = left;
        int result = array[left];
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i];
            if (v >= result) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = result;
        }
        return result;
    }

    private static int selectMax(int left, int right, int[] array) {
        int index = right;
        int result = array[right];
        for (int i = right - 1; i >= left; --i) {
            int v = array[i];
            if (result >= v) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = result;
        }
        return result;
    }

    private static void sortArray3(int left, int right, int[] array) {
        int base = left + 1;
        int a = array[left];
        int b = array[base];
        int c = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (c < b) {
            array[right] = b;
            b = c;
            if (b < a) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, int[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        int a = array[left];
        int b = array[afterLeft];
        int c = array[beforeRight];
        int d = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (d < c) {
            d = c;
            c = array[right];
        }
        if (a < c) {
            array[left] = a;
            if (b < d) {
                array[right] = d;
                if (b < c) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if (d < b) {
                array[right] = b;
                if (d < a) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, int[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            int v = array[i];
            for (int j = i - 1; j >= left && v < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = v;
        }
    }

    private static long selectMin(int left, int right, long[] array) {
        int index = left;
        long result = array[left];
        for (int i = left + 1; i <= right; ++i) {
            long v = array[i];
            if (v >= result) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = result;
        }
        return result;
    }

    private static long selectMax(int left, int right, long[] array) {
        int index = right;
        long result = array[right];
        for (int i = right - 1; i >= left; --i) {
            long v = array[i];
            if (result >= v) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = result;
        }
        return result;
    }

    private static void sortArray3(int left, int right, long[] array) {
        int base = left + 1;
        long a = array[left];
        long b = array[base];
        long c = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (c < b) {
            array[right] = b;
            b = c;
            if (b < a) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, long[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        long a = array[left];
        long b = array[afterLeft];
        long c = array[beforeRight];
        long d = array[right];
        if (b < a) {
            a = b;
            b = array[left];
        }
        if (d < c) {
            d = c;
            c = array[right];
        }
        if (a < c) {
            array[left] = a;
            if (b < d) {
                array[right] = d;
                if (b < c) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if (d < b) {
                array[right] = b;
                if (d < a) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, long[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            long v = array[i];
            for (int j = i - 1; j >= left && v < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = v;
        }
    }

    private static float selectMin(int left, int right, float[] array) {
        int index = left;
        float result = array[left];
        for (int i = left + 1; i <= right; ++i) {
            float v = array[i];
            if (Float.compare(v, result) >= 0) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = result;
        }
        return result;
    }

    private static float selectMax(int left, int right, float[] array) {
        int index = right;
        float result = array[right];
        for (int i = right - 1; i >= left; --i) {
            float v = array[i];
            if (Float.compare(result, v) >= 0) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = result;
        }
        return result;
    }

    private static void sortArray3(int left, int right, float[] array) {
        int base = left + 1;
        float a = array[left];
        float b = array[base];
        float c = array[right];
        if (Float.compare(b, a) < 0) {
            a = b;
            b = array[left];
        }
        if (Float.compare(c, b) < 0) {
            array[right] = b;
            b = c;
            if (Float.compare(b, a) < 0) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, float[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        float a = array[left];
        float b = array[afterLeft];
        float c = array[beforeRight];
        float d = array[right];
        if (Float.compare(b, a) < 0) {
            a = b;
            b = array[left];
        }
        if (Float.compare(d, c) < 0) {
            d = c;
            c = array[right];
        }
        if (Float.compare(a, c) < 0) {
            array[left] = a;
            if (Float.compare(b, d) < 0) {
                array[right] = d;
                if (Float.compare(b, c) < 0) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if (Float.compare(d, b) < 0) {
                array[right] = b;
                if (Float.compare(d, a) < 0) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, float[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            float v = array[i];
            for (int j = i - 1; j >= left && v < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = v;
        }
    }

    private static double selectMin(int left, int right, double[] array) {
        int index = left;
        double result = array[left];
        for (int i = left + 1; i <= right; ++i) {
            double v = array[i];
            if (Double.compare(v, result) >= 0) continue;
            result = v;
            index = i;
        }
        if (index != left) {
            array[index] = array[left];
            array[left] = result;
        }
        return result;
    }

    private static double selectMax(int left, int right, double[] array) {
        int index = right;
        double result = array[right];
        for (int i = right - 1; i >= left; --i) {
            double v = array[i];
            if (Double.compare(result, v) >= 0) continue;
            result = v;
            index = i;
        }
        if (index != right) {
            array[index] = array[right];
            array[right] = result;
        }
        return result;
    }

    private static void sortArray3(int left, int right, double[] array) {
        int base = left + 1;
        double a = array[left];
        double b = array[base];
        double c = array[right];
        if (Double.compare(b, a) < 0) {
            a = b;
            b = array[left];
        }
        if (Double.compare(c, b) < 0) {
            array[right] = b;
            b = c;
            if (Double.compare(b, a) < 0) {
                b = a;
                a = c;
            }
        }
        array[left] = a;
        array[base] = b;
    }

    private static void sortArray4(int left, int right, double[] array) {
        int afterLeft = left + 1;
        int beforeRight = right - 1;
        double a = array[left];
        double b = array[afterLeft];
        double c = array[beforeRight];
        double d = array[right];
        if (Double.compare(b, a) < 0) {
            a = b;
            b = array[left];
        }
        if (Double.compare(d, c) < 0) {
            d = c;
            c = array[right];
        }
        if (Double.compare(a, c) < 0) {
            array[left] = a;
            if (Double.compare(b, d) < 0) {
                array[right] = d;
                if (Double.compare(b, c) < 0) {
                    array[afterLeft] = b;
                    array[beforeRight] = c;
                } else {
                    array[afterLeft] = c;
                    array[beforeRight] = b;
                }
            } else {
                array[afterLeft] = c;
                array[beforeRight] = d;
                array[right] = b;
            }
        } else {
            array[left] = c;
            if (Double.compare(d, b) < 0) {
                array[right] = b;
                if (Double.compare(d, a) < 0) {
                    array[afterLeft] = d;
                    array[beforeRight] = a;
                } else {
                    array[afterLeft] = a;
                    array[beforeRight] = d;
                }
            } else {
                array[afterLeft] = a;
                array[beforeRight] = b;
                array[right] = d;
            }
        }
    }

    private static void sortLittleArray(int left, int right, double[] array) {
        switch (right - left) {
            default: 
        }
        for (int i = left + 1; i <= right; ++i) {
            double v = array[i];
            for (int j = i - 1; j >= left && v < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = v;
        }
    }
}

