/*
 * Decompiled with CFR 0.152.
 */
package com.siams.data.vpjson.project.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.data.vpjson.project.filter.Filter;
import com.siams.data.vpjson.project.filter.segment.Segment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Segmentation
extends Filter {
    static final String type = "segmentation";
    @JsonProperty
    protected String background = "255,255,255";
    @JsonProperty(value="mode")
    protected String colorMode;
    @JsonProperty(value="paint")
    protected boolean paint;
    @JsonProperty(value="segments")
    List<Segment> segments;
    @JsonProperty(value="allow_edit_mask")
    protected Integer allowEditMask;
    @JsonProperty(value="seg_mode")
    protected String segmentationMode;

    @JsonCreator
    public Segmentation() {
        super(type);
        this.colorMode = ColorMode.RGB.id;
        this.paint = true;
        this.segments = new ArrayList<Segment>();
        this.allowEditMask = 0;
        this.segmentationMode = Mode.DEFAULT.id;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    @JsonGetter(value="mode")
    public String getColorMode() {
        return this.colorMode;
    }

    @JsonSetter(value="mode")
    public void setColorMode(String colorMode) {
        this.colorMode = colorMode;
    }

    @JsonIgnore
    public void setColorMode(ColorMode colorMode) {
        this.colorMode = colorMode.toString();
    }

    @JsonGetter(value="paint")
    Integer getPaint() {
        return this.paint ? 1 : 0;
    }

    @JsonIgnore
    public boolean isPaint() {
        return this.paint;
    }

    @JsonSetter(value="paint")
    void setPaint(Integer paint) {
        this.paint = paint == 1;
    }

    @JsonIgnore
    public void setPaint(boolean isPaint) {
        this.paint = isPaint;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public Integer getAllowEditMask() {
        return this.allowEditMask;
    }

    public void setAllowEditMask(Integer allowEditMask) {
        this.allowEditMask = allowEditMask;
    }

    public String getSegmentationMode() {
        return this.segmentationMode;
    }

    @JsonSetter(value="seg_mode")
    public void setSegmentationMode(String segmentationMode) {
        this.segmentationMode = segmentationMode;
    }

    @JsonIgnore
    public void setSegmentationMode(Mode segmentationMode) {
        this.segmentationMode = segmentationMode.toString();
    }

    public void addSegment(Segment segment) {
        Objects.requireNonNull(segment, "Segment required");
        this.segments.add(segment);
    }

    public static enum ColorMode {
        RGB("RGB"),
        Y("Y"),
        YUV("YUV"),
        HLS("HLS"),
        H("H"),
        L("L"),
        HL("HL");

        String id;

        private ColorMode(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    static enum Mode {
        DEFAULT(""),
        CLUSTER("cluster"),
        DUAL("dual");

        String id;

        private Mode(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

