/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.Context;
import org.scijava.util.IteratorPlus;
import org.scijava.util.PlatformUtils;

public final class FileUtils {
    public static final int DEFAULT_SHORTENER_THRESHOLD = 4;
    public static final String SHORTENER_BACKSLASH_REGEX = "\\\\";
    public static final String SHORTENER_SLASH_REGEX = "/";
    public static final String SHORTENER_BACKSLASH = "\\";
    public static final String SHORTENER_SLASH = "/";
    public static final String SHORTENER_ELLIPSE = "...";
    private static final Pattern VERSION_PATTERN = FileUtils.buildVersionPattern();

    private FileUtils() {
    }

    public static String getPath(File file) {
        String path = file.getAbsolutePath();
        String slash = System.getProperty("file.separator");
        return FileUtils.getPath(path, slash);
    }

    public static String getPath(String path, String separator) {
        return path.replaceAll(Pattern.quote(separator), "/");
    }

    public static String getExtension(File file) {
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(dot + 1);
    }

    public static String getExtension(String path) {
        return FileUtils.getExtension(new File(path));
    }

    public static Date getModifiedTime(File file) {
        long modifiedTime = file.lastModified();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(modifiedTime);
        return c.getTime();
    }

    public static byte[] readFile(File file) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too large");
        }
        byte[] bytes = new byte[(int)length];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static void writeFile(File file, byte[] bytes) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes);
        }
    }

    public static String stripFilenameVersion(String filename) {
        Matcher matcher = VERSION_PATTERN.matcher(filename);
        if (!matcher.matches()) {
            return filename;
        }
        return matcher.group(1) + matcher.group(5);
    }

    public static File[] getAllVersions(File directory, String filename) {
        Matcher matcher = VERSION_PATTERN.matcher(filename);
        if (!matcher.matches()) {
            File[] fileArray;
            File file = new File(directory, filename);
            if (file.exists()) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = file;
            } else {
                fileArray = null;
            }
            return fileArray;
        }
        final String baseName = matcher.group(1);
        final String classifier = matcher.group(6);
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(baseName)) {
                    return false;
                }
                Matcher matcher2 = VERSION_PATTERN.matcher(name);
                return matcher2.matches() && baseName.equals(matcher2.group(1)) && this.equals(classifier, matcher2.group(6));
            }

            private boolean equals(String a, String b) {
                if (a == null) {
                    return b == null;
                }
                return a.equals(b);
            }
        });
    }

    public static File urlToFile(URL url) {
        return url == null ? null : FileUtils.urlToFile(url.toString());
    }

    public static File urlToFile(String url) {
        String path = url;
        if (path.startsWith("jar:")) {
            int index = path.indexOf("!/");
            path = path.substring(4, index);
        }
        try {
            if (PlatformUtils.isWindows() && path.matches("file:[A-Za-z]:.*")) {
                path = "file:/" + path.substring(5);
            }
            return new File(new URL(path).toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
            return new File(path);
        }
        throw new IllegalArgumentException("Invalid URL: " + url);
    }

    public static String shortenPath(String path) {
        return FileUtils.shortenPath(path, 4);
    }

    public static String shortenPath(String path, int threshold) {
        String regex = SHORTENER_BACKSLASH_REGEX;
        String sep = SHORTENER_BACKSLASH;
        if (path.indexOf("/") > 0) {
            regex = "/";
            sep = "/";
        }
        String[] pathtemp = path.split(regex);
        int elem = 0;
        String[] newtemp = new String[pathtemp.length];
        int j = 0;
        for (int i = 0; i < pathtemp.length; ++i) {
            if (pathtemp[i].equals("")) continue;
            newtemp[j++] = pathtemp[i];
            ++elem;
        }
        pathtemp = newtemp;
        if (elem > threshold) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int pos2dots = path.indexOf(":");
            if (pos2dots > 0) {
                sb.append(path.substring(0, pos2dots + 2));
                ++index;
                if (path.indexOf(":/") > 0 && pathtemp[0].length() > 2) {
                    sb.append("/");
                }
            } else {
                boolean isUNC = path.substring(0, 2).equals(SHORTENER_BACKSLASH_REGEX);
                if (isUNC) {
                    sb.append(SHORTENER_BACKSLASH).append(SHORTENER_BACKSLASH);
                }
            }
            while (index <= threshold) {
                sb.append(pathtemp[index]).append(sep);
                ++index;
            }
            if (index == elem - 1) {
                sb.append(pathtemp[elem - 1]);
            } else {
                sb.append(SHORTENER_ELLIPSE).append(sep).append(pathtemp[elem - 1]);
            }
            return sb.toString();
        }
        return path;
    }

    public static String limitPath(String path, int limit) {
        int i;
        if (path.length() <= limit) {
            return path;
        }
        char[] shortPathArray = new char[limit];
        char[] pathArray = path.toCharArray();
        char[] ellipseArray = SHORTENER_ELLIPSE.toCharArray();
        int pathindex = pathArray.length - 1;
        int shortpathindex = limit - 1;
        for (i = 0; i < limit && pathArray[pathindex - i] != '/' && pathArray[pathindex - i] != '\\'; ++i) {
            shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
        }
        int free = limit - i;
        if (free < SHORTENER_ELLIPSE.length()) {
            for (int j = 0; j < ellipseArray.length; ++j) {
                shortPathArray[j] = ellipseArray[j];
            }
        } else {
            int j = 0;
            while (j + ellipseArray.length < free) {
                shortPathArray[j] = pathArray[j];
                ++j;
            }
            int k = 0;
            while (j + k < free) {
                shortPathArray[j + k] = ellipseArray[k];
                ++k;
            }
        }
        return new String(shortPathArray);
    }

    public static File createTemporaryDirectory(String prefix) throws IOException {
        return FileUtils.createTemporaryDirectory(prefix, null, null);
    }

    public static File createTemporaryDirectory(String prefix, String suffix) throws IOException {
        return FileUtils.createTemporaryDirectory(prefix, suffix, null);
    }

    public static File createTemporaryDirectory(String prefix, String suffix, File directory) throws IOException {
        for (int counter = 0; counter < 10; ++counter) {
            File file = File.createTempFile(prefix, suffix, directory);
            if (!file.delete()) {
                throw new IOException("Could not delete file " + file);
            }
            if (!file.mkdir()) continue;
            return file;
        }
        throw new IOException("Could not create temporary directory (too many race conditions?)");
    }

    public static boolean deleteRecursively(File directory) {
        if (directory == null) {
            return true;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            return true;
        }
        for (File file : list) {
            if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteRecursively(file))) continue;
            return false;
        }
        return directory.delete();
    }

    public static Collection<URL> listContents(URL directory) {
        return FileUtils.listContents(directory, true, true);
    }

    public static Collection<URL> listContents(URL directory, boolean recurse, boolean filesOnly) {
        return FileUtils.appendContents(new ArrayList<URL>(), directory, recurse, filesOnly);
    }

    public static Collection<URL> appendContents(Collection<URL> result, URL directory) {
        return FileUtils.appendContents(result, directory, true, true);
    }

    public static Collection<URL> appendContents(Collection<URL> result, URL directory, boolean recurse, boolean filesOnly) {
        block24: {
            String protocol;
            block23: {
                if (directory == null) {
                    return result;
                }
                protocol = directory.getProtocol();
                if (!protocol.equals("file")) break block23;
                File dir = FileUtils.urlToFile(directory);
                File[] list = dir.listFiles();
                if (list == null) break block24;
                for (File file : list) {
                    try {
                        if (!filesOnly || file.isFile()) {
                            result.add(file.toURI().toURL());
                        }
                        if (!recurse || !file.isDirectory()) continue;
                        FileUtils.appendContents(result, file.toURI().toURL(), recurse, filesOnly);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                break block24;
            }
            if (protocol.equals("jar")) {
                try {
                    String url = directory.toString();
                    int bang = url.indexOf("!/");
                    if (bang < 0) {
                        return result;
                    }
                    String prefix = url.substring(bang + 2);
                    String baseURL = url.substring(0, bang + 2);
                    JarURLConnection connection = (JarURLConnection)new URL(baseURL).openConnection();
                    try (JarFile jar = connection.getJarFile();){
                        for (JarEntry entry : new IteratorPlus<JarEntry>(jar.entries())) {
                            int slash;
                            String urlEncoded = new URI(null, null, entry.getName(), null).toString();
                            if (urlEncoded.length() <= prefix.length() || !urlEncoded.startsWith(prefix) || filesOnly && urlEncoded.endsWith("/") || !recurse && (slash = urlEncoded.indexOf("/", prefix.length())) >= 0 && slash != urlEncoded.length() - 1) continue;
                            result.add(new URL(baseURL + urlEncoded));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return result;
    }

    public static Map<String, URL> findResources(String regex, String pathPrefix, File baseDirectory) {
        ClassLoader loader = Context.getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            urls.addAll(Collections.list(loader.getResources(pathPrefix + "/")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (baseDirectory != null) {
            try {
                urls.add(new File(baseDirectory, pathPrefix).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return FileUtils.findResources(regex, urls);
    }

    public static Map<String, URL> findResources(String regex, Iterable<URL> urls) {
        HashMap<String, URL> result = new HashMap<String, URL>();
        Pattern pattern = regex == null ? null : Pattern.compile(regex);
        for (URL url : urls) {
            FileUtils.getResources(pattern, result, url);
        }
        return result;
    }

    private static Pattern buildVersionPattern() {
        String version = "\\d+(\\.\\d+|\\d{7})+[a-z]?\\d?(-[A-Za-z0-9.]+?|\\.GA)*?";
        String suffix = "\\.jar(-[a-z]*)?";
        return Pattern.compile("(.+?)(-\\d+(\\.\\d+|\\d{7})+[a-z]?\\d?(-[A-Za-z0-9.]+?|\\.GA)*?)?((-(" + FileUtils.classifiers() + "))?(" + "\\.jar(-[a-z]*)?" + "))");
    }

    private static String classifiers() {
        String[] classifiers = new String[]{"swing", "swt", "shaded", "sources", "javadoc", "natives?-?\\w*", "(natives-)?(android|linux|macosx|macos|solaris|windows)-(aarch64|amd64|arm64|armv6hf|armv6|arm|i386|i486|i586|i686|universal|x86[_-]32|x86[_-]64|x86)"};
        StringBuilder sb = new StringBuilder("(");
        for (String classifier : classifiers) {
            if (sb.length() > 1) {
                sb.append("|");
            }
            sb.append(classifier);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void getResources(Pattern pattern, Map<String, URL> result, URL base) {
        String prefix = FileUtils.urlPath(base);
        if (prefix == null) {
            return;
        }
        for (URL url : FileUtils.listContents(base)) {
            String key;
            String s = FileUtils.urlPath(url);
            if (s == null || !s.startsWith(prefix) || pattern != null && !pattern.matcher(s).matches() || (key = FileUtils.urlPath(s.substring(prefix.length()))) == null) continue;
            result.put(key, url);
        }
    }

    private static String urlPath(URL url) {
        try {
            return url.toURI().toString();
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    private static String urlPath(String path) {
        try {
            return new URI(path).getPath();
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    @Deprecated
    public static Matcher matchVersionedFilename(String filename) {
        return VERSION_PATTERN.matcher(filename);
    }
}

