/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.matrices.stitching.Frame;
import net.algart.matrices.stitching.FramePosition;
import net.algart.matrices.stitching.ShiftFramePosition;
import net.algart.matrices.stitching.StitchingFunc;
import net.algart.matrices.stitching.StitchingMethod;

public final class ShiftStitchingMethod<P extends FramePosition>
implements StitchingMethod<P> {
    private final double defaultValue;
    private final boolean weighted;

    private ShiftStitchingMethod(double defaultValue, boolean weighted) {
        this.defaultValue = defaultValue;
        this.weighted = weighted;
    }

    public static <P extends FramePosition> ShiftStitchingMethod<P> getNearestNeighbourInstance(double defaultValue) {
        return new ShiftStitchingMethod<P>(defaultValue, false);
    }

    public static <P extends FramePosition> ShiftStitchingMethod<P> getWeightedNeighboursInstance(double defaultValue) {
        return new ShiftStitchingMethod<P>(defaultValue, true);
    }

    @Override
    public boolean simpleBehaviorForEmptySpace() {
        return true;
    }

    @Override
    public boolean simpleBehaviorForSingleFrame() {
        return true;
    }

    @Override
    public StitchingFunc getStitchingFunc(List<? extends Frame<P>> frames) {
        Objects.requireNonNull(frames, "Null frames argument");
        if (this.weighted) {
            return new ShiftWeighedStitchingFunc(frames);
        }
        return new ShiftNearestStitchingFunc(frames);
    }

    public String toString() {
        return "parallel shift stitching method";
    }

    private class ShiftWeighedStitchingFunc
    implements StitchingFunc {
        private final RectangularArea[] areas;

        private ShiftWeighedStitchingFunc(List<? extends Frame<P>> frames) {
            this.areas = new RectangularArea[frames.size()];
            int n = 0;
            Point shiftMinus05 = null;
            for (Frame frame : frames) {
                RectangularArea area = ShiftFramePosition.area(frame.position().area().min(), frame.matrix().dimensions());
                if (shiftMinus05 == null) {
                    double[] shift = new double[area.coordCount()];
                    JArrays.fill(shift, -0.5);
                    shiftMinus05 = Point.of(shift);
                }
                this.areas[n] = area.shift(shiftMinus05);
                ++n;
            }
        }

        @Override
        public double get(double[] coordinates, double[] values) {
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                distances[k] = this.areas[k].parallelDistance(coordinates);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1) {
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(coordinates)) < 0.0) {
                b -= d3;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(coordinates)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(coordinates)) < 0.0) {
                b -= d4;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(coordinates)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(coordinates)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(coordinates)) < 0.0) {
                b -= d5;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(coordinates)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(coordinates)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(coordinates)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(coordinates)) < 0.0) {
                b -= d6;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(coordinates)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(coordinates)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(coordinates)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(coordinates)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(coordinates)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(coordinates)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(coordinates)) < 0.0) {
                b -= d6;
            }
            if (v7 == v7 && (d7 = this.areas[7].parallelDistance(coordinates)) < 0.0) {
                b -= d7;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double[] values) {
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                distances[k] = this.areas[k].parallelDistance(x0);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get1D(double x0, double v0, double v1) {
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                d3 = this.areas[3].parallelDistance(dArray);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                d3 = this.areas[3].parallelDistance(dArray);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                d4 = this.areas[4].parallelDistance(dArray);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                d3 = this.areas[3].parallelDistance(dArray);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                d4 = this.areas[4].parallelDistance(dArray);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                d5 = this.areas[5].parallelDistance(dArray);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                d3 = this.areas[3].parallelDistance(dArray);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                d4 = this.areas[4].parallelDistance(dArray);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                d5 = this.areas[5].parallelDistance(dArray);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (v6 == v6) {
                double[] dArray = new double[]{x0};
                d6 = this.areas[6].parallelDistance(dArray);
                if (d6 < 0.0) {
                    b -= d6;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0) {
                double[] dArray = new double[]{x0};
                d0 = this.areas[0].parallelDistance(dArray);
                if (d0 < 0.0) {
                    b -= d0;
                }
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                d1 = this.areas[1].parallelDistance(dArray);
                if (d1 < 0.0) {
                    b -= d1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                d2 = this.areas[2].parallelDistance(dArray);
                if (d2 < 0.0) {
                    b -= d2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                d3 = this.areas[3].parallelDistance(dArray);
                if (d3 < 0.0) {
                    b -= d3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                d4 = this.areas[4].parallelDistance(dArray);
                if (d4 < 0.0) {
                    b -= d4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                d5 = this.areas[5].parallelDistance(dArray);
                if (d5 < 0.0) {
                    b -= d5;
                }
            }
            if (v6 == v6) {
                double[] dArray = new double[]{x0};
                d6 = this.areas[6].parallelDistance(dArray);
                if (d6 < 0.0) {
                    b -= d6;
                }
            }
            if (v7 == v7) {
                double[] dArray = new double[]{x0};
                d7 = this.areas[7].parallelDistance(dArray);
                if (d7 < 0.0) {
                    b -= d7;
                }
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double[] values) {
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                distances[k] = this.areas[k].parallelDistance(x0, x1);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1) {
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1)) < 0.0) {
                b -= d3;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1)) < 0.0) {
                b -= d4;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1)) < 0.0) {
                b -= d5;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(x0, x1)) < 0.0) {
                b -= d6;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(x0, x1)) < 0.0) {
                b -= d6;
            }
            if (v7 == v7 && (d7 = this.areas[7].parallelDistance(x0, x1)) < 0.0) {
                b -= d7;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double[] values) {
            double[] distances = new double[values.length];
            double b = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                distances[k] = this.areas[k].parallelDistance(x0, x1, x2);
                if (!(distances[k] < 0.0)) continue;
                b -= distances[k];
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (!(distances[k] < 0.0)) continue;
                a -= distances[k] * values[k];
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1) {
            double d0 = 0.0;
            double d1 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d3;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d4;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d5;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d6;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            return a / b;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double b = 0.0;
            if (v0 == v0 && (d0 = this.areas[0].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d0;
            }
            if (v1 == v1 && (d1 = this.areas[1].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d1;
            }
            if (v2 == v2 && (d2 = this.areas[2].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d2;
            }
            if (v3 == v3 && (d3 = this.areas[3].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d3;
            }
            if (v4 == v4 && (d4 = this.areas[4].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d4;
            }
            if (v5 == v5 && (d5 = this.areas[5].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d5;
            }
            if (v6 == v6 && (d6 = this.areas[6].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d6;
            }
            if (v7 == v7 && (d7 = this.areas[7].parallelDistance(x0, x1, x2)) < 0.0) {
                b -= d7;
            }
            if (b == 0.0) {
                return ShiftStitchingMethod.this.defaultValue;
            }
            double a = 0.0;
            if (d0 < 0.0) {
                a -= d0 * v0;
            }
            if (d1 < 0.0) {
                a -= d1 * v1;
            }
            if (d2 < 0.0) {
                a -= d2 * v2;
            }
            if (d3 < 0.0) {
                a -= d3 * v3;
            }
            if (d4 < 0.0) {
                a -= d4 * v4;
            }
            if (d5 < 0.0) {
                a -= d5 * v5;
            }
            if (d6 < 0.0) {
                a -= d6 * v6;
            }
            if (d7 < 0.0) {
                a -= d7 * v7;
            }
            return a / b;
        }

        public String toString() {
            return "\"weighted-frames\" simple stitching function";
        }
    }

    private class ShiftNearestStitchingFunc
    implements StitchingFunc {
        private final RectangularArea[] areas;

        private ShiftNearestStitchingFunc(List<? extends Frame<P>> frames) {
            this.areas = new RectangularArea[frames.size()];
            int n = 0;
            for (Frame frame : frames) {
                this.areas[n] = ShiftFramePosition.area(frame.position().area().min(), frame.matrix().dimensions());
                ++n;
            }
        }

        @Override
        public double get(double[] coordinates, double[] values) {
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int k = 0; k < values.length; ++k) {
                double distance;
                if (values[k] != values[k] || !((distance = this.areas[k].parallelDistance(coordinates)) <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                nearest = v1;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                nearest = v2;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(coordinates)) <= minDistance) {
                nearest = v3;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(coordinates)) <= minDistance) {
                nearest = v4;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(coordinates)) <= minDistance) {
                nearest = v5;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(coordinates)) <= minDistance) {
                nearest = v6;
            }
            return nearest;
        }

        @Override
        public double get(double[] coordinates, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(coordinates);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(coordinates)) <= minDistance) {
                minDistance = distance;
                nearest = v6;
            }
            if (v7 == v7 && (distance = this.areas[7].parallelDistance(coordinates)) <= minDistance) {
                nearest = v7;
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double[] values) {
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] != values[k]) continue;
                double[] dArray = new double[]{x0};
                double distance = this.areas[k].parallelDistance(dArray);
                if (!(distance <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get1D(double x0, double v0, double v1) {
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                double distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v1;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v2;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                distance = this.areas[3].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v3;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                distance = this.areas[3].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                distance = this.areas[4].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v4;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                distance = this.areas[3].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                distance = this.areas[4].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                distance = this.areas[5].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v5;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                distance = this.areas[3].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                distance = this.areas[4].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                distance = this.areas[5].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v5;
                }
            }
            if (v6 == v6) {
                double[] dArray = new double[]{x0};
                distance = this.areas[6].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v6;
                }
            }
            return nearest;
        }

        @Override
        public double get1D(double x0, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0);
                nearest = v0;
            }
            if (v1 == v1) {
                double[] dArray = new double[]{x0};
                distance = this.areas[1].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v1;
                }
            }
            if (v2 == v2) {
                double[] dArray = new double[]{x0};
                distance = this.areas[2].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v2;
                }
            }
            if (v3 == v3) {
                double[] dArray = new double[]{x0};
                distance = this.areas[3].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v3;
                }
            }
            if (v4 == v4) {
                double[] dArray = new double[]{x0};
                distance = this.areas[4].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v4;
                }
            }
            if (v5 == v5) {
                double[] dArray = new double[]{x0};
                distance = this.areas[5].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v5;
                }
            }
            if (v6 == v6) {
                double[] dArray = new double[]{x0};
                distance = this.areas[6].parallelDistance(dArray);
                if (distance <= minDistance) {
                    minDistance = distance;
                    nearest = v6;
                }
            }
            if (v7 == v7) {
                double[] dArray = new double[]{x0};
                distance = this.areas[7].parallelDistance(dArray);
                if (distance <= minDistance) {
                    nearest = v7;
                }
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double[] values) {
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int k = 0; k < values.length; ++k) {
                double distance;
                if (values[k] != values[k] || !((distance = this.areas[k].parallelDistance(x0, x1)) <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v1;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v2;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v3;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v4;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v5;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v6;
            }
            return nearest;
        }

        @Override
        public double get2D(double x0, double x1, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(x0, x1)) <= minDistance) {
                minDistance = distance;
                nearest = v6;
            }
            if (v7 == v7 && (distance = this.areas[7].parallelDistance(x0, x1)) <= minDistance) {
                nearest = v7;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double[] values) {
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int k = 0; k < values.length; ++k) {
                double distance;
                if (values[k] != values[k] || !((distance = this.areas[k].parallelDistance(x0, x1, x2)) <= minDistance)) continue;
                minDistance = distance;
                nearest = values[k];
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0) {
            if (v0 == v0) {
                return v0;
            }
            return ShiftStitchingMethod.this.defaultValue;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v1;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v2;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v3;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v4;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v5;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v6;
            }
            return nearest;
        }

        @Override
        public double get3D(double x0, double x1, double x2, double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
            double distance;
            double nearest = ShiftStitchingMethod.this.defaultValue;
            double minDistance = Double.POSITIVE_INFINITY;
            if (v0 == v0) {
                minDistance = this.areas[0].parallelDistance(x0, x1, x2);
                nearest = v0;
            }
            if (v1 == v1 && (distance = this.areas[1].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v1;
            }
            if (v2 == v2 && (distance = this.areas[2].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v2;
            }
            if (v3 == v3 && (distance = this.areas[3].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v3;
            }
            if (v4 == v4 && (distance = this.areas[4].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v4;
            }
            if (v5 == v5 && (distance = this.areas[5].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v5;
            }
            if (v6 == v6 && (distance = this.areas[6].parallelDistance(x0, x1, x2)) <= minDistance) {
                minDistance = distance;
                nearest = v6;
            }
            if (v7 == v7 && (distance = this.areas[7].parallelDistance(x0, x1, x2)) <= minDistance) {
                nearest = v7;
            }
            return nearest;
        }

        public String toString() {
            return "\"nearest-frame\" simple stitching function";
        }
    }
}

