/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.Abstract2DProcessor;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DWrapper;
import net.algart.matrices.scanning.ConnectivityType;

public class ContainingMainBoundaryFinder
extends Abstract2DProcessor {
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private final IRectangularArea matrixRectangle;
    private final byte[] brackets;
    private final long matrixSize;
    private Matrix<? extends BitArray> matrix = null;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;
    private boolean clearBoundary = false;
    private Boundary2DScanner scanner = null;
    private long[] offsets = JArrays.EMPTY_LONGS;
    private int offsetsLength = 0;
    private boolean ready = false;

    private ContainingMainBoundaryFinder(long[] dimensions) {
        super(Boolean.TYPE, dimensions);
        this.matrixRectangle = IRectangularArea.of(0L, 0L, this.dimX() - 1, this.dimY() - 1L);
        this.brackets = new byte[this.dimX() + 1];
        this.matrixSize = this.matrixSize();
    }

    public static ContainingMainBoundaryFinder newInstance(long[] dimensions) {
        return new ContainingMainBoundaryFinder(dimensions);
    }

    public static ContainingMainBoundaryFinder newInstance(long dimX, long dimY) {
        return ContainingMainBoundaryFinder.newInstance(new long[]{dimX, dimY});
    }

    public static ContainingMainBoundaryFinder newInstance(Matrix<? extends BitArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix");
        ContainingMainBoundaryFinder result = new ContainingMainBoundaryFinder(matrix.dimensions());
        result.matrix = matrix;
        return result;
    }

    public Matrix<? extends BitArray> getMatrix() {
        if (this.matrix == null) {
            throw new IllegalStateException("Scanned matrix is not specified yet");
        }
        return this.matrix;
    }

    public ContainingMainBoundaryFinder setMatrix(Matrix<? extends BitArray> matrix) {
        this.checkCompatibility(matrix);
        this.matrix = matrix;
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public ContainingMainBoundaryFinder setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = Objects.requireNonNull(connectivityType, "Null connectivityType");
        return this;
    }

    public boolean isClearBoundary() {
        return this.clearBoundary;
    }

    public ContainingMainBoundaryFinder setClearBoundary(boolean clearBoundary) {
        this.clearBoundary = clearBoundary;
        return this;
    }

    public IPoint fillAtRectangle(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
        return this.drawRectangleAndFind(result, source, rectangle, true, false);
    }

    public IPoint clearOutsideRectangle(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
        return this.drawRectangleAndFind(result, source, rectangle, false, true);
    }

    public IPoint buildAroundRectangle(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
        return this.drawRectangleAndFind(result, source, rectangle, true, true);
    }

    public long find(long x, long y) {
        this.getMatrix();
        long result = this.findUnsortedVerticalSegmentsAndReturnLeftX(x, y);
        Arrays.sort(this.offsets, 0, this.offsetsLength);
        this.ready = true;
        return result;
    }

    public void fillBitsInside(Matrix<? extends UpdatableBitArray> result) {
        this.fillInside(result, 1.0);
    }

    public void clearBitsOutside(Matrix<? extends UpdatableBitArray> result) {
        this.fillOutside(result, 0.0);
    }

    public void fillInside(Matrix<? extends UpdatablePArray> result, double filler) {
        Objects.requireNonNull(result, "Null result matrix");
        this.checkReady();
        if (!result.dimEquals(this.matrix)) {
            throw new IllegalArgumentException("Matrix to fill " + String.valueOf(result) + " has another dimensions than the scanned matrix " + String.valueOf(this.matrix));
        }
        assert ((this.offsetsLength & 1) == 0);
        UpdatablePArray array = result.array();
        long matrixSize = array.length();
        for (int k = 0; k < this.offsetsLength; k += 2) {
            long from = this.offsets[k];
            long to = this.offsets[k + 1];
            assert (from >= 0L && to > from && to <= matrixSize) : "Invalid from, to = " + from + ", " + to + " (full length = " + matrixSize + ")";
            array.fill(from, to - from, filler);
        }
    }

    public void fillOutside(Matrix<? extends UpdatablePArray> result, double filler) {
        Objects.requireNonNull(result, "Null result matrix");
        this.checkReady();
        if (!result.dimEquals(this.matrix)) {
            throw new IllegalArgumentException("Matrix to fill " + String.valueOf(result) + " has another dimensions than the scanned matrix " + String.valueOf(this.matrix));
        }
        assert ((this.offsetsLength & 1) == 0);
        UpdatablePArray array = result.array();
        long matrixSize = array.length();
        long to = 0L;
        for (int k = 0; k < this.offsetsLength; k += 2) {
            long from = this.offsets[k];
            array.fill(to, from - to, filler);
            to = this.offsets[k + 1];
            assert (from >= 0L && to > from && to <= matrixSize) : "Invalid from, to = " + from + ", " + to + " (full length = " + matrixSize + ")";
        }
        array.fill(to, matrixSize - to, filler);
    }

    public IRectangularArea findContainingRectangle() {
        this.checkReady();
        assert ((this.offsetsLength & 1) == 0);
        if (this.offsetsLength == 0) {
            return null;
        }
        long minX = Long.MAX_VALUE;
        long maxX = Long.MIN_VALUE;
        long minY = Long.MAX_VALUE;
        long maxY = Long.MIN_VALUE;
        int dimX = this.dimX();
        for (int k = 0; k < this.offsetsLength; k += 2) {
            long from = this.offsets[k];
            long to = this.offsets[k + 1];
            assert (from >= 0L && to > from && to <= this.matrixSize) : "Invalid from, to = " + from + ", " + to + " (full length = " + this.matrixSize + ")";
            long y = from / (long)dimX;
            long lineOffset = y * (long)dimX;
            long x1 = from - lineOffset;
            long x2 = to - 1L - lineOffset;
            assert (x2 < lineOffset + (long)dimX) : "Invalid from, to = " + from + ", " + to + ": different rows " + y + "!=" + (to - 1L) / (long)dimX;
            assert (x1 <= x2) : "Invalid from, to = " + from + ", " + to + ": left = " + x1 + " > right = " + x2;
            minX = Math.min(minX, x1);
            maxX = Math.max(maxX, x2);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return IRectangularArea.of(minX, minY, maxX, maxY);
    }

    public void clear() {
        this.offsetsLength = 0;
    }

    public Boundary2DScanner scanner() {
        this.checkReady();
        assert (this.scanner != null);
        return this.scanner;
    }

    public void freeResources() {
        this.clear();
        this.offsets = JArrays.EMPTY_LONGS;
    }

    private IPoint drawRectangleAndFind(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle, boolean fill, boolean clear) {
        long found;
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(source, "Null source matrix");
        Objects.requireNonNull(rectangle, "Null rectangle");
        if (rectangle.coordCount() != 2) {
            throw new IllegalArgumentException("Rectangular area is not 2-dimensional: " + String.valueOf(rectangle));
        }
        if (!result.dimEquals(source)) {
            throw new IllegalArgumentException("Matrix to fill " + String.valueOf(result) + " has another dimensions than the scanned source " + String.valueOf(source));
        }
        this.setMatrix(result);
        this.clear();
        IRectangularArea r = rectangle.intersection(this.matrixRectangle);
        if (r == null) {
            if (clear) {
                result.array().fill(0L);
            } else {
                result.array().copy(source.array());
                if (this.clearBoundary) {
                    Matrices.clearBoundary(result, 1);
                }
            }
            return null;
        }
        result.array().copy(source.array());
        Matrix<? extends UpdatableBitArray> subResult = result.subMatrix(r);
        subResult.array().fill(1L);
        if (this.clearBoundary) {
            Matrices.clearBoundary(result, 1);
        }
        if ((found = this.find(r.minX(), r.minY())) < 0L) {
            throw new AssertionError((Object)("Didn't find unit pixel at " + String.valueOf(r.min()) + ", which set to 1 before; result is " + found));
        }
        if (fill) {
            if (clear) {
                result.array().fill(0L);
            }
            this.fillBitsInside(result);
        } else {
            this.clearBitsOutside(result);
            subResult.array().copy(source.subMatrix(r).array());
        }
        return IPoint.of(found, r.minY());
    }

    private long findUnsortedVerticalSegmentsAndReturnLeftX(long x, long y) {
        if (x < 0L || x >= (long)this.dimX() || y < 0L || y >= this.dimY()) {
            throw new IndexOutOfBoundsException("Position (" + x + ", " + y + ") is out of the matrix " + String.valueOf(this.matrix));
        }
        Arrays.fill(this.brackets, (byte)0);
        this.clear();
        BitArray bitArray = this.matrix.array();
        long from = y * (long)this.dimX();
        long to = from + x + 1L;
        this.scanner = Boundary2DScanner.getSingleBoundaryScanner(this.matrix, this.connectivityType);
        VerticalSegmentsFinder wrapper = new VerticalSegmentsFinder(this.scanner, y);
        long p = bitArray.indexOf(from, to, true);
        while (p != -1L) {
            int leftX = (int)(p - from);
            this.clear();
            if ((long)leftX > x) {
                return -1L;
            }
            ((Boundary2DScanner)wrapper).goTo(leftX, y, Boundary2DScanner.Side.X_MINUS);
            wrapper.scanBoundary();
            if ((this.offsetsLength & 1) != 0) {
                throw new AssertionError((Object)("Unbalanced brackets at (" + leftX + ", " + y + ")"));
            }
            assert (this.brackets[leftX] == 1);
            int rightX = this.findRightBracket(leftX);
            if (rightX == -1) {
                throw new AssertionError((Object)("Right bracket not found after the left bracket at (" + leftX + ", " + y + ")"));
            }
            if ((long)rightX > x) {
                return leftX;
            }
            p = bitArray.indexOf(p + (long)(rightX - leftX), to, true);
        }
        this.clear();
        return -1L;
    }

    private int findRightBracket(int left) {
        int n = this.dimX() + 1;
        for (int i = left + 1; i < n; ++i) {
            if (this.brackets[i] == 0) continue;
            assert (this.brackets[i] == 2) : "invalid bracket " + this.brackets[i] + " at " + i + " after left bracket at " + left + "; but the right bracket expected!";
            return i;
        }
        return -1;
    }

    private void addOffset(long offset) {
        if (this.offsetsLength == this.offsets.length) {
            this.ensureCapacity((long)this.offsetsLength + 1L);
        }
        this.offsets[this.offsetsLength++] = offset;
    }

    private void ensureCapacity(long newLength) {
        if (newLength > (long)this.offsets.length) {
            if (newLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too long boundary: >=2^31 vertical segments");
            }
            this.offsets = Arrays.copyOf(this.offsets, Math.max(16, Math.max((int)newLength, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.offsets.length)))));
        }
    }

    private void checkReady() {
        if (!this.ready) {
            throw new IllegalStateException("Data are not ready: finding has not been performed yet");
        }
    }

    private class VerticalSegmentsFinder
    extends Boundary2DWrapper {
        final long y;

        VerticalSegmentsFinder(Boundary2DScanner parent, long y) {
            super(parent);
            this.y = y;
        }

        @Override
        public void next() {
            this.parent.next();
            switch (this.parent.side()) {
                case X_MINUS: {
                    this.leftBracket();
                    break;
                }
                case X_PLUS: {
                    this.rightBracket();
                }
            }
        }

        private void leftBracket() {
            if (this.parent.y() == this.y) {
                ContainingMainBoundaryFinder.this.brackets[(int)this.parent.x()] = 1;
            }
            ContainingMainBoundaryFinder.this.addOffset(this.parent.currentIndexInArray());
        }

        private void rightBracket() {
            if (this.parent.y() == this.y) {
                ContainingMainBoundaryFinder.this.brackets[(int)this.parent.x() + 1] = 2;
            }
            ContainingMainBoundaryFinder.this.addOffset(this.parent.currentIndexInArray() + 1L);
        }
    }
}

