/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePIntegerArray;
import net.algart.matrices.scanning.ConnectivityType;

public abstract class ConnectedObjectScanner
implements Cloneable {
    private static final long MAX_TEMP_JAVA_MEMORY = Arrays.SystemSettings.maxTempJavaMemory();
    private static final long MAX_TEMP_JAVA_INTS = Math.min(MAX_TEMP_JAVA_MEMORY / 4L, 0x3FFFFFFFL);
    private static final long MAX_TEMP_JAVA_LONGS = MAX_TEMP_JAVA_INTS / 2L;
    private static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 262144);
    private static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 262144);
    Matrix<? extends UpdatableBitArray> matrix;
    UpdatableBitArray array;
    final ConnectivityType connectivityType;
    final long[] dimensions;
    final int dimCount;
    final long arrayLength;
    final byte[][] coordShifts;
    final long[] xShifts;
    final long[] yShifts;
    final long[] indexShifts;
    final int apertureSize;
    final int[] intIndexShifts;
    ArrayContext context;
    MemoryModel mm;
    ElementVisitor elementVisitor;
    long[] coordinates;
    long index;
    boolean forceClearing;
    long maxUsedMemory = 0L;
    Matrix<UpdatableBitArray> workMemory = null;

    private ConnectedObjectScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        this.dimensions = matrix.dimensions();
        this.dimCount = this.dimensions.length;
        if (this.dimCount > 9) {
            throw new IllegalArgumentException(String.valueOf(ConnectedObjectScanner.class) + " cannot process a matrix with more than 9 dimensions (" + String.valueOf(matrix) + ")");
        }
        this.matrix = matrix;
        this.connectivityType = connectivityType;
        this.array = matrix.array();
        this.arrayLength = this.array.length();
        this.coordShifts = connectivityType.apertureShifts(this.dimCount);
        this.apertureSize = this.coordShifts.length;
        this.xShifts = new long[this.apertureSize];
        this.yShifts = new long[this.apertureSize];
        this.indexShifts = new long[this.apertureSize];
        this.intIndexShifts = new int[this.apertureSize];
        long[] temp = new long[this.dimCount];
        for (int k = 0; k < this.apertureSize; ++k) {
            for (int j = 0; j < this.dimCount; ++j) {
                temp[j] = this.coordShifts[k][j];
            }
            this.xShifts[k] = this.coordShifts[k][0];
            this.yShifts[k] = this.coordShifts[k][1];
            this.indexShifts[k] = matrix.uncheckedIndex(temp);
            this.intIndexShifts[k] = (int)this.indexShifts[k];
        }
        this.coordinates = new long[this.dimCount];
    }

    public static ConnectedObjectScanner getBreadthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new BreadthFirstScanner(matrix, connectivityType);
    }

    public static ConnectedObjectScanner getDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new DepthFirstScanner(matrix, connectivityType);
    }

    public static ConnectedObjectScanner getStacklessDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new StacklessDepthFirstScanner(matrix, connectivityType, true);
    }

    public static ConnectedObjectScanner getUncheckedBreadthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new UncheckedBreadthFirstScanner(matrix, connectivityType);
    }

    public static ConnectedObjectScanner getUncheckedDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new UncheckedDepthFirstScanner(matrix, connectivityType);
    }

    public static ConnectedObjectScanner getUncheckedStacklessDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
        return new StacklessDepthFirstScanner(matrix, connectivityType, false);
    }

    public abstract ConnectedObjectScanner clone();

    public final void reset() {
        this.matrix(this.matrix);
    }

    public void matrix(Matrix<? extends UpdatableBitArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        if (!matrix.dimEquals(this.matrix)) {
            throw new SizeMismatchException("The passed matrix have different dimensions than the current one: the passed is " + String.valueOf(matrix) + ", the current is " + String.valueOf(this.matrix));
        }
        this.matrix = matrix;
        this.array = matrix.array();
    }

    public Matrix<? extends UpdatableBitArray> matrix() {
        return this.matrix;
    }

    public ConnectivityType connectivityType() {
        return this.connectivityType;
    }

    public boolean nextUnitBit(long[] coordinates) {
        if (coordinates.length != this.dimCount) {
            throw new IllegalArgumentException("Number of passed coordinates " + coordinates.length + " does not match the number of dimensions of " + String.valueOf(this.matrix));
        }
        long from = this.matrix.index(coordinates);
        long index = this.indexOfUnit(from);
        if (index == -1L) {
            return false;
        }
        this.matrix.coordinates(index, coordinates);
        return true;
    }

    public long clear(ArrayContext context, ElementVisitor elementVisitor, long[] coordinates, boolean forceClearing) {
        if (coordinates.length != this.dimCount) {
            throw new IllegalArgumentException("Number of passed coordinates " + coordinates.length + " does not match the number of dimensions of " + String.valueOf(this.matrix));
        }
        this.index = this.matrix.index(coordinates);
        if (!this.matrix.array().getBit(this.index)) {
            return 0L;
        }
        System.arraycopy(coordinates, 0, this.coordinates, 0, this.dimCount);
        this.forceClearing = forceClearing;
        this.context = context;
        this.mm = context == null ? SimpleMemoryModel.getInstance() : context.getMemoryModel();
        this.elementVisitor = elementVisitor;
        return this.doClear();
    }

    public long clear(ArrayContext context, ElementVisitor elementVisitor, long ... coordinates) {
        return this.clear(context, elementVisitor, coordinates, true);
    }

    public long clear(ArrayContext context, long[] coordinates, boolean forceClearing) {
        return this.clear(context, null, coordinates, forceClearing);
    }

    public long clear(ArrayContext context, long ... coordinates) {
        return this.clear(context, null, coordinates, true);
    }

    public long clearAllBySizes(ArrayContext context, Matrix<? extends BitArray> mask, long minNonClearedSize, long maxNonClearedSize) {
        if (mask != null && !mask.dimEquals(this.matrix)) {
            throw new SizeMismatchException("Current matrix and mask dimensions mismatch: current matrix is " + String.valueOf(this.matrix) + ", mask is " + String.valueOf(mask));
        }
        if (this.workMemory == null) {
            SimpleMemoryModel mm = context == null || Arrays.sizeOf(this.array) < Arrays.SystemSettings.maxTempJavaMemory() ? SimpleMemoryModel.getInstance() : context.getMemoryModel();
            this.workMemory = mm.newBitMatrix(this.matrix.dimensions());
            assert (this.workMemory != null);
            if (!(mm instanceof SimpleMemoryModel)) {
                this.workMemory = this.workMemory.structureLike(this.matrix);
            }
        }
        Matrices.copy(context == null ? null : context.part(0.0, 0.02), this.workMemory, this.matrix);
        this.reset();
        if (context != null) {
            context = context.part(0.02, 1.0);
        }
        ConnectedObjectScanner workScanner = this.clone();
        workScanner.matrix(this.workMemory);
        MaskElementCounter maskElementCounter = mask == null ? null : new MaskElementCounter(mask);
        long[] coordinates = new long[this.matrix.dimCount()];
        long pixelCounter = 0L;
        while (workScanner.nextUnitBit(coordinates)) {
            long size = workScanner.clear(context, (ElementVisitor)maskElementCounter, coordinates, false);
            if (maskElementCounter != null) {
                size = maskElementCounter.counter();
                maskElementCounter.reset();
            }
            if (size < minNonClearedSize || size > maxNonClearedSize) {
                pixelCounter += this.clear(context, coordinates, true);
            }
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(Boolean.TYPE, this.matrix.index(coordinates), this.arrayLength);
        }
        return pixelCounter;
    }

    public long clearAllConnected(ArrayContext context, Matrix<? extends UpdatableBitArray> objects) {
        Objects.requireNonNull(objects, "Null secondary matrix");
        if (!objects.dimEquals(this.matrix)) {
            throw new SizeMismatchException("Current and secondary matrix dimensions mismatch: current matrix is " + String.valueOf(this.matrix) + ", secondary is " + String.valueOf(objects));
        }
        this.reset();
        ConnectedObjectScanner secondaryScanner = this.clone();
        secondaryScanner.matrix(objects);
        ClearerOfSecondaryMatrix clearer = new ClearerOfSecondaryMatrix(context, secondaryScanner);
        long[] coordinates = new long[this.matrix.dimCount()];
        while (this.nextUnitBit(coordinates)) {
            this.clear(context, (ElementVisitor)clearer, coordinates);
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(Boolean.TYPE, this.matrix.index(coordinates), this.arrayLength);
        }
        return clearer.pixelCounter;
    }

    public final void updateProgress(ArrayContext context, long ... coordinates) {
        if (context != null) {
            context.updateProgress(new ArrayContext.Event(Boolean.TYPE, this.matrix.index(coordinates), this.arrayLength));
        }
    }

    public long maxUsedMemory() {
        return this.maxUsedMemory;
    }

    public void resetUsedMemory() {
        this.maxUsedMemory = 0L;
    }

    public void freeResources(ArrayContext context) {
        if (this.workMemory != null) {
            this.workMemory.freeResources(context);
        }
    }

    long indexOfUnit(long from) {
        return this.array.indexOf(from, this.arrayLength, true);
    }

    abstract long doClear();

    private static class BreadthFirstScanner
    extends ConnectedObjectScanner {
        final int[] intCoordinates;
        final long[] longCoordinates;

        BreadthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
            super(matrix, connectivityType);
            this.intCoordinates = new int[this.dimCount];
            this.longCoordinates = new long[this.dimCount];
        }

        @Override
        public ConnectedObjectScanner clone() {
            BreadthFirstScanner result = new BreadthFirstScanner(this.matrix, this.connectivityType);
            result.maxUsedMemory = this.maxUsedMemory;
            return result;
        }

        @Override
        long doClear() {
            if (this.arrayLength < 0x7FFFFFFEL) {
                return this.breadthFirstSearchInt();
            }
            return this.breadthFirstSearchLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long breadthFirstSearchInt() {
            assert (this.dimCount <= 9);
            assert ((long)this.apertureSize * 10L <= Integer.MAX_VALUE);
            int queueSpaceForAperture = (this.dimCount + 1) * this.apertureSize;
            int[] buffer = (int[])INT_BUFFERS.requestArray();
            try {
                int[] queue = buffer;
                int blockSize = this.dimCount + 1;
                long h = 0L;
                long r = blockSize;
                long n = blockSize;
                long qSize = queue.length / blockSize * blockSize;
                for (int j = 0; j < this.dimCount; ++j) {
                    queue[j] = (int)this.coordinates[j];
                }
                queue[this.dimCount] = (int)this.index;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(this.coordinates, this.index);
                }
                this.array.clearBitNoSync(this.index);
                MutableIntArray largeQueue = null;
                int intIndex = 157;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    if (n + (long)queueSpaceForAperture > qSize) {
                        if (qSize > 0x3FFFFFFFFFFFFFFFL) {
                            throw new TooLargeArrayException("Necessary queue is larger than 2^63-1");
                        }
                        long newSize = 2L * qSize;
                        if (largeQueue == null) {
                            if (newSize > MAX_TEMP_JAVA_INTS) {
                                largeQueue = this.mm.newIntArray(newSize);
                                if (h <= r) {
                                    assert (h - r == n);
                                    largeQueue.setData(0L, queue, (int)h, (int)n);
                                } else {
                                    largeQueue.setData(0L, queue, (int)h, (int)qSize - (int)h);
                                    largeQueue.setData((int)qSize - (int)h, queue, 0, (int)r);
                                }
                                queue = null;
                            } else {
                                int[] newQueue = new int[(int)newSize];
                                if (h <= r) {
                                    assert (h - r == n);
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)n);
                                } else {
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)qSize - (int)h);
                                    System.arraycopy(queue, 0, newQueue, (int)qSize - (int)h, (int)r);
                                }
                                queue = newQueue;
                            }
                        } else {
                            largeQueue.length(newSize);
                            if (h <= r) {
                                assert (h - r == n);
                                largeQueue.copy(0L, h, n);
                            } else {
                                largeQueue.copy(qSize, 0L, r);
                                largeQueue.copy(0L, h, qSize - h);
                                largeQueue.copy(qSize - h, qSize, r);
                            }
                        }
                        qSize = newSize;
                        h = 0L;
                        r = n;
                    }
                    int hInt = (int)h;
                    if (largeQueue != null) {
                        for (int j = 0; j < this.dimCount; ++j) {
                            this.intCoordinates[j] = largeQueue.getInt(h + (long)j);
                        }
                        intIndex = largeQueue.getInt(h + (long)this.dimCount);
                    }
                    if ((h += (long)blockSize) >= qSize) {
                        h = 0L;
                    }
                    n -= (long)blockSize;
                    for (int neighbourIndex = 0; neighbourIndex < this.apertureSize; ++neighbourIndex) {
                        int j;
                        boolean outside = false;
                        if (largeQueue == null) {
                            for (j = 0; j < this.dimCount; ++j) {
                                coord = queue[hInt + j] + this.coordShifts[neighbourIndex][j];
                                this.coordinates[j] = coord;
                                if (coord >= 0 && (long)coord < this.dimensions[j]) continue;
                                outside = true;
                            }
                            this.index = (long)queue[hInt + this.dimCount] + this.indexShifts[neighbourIndex];
                        } else {
                            for (j = 0; j < this.dimCount; ++j) {
                                coord = this.intCoordinates[j] + this.coordShifts[neighbourIndex][j];
                                this.coordinates[j] = coord;
                                if (coord >= 0 && (long)coord < this.dimensions[j]) continue;
                                outside = true;
                            }
                            this.index = (long)intIndex + this.indexShifts[neighbourIndex];
                        }
                        if (outside) continue;
                        if (this.array.getBit(this.index)) {
                            ++counter;
                            if (largeQueue == null) {
                                int rInt = (int)r;
                                for (int j2 = 0; j2 < this.dimCount; ++j2) {
                                    queue[rInt + j2] = (int)this.coordinates[j2];
                                }
                                queue[rInt + this.dimCount] = (int)this.index;
                            } else {
                                for (j = 0; j < this.dimCount; ++j) {
                                    largeQueue.setLong(r + (long)j, this.coordinates[j]);
                                }
                                largeQueue.setLong(r + (long)this.dimCount, this.index);
                            }
                            if ((r += (long)blockSize) >= qSize) {
                                r = 0L;
                            }
                            n += (long)blockSize;
                            if ((counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.elementVisitor.visit(this.coordinates, this.index);
                            }
                            this.array.clearBitNoSync(this.index);
                        }
                        if (n <= maxMemory) continue;
                        maxMemory = n;
                    }
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 4L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                INT_BUFFERS.releaseArray(buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long breadthFirstSearchLong() {
            assert (this.dimCount <= 9);
            assert ((long)this.apertureSize * 10L <= Integer.MAX_VALUE);
            int queueSpaceForAperture = (this.dimCount + 1) * this.apertureSize;
            long[] buffer = (long[])LONG_BUFFERS.requestArray();
            try {
                long[] queue = buffer;
                int blockSize = this.dimCount + 1;
                long h = 0L;
                long r = blockSize;
                long n = blockSize;
                long qSize = queue.length / blockSize * blockSize;
                for (int j = 0; j < this.dimCount; ++j) {
                    queue[j] = this.coordinates[j];
                }
                queue[this.dimCount] = this.index;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(this.coordinates, this.index);
                }
                this.array.clearBitNoSync(this.index);
                MutableLongArray largeQueue = null;
                long longIndex = 157L;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    if (n + (long)queueSpaceForAperture > qSize) {
                        if (qSize > 0x3FFFFFFFFFFFFFFFL) {
                            throw new TooLargeArrayException("Necessary queue is larger than 2^63-1");
                        }
                        long newSize = 2L * qSize;
                        if (largeQueue == null) {
                            if (newSize > MAX_TEMP_JAVA_LONGS) {
                                largeQueue = this.mm.newLongArray(newSize);
                                if (h <= r) {
                                    assert (h - r == n);
                                    largeQueue.setData(0L, queue, (int)h, (int)n);
                                } else {
                                    largeQueue.setData(0L, queue, (int)h, (int)qSize - (int)h);
                                    largeQueue.setData((int)qSize - (int)h, queue, 0, (int)r);
                                }
                                queue = null;
                            } else {
                                long[] newQueue = new long[(int)newSize];
                                if (h <= r) {
                                    assert (h - r == n);
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)n);
                                } else {
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)qSize - (int)h);
                                    System.arraycopy(queue, 0, newQueue, (int)qSize - (int)h, (int)r);
                                }
                                queue = newQueue;
                            }
                        } else {
                            largeQueue.length(newSize);
                            if (h <= r) {
                                assert (h - r == n);
                                largeQueue.copy(0L, h, n);
                            } else {
                                largeQueue.copy(qSize, 0L, r);
                                largeQueue.copy(0L, h, qSize - h);
                                largeQueue.copy(qSize - h, qSize, r);
                            }
                        }
                        qSize = newSize;
                        h = 0L;
                        r = n;
                    }
                    int hInt = (int)h;
                    if (largeQueue != null) {
                        for (int j = 0; j < this.dimCount; ++j) {
                            this.longCoordinates[j] = largeQueue.getLong(h + (long)j);
                        }
                        longIndex = largeQueue.getLong(h + (long)this.dimCount);
                    }
                    if ((h += (long)blockSize) >= qSize) {
                        h = 0L;
                    }
                    n -= (long)blockSize;
                    for (int neighbourIndex = 0; neighbourIndex < this.apertureSize; ++neighbourIndex) {
                        int j;
                        boolean outside = false;
                        if (largeQueue == null) {
                            for (j = 0; j < this.dimCount; ++j) {
                                long coord;
                                this.coordinates[j] = coord = queue[hInt + j] + (long)this.coordShifts[neighbourIndex][j];
                                if (coord >= 0L && coord < this.dimensions[j]) continue;
                                outside = true;
                            }
                            this.index = queue[hInt + this.dimCount] + this.indexShifts[neighbourIndex];
                        } else {
                            for (j = 0; j < this.dimCount; ++j) {
                                long coord;
                                this.coordinates[j] = coord = this.longCoordinates[j] + (long)this.coordShifts[neighbourIndex][j];
                                if (coord >= 0L && coord < this.dimensions[j]) continue;
                                outside = true;
                            }
                            this.index = longIndex + this.indexShifts[neighbourIndex];
                        }
                        if (outside) continue;
                        if (this.array.getBit(this.index)) {
                            ++counter;
                            if (largeQueue == null) {
                                int rInt = (int)r;
                                for (int j2 = 0; j2 < this.dimCount; ++j2) {
                                    queue[rInt + j2] = this.coordinates[j2];
                                }
                                queue[rInt + this.dimCount] = this.index;
                            } else {
                                for (j = 0; j < this.dimCount; ++j) {
                                    largeQueue.setLong(r + (long)j, this.coordinates[j]);
                                }
                                largeQueue.setLong(r + (long)this.dimCount, this.index);
                            }
                            if ((r += (long)blockSize) >= qSize) {
                                r = 0L;
                            }
                            n += (long)blockSize;
                            if ((counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.elementVisitor.visit(this.coordinates, this.index);
                            }
                            this.array.clearBitNoSync(this.index);
                        }
                        if (n <= maxMemory) continue;
                        maxMemory = n;
                    }
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 8L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                LONG_BUFFERS.releaseArray(buffer);
            }
        }
    }

    private static class DepthFirstScanner
    extends ConnectedObjectScanner {
        DepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
            super(matrix, connectivityType);
        }

        @Override
        public ConnectedObjectScanner clone() {
            DepthFirstScanner result = new DepthFirstScanner(this.matrix, this.connectivityType);
            result.maxUsedMemory = this.maxUsedMemory;
            return result;
        }

        @Override
        long doClear() {
            if (this.arrayLength < 0x7FFFFFFEL) {
                return this.depthFirstSearchInt();
            }
            return this.depthFirstSearchLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long depthFirstSearchInt() {
            assert (this.dimCount <= 9);
            int[] buffer = (int[])INT_BUFFERS.requestArray();
            try {
                int[] stack = buffer;
                int blockSize = this.dimCount + 2;
                long n = blockSize;
                for (int j = 0; j < this.dimCount; ++j) {
                    stack[j] = (int)this.coordinates[j];
                }
                stack[this.dimCount] = (int)this.index;
                stack[this.dimCount + 1] = 0;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(this.coordinates, this.index);
                }
                this.array.clearBitNoSync(this.index);
                IntArray largeStack = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    int disp;
                    int j;
                    int neighbourIndex;
                    int nInt = (int)n;
                    boolean outside = false;
                    if (largeStack == null) {
                        neighbourIndex = stack[nInt - 1];
                        j = 0;
                        disp = nInt - blockSize;
                        while (j < this.dimCount) {
                            int coord = stack[disp] + this.coordShifts[neighbourIndex][j];
                            this.coordinates[j] = coord;
                            if (coord < 0 || (long)coord >= this.dimensions[j]) {
                                outside = true;
                            }
                            ++j;
                            ++disp;
                        }
                        this.index = (long)stack[nInt - 2] + this.indexShifts[neighbourIndex];
                    } else {
                        neighbourIndex = largeStack.getInt(n - 1L);
                        for (j = 0; j < this.dimCount; ++j) {
                            int coord = largeStack.getInt(n - (long)blockSize + (long)j) + this.coordShifts[neighbourIndex][j];
                            this.coordinates[j] = coord;
                            if (coord >= 0 && (long)coord < this.dimensions[j]) continue;
                            outside = true;
                        }
                        this.index = (long)largeStack.getInt(n - 2L) + this.indexShifts[neighbourIndex];
                    }
                    if (++neighbourIndex >= this.apertureSize) {
                        n -= (long)blockSize;
                    } else if (largeStack == null) {
                        stack[nInt - 1] = neighbourIndex;
                    } else {
                        largeStack.setInt(n - 1L, neighbourIndex);
                    }
                    if (outside || !this.array.getBit(this.index)) continue;
                    ++counter;
                    if ((n += (long)blockSize) < 0L) {
                        throw new TooLargeArrayException("Necessary stack is larger than 2^63-1");
                    }
                    nInt = (int)n;
                    if (largeStack == null) {
                        if (n > (long)stack.length) {
                            long newSize = Math.max(2L * (long)stack.length, n);
                            if (newSize > MAX_TEMP_JAVA_INTS) {
                                largeStack = this.mm.newIntArray(n);
                                largeStack.setData(0L, stack, 0, (int)(n - (long)blockSize));
                                stack = null;
                            } else {
                                int[] newStack = new int[(int)newSize];
                                System.arraycopy(stack, 0, newStack, 0, nInt - blockSize);
                                stack = newStack;
                            }
                        }
                    } else {
                        largeStack.length(n);
                    }
                    if (n > maxMemory) {
                        maxMemory = n;
                    }
                    if (largeStack == null) {
                        j = 0;
                        disp = nInt - blockSize;
                        while (j < this.dimCount) {
                            stack[disp] = (int)this.coordinates[j];
                            ++j;
                            ++disp;
                        }
                        stack[nInt - 2] = (int)this.index;
                        stack[nInt - 1] = 0;
                    } else {
                        for (j = 0; j < this.dimCount; ++j) {
                            largeStack.setLong(n - (long)blockSize + (long)j, this.coordinates[j]);
                        }
                        largeStack.setLong(n - 2L, this.index);
                        largeStack.setLong(n - 1L, 0L);
                    }
                    if ((counter & 0xFFFFL) == 2L && this.context != null) {
                        this.context.checkInterruption();
                    }
                    if (this.elementVisitor != null) {
                        this.elementVisitor.visit(this.coordinates, this.index);
                    }
                    this.array.clearBitNoSync(this.index);
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 4L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                INT_BUFFERS.releaseArray(buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long depthFirstSearchLong() {
            assert (this.dimCount <= 9);
            long[] buffer = (long[])LONG_BUFFERS.requestArray();
            try {
                long[] stack = buffer;
                int blockSize = this.dimCount + 2;
                long n = blockSize;
                for (int j = 0; j < this.dimCount; ++j) {
                    stack[j] = this.coordinates[j];
                }
                stack[this.dimCount] = this.index;
                stack[this.dimCount + 1] = 0L;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(this.coordinates, this.index);
                }
                this.array.clearBitNoSync(this.index);
                LongArray largeStack = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    int disp;
                    int j;
                    int neighbourIndex;
                    int nInt = (int)n;
                    boolean outside = false;
                    if (largeStack == null) {
                        neighbourIndex = (int)stack[nInt - 1];
                        j = 0;
                        disp = nInt - blockSize;
                        while (j < this.dimCount) {
                            long coord;
                            this.coordinates[j] = coord = stack[disp] + (long)this.coordShifts[neighbourIndex][j];
                            if (coord < 0L || coord >= this.dimensions[j]) {
                                outside = true;
                            }
                            ++j;
                            ++disp;
                        }
                        this.index = stack[nInt - 2] + this.indexShifts[neighbourIndex];
                    } else {
                        neighbourIndex = (int)largeStack.getLong(n - 1L);
                        for (j = 0; j < this.dimCount; ++j) {
                            long coord;
                            this.coordinates[j] = coord = largeStack.getLong(n - (long)blockSize + (long)j) + (long)this.coordShifts[neighbourIndex][j];
                            if (coord >= 0L && coord < this.dimensions[j]) continue;
                            outside = true;
                        }
                        this.index = largeStack.getLong(n - 2L) + this.indexShifts[neighbourIndex];
                    }
                    if (++neighbourIndex >= this.apertureSize) {
                        n -= (long)blockSize;
                    } else if (largeStack == null) {
                        stack[nInt - 1] = neighbourIndex;
                    } else {
                        largeStack.setInt(n - 1L, neighbourIndex);
                    }
                    if (outside || !this.array.getBit(this.index)) continue;
                    ++counter;
                    if ((n += (long)blockSize) < 0L) {
                        throw new TooLargeArrayException("Necessary stack is larger than 2^63-1");
                    }
                    nInt = (int)n;
                    if (largeStack == null) {
                        if (n > (long)stack.length) {
                            long newSize = Math.max(2L * (long)stack.length, n);
                            if (newSize > MAX_TEMP_JAVA_LONGS) {
                                largeStack = this.mm.newLongArray(n);
                                largeStack.setData(0L, stack, 0, (int)(n - (long)blockSize));
                                stack = null;
                            } else {
                                long[] newStack = new long[(int)newSize];
                                System.arraycopy(stack, 0, newStack, 0, nInt - blockSize);
                                stack = newStack;
                            }
                        }
                    } else {
                        largeStack.length(n);
                    }
                    if (n > maxMemory) {
                        maxMemory = n;
                    }
                    if (largeStack == null) {
                        j = 0;
                        disp = nInt - blockSize;
                        while (j < this.dimCount) {
                            stack[disp] = this.coordinates[j];
                            ++j;
                            ++disp;
                        }
                        stack[nInt - 2] = this.index;
                        stack[nInt - 1] = 0L;
                    } else {
                        for (j = 0; j < this.dimCount; ++j) {
                            largeStack.setLong(n - (long)blockSize + (long)j, this.coordinates[j]);
                        }
                        largeStack.setLong(n - 2L, this.index);
                        largeStack.setLong(n - 1L, 0L);
                    }
                    if ((counter & 0xFFFFL) == 2L && this.context != null) {
                        this.context.checkInterruption();
                    }
                    if (this.elementVisitor != null) {
                        this.elementVisitor.visit(this.coordinates, this.index);
                    }
                    this.array.clearBitNoSync(this.index);
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 8L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                LONG_BUFFERS.releaseArray(buffer);
            }
        }
    }

    private static class StacklessDepthFirstScanner
    extends ConnectedObjectScanner {
        final boolean checked;
        final long[] coordinatesClone;
        UpdatablePIntegerArray buffer = null;
        boolean bufferValid = false;
        final int bufferHighBit;
        final int bufferMask;
        int bufOfs;
        byte[] bufBytes;

        StacklessDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType, boolean checked) {
            super(matrix, connectivityType);
            if (this.apertureSize >= 32768) {
                throw new AssertionError((Object)"Too large aperture: must never be greater than 32767 elements");
            }
            this.checked = checked;
            this.coordinatesClone = checked ? new long[this.dimCount] : null;
            this.bufferHighBit = this.apertureSize < 128 ? 128 : 32768;
            this.bufferMask = this.bufferHighBit - 1;
        }

        @Override
        public ConnectedObjectScanner clone() {
            StacklessDepthFirstScanner result = new StacklessDepthFirstScanner(this.matrix, this.connectivityType, this.checked);
            result.maxUsedMemory = this.maxUsedMemory;
            return result;
        }

        @Override
        public void matrix(Matrix<? extends UpdatableBitArray> matrix) {
            super.matrix(matrix);
            this.bufferValid = false;
        }

        @Override
        public void freeResources(ArrayContext context) {
            super.freeResources(context == null || this.buffer == null ? context : context.part(0.0, 0.5));
            if (this.buffer != null) {
                this.buffer.freeResources(context == null ? null : context.part(0.5, 1.0));
            }
        }

        @Override
        long indexOfUnit(long from) {
            if (!this.bufferValid) {
                return super.indexOfUnit(from);
            }
            return this.buffer.indexOf(from, this.arrayLength, this.bufferHighBit);
        }

        @Override
        long doClear() {
            if (this.elementVisitor != null) {
                if (this.coordinatesClone != null) {
                    System.arraycopy(this.coordinates, 0, this.coordinatesClone, 0, this.dimCount);
                }
                this.elementVisitor.visit(this.coordinatesClone, this.index);
            }
            this.array.clearBitNoSync(this.index);
            this.initializeBuffer();
            this.buffer.setInt(this.index, 0);
            if (this.checked) {
                if (this.bufBytes != null && !this.forceClearing) {
                    if (this.dimCount == 2) {
                        return this.stacklessDepthFirstSearchBytes2dNoForce();
                    }
                    return this.stacklessDepthFirstSearchBytesNoForce();
                }
                if (this.dimCount == 2) {
                    return this.stacklessDepthFirstSearchPArray2d();
                }
                return this.stacklessDepthFirstSearchPArray();
            }
            if (this.bufBytes != null && !this.forceClearing) {
                return this.uncheckedStacklessDepthFirstSearchBytesNoForce();
            }
            return this.uncheckedStacklessDepthFirstSearchPArray();
        }

        private void initializeBuffer() {
            DataBitBuffer buf;
            if (this.bufferValid) {
                return;
            }
            if (this.buffer == null) {
                MemoryModel mm = this.arrayLength > MAX_TEMP_JAVA_MEMORY ? this.mm : SimpleMemoryModel.getInstance();
                UpdatablePIntegerArray updatablePIntegerArray = this.buffer = this.apertureSize < 128 ? mm.newUnresizableByteArray(this.arrayLength) : mm.newUnresizableShortArray(this.arrayLength);
                if (!(mm instanceof SimpleMemoryModel)) {
                    this.buffer = this.matrix.matrix(this.buffer).structureLike(this.matrix).array();
                }
                boolean directBuffer = this.buffer instanceof DirectAccessible && ((DirectAccessible)((Object)this.buffer)).hasJavaArray();
                this.bufBytes = this.apertureSize < 128 && directBuffer ? (byte[])((DirectAccessible)((Object)this.buffer)).javaArray() : null;
                this.bufOfs = directBuffer ? ((DirectAccessible)((Object)this.buffer)).javaArrayOffset() : 0;
                this.maxUsedMemory = this.arrayLength * (long)(this.apertureSize < 128 ? 1 : 2);
            }
            DataBuffer dBuf = this.buffer.buffer(DataBuffer.AccessMode.READ_WRITE);
            long[] ja = null;
            long jaOfs = 0L;
            if (SimpleMemoryModel.isSimpleArray(this.array) && (buf = this.array.buffer(DataBuffer.AccessMode.READ, 16L)).isDirect()) {
                buf.map(0L);
                ja = buf.data();
                jaOfs = buf.from();
            }
            long[] bits = ja == null ? new long[PackedBitArrays.packedLength32(dBuf.capacity())] : ja;
            for (long p = 0L; p < this.arrayLength; p += dBuf.capacity()) {
                if (this.context != null) {
                    this.context.checkInterruption();
                }
                dBuf.map(p);
                if (ja == null) {
                    this.array.getBits(p, bits, 0L, dBuf.cnt());
                }
                if (this.buffer instanceof ByteArray) {
                    PackedBitArrays.unpackBits((byte[])dBuf.data(), dBuf.from(), bits, ja == null ? 0L : jaOfs + p, dBuf.cnt(), (byte)0, (byte)-128);
                } else if (this.buffer instanceof ShortArray) {
                    PackedBitArrays.unpackBits((short[])dBuf.data(), dBuf.from(), bits, ja == null ? 0L : jaOfs + p, dBuf.cnt(), (short)0, (short)Short.MIN_VALUE);
                } else {
                    throw new AssertionError((Object)"Impossible buffer class");
                }
                dBuf.force();
            }
            this.bufferValid = true;
        }

        private long stacklessDepthFirstSearchPArray() {
            long startIndex = this.index;
            long counter = 1L;
            int direction = 0;
            while (true) {
                if (direction < this.apertureSize) {
                    block10: {
                        boolean bit;
                        for (int j = 0; j < this.dimCount; ++j) {
                            long coord = this.coordinates[j] + (long)this.coordShifts[direction][j];
                            if (coord >= 0L && coord < this.dimensions[j]) {
                                this.coordinatesClone[j] = coord;
                                continue;
                            }
                            break block10;
                        }
                        long indexClone = this.index + this.indexShifts[direction];
                        boolean bl = bit = this.buffer.getInt(indexClone) >= this.bufferHighBit;
                        if (bit) {
                            System.arraycopy(this.coordinatesClone, 0, this.coordinates, 0, this.dimCount);
                            this.index = indexClone;
                            if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.elementVisitor.visit(this.coordinatesClone, indexClone);
                            }
                            if (this.forceClearing) {
                                this.array.clearBitNoSync(this.index);
                            }
                            this.buffer.setInt(this.index, direction);
                            direction = 0;
                            continue;
                        }
                    }
                    ++direction;
                    continue;
                }
                if (this.index == startIndex) break;
                direction = this.buffer.getInt(this.index) & this.bufferMask;
                for (int j = 0; j < this.dimCount; ++j) {
                    int n = j;
                    this.coordinates[n] = this.coordinates[n] - (long)this.coordShifts[direction][j];
                    assert (this.coordinates[j] >= 0L && this.coordinates[j] < this.dimensions[j]);
                }
                this.index -= this.indexShifts[direction];
                ++direction;
            }
            return counter;
        }

        private long stacklessDepthFirstSearchBytesNoForce() {
            assert (this.bufferHighBit == 128);
            int index = (int)this.index;
            long startIndex = index;
            long counter = 1L;
            int direction = 0;
            while (true) {
                int j;
                if (direction < this.apertureSize) {
                    block10: {
                        boolean bit;
                        for (j = 0; j < this.dimCount; ++j) {
                            long coord = this.coordinates[j] + (long)this.coordShifts[direction][j];
                            if (coord >= 0L && coord < this.dimensions[j]) {
                                this.coordinatesClone[j] = coord;
                                continue;
                            }
                            break block10;
                        }
                        int indexClone = index + this.intIndexShifts[direction];
                        boolean bl = bit = this.bufBytes[indexClone] < 0;
                        if (bit) {
                            System.arraycopy(this.coordinatesClone, 0, this.coordinates, 0, this.dimCount);
                            index = indexClone;
                            if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.elementVisitor.visit(this.coordinatesClone, indexClone);
                            }
                            this.bufBytes[index] = (byte)direction;
                            direction = 0;
                            continue;
                        }
                    }
                    ++direction;
                    continue;
                }
                if ((long)index == startIndex) break;
                direction = this.bufBytes[index] & 0x7F;
                for (j = 0; j < this.dimCount; ++j) {
                    int n = j;
                    this.coordinates[n] = this.coordinates[n] - (long)this.coordShifts[direction][j];
                    assert (this.coordinates[j] >= 0L && this.coordinates[j] < this.dimensions[j]);
                }
                index -= this.intIndexShifts[direction];
                ++direction;
            }
            return counter;
        }

        private long uncheckedStacklessDepthFirstSearchPArray() {
            long startIndex = this.index;
            long counter = 1L;
            int direction = 0;
            while (true) {
                if (direction < this.apertureSize) {
                    boolean bit;
                    long indexClone = this.index + this.indexShifts[direction];
                    boolean bl = bit = this.buffer.getInt(indexClone) >= this.bufferHighBit;
                    if (bit) {
                        this.index = indexClone;
                        if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                            this.context.checkInterruption();
                        }
                        if (this.elementVisitor != null) {
                            this.elementVisitor.visit(null, indexClone);
                        }
                        if (this.forceClearing) {
                            this.array.clearBitNoSync(this.index);
                        }
                        this.buffer.setInt(this.index, direction);
                        direction = 0;
                        continue;
                    }
                    ++direction;
                    continue;
                }
                if (this.index == startIndex) break;
                direction = this.buffer.getInt(this.index) & this.bufferMask;
                this.index -= this.indexShifts[direction];
                ++direction;
            }
            return counter;
        }

        private long uncheckedStacklessDepthFirstSearchBytesNoForce() {
            assert (this.bufferHighBit == 128);
            int index = (int)this.index;
            long startIndex = index;
            long counter = 1L;
            int direction = 0;
            while (true) {
                if (direction < this.apertureSize) {
                    boolean bit;
                    int indexClone = index + this.intIndexShifts[direction];
                    boolean bl = bit = this.bufBytes[indexClone] < 0;
                    if (bit) {
                        index = indexClone;
                        if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                            this.context.checkInterruption();
                        }
                        if (this.elementVisitor != null) {
                            this.elementVisitor.visit(null, indexClone);
                        }
                        this.bufBytes[index] = (byte)direction;
                        direction = 0;
                        continue;
                    }
                    ++direction;
                    continue;
                }
                if ((long)index == startIndex) break;
                direction = this.bufBytes[index] & 0x7F;
                index -= this.intIndexShifts[direction];
                ++direction;
            }
            return counter;
        }

        private long stacklessDepthFirstSearchPArray2d() {
            long startIndex = this.index;
            long x = this.coordinates[0];
            long y = this.coordinates[1];
            long dimX = this.dimensions[0];
            long dimY = this.dimensions[1];
            long counter = 1L;
            int direction = 0;
            while (true) {
                if (direction < this.apertureSize) {
                    long yClone;
                    long xClone = x + this.xShifts[direction];
                    if (xClone >= 0L && xClone < dimX && (yClone = y + this.yShifts[direction]) >= 0L && yClone < dimY) {
                        boolean bit;
                        long indexClone = this.index + this.indexShifts[direction];
                        boolean bl = bit = this.buffer.getInt(indexClone) >= this.bufferHighBit;
                        if (bit) {
                            x = xClone;
                            y = yClone;
                            this.index = indexClone;
                            if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.coordinatesClone[0] = xClone;
                                this.coordinatesClone[1] = yClone;
                                this.elementVisitor.visit(this.coordinatesClone, indexClone);
                            }
                            if (this.forceClearing) {
                                this.array.clearBitNoSync(this.index);
                            }
                            this.buffer.setInt(this.index, direction);
                            direction = 0;
                            continue;
                        }
                    }
                    ++direction;
                    continue;
                }
                if (this.index == startIndex) break;
                direction = this.buffer.getInt(this.index) & this.bufferMask;
                x -= this.xShifts[direction];
                y -= this.yShifts[direction];
                this.index -= this.indexShifts[direction];
                ++direction;
            }
            return counter;
        }

        private long stacklessDepthFirstSearchBytes2dNoForce() {
            assert (!this.forceClearing);
            int index = (int)this.index;
            long startIndex = index;
            long x = this.coordinates[0];
            long y = this.coordinates[1];
            long dimX = this.dimensions[0];
            long dimY = this.dimensions[1];
            long counter = 1L;
            int direction = 0;
            while (true) {
                if (direction < this.apertureSize) {
                    long yClone;
                    long xClone = x + this.xShifts[direction];
                    if (xClone >= 0L && xClone < dimX && (yClone = y + this.yShifts[direction]) >= 0L && yClone < dimY) {
                        boolean bit;
                        int indexClone = index + this.intIndexShifts[direction];
                        boolean bl = bit = this.bufBytes[indexClone] < 0;
                        if (bit) {
                            x = xClone;
                            y = yClone;
                            index = indexClone;
                            if ((++counter & 0xFFFFL) == 2L && this.context != null) {
                                this.context.checkInterruption();
                            }
                            if (this.elementVisitor != null) {
                                this.coordinatesClone[0] = xClone;
                                this.coordinatesClone[1] = yClone;
                                this.elementVisitor.visit(this.coordinatesClone, indexClone);
                            }
                            this.bufBytes[index] = (byte)direction;
                            direction = 0;
                            continue;
                        }
                    }
                    ++direction;
                    continue;
                }
                if ((long)index == startIndex) break;
                direction = this.bufBytes[index] & 0x7F;
                x -= this.xShifts[direction];
                y -= this.yShifts[direction];
                index -= this.intIndexShifts[direction];
                ++direction;
            }
            return counter;
        }
    }

    private static class UncheckedBreadthFirstScanner
    extends ConnectedObjectScanner {
        UncheckedBreadthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
            super(matrix, connectivityType);
        }

        @Override
        public ConnectedObjectScanner clone() {
            UncheckedBreadthFirstScanner result = new UncheckedBreadthFirstScanner(this.matrix, this.connectivityType);
            result.maxUsedMemory = this.maxUsedMemory;
            return result;
        }

        @Override
        long doClear() {
            if (this.arrayLength < 0x7FFFFFFEL) {
                return this.uncheckedBreadthFirstSearchInt();
            }
            return this.uncheckedBreadthFirstSearchLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long uncheckedBreadthFirstSearchInt() {
            assert (this.dimCount <= 9);
            assert ((long)this.apertureSize * 10L <= Integer.MAX_VALUE);
            int queueSpaceForAperture = this.apertureSize;
            int[] buffer = (int[])INT_BUFFERS.requestArray();
            try {
                int[] queue = buffer;
                long h = 0L;
                long r = 1L;
                long n = 1L;
                long qSize = queue.length;
                queue[0] = (int)this.index;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(null, this.index);
                }
                this.array.clearBitNoSync(this.index);
                IntArray largeQueue = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    int intIndex;
                    if (n + (long)queueSpaceForAperture > qSize) {
                        if (qSize > 0x3FFFFFFFFFFFFFFFL) {
                            throw new TooLargeArrayException("Necessary queue is larger than 2^63-1");
                        }
                        long newSize = 2L * qSize;
                        if (largeQueue == null) {
                            if (newSize > MAX_TEMP_JAVA_INTS) {
                                largeQueue = this.mm.newIntArray(newSize);
                                if (h <= r) {
                                    assert (h - r == n);
                                    largeQueue.setData(0L, queue, (int)h, (int)n);
                                } else {
                                    largeQueue.setData(0L, queue, (int)h, (int)qSize - (int)h);
                                    largeQueue.setData((int)qSize - (int)h, queue, 0, (int)r);
                                }
                                queue = null;
                            } else {
                                int[] newQueue = new int[(int)newSize];
                                if (h <= r) {
                                    assert (h - r == n);
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)n);
                                } else {
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)qSize - (int)h);
                                    System.arraycopy(queue, 0, newQueue, (int)qSize - (int)h, (int)r);
                                }
                                queue = newQueue;
                            }
                        } else {
                            largeQueue.length(newSize);
                            if (h <= r) {
                                assert (h - r == n);
                                largeQueue.copy(0L, h, n);
                            } else {
                                largeQueue.copy(qSize, 0L, r);
                                largeQueue.copy(0L, h, qSize - h);
                                largeQueue.copy(qSize - h, qSize, r);
                            }
                        }
                        qSize = newSize;
                        h = 0L;
                        r = n;
                    }
                    int n2 = intIndex = largeQueue != null ? largeQueue.getInt(h) : queue[(int)h];
                    if (++h >= qSize) {
                        h = 0L;
                    }
                    --n;
                    for (int neighbourIndex = 0; neighbourIndex < this.apertureSize; ++neighbourIndex) {
                        this.index = (long)intIndex + this.indexShifts[neighbourIndex];
                        if (!this.array.getBit(this.index)) continue;
                        ++counter;
                        if (largeQueue == null) {
                            queue[(int)r] = (int)this.index;
                        } else {
                            largeQueue.setLong(r, this.index);
                        }
                        if (++r >= qSize) {
                            r = 0L;
                        }
                        ++n;
                        if ((counter & 0xFFFFL) == 2L && this.context != null) {
                            this.context.checkInterruption();
                        }
                        if (this.elementVisitor != null) {
                            this.elementVisitor.visit(null, this.index);
                        }
                        this.array.clearBitNoSync(this.index);
                    }
                    if (n <= maxMemory) continue;
                    maxMemory = n;
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 4L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                INT_BUFFERS.releaseArray(buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long uncheckedBreadthFirstSearchLong() {
            assert (this.dimCount <= 9);
            assert ((long)this.apertureSize * 10L <= Integer.MAX_VALUE);
            int queueSpaceForAperture = this.apertureSize;
            long[] buffer = (long[])LONG_BUFFERS.requestArray();
            try {
                long[] queue = buffer;
                long h = 0L;
                long r = 1L;
                long n = 1L;
                long qSize = queue.length;
                queue[0] = this.index;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(null, this.index);
                }
                this.array.clearBitNoSync(this.index);
                LongArray largeQueue = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    long longIndex;
                    if (n + (long)queueSpaceForAperture > qSize) {
                        if (qSize > 0x3FFFFFFFFFFFFFFFL) {
                            throw new TooLargeArrayException("Necessary queue is larger than 2^63-1");
                        }
                        long newSize = 2L * qSize;
                        if (largeQueue == null) {
                            if (newSize > MAX_TEMP_JAVA_LONGS) {
                                largeQueue = this.mm.newLongArray(newSize);
                                if (h <= r) {
                                    assert (h - r == n);
                                    largeQueue.setData(0L, queue, (int)h, (int)n);
                                } else {
                                    largeQueue.setData(0L, queue, (int)h, (int)qSize - (int)h);
                                    largeQueue.setData((int)qSize - (int)h, queue, 0, (int)r);
                                }
                                queue = null;
                            } else {
                                long[] newQueue = new long[(int)newSize];
                                if (h <= r) {
                                    assert (h - r == n);
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)n);
                                } else {
                                    System.arraycopy(queue, (int)h, newQueue, 0, (int)qSize - (int)h);
                                    System.arraycopy(queue, 0, newQueue, (int)qSize - (int)h, (int)r);
                                }
                                queue = newQueue;
                            }
                        } else {
                            largeQueue.length(newSize);
                            if (h <= r) {
                                assert (h - r == n);
                                largeQueue.copy(0L, h, n);
                            } else {
                                largeQueue.copy(qSize, 0L, r);
                                largeQueue.copy(0L, h, qSize - h);
                                largeQueue.copy(qSize - h, qSize, r);
                            }
                        }
                        qSize = newSize;
                        h = 0L;
                        r = n;
                    }
                    long l = longIndex = largeQueue != null ? largeQueue.getLong(h) : queue[(int)h];
                    if (++h >= qSize) {
                        h = 0L;
                    }
                    --n;
                    for (int neighbourIndex = 0; neighbourIndex < this.apertureSize; ++neighbourIndex) {
                        this.index = longIndex + this.indexShifts[neighbourIndex];
                        if (!this.array.getBit(this.index)) continue;
                        ++counter;
                        if (largeQueue == null) {
                            queue[(int)r] = this.index;
                        } else {
                            largeQueue.setLong(r, this.index);
                        }
                        if (++r >= qSize) {
                            r = 0L;
                        }
                        ++n;
                        if ((counter & 0xFFFFL) == 2L && this.context != null) {
                            this.context.checkInterruption();
                        }
                        if (this.elementVisitor != null) {
                            this.elementVisitor.visit(null, this.index);
                        }
                        this.array.clearBitNoSync(this.index);
                    }
                    if (n <= maxMemory) continue;
                    maxMemory = n;
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 8L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                LONG_BUFFERS.releaseArray(buffer);
            }
        }
    }

    private static class UncheckedDepthFirstScanner
    extends ConnectedObjectScanner {
        UncheckedDepthFirstScanner(Matrix<? extends UpdatableBitArray> matrix, ConnectivityType connectivityType) {
            super(matrix, connectivityType);
        }

        @Override
        public ConnectedObjectScanner clone() {
            UncheckedDepthFirstScanner result = new UncheckedDepthFirstScanner(this.matrix, this.connectivityType);
            result.maxUsedMemory = this.maxUsedMemory;
            return result;
        }

        @Override
        long doClear() {
            if (this.arrayLength < 0x7FFFFFFEL) {
                return this.uncheckedDepthFirstSearchInt();
            }
            return this.uncheckedDepthFirstSearchLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long uncheckedDepthFirstSearchInt() {
            assert (this.dimCount <= 9);
            int[] buffer = (int[])INT_BUFFERS.requestArray();
            try {
                int[] stack = buffer;
                long n = 2L;
                stack[0] = (int)this.index;
                stack[1] = 0;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(null, this.index);
                }
                this.array.clearBitNoSync(this.index);
                IntArray largeStack = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    int neighbourIndex;
                    int nInt = (int)n;
                    if (largeStack == null) {
                        neighbourIndex = stack[nInt - 1];
                        this.index = (long)stack[nInt - 2] + this.indexShifts[neighbourIndex];
                    } else {
                        neighbourIndex = largeStack.getInt(n - 1L);
                        this.index = (long)largeStack.getInt(n - 2L) + this.indexShifts[neighbourIndex];
                    }
                    if (++neighbourIndex >= this.apertureSize) {
                        n -= 2L;
                    } else if (largeStack == null) {
                        stack[nInt - 1] = neighbourIndex;
                    } else {
                        largeStack.setInt(n - 1L, neighbourIndex);
                    }
                    if (!this.array.getBit(this.index)) continue;
                    ++counter;
                    if ((n += 2L) < 0L) {
                        throw new TooLargeArrayException("Necessary stack is larger than 2^63-1");
                    }
                    nInt = (int)n;
                    if (largeStack == null) {
                        if (n > (long)stack.length) {
                            long newSize = Math.max(2L * (long)stack.length, n);
                            if (newSize > MAX_TEMP_JAVA_INTS) {
                                largeStack = this.mm.newIntArray(n);
                                largeStack.setData(0L, stack, 0, (int)(n - 2L));
                                stack = null;
                            } else {
                                int[] newStack = new int[(int)newSize];
                                System.arraycopy(stack, 0, newStack, 0, nInt - 2);
                                stack = newStack;
                            }
                        }
                    } else {
                        largeStack.length(n);
                    }
                    if (n > maxMemory) {
                        maxMemory = n;
                    }
                    if (largeStack == null) {
                        stack[nInt - 2] = (int)this.index;
                        stack[nInt - 1] = 0;
                    } else {
                        largeStack.setLong(n - 2L, this.index);
                        largeStack.setLong(n - 1L, 0L);
                    }
                    if ((counter & 0xFFFFL) == 2L && this.context != null) {
                        this.context.checkInterruption();
                    }
                    if (this.elementVisitor != null) {
                        this.elementVisitor.visit(null, this.index);
                    }
                    this.array.clearBitNoSync(this.index);
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 4L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                INT_BUFFERS.releaseArray(buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long uncheckedDepthFirstSearchLong() {
            assert (this.dimCount <= 9);
            long[] buffer = (long[])LONG_BUFFERS.requestArray();
            try {
                long[] stack = buffer;
                long n = 2L;
                stack[0] = this.index;
                stack[1] = 0L;
                if (this.elementVisitor != null) {
                    this.elementVisitor.visit(null, this.index);
                }
                this.array.clearBitNoSync(this.index);
                LongArray largeStack = null;
                long maxMemory = 0L;
                long counter = 1L;
                while (n > 0L) {
                    int neighbourIndex;
                    int nInt = (int)n;
                    if (largeStack == null) {
                        neighbourIndex = (int)stack[nInt - 1];
                        this.index = stack[nInt - 2] + this.indexShifts[neighbourIndex];
                    } else {
                        neighbourIndex = (int)largeStack.getLong(n - 1L);
                        this.index = largeStack.getLong(n - 2L) + this.indexShifts[neighbourIndex];
                    }
                    if (++neighbourIndex >= this.apertureSize) {
                        n -= 2L;
                    } else if (largeStack == null) {
                        stack[nInt - 1] = neighbourIndex;
                    } else {
                        largeStack.setInt(n - 1L, neighbourIndex);
                    }
                    if (!this.array.getBit(this.index)) continue;
                    ++counter;
                    if ((n += 2L) < 0L) {
                        throw new TooLargeArrayException("Necessary stack is larger than 2^63-1");
                    }
                    nInt = (int)n;
                    if (largeStack == null) {
                        if (n > (long)stack.length) {
                            long newSize = Math.max(2L * (long)stack.length, n);
                            if (newSize > MAX_TEMP_JAVA_LONGS) {
                                largeStack = this.mm.newLongArray(n);
                                largeStack.setData(0L, stack, 0, (int)(n - 2L));
                                stack = null;
                            } else {
                                long[] newStack = new long[(int)newSize];
                                System.arraycopy(stack, 0, newStack, 0, nInt - 2);
                                stack = newStack;
                            }
                        }
                    } else {
                        largeStack.length(n);
                    }
                    if (n > maxMemory) {
                        maxMemory = n;
                    }
                    if (largeStack == null) {
                        stack[nInt - 2] = this.index;
                        stack[nInt - 1] = 0L;
                    } else {
                        largeStack.setLong(n - 2L, this.index);
                        largeStack.setLong(n - 1L, 0L);
                    }
                    if ((counter & 0xFFFFL) == 2L && this.context != null) {
                        this.context.checkInterruption();
                    }
                    if (this.elementVisitor != null) {
                        this.elementVisitor.visit(null, this.index);
                    }
                    this.array.clearBitNoSync(this.index);
                }
                this.maxUsedMemory = Math.max(this.maxUsedMemory, 8L * maxMemory);
                long l = counter;
                return l;
            }
            finally {
                LONG_BUFFERS.releaseArray(buffer);
            }
        }
    }

    @FunctionalInterface
    public static interface ElementVisitor {
        public void visit(long[] var1, long var2);
    }

    public static class MaskElementCounter
    implements ElementVisitor {
        private final Matrix<? extends BitArray> mask;
        private final BitArray array;
        protected long counter = 0L;

        public MaskElementCounter(Matrix<? extends BitArray> mask) {
            Objects.requireNonNull(mask, "Null mask");
            this.mask = mask;
            this.array = mask.array();
        }

        @Override
        public void visit(long[] coordinatesInMatrix, long indexInArray) {
            if (this.array.getBit(indexInArray)) {
                ++this.counter;
            }
        }

        public Matrix<? extends BitArray> mask() {
            return this.mask;
        }

        public void reset() {
            this.counter = 0L;
        }

        public long counter() {
            return this.counter;
        }
    }

    private static class ClearerOfSecondaryMatrix
    implements ElementVisitor {
        final ArrayContext context;
        final ConnectedObjectScanner secondaryScanner;
        final Matrix<? extends UpdatableBitArray> secondaryMatrix;
        final BitArray secondaryArray;
        final long[] secondaryCoordinates;
        long pixelCounter = 0L;

        ClearerOfSecondaryMatrix(ArrayContext context, ConnectedObjectScanner secondaryScanner) {
            this.context = context;
            this.secondaryScanner = secondaryScanner;
            this.secondaryMatrix = secondaryScanner.matrix();
            this.secondaryCoordinates = new long[this.secondaryMatrix.dimCount()];
            this.secondaryArray = this.secondaryMatrix.array();
        }

        @Override
        public void visit(long[] coordinatesInMatrix, long indexInArray) {
            if (this.secondaryArray.getBit(indexInArray)) {
                long count = this.secondaryScanner.clear(this.context, this.secondaryMatrix.coordinates(indexInArray, null));
                this.pixelCounter += count;
            }
        }
    }
}

